/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.web.controller.reports.NatureOfUsageReportAdaptor;
import org.egov.ptis.web.controller.reports.NatureOfUsageResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class NatureOfUsageReportController {
    private static final String NATURE_OF_USAGE_REPORT_FORM = "natureOfUsageReport-form";
    private final NatureOfUsageResult natureOfUsageResult = new NatureOfUsageResult();
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private PropertyUsageService propertyUsageService;
    @Autowired
    private BoundaryService boundaryService;
    private String srchCriteria;

    @ModelAttribute(value="natureOfUsageResult")
    public NatureOfUsageResult natureOfUsageResultModel() {
        return this.natureOfUsageResult;
    }

    @ModelAttribute(value="natureOfUsages")
    public List<PropertyUsage> getNatureOfUsages() {
        return this.propertyUsageService.getAllActivePropertyUsages();
    }

    @ModelAttribute(value="wards")
    public List<Boundary> getWards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="blocks")
    public List<Boundary> getBlocks() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Block", "REVENUE");
    }

    @RequestMapping(value={"/natureOfUsageReport-form"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        return NATURE_OF_USAGE_REPORT_FORM;
    }

    @RequestMapping(value={"/natureOfUsageReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        List natureOfUsageResultList = this.getReportResults(request);
        StringBuilder natureOfUsageSONData = new StringBuilder("{ \"data\":").append(this.toJSON((Object)natureOfUsageResultList)).append("}");
        response.setContentType("application/json");
        IOUtils.write((String)natureOfUsageSONData.toString(), (Writer)response.getWriter());
    }

    private List<NatureOfUsageResult> getReportResults(HttpServletRequest request) {
        StringBuffer query = new StringBuffer("select distinct pi.upicno \"assessmentNumber\", pi.ownersname \"ownerName\", pi.mobileno \"mobileNumber\", pi.houseno \"doorNumber\", pi.address \"address\", cast(pi.AGGREGATE_CURRENT_FIRSTHALF_DEMAND as numeric) \"halfYearTax\" from egpt_mv_propertyInfo pi ");
        StringBuffer whereQuery = new StringBuffer(" where pi.upicno is not null and pi.isactive = true ");
        String natureOfUsage = request.getParameter("natureOfUsage");
        String ward = request.getParameter("ward");
        String block = request.getParameter("block");
        StringBuffer srchCriteria = new StringBuffer("Total number of properties with");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != natureOfUsage && !"-1".equals(natureOfUsage) && !"".equals(natureOfUsage)) {
            PropertyUsage propertyUsage = this.propertyUsageService.findById(Long.valueOf(natureOfUsage));
            srchCriteria.append(" Nature of usage : " + propertyUsage.getUsageName());
            query.append(",EGPT_MV_CURRENT_FLOOR_DETAIL fd ");
            whereQuery.append(" and fd.basicpropertyid = pi.basicpropertyid and fd.natureofusage = :natureOfUsage");
            params.put("natureOfUsage", propertyUsage.getUsageName());
        }
        if (null != ward && !"-1".equals(ward) && !"".equals(ward)) {
            Boundary wardBndry = this.boundaryService.getBoundaryById(Long.valueOf(ward));
            srchCriteria.append(" Ward : " + wardBndry.getName());
            whereQuery.append(" and pi.wardid = :ward");
            params.put("ward", Long.valueOf(ward));
        }
        if (null != block && !"-1".equals(block) && !"".equals(block)) {
            Boundary blockBndry = this.boundaryService.getBoundaryById(Long.valueOf(block));
            srchCriteria.append(" Block : " + blockBndry.getName());
            whereQuery.append(" and pi.blockid = :block");
            params.put("block", Long.valueOf(block));
        }
        SQLQuery sqlQuery = this.getSession().createSQLQuery(query.append(whereQuery).toString());
        for (String key : params.keySet()) {
            sqlQuery.setParameter(key, params.get(key));
        }
        sqlQuery.setResultTransformer(Transformers.aliasToBean(NatureOfUsageResult.class));
        List results = sqlQuery.list();
        srchCriteria.append(" are : " + results.size());
        this.setSrchCriteria(srchCriteria.toString());
        return results;
    }

    public String toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(NatureOfUsageResult.class, (Object)new NatureOfUsageReportAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    public Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public String getSrchCriteria() {
        return this.srchCriteria;
    }

    public void setSrchCriteria(String srchCriteria) {
        this.srchCriteria = srchCriteria;
    }
}

