/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.RegionalHeirarchy;
import org.egov.commons.RegionalHeirarchyType;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.RegionalHeirarchyService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.ptis.domain.entity.property.BillCollectorDailyCollectionReportResult;
import org.egov.ptis.domain.service.report.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class GeneralDialyCollectionReportController {
    private static final String BILL_COLLECTOR_COLL_REPORT_FORM = "bcDailyCollectionReport-form";
    private static final String ULBWISE_COLL_REPORT_FORM = "ulbWiseCollectionReport-form";
    private static final String ULBWISE_DCB_REPORT_FORM = "ulbWiseDcbReport-form";
    private String DISTRICT = "DISTRICT";
    private String CITY = "CITY";
    private BillCollectorDailyCollectionReportResult bcDailyCollectionReportResult = new BillCollectorDailyCollectionReportResult();
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private RegionalHeirarchyService regionalHeirarchyService;
    @Autowired
    private ReportService reportService;
    @Autowired
    protected FinancialYearDAO financialYearDAO;

    @ModelAttribute(value="previousFinancialYear")
    public CFinancialYear previousFinancialYear() {
        return this.financialYearDAO.getPreviousFinancialYearByDate(new Date());
    }

    @ModelAttribute(value="currentFinancialYear")
    public CFinancialYear currentFinancialYear() {
        return this.financialYearDAO.getFinancialYearByDate(new Date());
    }

    @ModelAttribute(value="regions")
    public List<RegionalHeirarchy> getRegions() {
        return this.regionalHeirarchyService.getActiveRegionalHeirarchyByRegion(RegionalHeirarchyType.REGION);
    }

    @RequestMapping(value={"/getRegionHeirarchyByType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<RegionalHeirarchy> getRegionHeirarchyByType(@RequestParam String regionName, @RequestParam String type) {
        if (type != null && type.equalsIgnoreCase(this.DISTRICT)) {
            return this.regionalHeirarchyService.getActiveChildRegionHeirarchyByPassingParentNameAndType(RegionalHeirarchyType.DISTRICT, regionName);
        }
        if (type != null && type.equalsIgnoreCase(this.CITY)) {
            return this.regionalHeirarchyService.getActiveChildRegionHeirarchyByPassingParentNameAndType(RegionalHeirarchyType.CITY, regionName);
        }
        return null;
    }

    @ModelAttribute(value="bcDailyCollectionReportResult")
    public BillCollectorDailyCollectionReportResult bcDailyCollectionReportResultModel() {
        return this.bcDailyCollectionReportResult;
    }

    @RequestMapping(value={"/billcollectorDailyCollectionReport-form"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        if (this.bcDailyCollectionReportResult != null) {
            this.bcDailyCollectionReportResult.setGeneratedDate(dateFormat.format(calendar.getTime()));
        }
        return BILL_COLLECTOR_COLL_REPORT_FORM;
    }

    @RequestMapping(value={"/ulbWiseDcbReport-form"}, method={RequestMethod.GET})
    public String searchUlbWiseDcbForm(Model model, @RequestParam String type) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Calendar calendar = Calendar.getInstance();
        model.addAttribute("typeValue", (Object)type);
        calendar.add(5, -1);
        if (this.bcDailyCollectionReportResult != null) {
            this.bcDailyCollectionReportResult.setGeneratedDate(dateFormat.format(calendar.getTime()));
        }
        return ULBWISE_DCB_REPORT_FORM;
    }

    @RequestMapping(value={"/ulbWiseCollectionReport-form"}, method={RequestMethod.GET})
    public String searchUlbWiseForm(Model model) {
        return ULBWISE_COLL_REPORT_FORM;
    }

    @RequestMapping(value={"/ulbWiseDCBList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchUlbWiseDcb(HttpServletRequest request, HttpServletResponse response, BillCollectorDailyCollectionReportResult bcDailyCollectionReportResult, Model model) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.reportService.getUlbWiseDcbCollection(new Date(), bcDailyCollectionReportResult)) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/ulbWiseCollectionList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchUlbWise(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.reportService.getUlbWiseDailyCollection(new Date())) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/billcollectorDailyCollectionReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, BillCollectorDailyCollectionReportResult bcDailyCollectionReportResult, Model model) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.reportService.getBillCollectorWiseDailyCollection(new Date(), bcDailyCollectionReportResult)) + "}"), (Writer)response.getWriter());
    }
}

