/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.view;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.DCBException;
import org.egov.commons.Installment;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.dcb.bean.DCBReport;
import org.egov.dcb.bean.Receipt;
import org.egov.dcb.service.DCBService;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.client.model.PropertyArrearBean;
import org.egov.ptis.client.util.DCBUtils;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyReceipt;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.exceptions.PropertyNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@ParentPackage(value="egov")
@Results(value={@Result(name="view", location="viewDCBProperty-view.jsp"), @Result(name="headwiseDcb", location="viewDCBProperty-headwiseDcb.jsp"), @Result(name="viewMigData", location="viewDCBProperty-viewMigData.jsp")})
public class ViewDCBPropertyAction
extends BaseFormAction
implements ServletRequestAware {
    private static final Logger LOGGER = Logger.getLogger(ViewDCBPropertyAction.class);
    public static final String HEADWISE_DCB = "headwiseDcb";
    public static final String VIEW = "view";
    public static final String RESULT_MIGDATA = "viewMigData";
    private Map<String, BigDecimal> propertyArrearsMap = new TreeMap();
    private List<PropertyArrearBean> propertyArrearsList = new ArrayList();
    private DCBReport dcbReport = new DCBReport();
    private String propertyId;
    private BasicProperty basicProperty;
    private DCBDisplayInfo dcbDispInfo;
    private HttpSession session = null;
    private HttpServletRequest request;
    private Long userId;
    private Boolean isCitizen = Boolean.FALSE;
    private List<PropertyReceipt> propReceiptList = new ArrayList();
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private List<Receipt> cancelRcpt = new ArrayList();
    private List<Receipt> activeRcpts = new ArrayList();
    private List<Receipt> mutationRcpts = new ArrayList();
    private String demandEffectiveYear;
    private Integer noOfDaysForInactiveDemand;
    private String errorMessage;
    private String roleName;
    private Map<String, Object> viewMap;
    @Autowired
    private UserService userService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private DCBService dcbService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public Object getModel() {
        return this.dcbReport;
    }

    public void prepare() {
        this.setBasicProperty(this.basicPropertyDAO.getBasicPropertyByPropertyID(this.propertyId));
    }

    @ValidationErrorPage(value="view")
    @Action(value="/view/viewDCBProperty-displayPropInfo")
    public String displayPropInfo() {
        LOGGER.debug((Object)"Entered into method displayPropInfo");
        LOGGER.debug((Object)("displayPropInfo : propertyId : " + this.propertyId));
        DCBUtils dcbUtils = new DCBUtils();
        this.session = this.request.getSession();
        if (this.session.getAttribute("userid") == null) {
            User user = this.userService.getUserByUsername("9999999999");
            this.userId = user.getId();
            ApplicationThreadLocals.setUserId((Long)this.userId);
            this.session.setAttribute("com.egov.user.LoginUserName", (Object)user.getUsername());
            if (user != null) {
                this.setCitizen(Boolean.TRUE);
            }
        } else {
            this.setCitizen(Boolean.FALSE);
            Long userId = (Long)this.session().get("userid");
            if (userId != null) {
                this.setRoleName(this.propertyTaxUtil.getRolesForUserId(userId));
            }
        }
        try {
            if (this.getBasicProperty() == null) {
                return VIEW;
            }
            LOGGER.debug((Object)("BasicProperty : " + this.basicProperty));
            this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.propertyId);
            this.viewMap = new HashMap();
            this.viewMap.put("propID", this.basicProperty.getPropertyID());
            PropertyTypeMaster propertyTypeMaster = this.basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster();
            this.viewMap.put("ownershipType", propertyTypeMaster.getType());
            Property property = this.getBasicProperty().getProperty();
            this.viewMap.put("propAddress", this.getBasicProperty().getAddress().toString());
            this.viewMap.put("ownerName", this.basicProperty.getFullOwnerName());
            this.viewMap.put("taxExempted", property.getIsExemptedFromTax());
            if (!property.getIsExemptedFromTax().booleanValue()) {
                Map demandCollMap = this.ptDemandDAO.getDemandCollMap(property);
                this.viewMap.put("currFirstHalfTaxAmount", demandCollMap.get("CURR_FIRSTHALF_DMD"));
                this.viewMap.put("currFirstHalfTaxDue", ((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_COLL")));
                this.viewMap.put("currSecondHalfTaxAmount", demandCollMap.get("CURR_SECONDHALF_DMD"));
                this.viewMap.put("currSecondHalfTaxDue", ((BigDecimal)demandCollMap.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_SECONDHALF_COLL")));
                this.viewMap.put("totalArrDue", ((BigDecimal)demandCollMap.get("ARR_DMD")).subtract((BigDecimal)demandCollMap.get("ARR_COLL")));
                PropertyTaxBillable billable = (PropertyTaxBillable)this.beanProvider.getBean("propertyTaxBillable");
                billable.setBasicProperty(this.basicProperty);
                this.dcbService.setBillable((Billable)billable);
                this.dcbDispInfo = dcbUtils.prepareDisplayInfo();
                this.dcbReport = this.dcbService.getCurrentDCBAndReceipts(this.dcbDispInfo);
                this.activeRcpts = this.populateActiveReceiptsOnly(this.dcbReport.getReceipts());
                this.cancelRcpt = this.populateCancelledReceiptsOnly(this.dcbReport.getReceipts());
                this.populateMutationReceipts();
            } else {
                this.viewMap.put("currTaxAmount", BigDecimal.ZERO);
                this.viewMap.put("currTaxDue", BigDecimal.ZERO);
                this.viewMap.put("totalArrDue", BigDecimal.ZERO);
                this.dcbReport.setTotalDmdTax(BigDecimal.ZERO);
                this.dcbReport.setTotalLpayPnlty(BigDecimal.ZERO);
                this.dcbReport.setTotalDmdPnlty(BigDecimal.ZERO);
                this.dcbReport.setTotalColTax(BigDecimal.ZERO);
                this.dcbReport.setTotalColPnlty(BigDecimal.ZERO);
                this.dcbReport.setTotalColLpayPnlty(BigDecimal.ZERO);
                this.dcbReport.setTotalRebate(BigDecimal.ZERO);
                this.dcbReport.setTotalBalance(BigDecimal.ZERO);
            }
        }
        catch (DCBException e) {
            this.errorMessage = "Demand details does not exists !";
            LOGGER.warn((Object)this.errorMessage);
        }
        LOGGER.debug((Object)"Exit from method displayPropInfo");
        return VIEW;
    }

    @Action(value="/view/viewDCBProperty-displayHeadwiseDcb")
    public String displayHeadwiseDcb() {
        LOGGER.debug((Object)"Entered into method displayHeadwiseDcb");
        LOGGER.debug((Object)("displayPropInfo : Index Number : " + this.propertyId));
        DCBUtils dcbUtils = new DCBUtils();
        this.session = this.request.getSession();
        if (this.session.getAttribute("com.egov.user.LoginUserId") == null) {
            this.session.setAttribute("com.egov.user.LoginUserName", (Object)"9999999999");
            this.setCitizen(Boolean.TRUE);
        } else {
            this.setCitizen(Boolean.FALSE);
        }
        try {
            if (this.getBasicProperty() == null) {
                throw new PropertyNotFoundException();
            }
        }
        catch (PropertyNotFoundException e) {
            LOGGER.error((Object)("Property not found with given Index Number " + this.propertyId), (Throwable)e);
        }
        LOGGER.debug((Object)("BasicProperty : " + this.basicProperty));
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.propertyId);
        PropertyTaxBillable billable = (PropertyTaxBillable)this.beanProvider.getBean("propertyTaxBillable");
        billable.setBasicProperty(this.basicProperty);
        this.dcbService.setBillable((Billable)billable);
        this.dcbDispInfo = dcbUtils.prepareDisplayInfoHeadwise();
        this.dcbReport = this.dcbService.getCurrentDCBAndReceipts(this.dcbDispInfo);
        LOGGER.debug((Object)"Exit from method displayHeadwiseDcb");
        return HEADWISE_DCB;
    }

    private List<Receipt> populateActiveReceiptsOnly(Map<Installment, List<Receipt>> receipts) {
        ArrayList<Receipt> rcpt = new ArrayList<Receipt>();
        for (Map.Entry<Installment, List<Receipt>> entry : receipts.entrySet()) {
            for (Receipt r : entry.getValue()) {
                if (rcpt.contains(r) || r.getReceiptStatus().equals(EgdmCollectedReceipt.RCPT_CANCEL_STATUS)) continue;
                rcpt.add(r);
            }
        }
        return this.receiptsInDescendingOrderOfReceiptDate(rcpt);
    }

    private List<Receipt> receiptsInDescendingOrderOfReceiptDate(List<Receipt> receipts) {
        LOGGER.debug((Object)"Entered into receiptsInDescendingOrderOfReceiptDate");
        Collections.sort(receipts, new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.debug((Object)"Exiting from receiptsInDescendingOrderOfReceiptDate");
        return receipts;
    }

    private List<Receipt> populateCancelledReceiptsOnly(Map<Installment, List<Receipt>> receipts) {
        ArrayList<Receipt> rcpt = new ArrayList<Receipt>();
        for (Map.Entry<Installment, List<Receipt>> entry : receipts.entrySet()) {
            for (Receipt r : entry.getValue()) {
                if (rcpt.contains(r) || !r.getReceiptStatus().equals(EgdmCollectedReceipt.RCPT_CANCEL_STATUS)) continue;
                rcpt.add(r);
            }
        }
        return this.receiptsInDescendingOrderOfReceiptDate(rcpt);
    }

    public List<Receipt> getCancelledReceipts() {
        LOGGER.debug((Object)"Entered into method getCancelledReceipts");
        ArrayList<Receipt> cancelledReceipts = new ArrayList<Receipt>();
        for (Installment inst : this.dcbReport.getReceipts().keySet()) {
            List receipts = (List)this.dcbReport.getReceipts().get(inst);
            LOGGER.debug((Object)("Installment : " + inst));
            LOGGER.debug((Object)"Cancelled receipts : ");
            for (Receipt rcpt : receipts) {
                if (cancelledReceipts.contains(rcpt) || !rcpt.getReceiptStatus().equals(PropertyTaxConstants.CANCELLED_RECEIPT_STATUS)) continue;
                LOGGER.debug((Object)("Receipt : " + rcpt));
                cancelledReceipts.add(rcpt);
            }
        }
        LOGGER.debug((Object)("Number of cancelled receitps : " + (cancelledReceipts != null ? Integer.valueOf(cancelledReceipts.size()) : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from method getCancelledREceipts");
        return cancelledReceipts;
    }

    @SkipValidation
    public void setServletRequest(HttpServletRequest arg0) {
        this.request = arg0;
    }

    @Action(value="/view/viewDCBProperty-showMigData")
    public String getMigratedData() {
        LOGGER.debug((Object)"Entered into getMigratedData");
        LOGGER.debug((Object)("getMigratedData - propertyId: " + this.getPropertyId()));
        this.propReceiptList = this.getPersistenceService().findAllBy("from PropertyReceipt where basicProperty.id=? order by receiptDate desc", new Object[]{this.getBasicProperty().getId()});
        for (PropertyReceipt propReceipt : this.propReceiptList) {
            try {
                propReceipt.setReceiptDate(this.sdf.parse(this.sdf.format(propReceipt.getReceiptDate())));
                if (propReceipt.getFromDate() != null) {
                    propReceipt.setFromDate(this.sdf.parse(this.sdf.format(propReceipt.getFromDate())));
                }
                if (propReceipt.getToDate() == null) continue;
                propReceipt.setToDate(this.sdf.parse(this.sdf.format(propReceipt.getToDate())));
            }
            catch (ParseException e) {
                LOGGER.error((Object)("ParseException in getPropertyArrears method for Property" + this.propertyId), (Throwable)e);
            }
        }
        LOGGER.debug((Object)"Exiting from getMigratedData");
        return RESULT_MIGDATA;
    }

    private void populateMutationReceipts() {
        Receipt receipt = null;
        for (PropertyMutation propMutation : this.basicProperty.getPropertyMutations()) {
            if (propMutation.getReceiptNum() == null || propMutation.getReceiptNum().isEmpty()) continue;
            receipt = new Receipt();
            receipt.setReceiptNumber(propMutation.getReceiptNum());
            receipt.setReceiptAmt(propMutation.getMutationFee());
            receipt.setReceiptDate(propMutation.getReceiptDate());
            receipt.setConsumerCode(propMutation.getApplicationNo());
            this.mutationRcpts.add(receipt);
        }
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public DCBService getDcbService() {
        return this.dcbService;
    }

    public void setDcbService(DCBService dcbService) {
        this.dcbService = dcbService;
    }

    public DCBDisplayInfo getDcbDispInfo() {
        return this.dcbDispInfo;
    }

    public void setDcbDispInfo(DCBDisplayInfo dcbDispInfo) {
        this.dcbDispInfo = dcbDispInfo;
    }

    public DCBReport getDcbReport() {
        return this.dcbReport;
    }

    public void setDcbReport(DCBReport dcbReport) {
        this.dcbReport = dcbReport;
    }

    public Map<String, BigDecimal> getPropertyArrearsMap() {
        return this.propertyArrearsMap;
    }

    public void setPropertyArrearsMap(Map<String, BigDecimal> propertyArrearsMap) {
        this.propertyArrearsMap = propertyArrearsMap;
    }

    public Boolean getIsCitizen() {
        return this.isCitizen;
    }

    public void setCitizen(Boolean isCitizen) {
        this.isCitizen = isCitizen;
    }

    public List<PropertyArrearBean> getPropertyArrearsList() {
        return this.propertyArrearsList;
    }

    public void setPropertyArrearsList(List<PropertyArrearBean> propertyArrearsList) {
        this.propertyArrearsList = propertyArrearsList;
    }

    public List<PropertyReceipt> getPropReceiptList() {
        return this.propReceiptList;
    }

    public void setPropReceiptList(List<PropertyReceipt> propReceiptList) {
        this.propReceiptList = propReceiptList;
    }

    public List<Receipt> getCancelRcpt() {
        return this.cancelRcpt;
    }

    public void setCancelRcpt(List<Receipt> cancelRcpt) {
        this.cancelRcpt = cancelRcpt;
    }

    public List<Receipt> getActiveRcpts() {
        return this.activeRcpts;
    }

    public void setActiveRcpts(List<Receipt> activeRcpts) {
        this.activeRcpts = activeRcpts;
    }

    public List<Receipt> getMutationRcpts() {
        return this.mutationRcpts;
    }

    public void setMutationRcpts(List<Receipt> mutationRcpts) {
        this.mutationRcpts = mutationRcpts;
    }

    public String getDemandEffectiveYear() {
        return this.demandEffectiveYear;
    }

    public void setDemandEffectiveYear(String demandEffectiveYear) {
        this.demandEffectiveYear = demandEffectiveYear;
    }

    public Integer getNoOfDaysForInactiveDemand() {
        return this.noOfDaysForInactiveDemand;
    }

    public void setNoOfDaysForInactiveDemand(Integer noOfDaysForInactiveDemand) {
        this.noOfDaysForInactiveDemand = noOfDaysForInactiveDemand;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, Object> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Object> viewMap) {
        this.viewMap = viewMap;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }
}

