/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.ptis.actions.reports.DefaultersReportHelperAdaptor;
import org.egov.ptis.bean.DefaultersInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.InstDmdCollMaterializeView;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Namespace(value="/reports")
@Results(value={@Result(name="search", location="reports/defaultersReport-search.jsp")})
public class DefaultersReportAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(DefaultersReportAction.class);
    public static final String RESULT_SEARCH = "search";
    private Long wardId;
    private String fromDemand;
    private String toDemand;
    private Integer limit;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    public PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    private Map<String, String> ownerShipMap;
    private String ownerShipType;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into prepare method");
        }
        super.prepare();
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        this.addDropdownData("wardList", wardList);
        this.addDropdownData("limitList", this.buildLimitList());
        this.setOwnerShipMap((Map)PropertyTaxConstants.OWNERSHIP_OF_PROPERTY_FOR_DEFAULTERS_REPORT);
    }

    @SkipValidation
    @Action(value="/defaultersReport-search")
    public String search() {
        return RESULT_SEARCH;
    }

    private List<Integer> buildLimitList() {
        ArrayList<Integer> limitList = new ArrayList<Integer>();
        limitList.add(10);
        limitList.add(50);
        limitList.add(100);
        limitList.add(500);
        limitList.add(1000);
        return limitList;
    }

    @Action(value="/defaultersReport-getDefaultersList")
    public void getDefaultersList() {
        List resultList = new ArrayList();
        String result = null;
        Query query = this.propertyTaxUtil.prepareQueryforDefaultersReport(this.wardId, this.fromDemand, this.toDemand, this.limit, this.ownerShipType);
        resultList = this.prepareOutput(query.list());
        result = "{ \"data\":" + this.toJSON(resultList) + "}";
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("application/json");
        try {
            IOUtils.write((String)result, (Writer)response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object toJSON(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DefaultersInfo.class, (Object)new DefaultersReportHelperAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private List<DefaultersInfo> prepareOutput(List<PropertyMaterlizeView> propertyViewList) {
        ArrayList<DefaultersInfo> defaultersList = new ArrayList<DefaultersInfo>();
        DefaultersInfo defaultersInfo = null;
        BigDecimal totalDue = BigDecimal.ZERO;
        BigDecimal currPenalty = BigDecimal.ZERO;
        BigDecimal currPenaltyColl = BigDecimal.ZERO;
        int count = 0;
        Installment curInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        for (PropertyMaterlizeView propView : propertyViewList) {
            defaultersInfo = new DefaultersInfo();
            totalDue = BigDecimal.ZERO;
            currPenalty = BigDecimal.ZERO;
            currPenaltyColl = BigDecimal.ZERO;
            defaultersInfo.setSlNo(Integer.valueOf(++count));
            defaultersInfo.setAssessmentNo(propView.getPropertyId());
            defaultersInfo.setOwnerName(propView.getOwnerName().contains(",") ? propView.getOwnerName().replace(",", " & ") : propView.getOwnerName());
            defaultersInfo.setWardName(propView.getWard().getName());
            defaultersInfo.setHouseNo(propView.getHouseNo());
            defaultersInfo.setLocality(propView.getLocality() != null ? propView.getLocality().getName() : "NA");
            defaultersInfo.setMobileNumber(StringUtils.isNotBlank((String)propView.getMobileNumber()) ? propView.getMobileNumber() : "NA");
            defaultersInfo.setArrearsDue(propView.getAggrArrDmd().subtract(propView.getAggrArrColl()));
            defaultersInfo.setCurrentDue(propView.getAggrCurrFirstHalfDmd().add(propView.getAggrCurrSecondHalfDmd()).subtract(propView.getAggrCurrFirstHalfColl().add(propView.getAggrCurrSecondHalfColl())));
            defaultersInfo.setAggrArrearPenalyDue((propView.getAggrArrearPenaly() != null ? propView.getAggrArrearPenaly() : BigDecimal.ZERO).subtract(propView.getAggrArrearPenalyColl() != null ? propView.getAggrArrearPenalyColl() : BigDecimal.ZERO));
            currPenalty = (propView.getAggrCurrFirstHalfPenaly() != null ? propView.getAggrCurrFirstHalfPenaly() : BigDecimal.ZERO).add(propView.getAggrCurrSecondHalfPenaly() != null ? propView.getAggrCurrSecondHalfPenaly() : BigDecimal.ZERO);
            currPenaltyColl = (propView.getAggrCurrFirstHalfPenalyColl() != null ? propView.getAggrCurrFirstHalfPenalyColl() : BigDecimal.ZERO).add(propView.getAggrCurrSecondHalfPenalyColl() != null ? propView.getAggrCurrSecondHalfPenalyColl() : BigDecimal.ZERO);
            defaultersInfo.setAggrCurrPenalyDue(currPenalty.subtract(currPenaltyColl));
            totalDue = defaultersInfo.getArrearsDue().add(defaultersInfo.getCurrentDue()).add(defaultersInfo.getAggrArrearPenalyDue()).add(defaultersInfo.getAggrCurrPenalyDue());
            defaultersInfo.setTotalDue(totalDue);
            if (propView.getInstDmdColl().size() != 0 && !propView.getInstDmdColl().isEmpty()) {
                defaultersInfo.setArrearsFrmInstallment(((InstDmdCollMaterializeView)propView.getInstDmdColl().iterator().next()).getInstallment().getDescription());
                Iterator itr = propView.getInstDmdColl().iterator();
                InstDmdCollMaterializeView idc = new InstDmdCollMaterializeView();
                InstDmdCollMaterializeView lastElement = new InstDmdCollMaterializeView();
                while (itr.hasNext()) {
                    idc = (InstDmdCollMaterializeView)itr.next();
                    if (idc.getInstallment().equals((Object)curInstallment)) continue;
                    lastElement = idc;
                }
                if (lastElement != null && lastElement.getInstallment() != null) {
                    defaultersInfo.setArrearsToInstallment(lastElement.getInstallment().getDescription());
                }
            }
            defaultersList.add(defaultersInfo);
        }
        return defaultersList;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getFromDemand() {
        return this.fromDemand;
    }

    public void setFromDemand(String fromDemand) {
        this.fromDemand = fromDemand;
    }

    public String getToDemand() {
        return this.toDemand;
    }

    public void setToDemand(String toDemand) {
        this.toDemand = toDemand;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Map<String, String> getOwnerShipMap() {
        return this.ownerShipMap;
    }

    public void setOwnerShipMap(Map<String, String> ownerShipMap) {
        this.ownerShipMap = ownerShipMap;
    }

    public String getOwnerShipType() {
        return this.ownerShipType;
    }

    public void setOwnerShipType(String ownerShipType) {
        this.ownerShipType = ownerShipType;
    }
}

