/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.recovery;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.actions.view.ViewPropertyAction;
import org.egov.ptis.client.util.FinancialUtil;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.recovery.Recovery;
import org.egov.ptis.domain.entity.recovery.WarrantFee;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BaseRecoveryAction
extends PropertyTaxBaseAction {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(BaseRecoveryAction.class);
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", new Locale("en", "IN"));
    protected ViewPropertyAction viewPropertyAction = new ViewPropertyAction();
    protected Map<String, Object> viewMap;
    protected String ownerName;
    protected String propertyAddress;
    protected EisCommonService eisCommonService;
    protected ReportService reportService;
    protected String reportId;
    protected ModuleService moduleService;
    protected PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    protected PersistenceService<BasicProperty, Long> basicPropertyService;
    protected FinancialUtil financialUtil;
    protected NoticeService noticeService;
    private InstallmentDao instalDao;
    private ModuleService moduleDao;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public StateAware getModel() {
        return null;
    }

    protected BasicProperty getPropertyView(String propertyId) {
        this.LOGGER.debug((Object)"BaseRecoveryAction | getPropertyView | Start");
        this.viewPropertyAction.setPropertyId(propertyId);
        this.viewPropertyAction.setPropertyTaxUtil(new PropertyTaxUtil());
        this.viewPropertyAction.setSession(this.getSession());
        this.viewPropertyAction.setPersistenceService(this.persistenceService);
        this.viewPropertyAction.viewForm();
        this.viewMap = this.viewPropertyAction.getViewMap();
        this.LOGGER.debug((Object)"BaseRecoveryAction | getPropertyView | End");
        return this.viewPropertyAction.getBasicProperty();
    }

    protected void validateStartRecovery(Recovery recovery) {
        if (this.getCurrentDate().after(recovery.getIntimationNotice().getPaymentDueDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("paymentDueDate", this.getText("paymentDueDate.greaterThan.currentDate"))));
        }
    }

    protected void validateWarrantNotice(Recovery recovery) {
        if (recovery.getIntimationNotice().getPaymentDueDate().after(recovery.getWarrantNotice().getWarrantReturnByDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("warrantReturnByDate", this.getText("warrantReturnByDate.greaterThan.paymentDueDate"))));
        }
    }

    protected void validateCeaseNotice(Recovery recovery) {
        if (recovery.getWarrantNotice().getWarrantReturnByDate().after(recovery.getCeaseNotice().getExecutionDate())) {
            throw new ValidationException(Arrays.asList(new ValidationError("executionDate", this.getText("executionDate.greaterThan.warrantReturnByDate"))));
        }
    }

    protected String getNextState(String currectState) {
        if (currectState.equalsIgnoreCase("NOTICE155CREATED")) {
            return "Generate Notice 155";
        }
        if (currectState.equalsIgnoreCase("NOTICE155GENERATED")) {
            return "Create Warrant";
        }
        if (currectState.equalsIgnoreCase("WARRANT APPLICATION PREPARED")) {
            return "Generate Warrant Application Pending";
        }
        if (currectState.equalsIgnoreCase("WARRANT APPLICATION APPROVED")) {
            return "Create Notice 156";
        }
        if (currectState.equalsIgnoreCase("WARRANT NOTICE CREATED")) {
            return "Issue Notice 156";
        }
        if (currectState.equalsIgnoreCase("WARRANT NOTICE ISSUED")) {
            return "Create Notice 159";
        }
        if (currectState.equalsIgnoreCase("CEASE NOTICE CREATED")) {
            return "Issue Notice 159";
        }
        return null;
    }

    protected EgBill getBil(String consumerId) {
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Installment finYear = this.instalDao.getInsatllmentByModuleForGivenDate(module, new Date());
        StringBuffer query = new StringBuffer(100);
        query.append("select id from eg_bill where issue_date = ( select issue_date from (select issue_date from eg_bill where").append(" consumer_id='" + consumerId + "' and issue_date >=to_date('" + DDMMYYYYFORMATS.format(finYear.getFromDate()) + "','dd/MM/yyyy')").append("  order by issue_date desc)  group by rownum,issue_date having rownum <=1)");
        this.LOGGER.debug((Object)("BaseRecoveryAction | getBilAmount | query >> " + query.toString()));
        List list = this.persistenceService.getSession().createSQLQuery(query.toString()).list();
        if (list != null && list.size() > 0) {
            EgBill bill = (EgBill)this.persistenceService.find(" from EgBill where id=" + list.get(0));
            return bill;
        }
        return null;
    }

    public Long getDemandReason(String demandMaster) {
        StringBuffer query = new StringBuffer();
        query.append(" from EgDemandReason where egDemandReasonMaster.reasonMaster='" + demandMaster + "'").append(" and egInstallmentMaster.id='" + this.propertyTaxCommonUtils.getCurrentInstallment().getId() + "'");
        EgDemandReason demandReason = (EgDemandReason)this.persistenceService.find(query.toString());
        return demandReason.getId();
    }

    protected Map<String, Object> getNotice156Param(Recovery recovery) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("currentDate", DateUtils.getFormattedDate((Date)new Date(), (String)"dd/MM/yyyy"));
        params.put("ownerFatherName", "-");
        params.put("taxName", "Property Tax");
        BigDecimal totalWarrantFees = BigDecimal.ZERO;
        for (WarrantFee warrantFee : recovery.getWarrant().getWarrantFees()) {
            totalWarrantFees = totalWarrantFees.add(warrantFee.getAmount());
        }
        params.put("totalWarrantFees", totalWarrantFees.setScale(2).toString());
        params.put("warrantReturnByDate", DateUtils.convertToWords((Date)recovery.getWarrantNotice().getWarrantReturnByDate()));
        return params;
    }

    protected Map<String, Object> getNotice159Param(Recovery recovery) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fatherName", "-");
        params.put("noticeDate", DDMMYYYYFORMATS.format(new Date()));
        BigDecimal totalWarrantFees = BigDecimal.ZERO;
        for (WarrantFee warrantFee : recovery.getWarrant().getWarrantFees()) {
            totalWarrantFees = totalWarrantFees.add(warrantFee.getAmount());
        }
        params.put("totalWarrantFees", totalWarrantFees.setScale(2).toString());
        return params;
    }

    protected void updateDemand(Recovery recovery) {
        StringBuffer consumerId = new StringBuffer();
        consumerId.append(recovery.getBasicProperty().getUpicNo()).append("(Zone:").append(recovery.getBasicProperty().getPropertyID().getZone().getBoundaryNum()).append(" Ward:").append(recovery.getBasicProperty().getPropertyID().getWard().getBoundaryNum()).append(")");
        EgBill currentBill = this.getBil(consumerId.toString());
        EgDemand currentDemand = currentBill.getEgDemand();
        Set demandDetails = currentDemand.getEgDemandDetails();
        EgDemandDetails demandDetail = new EgDemandDetails();
        BigDecimal totalDemandAmt = currentDemand.getBaseDemand();
        for (WarrantFee warrantFee : recovery.getWarrant().getWarrantFees()) {
            totalDemandAmt = totalDemandAmt.add(warrantFee.getAmount());
            demandDetail = new EgDemandDetails();
            demandDetail.setAmount(warrantFee.getAmount());
            demandDetail.setAmtCollected(BigDecimal.ZERO);
            demandDetail.setAmtRebate(BigDecimal.ZERO);
            demandDetail.setEgDemandReason(warrantFee.getDemandReason());
            demandDetail.setCreateDate(new Date());
            demandDetail.setModifiedDate(new Date());
            demandDetails.add(demandDetail);
        }
        currentDemand.setBaseDemand(totalDemandAmt);
        currentDemand.setEgDemandDetails(demandDetails);
        currentBill.setTotalAmount(totalDemandAmt);
        currentBill.setEgDemand(currentDemand);
        this.egBillDAO.update(currentBill);
        HashMap amounts = new HashMap();
        HashMap<String, BigDecimal> voucherDemandMap = new HashMap<String, BigDecimal>();
        voucherDemandMap.put("RECOVERY_FEE", totalDemandAmt);
        amounts.put(currentDemand.getEgInstallmentMaster(), voucherDemandMap);
        this.financialUtil.createVoucher(recovery.getBasicProperty().getUpicNo(), amounts, "Recovery Fees");
    }

    protected EgwStatus getEgwStatusForModuleAndCode(String moduleName, String statusCode) {
        EgwStatus status = (EgwStatus)this.persistenceService.findByNamedQuery("getStatusByModuleAndCode", new Object[]{moduleName, statusCode});
        return status;
    }

    protected PropertyStatus getPropStatusByStatusCode(String statusCode) {
        PropertyStatus status = (PropertyStatus)this.persistenceService.findByNamedQuery("getPropStatusByStatusCode", new Object[]{statusCode});
        return status;
    }

    public Boolean authenticateInboxItemRqst(State state) {
        if (null == state || null == state.getOwnerUser()) {
            return Boolean.FALSE;
        }
        Object authorisedUser = null;
        Object loggedInUser = null;
        return authorisedUser.equals(loggedInUser);
    }

    protected String addingReportToSession(ReportOutput reportOutput) {
        return this.reportViewerUtil.addReportToTempCache(reportOutput);
    }

    public Map<String, Object> getViewMap() {
        return this.viewMap;
    }

    public void setViewPropertyAction(ViewPropertyAction viewPropertyAction) {
        this.viewPropertyAction = viewPropertyAction;
    }

    public void setViewMap(Map<String, Object> viewMap) {
        this.viewMap = viewMap;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getPropertyAddress() {
        return this.propertyAddress;
    }

    public void setOwnerName(Property property) {
        this.ownerName = property.getBasicProperty().getFullOwnerName();
    }

    public void setPropertyAddress(Address address) {
        this.propertyAddress = address.toString();
    }

    public Date getCurrentDate() {
        return new Date();
    }

    public void setFinancialUtil(FinancialUtil financialUtil) {
        this.financialUtil = financialUtil;
    }

    public void setNoticeService(NoticeService noticeService) {
        this.noticeService = noticeService;
    }
}

