/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.modify;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Area;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.client.util.FinancialUtil;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyStatusValuesDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@ResultPath(value="/WEB-INF/jsp")
@Results(value={@Result(name="ack", location="modify/modifyProperty-ack.jsp"), @Result(name="edit", location="modify/modifyProperty-new.jsp"), @Result(name="new", location="modify/modifyProperty-new.jsp"), @Result(name="view", location="modify/modifyProperty-view.jsp"), @Result(name="workFlowError", location="workflow/workflow-error.jsp"), @Result(name="balance", location="modify/modifyProperty-balance.jsp"), @Result(name="printAck", location="modify/modifyProperty-printAck.jsp"), @Result(name="commonForm", location="search/searchProperty-commonForm.jsp")})
@Namespace(value="/modify")
public class ModifyPropertyAction
extends PropertyTaxBaseAction {
    protected static final String COMMON_FORM = "commonForm";
    private static final String PROPERTY_MODIFY_REJECT_SUCCESS = "property.modify.reject.success";
    private static final String PROPERTY_MODIFY_FINAL_REJECT_SUCCESS = "property.modify.final.reject.success";
    private static final String PROPERTY_MODIFY_APPROVE_SUCCESS = "property.modify.approve.success";
    private static final String PROPERTY_FORWARD_SUCCESS = "property.forward.success";
    private static final String TAXDUES_ERROR_MSG = "taxdues.error.msg";
    private static final String WF_PENDING_MSG = "wf.pending.msg";
    private static final String PROPERTY_ALTER_ADDITION = "Property Alter/Addition";
    private static final String PROPERTY_BIFURCATION = "Property Bifurcation";
    private static final String PROPERTY_GENERAL_REVISION_PETITION = "Property General Revision Petition";
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private static final String BIFURCATION = "Bifurcation";
    protected static final String BALANCE = "balance";
    protected static final String RESULT_ACK = "ack";
    private static final String RESULT_ERROR = "error";
    protected static final String VIEW = "view";
    private static final String MODIFY_ACK_TEMPLATE = "modifyProperty_ack";
    private static final String GRP_ACK_TEMPLATE = "GRP_Property_ack";
    public static final String PRINT_ACK = "printAck";
    private PersistenceService<Property, Long> propertyImplService;
    private PersistenceService<Floor, Long> floorService;
    private BasicProperty basicProp;
    private PropertyImpl oldProperty = new PropertyImpl();
    private PropertyImpl propertyModel = new PropertyImpl();
    private String areaOfPlot;
    private Map<String, String> waterMeterMap;
    private boolean generalTax;
    private boolean sewerageTax;
    private boolean lightingTax;
    private boolean fireServTax;
    private boolean bigResdBldgTax;
    private boolean educationCess;
    private boolean empGuaCess;
    private TreeMap<Integer, String> floorNoMap;
    private String dateOfCompletion;
    private String modifyRsn;
    private Map<String, String> modifyReasonMap;
    private String ownerName;
    private String propAddress;
    private String corrsAddress;
    private String[] amalgPropIds;
    private PropertyService propService;
    private String courtOrdNum;
    private String orderDate;
    private String judgmtDetails;
    private String isAuthProp;
    private String amalgStatus;
    private BasicProperty amalgPropBasicProp;
    private String oldpropId;
    private String oldOwnerName;
    private String oldPropAddress;
    private String ackMessage;
    private Map<String, String> amenitiesMap;
    private String propTypeId;
    private String propertyCategory;
    private String propUsageId;
    private String propOccId;
    private String amenities;
    private String[] floorNoStr = new String[100];
    List<ValidationError> errors = new ArrayList();
    final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    int i = 0;
    private PropertyImpl propWF;
    private Map<String, String> propTypeCategoryMap;
    FinancialUtil financialUtil = new FinancialUtil();
    private String docNumber;
    private boolean isfloorDetailsRequired;
    private boolean updateData;
    private PropertyAddress propertyAddr;
    private String parcelId;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private String errorMessage;
    private String partNo;
    private List<PropertyOwnerInfo> propertyOwners = new ArrayList();
    private String modificationType;
    private boolean isTenantFloorPresent;
    private String mode;
    private Integer buildingPermissionNo;
    private Date buildingPermissionDate;
    private Long floorTypeId;
    private Long roofTypeId;
    private Long wallTypeId;
    private Long woodTypeId;
    private List<DocumentType> documentTypes = new ArrayList();
    private ReportService reportService;
    private String reportId;
    private PropertyTypeMaster propTypeMstr;
    private Map<String, String> deviationPercentageMap;
    private String certificationNumber;
    private String northBoundary;
    private String southBoundary;
    private String eastBoundary;
    private String westBoundary;
    private BigDecimal currentPropertyTax;
    private BigDecimal currentPropertyTaxDue;
    private BigDecimal currentWaterTaxDue;
    private BigDecimal arrearPropertyTaxDue;
    private String taxDueErrorMsg;
    private Long taxExemptedReason;
    private Boolean wfInitiatorRejected;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private PropertyStatusValuesDAO propertyStatusValuesDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public ModifyPropertyAction() {
        this.propertyModel.setPropertyDetail((PropertyDetail)new BuiltUpProperty());
        this.addRelatedEntity("propertyDetail.propertyTypeMaster", PropertyTypeMaster.class);
        this.addRelatedEntity("propertyDetail.apartment", Apartment.class);
    }

    @SkipValidation
    public StateAware getModel() {
        return this.propertyModel;
    }

    @SkipValidation
    @Action(value="/modifyProperty-modifyForm")
    public String modifyForm() {
        this.LOGGER.debug((Object)("Entered into modifyForm, \nIndexNumber: " + this.indexNumber + ", BasicProperty: " + this.basicProp + ", OldProperty: " + this.oldProperty + ", PropertyModel: " + this.propertyModel));
        if (this.propertyModel.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE)) {
            this.addActionError(this.getText("error.msg.demandInactive"));
            return COMMON_FORM;
        }
        String target = "";
        target = this.populateFormData(Boolean.FALSE);
        this.LOGGER.debug((Object)("modifyForm: IsAuthProp: " + this.getIsAuthProp() + ", AreaOfPlot: " + this.getAreaOfPlot() + ", PropTypeId: " + this.getPropTypeId() + ", PropertyCategory: " + this.getPropertyCategory() + ", PropUsageId: " + this.getPropUsageId() + ", PropOccId: " + this.getPropOccId()));
        this.LOGGER.debug((Object)"Exiting from modifyForm");
        return target;
    }

    @SkipValidation
    @Action(value="/modifyProperty-modifyDataEntry")
    public String modifyDataEntry() {
        this.LOGGER.debug((Object)("Entered into modifyForm, \nIndexNumber: " + this.indexNumber + ", BasicProperty: " + this.basicProp + ", OldProperty: " + this.oldProperty + ", PropertyModel: " + this.propertyModel));
        String target = "";
        target = this.populateFormData(Boolean.FALSE);
        this.LOGGER.debug((Object)("modifyForm: IsAuthProp: " + this.getIsAuthProp() + ", AreaOfPlot: " + this.getAreaOfPlot() + ", PropTypeId: " + this.getPropTypeId() + ", PropTypeCategoryId: " + this.getPropertyCategory() + ", PropUsageId: " + this.getPropUsageId() + ", PropOccId: " + this.getPropOccId()));
        this.LOGGER.debug((Object)"Exiting from modifyForm");
        return target;
    }

    @SkipValidation
    @Action(value="/modifyProperty-saveDataEntry")
    public String saveDataEntry() {
        this.LOGGER.debug((Object)("updateData: Property modification started for Migrated Property, PropertyId: " + this.propertyModel));
        long startTimeMillis = System.currentTimeMillis();
        this.LOGGER.debug((Object)("Entered into modifyForm, \nIndexNumber: " + this.indexNumber + ", BasicProperty: " + this.basicProp + ", OldProperty: " + this.oldProperty + ", PropertyModel: " + this.propertyModel));
        Date propCompletionDate = null;
        PropertyTypeMaster proptypeMstr = this.propertyTypeMasterDAO.findById(Integer.valueOf(this.propTypeId), false);
        propCompletionDate = !proptypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.propertyModel.getPropertyDetail().getFloorDetailsProxy()) : this.propertyModel.getPropertyDetail().getDateOfCompletion();
        PropertyImpl property = (PropertyImpl)this.basicProp.getProperty();
        this.propService.createProperty(property, this.getAreaOfPlot(), this.modifyRsn, this.propTypeId, this.propUsageId, this.propOccId, Character.valueOf('A'), this.propertyModel.getDocNumber(), null, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, this.taxExemptedReason);
        this.propertyModel.setPropertyModifyReason(this.modifyRsn);
        this.propertyModel.setBasicProperty(this.basicProp);
        this.propertyModel.setEffectiveDate(propCompletionDate);
        this.LOGGER.debug((Object)("modifyForm: AreaOfPlot: " + this.getAreaOfPlot() + ", PropTypeId: " + this.getPropTypeId() + ", PropUsageId: " + this.getPropUsageId() + ", PropOccId: " + this.getPropOccId()));
        this.LOGGER.debug((Object)"Exiting from modifyForm");
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        this.LOGGER.info((Object)("updateData: Property modified successfully in system with Index Number: " + this.basicProp.getUpicNo() + "; Time taken(ms) = " + elapsedTimeMillis));
        return RESULT_ACK;
    }

    private String populateFormData(Boolean fromInbox) {
        this.LOGGER.debug((Object)"Entered into populateFormData");
        String target = "";
        PropertyImpl propertyImpl = null;
        if (this.basicProp.isUnderWorkflow() && !fromInbox.booleanValue()) {
            ArrayList<String> msgParams = new ArrayList<String>();
            if ("BIFURCATE".equalsIgnoreCase(this.modifyRsn)) {
                msgParams.add(PROPERTY_BIFURCATION);
            } else if ("ADD_OR_ALTER".equalsIgnoreCase(this.modifyRsn)) {
                msgParams.add(PROPERTY_ALTER_ADDITION);
            } else {
                msgParams.add(PROPERTY_GENERAL_REVISION_PETITION);
            }
            this.setWfErrorMsg(this.getText(WF_PENDING_MSG, msgParams));
            target = "workFlowError";
        } else {
            boolean hasChildPropertyUnderWorkflow;
            if ("BIFURCATE".equalsIgnoreCase(this.modifyRsn) && !fromInbox.booleanValue()) {
                Map propertyTaxDetails = this.propService.getCurrentPropertyTaxDetails((Property)this.basicProp.getActiveProperty());
                Map currentTaxAndDue = this.propertyService.getCurrentTaxAndBalance(propertyTaxDetails, new Date());
                this.currentPropertyTax = (BigDecimal)currentTaxAndDue.get("CURR_DMD");
                this.currentPropertyTaxDue = (BigDecimal)currentTaxAndDue.get("CURR_BAL");
                this.arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                this.currentWaterTaxDue = this.propertyService.getWaterTaxDues(this.basicProp.getUpicNo());
                if (this.currentWaterTaxDue.add(this.currentPropertyTaxDue).add(this.arrearPropertyTaxDue).longValue() > 0L) {
                    this.setTaxDueErrorMsg(this.getText(TAXDUES_ERROR_MSG, new String[]{BIFURCATION}));
                    return BALANCE;
                }
            }
            if (hasChildPropertyUnderWorkflow = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProp.getUpicNo())) {
                this.setWfErrorMsg(this.getText("error.msg.child.underworkflow"));
                return "workFlowError";
            }
            this.setOldProperty((PropertyImpl)this.getBasicProp().getProperty());
            propertyImpl = this.propWF == null && (this.propertyModel == null || this.propertyModel.getId() == null) ? (PropertyImpl)this.oldProperty.createPropertyclone() : (this.propWF != null ? this.propWF : this.propertyModel);
            this.setProperty(propertyImpl);
            this.setOwnerName(this.basicProp.getFullOwnerName());
            this.setPropAddress(this.basicProp.getAddress().toString());
            this.propertyAddr = this.basicProp.getAddress();
            this.corrsAddress = PropertyTaxUtil.getOwnerAddress((List)this.basicProp.getPropertyOwnerInfo());
            if (this.propertyModel.getPropertyDetail().getFloorType() != null) {
                this.floorTypeId = this.propertyModel.getPropertyDetail().getFloorType().getId();
            }
            if (this.propertyModel.getPropertyDetail().getRoofType() != null) {
                this.roofTypeId = this.propertyModel.getPropertyDetail().getRoofType().getId();
            }
            if (this.propertyModel.getPropertyDetail().getWallType() != null) {
                this.wallTypeId = this.propertyModel.getPropertyDetail().getWallType().getId();
            }
            if (this.propertyModel.getPropertyDetail().getWoodType() != null) {
                this.woodTypeId = this.propertyModel.getPropertyDetail().getWoodType().getId();
            }
            if (this.propertyModel.getPropertyDetail().getSitalArea() != null) {
                this.setAreaOfPlot(this.propertyModel.getPropertyDetail().getSitalArea().getArea().toString());
            }
            if (this.basicProp.getPropertyID() != null) {
                PropertyID propertyID = this.basicProp.getPropertyID();
                this.northBoundary = propertyID.getNorthBoundary();
                this.southBoundary = propertyID.getSouthBoundary();
                this.eastBoundary = propertyID.getEastBoundary();
                this.westBoundary = propertyID.getWestBoundary();
            }
            PropertyTypeMaster propertyType = this.propertyModel.getPropertyDetail().getPropertyTypeMaster();
            this.propTypeId = propertyType.getId().toString();
            if (this.propertyModel.getPropertyDetail().getPropertyUsage() != null) {
                this.propUsageId = this.propertyModel.getPropertyDetail().getPropertyUsage().getId().toString();
            }
            if (this.propertyModel.getPropertyDetail().getPropertyOccupation() != null) {
                this.propOccId = this.propertyModel.getPropertyDetail().getPropertyOccupation().getId().toString();
            }
            this.setDocNumber(this.propertyModel.getDocNumber());
            if (this.propertyModel.getPropertyDetail().getFloorDetails().size() > 0) {
                this.setFloorDetails((Property)this.propertyModel);
            }
            target = "new";
        }
        this.LOGGER.debug((Object)("populateFormData - target : " + target + "\n Exiting from populateFormData"));
        return target;
    }

    @SkipValidation
    @Action(value="/modifyProperty-view")
    public String view() {
        int i;
        this.LOGGER.debug((Object)("Entered into view, BasicProperty: " + this.basicProp + ", ModelId: " + this.getModelId()));
        if (this.getModelId() != null) {
            this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
            this.LOGGER.debug((Object)("view: PropertyModel by model id: " + this.propertyModel));
        }
        String currWfState = this.propertyModel.getState().getValue();
        this.populateFormData(Boolean.TRUE);
        this.corrsAddress = PropertyTaxUtil.getOwnerAddress((List)this.propertyModel.getBasicProperty().getPropertyOwnerInfo());
        this.amalgPropIds = new String[10];
        if (this.propertyModel.getPropertyDetail().getFloorDetails().size() > 0) {
            this.setFloorDetails((Property)this.propertyModel);
        }
        if (!currWfState.endsWith("Commissioner Approved")) {
            i = 0;
            for (PropertyStatusValues propstatval : this.basicProp.getPropertyStatusValuesSet()) {
                if (propstatval.getIsActive().equals("W")) {
                    this.setPropStatValForView(propstatval);
                    this.LOGGER.debug((Object)("view: PropertyStatusValues for new modify screen: " + propstatval));
                }
                this.LOGGER.debug((Object)"view: Amalgamated property ids:");
                if (!"CREATE".equals(propstatval.getPropertyStatus().getStatusCode()) || !propstatval.getIsActive().equals("Y") || propstatval.getReferenceBasicProperty() == null) continue;
                this.amalgPropIds[i] = propstatval.getReferenceBasicProperty().getUpicNo();
                this.LOGGER.debug((Object)(this.amalgPropIds[i] + ", "));
                ++i;
            }
        }
        if (currWfState.endsWith("Commissioner Approved")) {
            this.setIsApprPageReq(Boolean.FALSE);
            if (this.basicProp.getUpicNo() != null && !this.basicProp.getUpicNo().isEmpty()) {
                this.setIndexNumber(this.basicProp.getUpicNo());
            }
            i = 0;
            for (PropertyStatusValues propstatval : this.basicProp.getPropertyStatusValuesSet()) {
                if (propstatval.getIsActive().equals("Y")) {
                    this.setPropStatValForView(propstatval);
                    this.LOGGER.debug((Object)("PropertyStatusValues for view modify screen: " + propstatval));
                }
                this.LOGGER.debug((Object)"view: Amalgamated property ids:");
                if (!"CREATE".equals(propstatval.getPropertyStatus().getStatusCode()) || !propstatval.getIsActive().equals("Y") || propstatval.getReferenceBasicProperty() == null) continue;
                this.amalgPropIds[i] = propstatval.getReferenceBasicProperty().getUpicNo();
                this.LOGGER.debug((Object)(this.amalgPropIds[i] + ", "));
                ++i;
            }
        }
        this.propertyAddr = this.basicProp.getAddress();
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.setDocNumber(this.propertyModel.getDocNumber());
        this.LOGGER.debug((Object)("view: ModifyReason: " + this.getModifyRsn()));
        this.LOGGER.debug((Object)"Exiting from view");
        return VIEW;
    }

    @SkipValidation
    @Action(value="/modifyProperty-forward")
    public String forwardModify() {
        this.LOGGER.debug((Object)("forwardModify: Modify property started " + this.propertyModel));
        this.validate();
        long startTimeMillis = System.currentTimeMillis();
        if (this.getModelId() != null && !this.getModelId().trim().isEmpty()) {
            this.propWF = (PropertyImpl)this.getPersistenceService().findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.LOGGER.debug((Object)("forwardModify: Workflow property: " + this.propWF));
            this.basicProp = this.propWF.getBasicProperty();
            this.setBasicProp(this.basicProp);
        } else {
            this.populateBasicProp();
        }
        this.oldProperty = (PropertyImpl)this.basicProp.getProperty();
        if (this.areaOfPlot != null && !this.areaOfPlot.isEmpty()) {
            Area area = new Area();
            area.setArea(new Float(this.areaOfPlot));
            this.propertyModel.getPropertyDetail().setSitalArea(area);
        }
        if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !this.propTypeId.equals("-1")) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeId)});
        }
        this.propertyModel.getPropertyDetail().setPropertyTypeMaster(this.propTypeMstr);
        String errorKey = null;
        if (!this.hasErrors()) {
            errorKey = this.propService.validationForBifurcation(this.propertyModel, this.basicProp, this.modifyRsn);
        }
        if (!StringUtils.isBlank(errorKey)) {
            this.addActionError(this.getText(errorKey));
        }
        PropertyTypeMaster oldPropTypeMstr = this.oldProperty.getPropertyDetail().getPropertyTypeMaster();
        if (null != this.propTypeMstr && !this.propTypeMstr.getType().equals(oldPropTypeMstr.getType()) && this.propTypeMstr.getType().equals("Vacant Land")) {
            this.addActionError(this.getText("error.nonVacantToVacant"));
        }
        if (this.hasErrors()) {
            if ("Junior Assistant".equalsIgnoreCase(this.userDesgn) || "Senior Assistant".equalsIgnoreCase(this.userDesgn) || this.getModel().getState().getNextAction() != null && this.getModel().getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending") || !this.propertyByEmployee.booleanValue()) {
                return "new";
            }
            if ("Bill Collector".equalsIgnoreCase(this.userDesgn) || "Commissioner".equalsIgnoreCase(this.userDesgn) || "Revenue officer".equalsIgnoreCase(this.userDesgn)) {
                return VIEW;
            }
        }
        try {
            this.modifyBasicProp(this.getDocNumber());
        }
        catch (TaxCalculatorExeption e) {
            this.addActionError(this.getText("unitrate.error"));
            this.LOGGER.error((Object)"forwardModify : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return "new";
        }
        this.transitionWorkFlow(this.propertyModel);
        this.basicProp.setUnderWorkflow(Boolean.TRUE.booleanValue());
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.propertyModel.getState());
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        if (this.basicProp.getWFProperty() != null && this.basicProp.getWFProperty().getPtDemandSet() != null && !this.basicProp.getWFProperty().getPtDemandSet().isEmpty()) {
            for (Ptdemand ptDemand : this.basicProp.getWFProperty().getPtDemandSet()) {
                this.basicPropertyService.applyAuditing((BaseModel)ptDemand.getDmdCalculations());
            }
        }
        this.basicPropertyService.update((Object)this.basicProp);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.prepareAckMsg();
        this.buildEmailandSms(this.propertyModel, this.getApplicationType());
        this.addActionMessage(this.getText(PROPERTY_FORWARD_SUCCESS, new String[]{this.propertyModel.getBasicProperty().getUpicNo()}));
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        this.LOGGER.info((Object)("forwardModify: Modify property forwarded successfully; Time taken(ms) = " + elapsedTimeMillis));
        this.LOGGER.debug((Object)"forwardModify: Modify property forward ended");
        return RESULT_ACK;
    }

    private String getApplicationType() {
        String applicationType = "ADD_OR_ALTER".equals(this.modifyRsn) ? "Alteration of Assessment" : ("BIFURCATE".equals(this.modifyRsn) ? "Bifuracate_Assessment" : "General_Revision_Petition");
        return applicationType;
    }

    @SkipValidation
    @Action(value="/modifyProperty-forwardView")
    public String forwardView() {
        this.LOGGER.debug((Object)"Entered into forwardView");
        this.validateApproverDetails();
        if (this.hasErrors()) {
            if ("Junior Assistant".equalsIgnoreCase(this.userDesgn) || "Senior Assistant".equalsIgnoreCase(this.userDesgn) || this.getModel().getState().getNextAction() != null && this.getModel().getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending")) {
                return "new";
            }
            if ("Bill Collector".equalsIgnoreCase(this.userDesgn) || "Commissioner".equalsIgnoreCase(this.userDesgn) || "Revenue officer".equalsIgnoreCase(this.userDesgn)) {
                return VIEW;
            }
        }
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        this.LOGGER.debug((Object)("forwardView: Workflow property: " + this.propertyModel));
        this.transitionWorkFlow(this.propertyModel);
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.basicPropertyService.update((Object)this.basicProp);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.prepareAckMsg();
        this.buildEmailandSms(this.propertyModel, "Alter_Assessment");
        this.addActionMessage(this.getText(PROPERTY_FORWARD_SUCCESS, new String[]{this.propertyModel.getBasicProperty().getUpicNo()}));
        this.LOGGER.debug((Object)"Exiting from forwardView");
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/modifyProperty-approve")
    public String approve() {
        this.LOGGER.debug((Object)"Enter method approve");
        this.amalgPropIds = new String[10];
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        this.LOGGER.debug((Object)("approve: Workflow property: " + this.propertyModel));
        this.basicProp = this.propertyModel.getBasicProperty();
        this.oldProperty = (PropertyImpl)this.basicProp.getProperty();
        this.transitionWorkFlow(this.propertyModel);
        if (!"OBJ".equals(this.modifyRsn)) {
            this.propService.setWFPropStatValActive(this.basicProp);
        }
        if ("ADD_OR_ALTER".equals(this.modifyRsn) || "AMALG".equals(this.modifyRsn) || "BIFURCATE".equals(this.modifyRsn)) {
            // empty if block
        }
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        if ("ADD_OR_ALTER".equals(this.modifyRsn) || "BIFURCATE".equals(this.modifyRsn) || "GRP".equals(this.modifyRsn)) {
            this.propertyModel.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.propertyTaxUtil.makeTheEgBillAsHistory(this.basicProp);
        }
        this.processAndStoreDocumentsWithReason(this.basicProp, this.getReason(this.modifyRsn));
        if ("ADD_OR_ALTER".equals(this.modifyRsn) || "BIFURCATE".equals(this.modifyRsn) || "AMALG".equals(this.modifyRsn) || "GRP".equals(this.modifyRsn)) {
            this.updateAddress();
        }
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.basicPropertyService.update((Object)this.basicProp);
        this.setBasicProp(this.basicProp);
        this.setAckMessage(this.getText(PROPERTY_MODIFY_APPROVE_SUCCESS, new String[]{this.getModifyReasonString(), this.propertyModel.getBasicProperty().getUpicNo()}));
        this.buildEmailandSms(this.propertyModel, this.getApplicationType());
        this.addActionMessage(this.getText(PROPERTY_MODIFY_APPROVE_SUCCESS, new String[]{this.getModifyReasonString(), this.propertyModel.getBasicProperty().getUpicNo()}));
        this.LOGGER.debug((Object)"Exiting approve");
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/modifyProperty-reject")
    public String reject() {
        this.LOGGER.debug((Object)"reject: Property rejection started");
        if (StringUtils.isBlank((String)this.approverComments)) {
            this.addActionError(this.getText("property.workflow.remarks"));
            if ("Junior Assistant".equalsIgnoreCase(this.userDesgn) || "Senior Assistant".equalsIgnoreCase(this.userDesgn) || this.getModel().getState().getNextAction() != null && this.getModel().getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending")) {
                return "new";
            }
            if ("Bill Collector".equalsIgnoreCase(this.userDesgn) || "Commissioner".equalsIgnoreCase(this.userDesgn) || "Revenue officer".equalsIgnoreCase(this.userDesgn)) {
                return VIEW;
            }
        }
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        if (this.propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.propertyModel.getPropertyDetail().getFloorDetails().clear();
        }
        this.LOGGER.debug((Object)("reject: Property: " + this.propertyModel));
        BasicProperty basicProperty = this.propertyModel.getBasicProperty();
        this.setBasicProp(basicProperty);
        this.LOGGER.debug((Object)("reject: BasicProperty: " + basicProperty));
        this.transitionWorkFlow(this.propertyModel);
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.propertyImplService.update((Object)this.propertyModel);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        String username = "";
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)this.propertyModel.getStateHistory().get(0)).getOwnerPosition().getId());
        if (this.propService.isEmployee(this.propertyModel.getCreatedBy()).booleanValue()) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(this.propertyModel.getCreatedBy().getId());
            username = this.propertyModel.getCreatedBy().getName().concat("~").concat(assignment.getPosition().getName());
        } else {
            username = userAssignment.getEmployee().getName().concat("~").concat(userAssignment.getPosition().getName());
        }
        Assignment wfInitiator = this.propService.getWorkflowInitiator(this.propertyModel);
        if (wfInitiator.getEmployee().getUsername().equals(this.securityUtils.getCurrentUser().getUsername())) {
            this.wfInitiatorRejected = Boolean.TRUE;
            this.setAckMessage(this.getText(PROPERTY_MODIFY_FINAL_REJECT_SUCCESS, new String[]{this.getModifyReasonString()}));
        } else {
            this.setAckMessage(this.getText(PROPERTY_MODIFY_REJECT_SUCCESS, new String[]{this.getModifyReasonString(), username}));
        }
        this.buildEmailandSms(this.propertyModel, this.getApplicationType());
        this.LOGGER.debug((Object)("reject: BasicProperty: " + this.getBasicProp() + "AckMessage: " + this.getAckMessage()));
        this.LOGGER.debug((Object)"reject: Property rejection ended");
        return RESULT_ACK;
    }

    public void prepare() {
        this.LOGGER.debug((Object)("Entered into preapre, ModelId: " + this.getModelId()));
        super.prepare();
        this.setUserInfo();
        this.propertyByEmployee = this.propService.isEmployee(this.securityUtils.getCurrentUser());
        if (this.getModelId() != null && !this.getModelId().isEmpty()) {
            this.setBasicProp((BasicProperty)this.getPersistenceService().find("select prop.basicProperty from PropertyImpl prop where prop.id=?", new Object[]{Long.valueOf(this.getModelId())}));
            this.LOGGER.debug((Object)("prepare: BasicProperty: " + this.basicProp));
            this.propWF = (PropertyImpl)this.getPersistenceService().findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            if (this.propWF != null) {
                this.setProperty(this.propWF);
                this.preparePropertyTaxDetails((Property)this.propWF);
                this.historyMap = this.propService.populateHistory((StateAware)this.propWF);
            } else {
                this.preparePropertyTaxDetails((Property)this.basicProp.getActiveProperty());
                this.historyMap = this.propService.populateHistory((StateAware)this.basicProp.getActiveProperty());
            }
        } else if (this.indexNumber != null && !this.indexNumber.trim().isEmpty()) {
            this.setBasicProp((BasicProperty)this.getPersistenceService().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber}));
            this.preparePropertyTaxDetails((Property)this.basicProp.getActiveProperty());
        }
        this.documentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.MODIFY);
        List floorTypes = this.getPersistenceService().findAllBy("from FloorType order by name", new Object[0]);
        List roofTypes = this.getPersistenceService().findAllBy("from RoofType order by name", new Object[0]);
        List wallTypes = this.getPersistenceService().findAllBy("from WallType order by name", new Object[0]);
        List woodTypes = this.getPersistenceService().findAllBy("from WoodType order by name", new Object[0]);
        List propTypeList = this.getPersistenceService().findAllBy("from PropertyTypeMaster where type != 'EWSHS' order by orderNo", new Object[0]);
        List StructureList = this.getPersistenceService().findAllBy("from StructureClassification", new Object[0]);
        List usageList = this.getPersistenceService().findAllBy("from PropertyUsage order by usageName", new Object[0]);
        List propOccList = this.getPersistenceService().findAllBy("from PropertyOccupation", new Object[0]);
        List ageFacList = this.getPersistenceService().findAllBy("from DepreciationMaster", new Object[0]);
        List apartmentsList = this.getPersistenceService().findAllBy("from Apartment order by name", new Object[0]);
        List taxExemptionReasonList = this.getPersistenceService().findAllBy("from TaxExeptionReason order by name", new Object[0]);
        this.setFloorNoMap(PropertyTaxConstants.FLOOR_MAP);
        this.addDropdownData("floorType", floorTypes);
        this.addDropdownData("roofType", roofTypes);
        this.addDropdownData("wallType", wallTypes);
        this.addDropdownData("woodType", woodTypes);
        this.addDropdownData("PropTypeMaster", propTypeList);
        this.addDropdownData("OccupancyList", propOccList);
        this.addDropdownData("StructureList", StructureList);
        this.addDropdownData("AgeFactorList", ageFacList);
        this.addDropdownData("apartments", apartmentsList);
        this.addDropdownData("taxExemptionReasonList", taxExemptionReasonList);
        this.populatePropertyTypeCategory();
        this.setDeviationPercentageMap((Map)PropertyTaxConstants.DEVIATION_PERCENTAGE);
        if (this.getBasicProp() != null) {
            this.setPropAddress(this.getBasicProp().getAddress().toString());
        }
        if (this.propWF != null) {
            this.setOwnerName(this.propWF.getBasicProperty().getFullOwnerName());
            List ownerSet = this.propWF.getBasicProperty().getPropertyOwnerInfo();
            if (ownerSet != null && !ownerSet.isEmpty()) {
                for (PropertyOwnerInfo owner : ownerSet) {
                    Iterator iterator = owner.getOwner().getAddress().iterator();
                    if (!iterator.hasNext()) continue;
                    Address address = (Address)iterator.next();
                    this.corrsAddress = address.toString();
                }
            }
            for (PropertyStatusValues propstatval : this.basicProp.getPropertyStatusValuesSet()) {
                if (!propstatval.getIsActive().equals("W")) continue;
                this.setPropStatValForView(propstatval);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.propertyCategory})) {
            if (this.propertyCategory.equals("MIXED")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("RESIDENTIAl")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = true order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("NON_RESIDENTIAL")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = false order by usageName", new Object[0]);
            }
        }
        this.addDropdownData("UsageList", usageList);
        this.LOGGER.debug((Object)("Exiting from preapre, ModelId: " + this.getModelId()));
    }

    private void populatePropertyTypeCategory() {
        if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !this.propTypeId.equals("-1")) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(this.propTypeId)});
        } else if (this.propertyModel != null && this.propertyModel.getPropertyDetail() != null && this.propertyModel.getPropertyDetail().getPropertyTypeMaster() != null && !this.propertyModel.getPropertyDetail().getPropertyTypeMaster().getId().equals(-1)) {
            this.propTypeMstr = this.propertyModel.getPropertyDetail().getPropertyTypeMaster();
        } else if (this.basicProp != null) {
            this.propTypeMstr = this.basicProp.getProperty().getPropertyDetail().getPropertyTypeMaster();
        }
        if (this.propTypeMstr != null) {
            if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
        } else {
            this.setPropTypeCategoryMap(Collections.emptyMap());
        }
    }

    private void modifyBasicProp(String docNumber) throws TaxCalculatorExeption {
        this.LOGGER.debug((Object)("Entered into modifyBasicProp, BasicProperty: " + this.basicProp));
        this.LOGGER.debug((Object)("modifyBasicProp: PropTypeId: " + this.propTypeId + ", PropUsageId: " + this.propUsageId + ", PropOccId: " + this.propOccId + ", statusModifyRsn: " + this.modifyRsn + ", NoOfAmalgmatedProps: " + (this.amalgPropIds != null ? Integer.valueOf(this.amalgPropIds.length) : "NULL")));
        Date propCompletionDate = null;
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        PropertyTypeMaster proptypeMstr = this.propertyTypeMasterDAO.findById(Integer.valueOf(this.propTypeId), false);
        propCompletionDate = !proptypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.propertyModel.getPropertyDetail().getFloorDetailsProxy()) : this.propertyModel.getPropertyDetail().getDateOfCompletion();
        PropertyMutationMaster propMutMstr = (PropertyMutationMaster)this.propService.getPropPerServ().find("from PropertyMutationMaster PM where upper(PM.code) = ?", new Object[]{this.modifyRsn});
        this.basicProp.setPropertyMutationMaster(propMutMstr);
        if ("AMALG".equals(this.modifyRsn) || "BIFURCATE".equals(this.modifyRsn) || "GRP".equals(this.modifyRsn)) {
            this.basicProp.addPropertyStatusValues(this.propService.createPropStatVal(this.basicProp, this.getModifyRsn(), propCompletionDate, null, null, null, null));
            if ("AMALG".equals(this.modifyRsn)) {
                this.propService.createAmalgPropStatVal(this.amalgPropIds, this.basicProp);
            }
        } else if ("ADD_OR_ALTER".equals(this.modifyRsn)) {
            this.basicProp.addPropertyStatusValues(this.propService.createPropStatVal(this.basicProp, "ADD_OR_ALTER", propCompletionDate, null, null, null, null));
        } else if ("COURT_RULE".equals(this.getModifyRsn())) {
            this.basicProp.addPropertyStatusValues(this.propService.createPropStatVal(this.basicProp, "ADD_OR_ALTER", propCompletionDate, this.getCourtOrdNum(), this.propService.getPropOccupatedDate(this.getOrderDate()), this.getJudgmtDetails(), null));
        }
        this.basicProp.setPropOccupationDate(propCompletionDate);
        this.setProperty(this.propService.createProperty(this.propertyModel, this.getAreaOfPlot(), this.modifyRsn, this.propTypeId, this.propUsageId, this.propOccId, status, this.propertyModel.getDocNumber(), null, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, this.taxExemptedReason));
        this.updatePropertyID(this.basicProp);
        this.propertyModel.setPropertyModifyReason(this.modifyRsn);
        this.propertyModel.setBasicProperty(this.basicProp);
        this.propertyModel.setEffectiveDate(propCompletionDate);
        Long oldPropTypeId = this.oldProperty.getPropertyDetail().getPropertyTypeMaster().getId();
        PropertyTypeMaster propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.code = ?", new Object[]{"VAC_LAND"});
        if ((oldPropTypeId == propTypeMstr.getId() && Long.parseLong(this.propTypeId) != propTypeMstr.getId() || oldPropTypeId != propTypeMstr.getId() && Long.parseLong(this.propTypeId) == propTypeMstr.getId()) && !this.propertyModel.getStatus().equals(Character.valueOf('W'))) {
            if (propTypeMstr != null && StringUtils.equals((String)propTypeMstr.getId().toString(), (String)this.propTypeId)) {
                this.changePropertyDetail((Property)this.propertyModel, (PropertyDetail)new VacantProperty(), Integer.valueOf(0));
            } else {
                this.changePropertyDetail((Property)this.propertyModel, (PropertyDetail)new BuiltUpProperty(), this.propertyModel.getPropertyDetail().getNoofFloors());
            }
        }
        Property modProperty = null;
        try {
            modProperty = this.propService.modifyDemand(this.propertyModel, this.oldProperty);
            if ("GRP".equals(this.modifyRsn)) {
                this.propService.calculateGrpPenalty(modProperty, propCompletionDate);
            }
        }
        catch (TaxCalculatorExeption e) {
            throw new TaxCalculatorExeption();
        }
        if (modProperty != null && !modProperty.getDocuments().isEmpty()) {
            this.propService.processAndStoreDocument(modProperty.getDocuments());
        }
        if (modProperty == null) {
            this.basicProp.addProperty((Property)this.propertyModel);
        } else {
            this.basicProp.addProperty(modProperty);
        }
        this.LOGGER.debug((Object)"Exiting modifyBasicProp");
    }

    private void updatePropertyID(BasicProperty basicProperty) {
        PropertyID propertyId = basicProperty.getPropertyID();
        if (propertyId != null) {
            propertyId.setEastBoundary(this.getEastBoundary());
            propertyId.setWestBoundary(this.getWestBoundary());
            propertyId.setNorthBoundary(this.getNorthBoundary());
            propertyId.setSouthBoundary(this.getSouthBoundary());
        }
    }

    private void changePropertyDetail(Property modProperty, PropertyDetail propDetail, Integer numOfFloors) {
        this.LOGGER.debug((Object)"Entered into changePropertyDetail, Property is Vacant Land");
        PropertyDetail propertyDetail = modProperty.getPropertyDetail();
        propDetail.setSitalArea(propertyDetail.getSitalArea());
        propDetail.setTotalBuiltupArea(propertyDetail.getTotalBuiltupArea());
        propDetail.setCommBuiltUpArea(propertyDetail.getCommBuiltUpArea());
        propDetail.setPlinthArea(propertyDetail.getPlinthArea());
        propDetail.setCommVacantLand(propertyDetail.getCommVacantLand());
        propDetail.setSurveyNumber(propertyDetail.getSurveyNumber());
        propDetail.setFieldVerified(propertyDetail.getFieldVerified());
        propDetail.setFieldVerificationDate(propertyDetail.getFieldVerificationDate());
        propDetail.setFloorDetails(propertyDetail.getFloorDetails());
        propDetail.setPropertyDetailsID(propertyDetail.getPropertyDetailsID());
        propDetail.setWater_Meter_Num(propertyDetail.getWater_Meter_Num());
        propDetail.setElec_Meter_Num(propertyDetail.getElec_Meter_Num());
        propDetail.setNoofFloors(numOfFloors);
        propDetail.setFieldIrregular(propertyDetail.getFieldIrregular());
        propDetail.setDateOfCompletion(propertyDetail.getDateOfCompletion());
        propDetail.setProperty(propertyDetail.getProperty());
        propDetail.setUpdatedTime(propertyDetail.getUpdatedTime());
        propDetail.setPropertyTypeMaster(propertyDetail.getPropertyTypeMaster());
        propDetail.setPropertyType(propertyDetail.getPropertyType());
        propDetail.setInstallment(propertyDetail.getInstallment());
        propDetail.setPropertyOccupation(propertyDetail.getPropertyOccupation());
        propDetail.setPropertyMutationMaster(propertyDetail.getPropertyMutationMaster());
        propDetail.setComZone(propertyDetail.getComZone());
        propDetail.setCornerPlot(propertyDetail.getCornerPlot());
        propDetail.setCable(propertyDetail.isCable());
        propDetail.setAttachedBathRoom(propertyDetail.isAttachedBathRoom());
        propDetail.setElectricity(propertyDetail.isElectricity());
        propDetail.setWaterTap(propertyDetail.isWaterTap());
        propDetail.setWaterHarvesting(propertyDetail.isWaterHarvesting());
        propDetail.setLift(propertyDetail.isLift());
        propDetail.setToilets(propertyDetail.isToilets());
        propDetail.setFloorType(propertyDetail.getFloorType());
        propDetail.setRoofType(propertyDetail.getRoofType());
        propDetail.setWallType(propertyDetail.getWallType());
        propDetail.setWoodType(propertyDetail.getWoodType());
        propDetail.setExtentSite(propertyDetail.getExtentSite());
        propDetail.setStructure(propertyDetail.isStructure());
        propDetail.setExtentAppartenauntLand(propertyDetail.getExtentAppartenauntLand());
        if (numOfFloors == 0) {
            propDetail.setPropertyUsage(propertyDetail.getPropertyUsage());
        } else {
            propDetail.setPropertyUsage(null);
        }
        propDetail.setManualAlv(propertyDetail.getManualAlv());
        propDetail.setOccupierName(propertyDetail.getOccupierName());
        modProperty.setPropertyDetail(propDetail);
        this.LOGGER.debug((Object)"Exiting from changePropertyDetail");
    }

    private void populateBasicProp() {
        this.LOGGER.debug((Object)"Entered into populateBasicProp");
        if (this.basicProp == null) {
            if (this.indexNumber != null && !this.indexNumber.trim().isEmpty()) {
                this.setBasicProp((BasicProperty)this.getPersistenceService().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber}));
            } else if (this.getModelId() != null && !this.getModelId().equals("")) {
                this.setBasicProp(((PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())})).getBasicProperty());
            }
        }
        this.LOGGER.debug((Object)"Exiting from populateBasicProp");
    }

    private void setFloorDetails(Property property) {
        this.LOGGER.debug((Object)("Entered into setFloorDetails, Property: " + property));
        List floors = property.getPropertyDetail().getFloorDetails();
        property.getPropertyDetail().setFloorDetailsProxy(floors);
        int i = 0;
        for (Floor flr : floors) {
            this.floorNoStr[i] = (String)PropertyTaxConstants.FLOOR_MAP.get(flr.getFloorNo());
            ++i;
        }
        this.LOGGER.debug((Object)"Exiting from setFloorDetails: ");
    }

    public List<Floor> getFloorDetails() {
        return new ArrayList<Floor>(this.propertyModel.getPropertyDetail().getFloorDetails());
    }

    public void validate() {
        this.LOGGER.debug((Object)("Entered into validate, ModifyRsn: " + this.modifyRsn));
        this.propertyModel.setBasicProperty(this.basicProp);
        Date propCompletionDate = null;
        if (this.basicProp.getSource() == PropertyTaxConstants.SOURCEOFDATA_MIGRATION || this.basicProp.getSource() == PropertyTaxConstants.SOURCEOFDATA_DATAENTRY) {
            this.setOldProperty((PropertyImpl)this.getBasicProp().getProperty());
            propCompletionDate = this.propertyTaxUtil.getLowestInstallmentForProperty((Property)this.oldProperty);
        }
        this.validateProperty((Property)this.propertyModel, this.areaOfPlot, this.dateOfCompletion, this.eastBoundary, this.westBoundary, this.southBoundary, this.northBoundary, this.propTypeId, null != this.basicProp.getPropertyID() ? String.valueOf(this.basicProp.getPropertyID().getZone().getId()) : "", this.propOccId, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, this.modifyRsn, propCompletionDate);
        this.validateApproverDetails();
        if (!this.propertyByEmployee.booleanValue() && null != this.basicProp && null == this.propService.getUserPositionByZone(this.basicProp)) {
            this.addActionError(this.getText("notexists.position"));
        }
        this.LOGGER.debug((Object)("Exiting from validate, BasicProperty: " + this.getBasicProp()));
    }

    private void setPropStatValForView(PropertyStatusValues propstatval) {
        PropertyImpl propertyImpl;
        this.LOGGER.debug((Object)("Entered into setPropStatValForView " + propstatval));
        PropertyImpl propertyImpl2 = propertyImpl = this.propWF != null ? this.propWF : this.propertyModel;
        if ("ADD_OR_ALTER".equals(propstatval.getPropertyStatus().getStatusCode()) && "COURT_RULE".equals(propertyImpl.getPropertyDetail().getPropertyMutationMaster().getCode())) {
            this.setCourtOrdNum(propstatval.getReferenceNo());
            this.setOrderDate(this.dateFormatter.format(propstatval.getReferenceDate()));
            this.setJudgmtDetails(propstatval.getRemarks());
        }
        if (propertyImpl.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.setDateOfCompletion(propstatval.getExtraField1());
        }
        this.LOGGER.debug((Object)"Entered into setPropStatValForView");
    }

    private void prepareAckMsg() {
        this.LOGGER.debug((Object)("Entered into prepareAckMsg, ModifyRsn: " + this.modifyRsn));
        Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositon(this.approverPositionId);
        User approverUser = this.eisCommonService.getUserForPosition(this.approverPositionId, new Date());
        String action = this.getModifyReasonString();
        this.setAckMessage(this.getText("property.modify.forward.success", new String[]{action, approverUser.getName().concat("~").concat(assignment.getPosition().getName()), this.propertyModel.getApplicationNo()}));
        this.LOGGER.debug((Object)("AckMessage: " + this.getAckMessage() + "\nExiting from prepareAckMsg"));
    }

    private String getModifyReasonString() {
        String action = "ADD_OR_ALTER".equals(this.modifyRsn) ? "Alteration of Assessment" : ("BIFURCATE".equals(this.modifyRsn) ? "Bifurcation of Assessment" : ("GRP".equals(this.modifyRsn) ? "General Revision Petition of Assessment" : "Amalgamation of Assessment"));
        return action;
    }

    private String getReason(String modifyReason) {
        if ("ADD_OR_ALTER".equals(this.modifyRsn)) {
            return "MODIFICATION";
        }
        if ("BIFURCATE".equals(this.modifyRsn)) {
            return "BIFURCATION";
        }
        if ("AMALG".equals(this.modifyRsn)) {
            return "AMALGAMATION";
        }
        return "";
    }

    public PropertyImpl updatePropertyForMigratedProp(PropertyImpl property, String areaOfPlot, String mutationCode, String propTypeId, String propUsageId, String propOccId, String docnumber, String nonResPlotArea, boolean isfloorDetailsRequired) {
        Area area;
        this.LOGGER.debug((Object)"Entered into modifyPropertyForMigratedProp");
        this.LOGGER.debug((Object)("modifyPropertyForMigratedProp: Property: " + property + ", areaOfPlot: " + areaOfPlot + ", mutationCode: " + mutationCode + ",propTypeId: " + propTypeId + ", propUsageId: " + propUsageId + ", propOccId: " + propOccId));
        if (areaOfPlot != null && !areaOfPlot.isEmpty()) {
            area = new Area();
            area.setArea(new Float(areaOfPlot));
            property.getPropertyDetail().setSitalArea(area);
        }
        if (nonResPlotArea != null && !nonResPlotArea.isEmpty()) {
            area = new Area();
            area.setArea(new Float(nonResPlotArea));
            property.getPropertyDetail().setNonResPlotArea(area);
        }
        property.getPropertyDetail().setFieldVerified(Character.valueOf('Y'));
        property.getPropertyDetail().setProperty((Property)property);
        PropertyTypeMaster propTypeMstr = (PropertyTypeMaster)this.persistenceService.find("from PropertyTypeMaster PTM where PTM.id = ?", new Object[]{Long.valueOf(propTypeId)});
        String propTypeCode = propTypeMstr.getCode();
        boolean isNofloors = "VAC_LAND".equals(propTypeCode);
        if (propUsageId != null && isNofloors) {
            PropertyUsage usage = (PropertyUsage)this.persistenceService.find("from PropertyUsage pu where pu.id = ?", new Object[]{Long.valueOf(propUsageId)});
            property.getPropertyDetail().setPropertyUsage(usage);
        } else {
            property.getPropertyDetail().setPropertyUsage(null);
        }
        if (propOccId != null && isNofloors) {
            PropertyOccupation occupancy = (PropertyOccupation)this.persistenceService.find("from PropertyOccupation po where po.id = ?", new Object[]{Long.valueOf(propOccId)});
            property.getPropertyDetail().setPropertyOccupation(occupancy);
        } else {
            property.getPropertyDetail().setPropertyOccupation(null);
        }
        if (propTypeMstr.getCode().equals("VAC_LAND")) {
            property.getPropertyDetail().setPropertyType("VacantProperty");
        } else {
            property.getPropertyDetail().setPropertyType("BuiltUpProperty");
        }
        property.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        this.propertyModel.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        this.propertyModel.getPropertyDetail().setPropertyMutationMaster(property.getPropertyDetail().getPropertyMutationMaster());
        property.getPropertyDetail().setUpdatedTime(new Date());
        this.propService.createFloors((Property)this.propertyModel, mutationCode, propUsageId, propOccId);
        block0: for (Floor floor : property.getPropertyDetail().getFloorDetails()) {
            for (Floor newFloorInfo : this.propertyModel.getPropertyDetail().getFloorDetails()) {
                if (!floor.getId().equals(newFloorInfo.getId())) continue;
                floor.setUnitType(newFloorInfo.getUnitType());
                floor.setUnitTypeCategory(newFloorInfo.getUnitTypeCategory());
                floor.setFloorNo(newFloorInfo.getFloorNo());
                floor.setBuiltUpArea(newFloorInfo.getBuiltUpArea());
                floor.setPropertyUsage(newFloorInfo.getPropertyUsage());
                floor.setPropertyOccupation(newFloorInfo.getPropertyOccupation());
                floor.setWaterRate(newFloorInfo.getWaterRate());
                floor.setStructureClassification(newFloorInfo.getStructureClassification());
                floor.setDepreciationMaster(newFloorInfo.getDepreciationMaster());
                floor.setRentPerMonth(newFloorInfo.getRentPerMonth());
                floor.setManualAlv(newFloorInfo.getManualAlv());
                continue block0;
            }
        }
        property.getPropertyDetail().setNoofFloors(Integer.valueOf(property.getPropertyDetail().getFloorDetails().size()));
        property.setDocNumber(docnumber);
        this.LOGGER.debug((Object)"Exiting from createProperty");
        return property;
    }

    private void updateBasicPropForMigratedProp(String docNumber, PropertyImpl existingProp) {
        this.LOGGER.debug((Object)("Entered into modifyBasicPropForMigratedProp, BasicProperty: " + this.basicProp));
        this.LOGGER.debug((Object)("modifyBasicPropForMigratedProp: PropTypeId: " + this.propTypeId + ", PropUsageId: " + this.propUsageId + ", PropOccId: " + this.propOccId + ", statusModifyRsn: " + this.modifyRsn));
        Date propCompletionDate = null;
        PropertyTypeMaster proptypeMstr = this.propertyTypeMasterDAO.findById(Integer.valueOf(this.propTypeId), false);
        propCompletionDate = !proptypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.propertyModel.getPropertyDetail().getFloorDetails()) : this.propService.getPropOccupatedDate(this.getDateOfCompletion());
        this.basicProp.setExtraField1(this.isAuthProp);
        this.basicProp.setPropOccupationDate(propCompletionDate);
        existingProp = this.updatePropertyForMigratedProp(existingProp, this.getAreaOfPlot(), "CREATE", this.propTypeId, this.propUsageId, this.propOccId, this.propertyModel.getDocNumber(), null, this.isfloorDetailsRequired);
        existingProp.setBasicProperty(this.basicProp);
        existingProp.setEffectiveDate(propCompletionDate);
        existingProp.getPropertyDetail().setManualAlv(this.propertyModel.getPropertyDetail().getManualAlv());
        existingProp.getPropertyDetail().setOccupierName(this.propertyModel.getPropertyDetail().getOccupierName());
        existingProp.setDocNumber(docNumber);
        this.updateAddress();
        this.basicProp.setGisReferenceNo(this.parcelId);
        this.basicProp.getPropertyID().setNorthBoundary(this.northBoundary);
        this.basicProp.getPropertyID().setSouthBoundary(this.southBoundary);
        this.basicProp.getPropertyID().setEastBoundary(this.eastBoundary);
        this.basicProp.getPropertyID().setWestBoundary(this.westBoundary);
        this.propertyImplService.merge((Object)existingProp);
        this.basicPropertyService.update((Object)this.basicProp);
        this.LOGGER.debug((Object)"Exiting modifyBasicPropForMigratedProp");
    }

    @ValidationErrorPage(value="new")
    public String updateData() {
        this.LOGGER.debug((Object)("updateData: Property modification started for Migrated Property, PropertyId: " + this.propertyModel));
        long startTimeMillis = System.currentTimeMillis();
        if ("ASSISTANT".equals(this.userRole)) {
            PropertyImpl nonHistoryProperty = (PropertyImpl)this.basicProp.getProperty();
            this.processAndStoreDocumentsWithReason(this.basicProp, this.getReason(this.modifyRsn));
            this.updateBasicPropForMigratedProp(this.getDocNumber(), nonHistoryProperty);
            this.setAckMessage("Migrated Property updated Successfully in System with Index Number: ");
            long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
            this.LOGGER.info((Object)("updateData: Property modified successfully in system with Index Number: " + this.basicProp.getUpicNo() + "; Time taken(ms) = " + elapsedTimeMillis));
        }
        return RESULT_ACK;
    }

    @SkipValidation
    public String modifyOrDataUpdateForm() {
        this.LOGGER.debug((Object)"Entered into modifyOrDataUpdateForm");
        String resultPage = "";
        if ("DATA_UPDATE".equals(this.modifyRsn) && this.basicProp.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_APPLICATION)) {
            this.setErrorMessage(" This is not a migrated property ");
            resultPage = RESULT_ERROR;
        } else {
            resultPage = this.populateFormData(Boolean.FALSE);
        }
        this.LOGGER.debug((Object)"Exiting from modifyOrDataUpdateForm");
        return resultPage;
    }

    private void updateAddress() {
        this.LOGGER.debug((Object)"Entered into updateAddress");
        PropertyAddress addr = this.basicProp.getAddress();
        if (this.propertyAddr != null) {
            addr.setHouseNoBldgApt(this.propertyAddr.getHouseNoBldgApt());
            addr.setLandmark(this.propertyAddr.getLandmark());
            addr.setPinCode(this.propertyAddr.getPinCode());
        }
        this.LOGGER.debug((Object)"Exiting from updateAddress");
    }

    @SkipValidation
    @Action(value="/modifyProperty-printAck")
    public String printAck() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String imagePath = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        PropertyAckNoticeInfo ackBean = new PropertyAckNoticeInfo();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        ackBean.setOwnerName(this.basicProp.getFullOwnerName());
        ackBean.setOwnerAddress(this.basicProp.getAddress().toString());
        ackBean.setApplicationDate(new SimpleDateFormat("dd/MM/yyyy").format(this.basicProp.getCreatedDate()));
        ackBean.setApplicationNo(this.propertyModel.getApplicationNo());
        ackBean.setApprovedDate(new SimpleDateFormat("dd/MM/yyyy").format(this.propWF.getState().getCreatedDate()));
        Date noticeDueDate = DateUtils.add((Date)this.propWF.getState().getCreatedDate(), (int)5, (int)15);
        ackBean.setNoticeDueDate(noticeDueDate);
        ackBean.setCreationReason(this.modifyRsn);
        reportParams.put("logoPath", imagePath);
        reportParams.put("cityName", cityName);
        reportParams.put("loggedInUsername", this.propertyTaxUtil.getLoggedInUser(this.getSession()).getName());
        ReportRequest reportInput = null;
        reportInput = this.modifyRsn.equals("GRP") ? new ReportRequest(GRP_ACK_TEMPLATE, (Object)ackBean, reportParams) : new ReportRequest(MODIFY_ACK_TEMPLATE, (Object)ackBean, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return PRINT_ACK;
    }

    public BasicProperty getBasicProp() {
        return this.basicProp;
    }

    public void setBasicProp(BasicProperty basicProp) {
        this.basicProp = basicProp;
    }

    public Long getTaxExemptedReason() {
        return this.taxExemptedReason;
    }

    public void setTaxExemptedReason(Long taxExemptedReason) {
        this.taxExemptedReason = taxExemptedReason;
    }

    public String getModifyRsn() {
        return this.modifyRsn;
    }

    public void setModifyRsn(String modifyRsn) {
        this.modifyRsn = modifyRsn;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getPropAddress() {
        return this.propAddress;
    }

    public void setPropAddress(String propAddress) {
        this.propAddress = propAddress;
    }

    public String getAreaOfPlot() {
        return this.areaOfPlot;
    }

    public void setAreaOfPlot(String areaOfPlot) {
        this.areaOfPlot = areaOfPlot;
    }

    public Map<String, String> getWaterMeterMap() {
        return this.waterMeterMap;
    }

    public void setWaterMeterMap(Map<String, String> waterMeterMap) {
        this.waterMeterMap = waterMeterMap;
    }

    public boolean isGeneralTax() {
        return this.generalTax;
    }

    public void setGeneralTax(boolean generalTax) {
        this.generalTax = generalTax;
    }

    public boolean isSewerageTax() {
        return this.sewerageTax;
    }

    public void setSewerageTax(boolean sewerageTax) {
        this.sewerageTax = sewerageTax;
    }

    public boolean isLightingTax() {
        return this.lightingTax;
    }

    public void setLightingTax(boolean lightingTax) {
        this.lightingTax = lightingTax;
    }

    public boolean isFireServTax() {
        return this.fireServTax;
    }

    public void setFireServTax(boolean fireServTax) {
        this.fireServTax = fireServTax;
    }

    public boolean isBigResdBldgTax() {
        return this.bigResdBldgTax;
    }

    public void setBigResdBldgTax(boolean bigResdBldgTax) {
        this.bigResdBldgTax = bigResdBldgTax;
    }

    public boolean isEducationCess() {
        return this.educationCess;
    }

    public void setEducationCess(boolean educationCess) {
        this.educationCess = educationCess;
    }

    public boolean isEmpGuaCess() {
        return this.empGuaCess;
    }

    public void setEmpGuaCess(boolean empGuaCess) {
        this.empGuaCess = empGuaCess;
    }

    public TreeMap<Integer, String> getFloorNoMap() {
        return this.floorNoMap;
    }

    public void setFloorNoMap(TreeMap<Integer, String> floorNoMap) {
        this.floorNoMap = floorNoMap;
    }

    public String getDateOfCompletion() {
        return this.dateOfCompletion;
    }

    public void setDateOfCompletion(String dateOfCompletion) {
        this.dateOfCompletion = dateOfCompletion;
    }

    public Map<String, String> getModifyReasonMap() {
        return this.modifyReasonMap;
    }

    public void setModifyReasonMap(Map<String, String> modifyReasonMap) {
        this.modifyReasonMap = modifyReasonMap;
    }

    public String[] getAmalgPropIds() {
        return this.amalgPropIds;
    }

    public void setAmalgPropIds(String[] amalgPropIds) {
        this.amalgPropIds = amalgPropIds;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public String getCourtOrdNum() {
        return this.courtOrdNum;
    }

    public void setCourtOrdNum(String courtOrdNum) {
        this.courtOrdNum = courtOrdNum;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    public String getJudgmtDetails() {
        return this.judgmtDetails;
    }

    public void setJudgmtDetails(String judgmtDetails) {
        this.judgmtDetails = judgmtDetails;
    }

    public PropertyImpl getOldProperty() {
        return this.oldProperty;
    }

    public void setOldProperty(PropertyImpl oldProperty) {
        this.oldProperty = oldProperty;
    }

    public PropertyImpl getProperty() {
        return this.propertyModel;
    }

    public void setProperty(PropertyImpl property) {
        this.propertyModel = property;
    }

    public String getIsAuthProp() {
        return this.isAuthProp;
    }

    public void setIsAuthProp(String isAuthProp) {
        this.isAuthProp = isAuthProp;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public String getAmalgStatus() {
        return this.amalgStatus;
    }

    public void setAmalgStatus(String amalgStatus) {
        this.amalgStatus = amalgStatus;
    }

    public BasicProperty getAmalgPropBasicProp() {
        return this.amalgPropBasicProp;
    }

    public void setAmalgPropBasicProp(BasicProperty amalgPropBasicProp) {
        this.amalgPropBasicProp = amalgPropBasicProp;
    }

    public String getOldpropId() {
        return this.oldpropId;
    }

    public void setOldpropId(String oldpropId) {
        this.oldpropId = oldpropId;
    }

    public String getOldOwnerName() {
        return this.oldOwnerName;
    }

    public void setOldOwnerName(String oldOwnerName) {
        this.oldOwnerName = oldOwnerName;
    }

    public String getOldPropAddress() {
        return this.oldPropAddress;
    }

    public void setOldPropAddress(String oldPropAddress) {
        this.oldPropAddress = oldPropAddress;
    }

    public Map<String, String> getAmenitiesMap() {
        return this.amenitiesMap;
    }

    public void setAmenitiesMap(Map<String, String> amenitiesMap) {
        this.amenitiesMap = amenitiesMap;
    }

    public String getPropTypeId() {
        return this.propTypeId;
    }

    public void setPropTypeId(String propTypeId) {
        this.propTypeId = propTypeId;
    }

    public String getPropUsageId() {
        return this.propUsageId;
    }

    public void setPropUsageId(String propUsageId) {
        this.propUsageId = propUsageId;
    }

    public String getPropOccId() {
        return this.propOccId;
    }

    public void setPropOccId(String propOccId) {
        this.propOccId = propOccId;
    }

    public String getCorrsAddress() {
        return this.corrsAddress;
    }

    public void setCorrsAddress(String corrsAddress) {
        this.corrsAddress = corrsAddress;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public String getAmenities() {
        return this.amenities;
    }

    public void setAmenities(String amenities) {
        this.amenities = amenities;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public boolean isIsfloorDetailsRequired() {
        return this.isfloorDetailsRequired;
    }

    public void setIsfloorDetailsRequired(boolean isfloorDetailsRequired) {
        this.isfloorDetailsRequired = isfloorDetailsRequired;
    }

    public boolean isUpdateData() {
        return this.updateData;
    }

    public void setUpdateData(boolean updateData) {
        this.updateData = updateData;
    }

    public PersistenceService<Floor, Long> getFloorService() {
        return this.floorService;
    }

    public void setFloorService(PersistenceService<Floor, Long> floorService) {
        this.floorService = floorService;
    }

    public PropertyAddress getPropertyAddr() {
        return this.propertyAddr;
    }

    public void setPropertyAddr(PropertyAddress propertyAddr) {
        this.propertyAddr = propertyAddr;
    }

    public String getParcelId() {
        return this.parcelId;
    }

    public void setParcelId(String parcelId) {
        this.parcelId = parcelId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public List<PropertyOwnerInfo> getPropertyOwners() {
        return this.propertyOwners;
    }

    public void setPropertyOwners(List<PropertyOwnerInfo> propertyOwners) {
        this.propertyOwners = propertyOwners;
    }

    public String getPartNo() {
        return this.partNo;
    }

    public void setPartNo(String partNo) {
        this.partNo = partNo;
    }

    public String getModificationType() {
        return this.modificationType;
    }

    public void setModificationType(String modificationType) {
        this.modificationType = modificationType;
    }

    public boolean getIsTenantFloorPresent() {
        return this.isTenantFloorPresent;
    }

    public void setIsTenantFloorPresent(boolean isTenantFloorPresent) {
        this.isTenantFloorPresent = isTenantFloorPresent;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Integer getBuildingPermissionNo() {
        return this.buildingPermissionNo;
    }

    public void setBuildingPermissionNo(Integer buildingPermissionNo) {
        this.buildingPermissionNo = buildingPermissionNo;
    }

    public Date getBuildingPermissionDate() {
        return this.buildingPermissionDate;
    }

    public void setBuildingPermissionDate(Date buildingPermissionDate) {
        this.buildingPermissionDate = buildingPermissionDate;
    }

    public Long getFloorTypeId() {
        return this.floorTypeId;
    }

    public void setFloorTypeId(Long floorTypeId) {
        this.floorTypeId = floorTypeId;
    }

    public Long getRoofTypeId() {
        return this.roofTypeId;
    }

    public void setRoofTypeId(Long roofTypeId) {
        this.roofTypeId = roofTypeId;
    }

    public Long getWallTypeId() {
        return this.wallTypeId;
    }

    public void setWallTypeId(Long wallTypeId) {
        this.wallTypeId = wallTypeId;
    }

    public Long getWoodTypeId() {
        return this.woodTypeId;
    }

    public void setWoodTypeId(Long woodTypeId) {
        this.woodTypeId = woodTypeId;
    }

    public void setBasicPropertyDAO(BasicPropertyDAO basicPropertyDAO) {
        this.basicPropertyDAO = basicPropertyDAO;
    }

    public void setPropertyTypeMasterDAO(PropertyTypeMasterDAO propertyTypeMasterDAO) {
        this.propertyTypeMasterDAO = propertyTypeMasterDAO;
    }

    public void setPropertyStatusValuesDAO(PropertyStatusValuesDAO propertyStatusValuesDAO) {
        this.propertyStatusValuesDAO = propertyStatusValuesDAO;
    }

    public void setPtDemandDAO(PtDemandDao ptDemandDAO) {
        this.ptDemandDAO = ptDemandDAO;
    }

    public void setbasicPropertyService(PropertyPersistenceService basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public void setSecurityUtils(SecurityUtils securityUtils) {
        this.securityUtils = securityUtils;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public PropertyTypeMaster getPropTypeMstr() {
        return this.propTypeMstr;
    }

    public void setPropTypeMstr(PropertyTypeMaster propTypeMstr) {
        this.propTypeMstr = propTypeMstr;
    }

    public Map<String, String> getDeviationPercentageMap() {
        return this.deviationPercentageMap;
    }

    public void setDeviationPercentageMap(Map<String, String> deviationPercentageMap) {
        this.deviationPercentageMap = deviationPercentageMap;
    }

    public String getCertificationNumber() {
        return this.certificationNumber;
    }

    public void setCertificationNumber(String certificationNumber) {
        this.certificationNumber = certificationNumber;
    }

    public String getNorthBoundary() {
        return this.northBoundary;
    }

    public void setNorthBoundary(String northBoundary) {
        this.northBoundary = northBoundary;
    }

    public String getEastBoundary() {
        return this.eastBoundary;
    }

    public void setEastBoundary(String eastBoundary) {
        this.eastBoundary = eastBoundary;
    }

    public String getWestBoundary() {
        return this.westBoundary;
    }

    public void setWestBoundary(String westBoundary) {
        this.westBoundary = westBoundary;
    }

    public String getSouthBoundary() {
        return this.southBoundary;
    }

    public void setSouthBoundary(String southBoundary) {
        this.southBoundary = southBoundary;
    }

    public String getAdditionalRule() {
        String addittionalRule = "";
        addittionalRule = "ADD_OR_ALTER".equals(this.modifyRsn) ? "ALTER ASSESSMENT" : ("BIFURCATE".equals(this.modifyRsn) ? "BIFURCATE ASSESSMENT" : "GENERAL REVISION PETITION");
        return addittionalRule;
    }

    public BigDecimal getCurrentPropertyTax() {
        return this.currentPropertyTax;
    }

    public void setCurrentPropertyTax(BigDecimal currentPropertyTax) {
        this.currentPropertyTax = currentPropertyTax;
    }

    public BigDecimal getCurrentPropertyTaxDue() {
        return this.currentPropertyTaxDue;
    }

    public void setCurrentPropertyTaxDue(BigDecimal currentPropertyTaxDue) {
        this.currentPropertyTaxDue = currentPropertyTaxDue;
    }

    public BigDecimal getCurrentWaterTaxDue() {
        return this.currentWaterTaxDue;
    }

    public void setCurrentWaterTaxDue(BigDecimal currentWaterTaxDue) {
        this.currentWaterTaxDue = currentWaterTaxDue;
    }

    public BigDecimal getArrearPropertyTaxDue() {
        return this.arrearPropertyTaxDue;
    }

    public void setArrearPropertyTaxDue(BigDecimal arrearPropertyTaxDue) {
        this.arrearPropertyTaxDue = arrearPropertyTaxDue;
    }

    public String getTaxDueErrorMsg() {
        return this.taxDueErrorMsg;
    }

    public void setTaxDueErrorMsg(String taxDueErrorMsg) {
        this.taxDueErrorMsg = taxDueErrorMsg;
    }

    public Boolean getWfInitiatorRejected() {
        return this.wfInitiatorRejected;
    }

    public void setWfInitiatorRejected(Boolean wfInitiatorRejected) {
        this.wfInitiatorRejected = wfInitiatorRejected;
    }

    public String getPropertyCategory() {
        return this.propertyCategory;
    }

    public void setPropertyCategory(String propertyCategory) {
        this.propertyCategory = propertyCategory;
    }

    public Map<String, BigDecimal> getPropertyTaxDetailsMap() {
        return this.propertyTaxDetailsMap;
    }

    public void setPropertyTaxDetailsMap(Map<String, BigDecimal> propertyTaxDetailsMap) {
        this.propertyTaxDetailsMap = propertyTaxDetailsMap;
    }
}

