/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.deactivate;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.client.util.FinancialUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.PropertyMutationMasterDAO;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.PropertyNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@ParentPackage(value="egov")
@Namespace(value="/deactivate")
public class DeactivatePropertyAction
extends PropertyTaxBaseAction {
    private BasicProperty basicProp;
    private String ownerName;
    private String address;
    private String propertyType;
    private PropertyImpl property;
    private String referenceNo;
    private Date referenceDate;
    private String remarks;
    private String ackMessage;
    private String reason;
    private String docNumber;
    public static final String NEW = "new";
    public static final String ACK = "ack";
    public static final String RESULT_VIEW = "view";
    public static final String FORWARD_ACK = "forwardAck";
    public static final String PENDING_DMD = "pnd_ack";
    private static final String RSN_COURTORDER = "COURTORDER";
    private static final String PROP_STATUS_INACTIVE = "INACTIVE";
    private static final String WORKFLOW_END = "END";
    private static final String MSG_REJECT_SUCCESS = " Deactivate Property Rejected Successfully ";
    private PropertyService propService;
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PersistenceService<Property, Long> propertyImplService;
    FinancialUtil financialUtil = new FinancialUtil();
    PropertyStatusValues propStatusVal = new PropertyStatusValues();
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private UserService userService;
    private EisCommonService eisCommonService;
    @Autowired
    private PropertyMutationMasterDAO propertyMutationMasterDAO;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;

    @SkipValidation
    @Action(value="/deActivateProperty-newForm", results={@Result(name="new", location="/deActivateProperty-new.jsp")})
    public String newForm() {
        this.LOGGER.debug((Object)("Entered into the newForm method, Index Number " + this.indexNumber));
        String target = "";
        try {
            if (this.getBasicProp() == null) {
                throw new PropertyNotFoundException();
            }
            this.LOGGER.debug((Object)("newForm: BasicProperty: " + this.getBasicProp()));
            Map wfMap = this.basicProp.getPropertyWfStatus();
            String wfStatus = (String)wfMap.get("WFSTATUS");
            if (wfStatus.equalsIgnoreCase("TRUE")) {
                this.getSession().put("WFOWNER", wfMap.get("WFOWNER"));
                target = "workFlowError";
            } else {
                this.setOwnerName(this.basicProp.getFullOwnerName());
                this.setAddress(this.basicProp.getAddress().toString());
                this.setDocNumber(this.basicProp.getProperty().getDocNumber());
                target = NEW;
            }
        }
        catch (PropertyNotFoundException e) {
            this.LOGGER.error((Object)("Property not found with given Index Number " + this.indexNumber), (Throwable)e);
        }
        this.LOGGER.debug((Object)"Exit from newForm method");
        return target;
    }

    @SkipValidation
    @Action(value="/deActivateProperty-viewForm", results={@Result(name="forwardAck", location="/deActivateProperty-forwardAck.jsp")})
    public String viewForm() {
        this.LOGGER.debug((Object)"Entered into viewForm");
        this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        this.LOGGER.debug((Object)("viewForm: Property: " + this.property));
        if (this.userDesgn.equalsIgnoreCase("RO")) {
            this.setIsApprPageReq(Boolean.FALSE);
        }
        this.basicProp = this.property.getBasicProperty();
        this.LOGGER.debug((Object)("viewForm: BasicProperty: " + this.basicProp));
        this.propStatusVal = (PropertyStatusValues)this.getPersistenceService().find("from PropertyStatusValues PSV where PSV.basicProperty.upicNo = ? and PSV.isActive = 'N' and PSV.propertyStatus.statusCode=?", new Object[]{this.basicProp.getUpicNo(), PROP_STATUS_INACTIVE});
        this.setPropertyType(this.property.getPropertyDetail().getPropertyTypeMaster().getType());
        this.setOwnerName(this.basicProp.getFullOwnerName());
        this.setAddress(this.basicProp.getAddress().toString());
        this.setDocNumber(this.property.getDocNumber());
        this.LOGGER.debug((Object)"Exit from viewForm");
        return RESULT_VIEW;
    }

    public void prepare() {
        this.LOGGER.debug((Object)"Entered into the prepare method");
        if (this.getModelId() != null && !this.getModelId().isEmpty()) {
            this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.LOGGER.debug((Object)("prepare: Property: " + this.property));
        }
        if (this.indexNumber != null && !"".equals(this.indexNumber)) {
            this.basicProp = (BasicProperty)this.basicPropertyService.findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber});
            this.LOGGER.debug((Object)("prepare: BasicProperty: " + this.basicProp));
        }
        List propMutationMstr = this.propertyMutationMasterDAO.getAllPropertyMutationMastersByType("DEACTIVATE");
        this.addDropdownData("Reason", propMutationMstr);
        this.setupWorkflowDetails();
        this.setUserInfo();
        this.LOGGER.debug((Object)"Exit from prepare method");
    }

    @ValidationErrorPage(value="new")
    @Transactional
    @Action(value="/deActivateProperty-save", results={@Result(name="ack", location="/deActivateProperty-ack.jsp")})
    public String save() {
        this.LOGGER.debug((Object)"Entered into the save method");
        this.LOGGER.debug((Object)("save: BasicProperty: " + this.basicProp));
        this.LOGGER.debug((Object)("save: PropertyStatusValues for deactivation: " + this.propStatusVal));
        try {
            Map amounts = this.propService.prepareRsnWiseDemandForPropToBeDeactivated(this.basicProp.getProperty());
            this.financialUtil.createVoucher(this.basicProp.getUpicNo(), amounts, "Deactivate");
            this.basicProp.setActive(Boolean.valueOf(false));
            PropertyStatus propertyStatus = this.propertyStatusDAO.getPropertyStatusByCode(PROP_STATUS_INACTIVE);
            this.LOGGER.debug((Object)("save: PropertyStatus: " + propertyStatus));
            this.propStatusVal.setPropertyStatus(propertyStatus);
            this.propStatusVal.setIsActive("Y");
            this.propStatusVal.setExtraField2(this.getReason());
            this.basicProp.addPropertyStatusValues(this.propStatusVal);
            this.processAndStoreDocumentsWithReason(this.basicProp, "DEACTIVATE");
            this.basicProp = (BasicProperty)this.basicPropertyService.update((Object)this.basicProp);
            this.LOGGER.debug((Object)"Exit from save method");
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        return ACK;
    }

    @SkipValidation
    @Transactional
    @Action(value="/deActivateProperty-forward", results={@Result(name="ack", location="/deActivateProperty-ack.jsp")})
    public String forward() {
        this.LOGGER.debug((Object)"Entered into forward method");
        this.LOGGER.debug((Object)("forward: BasicProperty: " + this.basicProp));
        this.LOGGER.debug((Object)("forward: PropertyStatusValues for deactivation: " + this.propStatusVal));
        String propDocNum = "";
        try {
            if (this.userRole.equalsIgnoreCase("ASSISTANT")) {
                this.validate();
                if (this.hasErrors()) {
                    return NEW;
                }
                if (StringUtils.isNotBlank((String)this.getModelId())) {
                    this.property.setDocNumber(propDocNum);
                    PropertyStatusValues propStatVal = (PropertyStatusValues)this.getPersistenceService().find("from PropertyStatusValues PSV where PSV.basicProperty.upicNo = ? and PSV.isActive = 'N' and PSV.propertyStatus.statusCode=?", new Object[]{this.basicProp.getUpicNo(), PROP_STATUS_INACTIVE});
                    propStatVal.setExtraField2(this.getReason());
                    propStatVal.setReferenceNo(this.propStatusVal.getReferenceNo());
                    propStatVal.setReferenceDate(this.propStatusVal.getReferenceDate());
                    propStatVal.setRemarks(this.propStatusVal.getRemarks());
                    this.getPersistenceService().setType(PropertyStatusValues.class);
                    this.getPersistenceService().update((Object)propStatVal);
                } else {
                    this.property = (PropertyImpl)this.basicProp.getProperty().createPropertyclone();
                    this.property.setStatus(PropertyTaxConstants.STATUS_WORKFLOW);
                    propDocNum = this.getDocNumber() != null && this.getDocNumber() != "" ? this.getDocNumber() : this.property.getDocNumber();
                    this.property.setDocNumber(propDocNum);
                    this.basicProp.addProperty((Property)this.property);
                    PropertyStatus propertyStatus = this.propertyStatusDAO.getPropertyStatusByCode(PROP_STATUS_INACTIVE);
                    this.propStatusVal.setPropertyStatus(propertyStatus);
                    this.propStatusVal.setIsActive("N");
                    this.propStatusVal.setExtraField2(this.getReason());
                    this.LOGGER.debug((Object)("forward: PropertyStatusValues after setting status, isActive & reason fields: " + this.propStatusVal));
                    this.basicProp.addPropertyStatusValues(this.propStatusVal);
                    this.basicProp = (BasicProperty)this.basicPropertyService.update((Object)this.basicProp);
                }
            } else {
                this.propStatusVal = (PropertyStatusValues)this.getPersistenceService().find("from PropertyStatusValues PSV where PSV.basicProperty.upicNo = ? and PSV.isActive = 'N' and PSV.propertyStatus.statusCode=?", new Object[]{this.basicProp.getUpicNo(), PROP_STATUS_INACTIVE});
                this.LOGGER.debug((Object)("forward: PropertyStatusValues for deactivation: " + this.propStatusVal));
                super.validate();
                if (this.hasErrors()) {
                    return RESULT_VIEW;
                }
                this.LOGGER.debug((Object)"Exit from forward method");
            }
            this.transitionWorkFlow();
            User approverUser = this.userService.getUserById(Long.valueOf(this.getWorkflowBean().getApproverUserId()));
            this.setAckMessage("Property Successfully Forwarded to " + approverUser.getUsername());
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        this.LOGGER.debug((Object)("Ack message: " + this.ackMessage));
        return FORWARD_ACK;
    }

    @SkipValidation
    @Action(value="/deActivateProperty-approve", results={@Result(name="ack", location="/deActivateProperty-ack.jsp")})
    public String approve() {
        this.LOGGER.debug((Object)"Entered into approve");
        this.LOGGER.debug((Object)("approve: BasicProperty: " + this.basicProp));
        try {
            PropertyImpl nonHistProperty = (PropertyImpl)this.getPersistenceService().findByNamedQuery("getPropertyByUpicNoAndStatus", new Object[]{this.property.getBasicProperty().getUpicNo(), PropertyTaxConstants.STATUS_ISACTIVE});
            nonHistProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.transitionWorkFlow();
            PropertyStatus propertyStatus = this.propertyStatusDAO.getPropertyStatusByCode(PROP_STATUS_INACTIVE);
            this.propStatusVal = (PropertyStatusValues)this.getPersistenceService().find("from PropertyStatusValues PSV where PSV.basicProperty = ? and PSV.propertyStatus = ?", new Object[]{this.basicProp, propertyStatus});
            if (this.propStatusVal != null) {
                this.propStatusVal.setIsActive("Y");
            }
            this.LOGGER.debug((Object)("approve: PropertyStatusValues for deactivation made active: " + this.propStatusVal));
            Map amounts = this.propService.prepareRsnWiseDemandForPropToBeDeactivated(this.basicProp.getProperty());
            this.financialUtil.createVoucher(this.basicProp.getUpicNo(), amounts, "Deactivate");
            this.property.getBasicProperty().setActive(Boolean.valueOf(false));
            this.processAndStoreDocumentsWithReason(this.basicProp, "DEACTIVATE");
            this.basicProp = (BasicProperty)this.basicPropertyService.update((Object)this.basicProp);
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        this.LOGGER.debug((Object)"Exit from approve");
        return ACK;
    }

    @SkipValidation
    @Transactional
    @Action(value="/deActivateProperty-reject", results={@Result(name="forwardAck", location="/deActivateProperty-forwardAck.jsp")})
    public String reject() {
        this.LOGGER.debug((Object)"reject: Property rejection started");
        this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        this.LOGGER.debug((Object)("reject: Property: " + this.property));
        BasicProperty basicProperty = this.property.getBasicProperty();
        this.setBasicProp(basicProperty);
        this.LOGGER.debug((Object)("reject: BasicProperty: " + basicProperty));
        this.propStatusVal = (PropertyStatusValues)this.getPersistenceService().find("from PropertyStatusValues PSV where PSV.basicProperty.upicNo = ? and PSV.isActive = 'N' and PSV.propertyStatus.statusCode=?", new Object[]{this.basicProp.getUpicNo(), PROP_STATUS_INACTIVE});
        this.LOGGER.debug((Object)("reject: PropertyStatusValues for deactivation: " + this.propStatusVal));
        this.transitionWorkFlow();
        if (WORKFLOW_END.equalsIgnoreCase(this.property.getState().getValue())) {
            basicProperty.getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            this.setAckMessage(MSG_REJECT_SUCCESS);
            this.propertyImplService.update((Object)this.property);
            this.basicPropertyService.update((Object)basicProperty);
        } else {
            this.setAckMessage(MSG_REJECT_SUCCESS + this.property.getCreatedBy().getUsername());
        }
        this.LOGGER.debug((Object)("reject: BasicProperty: " + this.getBasicProp() + "AckMessage: " + this.getAckMessage()));
        this.LOGGER.debug((Object)"reject: Property rejection ended");
        return FORWARD_ACK;
    }

    public void validate() {
        this.LOGGER.debug((Object)"Entered into the validate method");
        this.LOGGER.debug((Object)("validate: PropertyStatusValues : " + this.propStatusVal));
        String comments = StringUtils.trim((String)this.propStatusVal.getRemarks());
        if (comments == null || StringUtils.isEmpty((String)comments)) {
            this.addActionError(this.getText("mandatory.remarks"));
        }
        if (this.reason == null || StringUtils.equals((String)this.reason, (String)"none")) {
            this.addActionError(this.getText("mandatory.deactRsn"));
        }
        if (StringUtils.isNumeric((String)this.reason)) {
            this.addActionError(this.getText("mandatory.properRsn"));
        }
        if (StringUtils.equals((String)this.reason, (String)RSN_COURTORDER)) {
            if (this.propStatusVal.getReferenceNo() == null || StringUtils.isEmpty((String)this.propStatusVal.getReferenceNo())) {
                this.addActionError(this.getText("mandatory.refNo"));
            } else {
                Pattern p = Pattern.compile("[^a-zA-Z0-9,/-]");
                Matcher m = p.matcher(this.propStatusVal.getReferenceNo());
                if (m.find()) {
                    this.addActionError(this.getText("mandatory.validOrderNo"));
                }
            }
            if (this.propStatusVal.getReferenceDate() == null) {
                this.addActionError(this.getText("mandatory.refDate"));
            }
        }
        if (this.propStatusVal.getReferenceDate() != null && this.propStatusVal.getReferenceDate().after(new Date())) {
            this.addActionError(this.getText("mandatory.ordDateBeforeCurr"));
        }
        super.validate();
        this.LOGGER.debug((Object)"Exit from validate method");
    }

    @Transactional
    private void transitionWorkFlow() {
        this.LOGGER.debug((Object)"Entered method : transitionWorkFlow");
        if (this.workflowBean == null) {
            this.LOGGER.debug((Object)"transitionWorkFlow: workflowBean is NULL");
        } else {
            this.LOGGER.debug((Object)("transitionWorkFlow - action : " + this.workflowBean.getActionName() + "property: " + this.property));
        }
        this.LOGGER.debug((Object)("transitionWorkFlow: Property transitioned to " + this.property.getState().getValue()));
        this.propertyImplService.persist((Object)this.property);
        this.LOGGER.debug((Object)"Exiting method : transitionWorkFlow");
    }

    public String getPropertyId() {
        return this.indexNumber;
    }

    public void setPropertyId(String propertyId) {
        this.indexNumber = propertyId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public BasicProperty getBasicProp() {
        return this.basicProp;
    }

    public void setBasicProp(BasicProperty basicProp) {
        this.basicProp = basicProp;
    }

    public PropertyStatusValues getPropStatusVal() {
        return this.propStatusVal;
    }

    public void setPropStatusVal(PropertyStatusValues propertyStatusValues) {
        this.propStatusVal = propertyStatusValues;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public String getReferenceNo() {
        return this.referenceNo;
    }

    public void setReferenceNo(String referenceNo) {
        this.referenceNo = referenceNo;
    }

    public Date getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(Date referenceDate) {
        this.referenceDate = referenceDate;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public EisCommonService getEisCommonService() {
        return this.eisCommonService;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public StateAware getModel() {
        return null;
    }
}

