/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.citizen.collection;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.springframework.beans.factory.annotation.Autowired;

@Namespace(value="/citizen/collection")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name="collectTax", location="citizen/collection/collection-collectTax.jsp"), @Result(name="taxPaid", location="citizen/collection/collection-taxPaid.jsp"), @Result(name="ownerDetails", location="citizen/collection/collection-ownerDetails.jsp"), @Result(name="updateMobileNo", location="citizen/collection/collection-updateMobileNo.jsp")})
@ParentPackage(value="egov")
@Validations
public class CollectionAction
extends BaseFormAction {
    private static final long serialVersionUID = -153634114075566642L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    public static final String RESULT_COLLECTTAX = "collectTax";
    public static final String RESULT_TAXPAID = "taxPaid";
    protected static final String USER_DETAILS = "ownerDetails";
    protected static final String UPDATEMOBILE_FORM = "updateMobileNo";
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private PTBillServiceImpl ptBillServiceImpl;
    private BasicProperty basicProperty;
    private User propertyOwner;
    private String collectXML;
    private String assessmentNumber;
    private String doorNo;
    private String mobileNumber;
    private Long userId;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyTaxBillable propertyTaxBillable;

    public void prepare() {
        this.LOGGER.debug((Object)"Entered into prepare method");
        User usr = this.userService.getUserByUsername("9999999999");
        this.setUserId(Long.valueOf(usr.getId()));
        ApplicationThreadLocals.setUserId((Long)usr.getId());
        this.basicProperty = (BasicProperty)this.basicPropertyService.findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.assessmentNumber});
        this.LOGGER.debug((Object)"Exit from prepare method");
    }

    @Action(value="/collection-generateBill")
    public String generateBill() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered method generatePropertyTaxBill, assessment Number: " + this.assessmentNumber));
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("generatePropertyTaxBill : BasicProperty :" + this.basicProperty));
        }
        Map demandCollMap = this.propertyTaxUtil.getDemandAndCollection(this.basicProperty.getProperty());
        BigDecimal currDue = ((BigDecimal)demandCollMap.get("CURR_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_COLL"));
        BigDecimal arrDue = ((BigDecimal)demandCollMap.get("ARR_DMD")).subtract((BigDecimal)demandCollMap.get("ARR_COLL"));
        BigDecimal advanceCollected = (BigDecimal)demandCollMap.get("ADVANCECOLLECTION");
        BigDecimal secondHalfTax = (BigDecimal)demandCollMap.get("CURR_SECONDHALF_DMD");
        BigDecimal actualAdvanceToBeCollected = secondHalfTax.multiply(new BigDecimal(PropertyTaxConstants.MAX_ADVANCES_ALLOWED));
        BigDecimal advanceBalance = actualAdvanceToBeCollected.subtract(advanceCollected);
        if (currDue.compareTo(BigDecimal.ZERO) <= 0 && arrDue.compareTo(BigDecimal.ZERO) <= 0 && advanceBalance.compareTo(BigDecimal.ZERO) <= 0) {
            return RESULT_TAXPAID;
        }
        this.propertyTaxBillable.setBasicProperty(this.basicProperty);
        this.propertyTaxBillable.setLevyPenalty(Boolean.valueOf(true));
        this.propertyTaxBillable.setUserId(this.userId);
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateBillNumber(this.basicProperty.getPropertyID().getWard().getBoundaryNum().toString()));
        this.propertyTaxBillable.setBillType(this.propertyTaxUtil.getBillTypeByCode("AUTO"));
        try {
            this.collectXML = URLEncoder.encode(this.ptBillServiceImpl.getBillXML((Billable)this.propertyTaxBillable), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.info((Object)("Exiting method generatePropertyTaxBill, collectXML: " + this.collectXML));
        }
        return RESULT_COLLECTTAX;
    }

    @Action(value="/collection-searchOwnerDetails")
    public String searchOwnerDetails() {
        if (null != this.basicProperty) {
            this.setPropertyOwner(this.basicProperty.getPrimaryOwner());
        }
        this.setMobileNumber(this.getPropertyOwner().getMobileNumber());
        if (StringUtils.isBlank((CharSequence)this.propertyOwner.getMobileNumber())) {
            this.propertyOwner.setMobileNumber("N/A");
        }
        for (PropertyOwnerInfo propOwner : this.basicProperty.getPropertyOwnerInfo()) {
            List addrSet = propOwner.getOwner().getAddress();
            Iterator iterator = addrSet.iterator();
            if (!iterator.hasNext()) continue;
            Address address = (Address)iterator.next();
            this.setDoorNo(address.getHouseNoBldgApt() == null ? "N/A" : address.getHouseNoBldgApt());
        }
        return USER_DETAILS;
    }

    @Action(value="/collection-updateMobileNo")
    public String updateMobileNo() {
        if (null != this.basicProperty) {
            this.setPropertyOwner(this.basicProperty.getPrimaryOwner());
        }
        if (StringUtils.isNotBlank((CharSequence)this.mobileNumber)) {
            this.propertyOwner.setMobileNumber(this.mobileNumber);
            this.userService.updateUser(this.propertyOwner);
        }
        return UPDATEMOBILE_FORM;
    }

    public PersistenceService<BasicProperty, Long> getBasicPropertyService() {
        return this.basicPropertyService;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public String getCollectXML() {
        return this.collectXML;
    }

    public void setCollectXML(String collectXML) {
        this.collectXML = collectXML;
    }

    public Object getModel() {
        return null;
    }

    public String getAssessmentNumber() {
        return this.assessmentNumber;
    }

    public void setAssessmentNumber(String assessmentNumber) {
        this.assessmentNumber = assessmentNumber;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public PTBillServiceImpl getPtBillServiceImpl() {
        return this.ptBillServiceImpl;
    }

    public void setPtBillServiceImpl(PTBillServiceImpl ptBillServiceImpl) {
        this.ptBillServiceImpl = ptBillServiceImpl;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public User getPropertyOwner() {
        return this.propertyOwner;
    }

    public void setPropertyOwner(User propertyOwner) {
        this.propertyOwner = propertyOwner;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }
}

