CREATE SEQUENCE SEQ_EGPT_AMALGAMATION;

CREATE TABLE EGPT_AMALGAMATION
(
	ID BIGINT NOT NULL, -- PRIMARY KEY
	PARENTPROPERTY BIGINT NOT NULL, -- PARENT PROPERTY ID
	AMALGAMATEDPROPERTY BIGINT NOT NULL, -- AMALGAMATED PROPERTY ID
	CREATEDBY BIGINT NOT NULL,
	LASTMODIFIEDBY BIGINT NOT NULL,
	CREATEDDATE TIMESTAMP WITHOUT TIME ZONE NOT NULL,
	LASTMODIFIEDDATE TIMESTAMP WITHOUT TIME ZONE NOT NULL,
	CONSTRAINT PK_EGPT_AMALGAMATION_ID PRIMARY KEY (ID ),
	CONSTRAINT FK_EGPT_AMALGAMATION_CREATEDBY FOREIGN KEY (CREATEDBY) REFERENCES EG_USER (ID),
	CONSTRAINT FK_EGPT_AMALGAMATION_LASTMODIFIEDBY FOREIGN KEY (LASTMODIFIEDBY) REFERENCES EG_USER (ID),
	CONSTRAINT FK_EGPT_AMALGAMATION_PARENTID FOREIGN KEY (PARENTPROPERTY) REFERENCES EGPT_BASIC_PROPERTY (ID),
	CONSTRAINT FK_EGPT_AMALGAMATION_AMALPROPID FOREIGN KEY (AMALGAMATEDPROPERTY) REFERENCES EGPT_BASIC_PROPERTY (ID)
);



CREATE SEQUENCE SEQ_EGPT_AMALGAMATION_OWNER;

CREATE TABLE EGPT_AMALGAMATION_OWNER
(
	ID BIGINT NOT NULL, -- PRIMARY KEY
	PROPERTY BIGINT NOT NULL, -- PROPERTY ID
	OWNER BIGINT NOT NULL, -- AMALGAMATED PROPERTY OWNER
	CONSTRAINT PK_EGPT_AMLG_OWNER_ID PRIMARY KEY (ID ),
	CONSTRAINT FK_EGPT_AMLG_OWNER_PROPERTYID FOREIGN KEY (PROPERTY) REFERENCES EGPT_PROPERTY (ID),
	CONSTRAINT FK_EGPT_AMLG_OWNER_OWNERID FOREIGN KEY (OWNER) REFERENCES EG_USER (ID)
);




