/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.es;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollTableData;
import org.egov.ptis.bean.dashboard.CollectionAnalysis;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.CollectionTrend;
import org.egov.ptis.bean.dashboard.DayWiseCollection;
import org.egov.ptis.bean.dashboard.DemandCollectionMIS;
import org.egov.ptis.bean.dashboard.MonthlyDCB;
import org.egov.ptis.bean.dashboard.ReceiptTableData;
import org.egov.ptis.bean.dashboard.ReceiptsTrend;
import org.egov.ptis.bean.dashboard.WeeklyDCB;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.es.BillCollectorIndex;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class CollectionIndexElasticSearchService {
    private static final String DECEMBER = "December";
    private static final String NOVEMBER = "November";
    private static final String OCTOBER = "October";
    private static final String SEPTEMBER = "September";
    private static final String AUGUST = "August";
    private static final String JULY = "July";
    private static final String JUNE = "June";
    private static final String MAY = "May";
    private static final String APRIL = "April";
    private static final String MARCH = "March";
    private static final String FEBRUARY = "Feburary";
    private static final String JANUARY = "January";
    private static final String LY_ADVANCE = "lyAdvance";
    private static final String LY_REBATE = "lyRebate";
    private static final String LY_CURRENT_CESS = "lyCurrentCess";
    private static final String LY_CURRENT_AMOUNT = "lyCurrentAmount";
    private static final String LY_ARREAR_CESS = "lyArrearCess";
    private static final String LY_ARREAR_AMOUNT = "lyArrearAmount";
    private static final String LY_PENALTY = "lyPenalty";
    private static final String LY_LATE_PAYMENT_PENALTY = "lyLatePaymentPenalty";
    private static final String CY_ADVANCE = "cyAdvance";
    private static final String CY_REBATE = "cyRebate";
    private static final String CY_PENALTY = "cyPenalty";
    private static final String CY_LATE_PAYMENT_PENALTY = "cyLatePaymentPenalty";
    private static final String CY_CURRENT_CESS = "cyCurrentCess";
    private static final String CY_CURRENT_AMOUNT = "cyCurrentAmount";
    private static final String CY_ARREAR_CESS = "cyArrearCess";
    private static final String CY_ARREAR_AMOUNT = "cyArrearAmount";
    private static final String CURRENT_INT_DMD = "currentIntDmd";
    private static final String ARREAR_INT_DMD = "arrearIntDmd";
    private static final String IS_EXEMPTED = "isExempted";
    private static final String IS_ACTIVE = "isActive";
    private static final String IS_UNDER_COURTCASE = "isUnderCourtcase";
    private static final String CONSUMER_TYPE = "consumerType";
    private static final String LATE_PAYMENT_CHARGES = "latePaymentCharges";
    private static final String CURR_CESS = "curr_cess";
    private static final String ARREAR_CESS_CONST = "arrear_cess";
    private static final String CURR_AMOUNT = "curr_amount";
    private static final String ARREAR_AMOUNT_CONST = "arrear_amount";
    private static final String CURRENT_DMD = "currentDmd";
    private static final String ARREAR_DMD = "arrearDmd";
    private static final String CURRENT_CESS = "currentCess";
    private static final String ARREAR_CESS = "arrearCess";
    private static final String CURRENT_AMOUNT = "currentAmount";
    private static final String ARREAR_AMOUNT = "arrearAmount";
    private static final String CONSUMER_CODE = "consumerCode";
    private static final String RECEIPT_COUNT = "receipt_count";
    private static final String DATE_AGG = "date_agg";
    private static final String BY_CITY = "by_city";
    private static final String MILLISECS = " (millisecs) ";
    private static final String REVENUE_WARD = "revenueWard";
    private static final String CITY_NAME = "cityName";
    private static final String CITY_CODE = "cityCode";
    private static final String CITY_GRADE = "cityGrade";
    private static final String DISTRICT_NAME = "districtName";
    private static final String REGION_NAME = "regionName";
    private static final String BILLING_SERVICE = "billingService";
    private static final String TOTAL_DEMAND = "totalDemand";
    private static final String TOTAL_AMOUNT = "totalAmount";
    private static final String COLLECTIONTOTAL = "collectiontotal";
    private static final String CANCELLED = "Cancelled";
    private static final String STATUS = "status";
    private static final String RECEIPT_DATE = "receiptDate";
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionIndexElasticSearchService.class);
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public BigDecimal getConsolidatedCollForYears(Date fromDate, Date toDate, String billingService) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        boolQuery = "Water Charges".equalsIgnoreCase(billingService) ? boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)BILLING_SERVICE, (Object)billingService)) : boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, Arrays.asList("Property Tax", "Property Tax (On Land)"))));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTIONTOTAL).field(TOTAL_AMOUNT)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)collAggr.get(COLLECTIONTOTAL);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public Map<String, BigDecimal> getFinYearsCollByService(String billingService) {
        HashMap<String, BigDecimal> consolidatedCollValues = new HashMap<String, BigDecimal>();
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        consolidatedCollValues.put("cytdColln", this.getConsolidatedCollForYears(currFinYear.getStartingDate(), DateUtils.addDays((Date)new Date(), (int)1), billingService));
        consolidatedCollValues.put("lytdColln", this.getConsolidatedCollForYears(DateUtils.addYears((Date)currFinYear.getStartingDate(), (int)-1), DateUtils.addDays((Date)DateUtils.addYears((Date)new Date(), (int)-1), (int)1), billingService));
        return consolidatedCollValues;
    }

    private BoolQueryBuilder prepareWhereClause(CollectionDetailsRequest collectionDetailsRequest, String indexName) {
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        if (indexName.equals("propertytax")) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        } else if (indexName.equals("receipts")) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)BILLING_SERVICE, Arrays.asList("Property Tax", "Property Tax (On Land)")));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)collectionDetailsRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)collectionDetailsRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)collectionDetailsRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)collectionDetailsRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getPropertyType())) {
            boolQuery = this.queryForPropertyType(collectionDetailsRequest, boolQuery, indexName);
        }
        if ("propertytax".equalsIgnoreCase(indexName) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUsageType())) {
            boolQuery = this.queryForUsageType(collectionDetailsRequest, boolQuery);
        }
        return boolQuery;
    }

    private BoolQueryBuilder queryForUsageType(CollectionDetailsRequest collectionDetailsRequest, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder usageTypeQuery = boolQuery;
        if (!"ALL".equalsIgnoreCase(collectionDetailsRequest.getUsageType())) {
            usageTypeQuery = usageTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"propertyUsage", (Object)collectionDetailsRequest.getUsageType()));
        }
        return usageTypeQuery;
    }

    public BoolQueryBuilder queryForPropertyType(CollectionDetailsRequest collectionDetailsRequest, BoolQueryBuilder boolQuery, String indexName) {
        BoolQueryBuilder propTypeQuery = boolQuery;
        if ("Courtcases".equalsIgnoreCase(collectionDetailsRequest.getPropertyType())) {
            propTypeQuery = "propertytax".equalsIgnoreCase(indexName) ? propTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_UNDER_COURTCASE, (Object)true)) : propTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"conflict", (Object)1));
        } else {
            propTypeQuery = "CENTRAL_GOVT".equalsIgnoreCase(collectionDetailsRequest.getPropertyType()) ? propTypeQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)CONSUMER_TYPE, PropertyTaxConstants.DASHBOARD_PROPERTY_TYPE_CENTRAL_GOVT_LIST)) : ("Private".equalsIgnoreCase(collectionDetailsRequest.getPropertyType()) ? propTypeQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)CONSUMER_TYPE, Arrays.asList(collectionDetailsRequest.getPropertyType(), "EWSHS"))) : ("BuiltUp".equalsIgnoreCase(collectionDetailsRequest.getPropertyType()) ? propTypeQuery.filter((QueryBuilder)QueryBuilders.termsQuery((String)CONSUMER_TYPE, PropertyTaxConstants.DASHBOARD_BUILT_UP_PROPERTY_TYPES)) : propTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CONSUMER_TYPE, (Object)collectionDetailsRequest.getPropertyType()))));
            if (!"BuiltUp".equalsIgnoreCase(collectionDetailsRequest.getPropertyType())) {
                propTypeQuery = "propertytax".equalsIgnoreCase(indexName) ? propTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_UNDER_COURTCASE, (Object)false)) : propTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"conflict", (Object)0));
            }
        }
        return propTypeQuery;
    }

    public void getCompleteCollectionIndexDetails(CollectionDetailsRequest collectionDetailsRequest, CollectionDetails collectionIndexDetails) {
        Date toDate;
        Date fromDate;
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, TOTAL_AMOUNT);
        collectionIndexDetails.setTodayColl(todayColl);
        todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), null, TOTAL_AMOUNT);
        collectionIndexDetails.setLyTodayColl(todayColl);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, TOTAL_AMOUNT);
        collectionIndexDetails.setCytdColl(tillDateColl);
        BigDecimal demandColl = this.calculateDemandCollection(collectionDetailsRequest, fromDate, toDate);
        collectionIndexDetails.setDmdColl(demandColl);
        collectionIndexDetails.setPntlyColl(this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, LATE_PAYMENT_CHARGES));
        tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), null, TOTAL_AMOUNT);
        collectionIndexDetails.setLytdColl(tillDateColl);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCompleteCollectionIndexDetails() is : " + timeTaken + MILLISECS);
    }

    private BigDecimal calculateDemandCollection(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        return this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, ARREAR_AMOUNT).add(this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, CURRENT_AMOUNT)).add(this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, ARREAR_CESS)).add(this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null, CURRENT_CESS));
    }

    public BigDecimal getCollectionBetweenDates(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String cityName, String fieldName) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)cityName));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTIONTOTAL).field(fieldName)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(COLLECTIONTOTAL);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionBetweenDates() is : " + timeTaken + MILLISECS);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<CollTableData> getResponseTableData(CollectionDetailsRequest collectionDetailsRequest, boolean isForMISReports) {
        Date endDate;
        Date toDate;
        Date fromDate;
        ArrayList<CollTableData> collIndDataList = new ArrayList<CollTableData>();
        String aggregationField = "";
        if (!isForMISReports) {
            aggregationField = REGION_NAME;
        }
        HashMap<String, BillCollectorIndex> wardWiseBillCollectors = new HashMap();
        HashMap<String, Map<String, BigDecimal>> currYrTillDateCollDivisionMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Map<String, BigDecimal>> lastYrTillDateCollDivisionMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, Map<String, BigDecimal>> lastFinYrCollDivisionMap = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, CollTableData> tableDataMap = new HashMap<String, CollTableData>();
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            aggregationField = this.getAggregrationField(collectionDetailsRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> totalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", TOTAL_DEMAND, aggregationField);
        Map<String, BigDecimal> currYrTotalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", TOTAL_DEMAND, aggregationField);
        StringTerms individualDmdDetails = this.getIndividualDemands(collectionDetailsRequest, "propertytax", aggregationField, false);
        HashMap<String, Map<String, BigDecimal>> demandDivisionMap = new HashMap<String, Map<String, BigDecimal>>();
        this.prepareIndividualDemandsMap(individualDmdDetails, demandDivisionMap);
        Map<String, BigDecimal> assessmentsCountMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, null, null, "propertytax", CONSUMER_CODE, aggregationField);
        Map<String, BigDecimal> todayCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", TOTAL_AMOUNT, aggregationField);
        Map<String, BigDecimal> lyTodayCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", TOTAL_AMOUNT, aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            endDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)endDate, (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            endDate = new Date();
            toDate = DateUtils.addDays((Date)endDate, (int)1);
        }
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)endDate) + 1;
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", TOTAL_AMOUNT, aggregationField);
        StringTerms collBreakupForCurrYearTillDate = this.getIndividualCollections(collectionDetailsRequest, fromDate, toDate, "receipts", aggregationField);
        StringTerms collBreakupForLastYearTillDate = this.getIndividualCollections(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", aggregationField);
        StringTerms collBreakupForLastFinYear = this.getIndividualCollections(collectionDetailsRequest, DateUtils.addYears((Date)financialYear.getStartingDate(), (int)-1), DateUtils.addYears((Date)DateUtils.addDays((Date)financialYear.getEndingDate(), (int)1), (int)-1), "receipts", aggregationField);
        this.prepareIndividualCollMap(collBreakupForCurrYearTillDate, currYrTillDateCollDivisionMap, true);
        this.prepareIndividualCollMap(collBreakupForLastYearTillDate, lastYrTillDateCollDivisionMap, false);
        this.prepareIndividualCollMap(collBreakupForLastFinYear, lastFinYrCollDivisionMap, false);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", TOTAL_AMOUNT, aggregationField);
        Map<String, BigDecimal> lastFinYrCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, DateUtils.addYears((Date)financialYear.getStartingDate(), (int)-1), DateUtils.addYears((Date)DateUtils.addDays((Date)financialYear.getEndingDate(), (int)1), (int)-1), "receipts", TOTAL_AMOUNT, aggregationField);
        if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType())) {
            wardWiseBillCollectors = this.getWardWiseBillCollectors(collectionDetailsRequest);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionAndDemandValues() is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getPropertyType())) {
            this.setDataForCollectionTab(collectionDetailsRequest, tableDataMap, aggregationField, wardWiseBillCollectors, currYrTillDateCollDivisionMap, lastYrTillDateCollDivisionMap, lastFinYrCollDivisionMap, noOfMonths, totalDemandMap, currYrTotalDemandMap, demandDivisionMap, assessmentsCountMap, todayCollMap, lyTodayCollMap, cytdCollMap, lytdCollMap, lastFinYrCollMap);
        } else {
            this.setDataForDCBTab(collectionDetailsRequest, tableDataMap, aggregationField, wardWiseBillCollectors, currYrTillDateCollDivisionMap, lastYrTillDateCollDivisionMap, lastFinYrCollDivisionMap, noOfMonths, totalDemandMap, currYrTotalDemandMap, demandDivisionMap, assessmentsCountMap, todayCollMap, lyTodayCollMap, cytdCollMap, lytdCollMap, lastFinYrCollMap);
        }
        List<String> cityDetails = this.getCityDetails(collectionDetailsRequest, aggregationField);
        if (cityDetails.size() != tableDataMap.size()) {
            for (String name : cityDetails) {
                if (tableDataMap.get(name) == null) {
                    CollTableData collTableData = new CollTableData();
                    this.setBoundaryDateForTable(collectionDetailsRequest, name, collTableData, aggregationField, wardWiseBillCollectors);
                    collIndDataList.add(collTableData);
                    continue;
                }
                collIndDataList.add((CollTableData)tableDataMap.get(name));
            }
        } else {
            for (Map.Entry entry : tableDataMap.entrySet()) {
                collIndDataList.add((CollTableData)entry.getValue());
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getResponseTableData() is : " + timeTaken + MILLISECS);
        return collIndDataList;
    }

    private void setDataForCollectionTab(CollectionDetailsRequest collectionDetailsRequest, Map<String, CollTableData> tableDataMap, String aggregationField, Map<String, BillCollectorIndex> wardWiseBillCollectors, Map<String, Map<String, BigDecimal>> currYrTillDateCollDivisionMap, Map<String, Map<String, BigDecimal>> lastYrTillDateCollDivisionMap, Map<String, Map<String, BigDecimal>> lastFinYrCollDivisionMap, int noOfMonths, Map<String, BigDecimal> totalDemandMap, Map<String, BigDecimal> currYrTotalDemandMap, Map<String, Map<String, BigDecimal>> demandDivisionMap, Map<String, BigDecimal> assessmentsCountMap, Map<String, BigDecimal> todayCollMap, Map<String, BigDecimal> lyTodayCollMap, Map<String, BigDecimal> cytdCollMap, Map<String, BigDecimal> lytdCollMap, Map<String, BigDecimal> lastFinYrCollMap) {
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            CollTableData collIndData = new CollTableData();
            BigDecimal totalAssessments = BigDecimal.ZERO;
            BigDecimal arrearDemand = BigDecimal.ZERO;
            BigDecimal currentDemand = BigDecimal.ZERO;
            BigDecimal arrearInterestDemand = BigDecimal.ZERO;
            BigDecimal currentInterestDemand = BigDecimal.ZERO;
            BigDecimal cyArrearColl = BigDecimal.ZERO;
            BigDecimal cyCurrentColl = BigDecimal.ZERO;
            BigDecimal cyPenaltyColl = BigDecimal.ZERO;
            BigDecimal cyRebate = BigDecimal.ZERO;
            BigDecimal cyAdvance = BigDecimal.ZERO;
            BigDecimal lyArrearColl = BigDecimal.ZERO;
            BigDecimal lyCurrentColl = BigDecimal.ZERO;
            BigDecimal lyPenaltyColl = BigDecimal.ZERO;
            BigDecimal lyRebate = BigDecimal.ZERO;
            BigDecimal lyAdvance = BigDecimal.ZERO;
            BigDecimal lyTotalArrearColl = BigDecimal.ZERO;
            BigDecimal lyTotalCurrentColl = BigDecimal.ZERO;
            BigDecimal lyTotalPenaltyColl = BigDecimal.ZERO;
            BigDecimal lyTotalRebate = BigDecimal.ZERO;
            BigDecimal lyTotalAdvance = BigDecimal.ZERO;
            String name = entry.getKey();
            if (!assessmentsCountMap.isEmpty() && assessmentsCountMap.get(name) != null) {
                BigDecimal bigDecimal = totalAssessments = assessmentsCountMap.get(name) == null ? BigDecimal.ZERO : assessmentsCountMap.get(name);
            }
            if (!currYrTillDateCollDivisionMap.isEmpty() && currYrTillDateCollDivisionMap.get(name) != null) {
                cyArrearColl = (currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_AMOUNT)).add(currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_CESS) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_CESS));
                cyCurrentColl = (currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_AMOUNT)).add(currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_CESS) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_CESS));
                cyPenaltyColl = (currYrTillDateCollDivisionMap.get(name).get(CY_PENALTY) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_PENALTY)).add(currYrTillDateCollDivisionMap.get(name).get(CY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_LATE_PAYMENT_PENALTY));
                cyRebate = currYrTillDateCollDivisionMap.get(name).get(CY_REBATE) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_REBATE);
                BigDecimal bigDecimal = cyAdvance = currYrTillDateCollDivisionMap.get(name).get(CY_ADVANCE) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ADVANCE);
            }
            if (!lastYrTillDateCollDivisionMap.isEmpty() && lastYrTillDateCollDivisionMap.get(name) != null) {
                lyArrearColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_CESS) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_CESS));
                lyCurrentColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_CESS) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_CESS));
                lyPenaltyColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_PENALTY) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_PENALTY)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY));
                lyRebate = lastYrTillDateCollDivisionMap.get(name).get(LY_REBATE) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_REBATE);
                BigDecimal bigDecimal = lyAdvance = lastYrTillDateCollDivisionMap.get(name).get(LY_ADVANCE) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ADVANCE);
            }
            if (!lastFinYrCollDivisionMap.isEmpty() && lastFinYrCollDivisionMap.get(name) != null) {
                lyTotalArrearColl = (lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT)).add(lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_CESS) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_CESS));
                lyTotalCurrentColl = (lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT)).add(lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_CESS) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_CESS));
                lyTotalPenaltyColl = (lastFinYrCollDivisionMap.get(name).get(LY_PENALTY) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_PENALTY)).add(lastFinYrCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY));
                lyTotalRebate = lastFinYrCollDivisionMap.get(name).get(LY_REBATE) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_REBATE);
                BigDecimal bigDecimal = lyTotalAdvance = lastFinYrCollDivisionMap.get(name).get(LY_ADVANCE) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ADVANCE);
            }
            if (!demandDivisionMap.isEmpty() && demandDivisionMap.get(name) != null) {
                arrearDemand = demandDivisionMap.get(name).get(ARREAR_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(ARREAR_DMD);
                currentDemand = demandDivisionMap.get(name).get(CURRENT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(CURRENT_DMD);
                arrearInterestDemand = demandDivisionMap.get(name).get(ARREAR_INT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(ARREAR_INT_DMD);
                currentInterestDemand = demandDivisionMap.get(name).get(CURRENT_INT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(CURRENT_INT_DMD);
            }
            BigDecimal currentYearTotalDemand = currYrTotalDemandMap.get(name) == null ? BigDecimal.valueOf(0L) : currYrTotalDemandMap.get(name);
            this.setBoundaryDateForTable(collectionDetailsRequest, name, collIndData, aggregationField, wardWiseBillCollectors);
            this.setCollAmountsForTableData(collIndData, todayCollMap.get(name) == null ? BigDecimal.ZERO : todayCollMap.get(name), lyTodayCollMap.get(name) == null ? BigDecimal.ZERO : lyTodayCollMap.get(name), entry.getValue(), lytdCollMap.get(name) == null ? BigDecimal.ZERO : lytdCollMap.get(name), lastFinYrCollMap.get(name) == null ? BigDecimal.ZERO : lastFinYrCollMap.get(name));
            this.setCurrYearTillDateCollBreakUpForTableData(collIndData, cyArrearColl, cyCurrentColl, cyPenaltyColl, cyRebate, cyAdvance);
            this.setLastYearTillDateCollBreakUpForTableData(collIndData, lyArrearColl, lyCurrentColl, lyPenaltyColl, lyRebate, lyAdvance);
            this.setLastFinYearCollBreakUpForTableData(collIndData, lyTotalArrearColl, lyTotalCurrentColl, lyTotalPenaltyColl, lyTotalRebate, lyTotalAdvance);
            this.setDemandBreakUpForTableData(collIndData, arrearDemand, currentDemand, arrearInterestDemand, currentInterestDemand, noOfMonths);
            this.setDemandAmountsForTableData(name, collIndData, totalAssessments, currentYearTotalDemand, noOfMonths, totalDemandMap);
            tableDataMap.put(name, collIndData);
        }
    }

    private void setDataForDCBTab(CollectionDetailsRequest collectionDetailsRequest, Map<String, CollTableData> tableDataMap, String aggregationField, Map<String, BillCollectorIndex> wardWiseBillCollectors, Map<String, Map<String, BigDecimal>> currYrTillDateCollDivisionMap, Map<String, Map<String, BigDecimal>> lastYrTillDateCollDivisionMap, Map<String, Map<String, BigDecimal>> lastFinYrCollDivisionMap, int noOfMonths, Map<String, BigDecimal> totalDemandMap, Map<String, BigDecimal> currYrTotalDemandMap, Map<String, Map<String, BigDecimal>> demandDivisionMap, Map<String, BigDecimal> assessmentsCountMap, Map<String, BigDecimal> todayCollMap, Map<String, BigDecimal> lyTodayCollMap, Map<String, BigDecimal> cytdCollMap, Map<String, BigDecimal> lytdCollMap, Map<String, BigDecimal> lastFinYrCollMap) {
        for (Map.Entry<String, BigDecimal> entry : currYrTotalDemandMap.entrySet()) {
            CollTableData collIndData = new CollTableData();
            BigDecimal totalAssessments = BigDecimal.ZERO;
            BigDecimal arrearDemand = BigDecimal.ZERO;
            BigDecimal currentDemand = BigDecimal.ZERO;
            BigDecimal arrearInterestDemand = BigDecimal.ZERO;
            BigDecimal currentInterestDemand = BigDecimal.ZERO;
            BigDecimal cyArrearColl = BigDecimal.ZERO;
            BigDecimal cyCurrentColl = BigDecimal.ZERO;
            BigDecimal cyPenaltyColl = BigDecimal.ZERO;
            BigDecimal cyRebate = BigDecimal.ZERO;
            BigDecimal cyAdvance = BigDecimal.ZERO;
            BigDecimal lyArrearColl = BigDecimal.ZERO;
            BigDecimal lyCurrentColl = BigDecimal.ZERO;
            BigDecimal lyPenaltyColl = BigDecimal.ZERO;
            BigDecimal lyRebate = BigDecimal.ZERO;
            BigDecimal lyAdvance = BigDecimal.ZERO;
            BigDecimal lyTotalArrearColl = BigDecimal.ZERO;
            BigDecimal lyTotalCurrentColl = BigDecimal.ZERO;
            BigDecimal lyTotalPenaltyColl = BigDecimal.ZERO;
            BigDecimal lyTotalRebate = BigDecimal.ZERO;
            BigDecimal lyTotalAdvance = BigDecimal.ZERO;
            String name = entry.getKey();
            if (!assessmentsCountMap.isEmpty() && assessmentsCountMap.get(name) != null) {
                BigDecimal bigDecimal = totalAssessments = assessmentsCountMap.get(name) == null ? BigDecimal.ZERO : assessmentsCountMap.get(name);
            }
            if (!currYrTillDateCollDivisionMap.isEmpty() && currYrTillDateCollDivisionMap.get(name) != null) {
                cyArrearColl = (currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_AMOUNT)).add(currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_CESS) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ARREAR_CESS));
                cyCurrentColl = (currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_AMOUNT)).add(currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_CESS) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_CURRENT_CESS));
                cyPenaltyColl = (currYrTillDateCollDivisionMap.get(name).get(CY_PENALTY) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_PENALTY)).add(currYrTillDateCollDivisionMap.get(name).get(CY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_LATE_PAYMENT_PENALTY));
                cyRebate = currYrTillDateCollDivisionMap.get(name).get(CY_REBATE) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_REBATE);
                BigDecimal bigDecimal = cyAdvance = currYrTillDateCollDivisionMap.get(name).get(CY_ADVANCE) == null ? BigDecimal.ZERO : currYrTillDateCollDivisionMap.get(name).get(CY_ADVANCE);
            }
            if (!lastYrTillDateCollDivisionMap.isEmpty() && lastYrTillDateCollDivisionMap.get(name) != null) {
                lyArrearColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_CESS) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ARREAR_CESS));
                lyCurrentColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_CESS) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_CURRENT_CESS));
                lyPenaltyColl = (lastYrTillDateCollDivisionMap.get(name).get(LY_PENALTY) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_PENALTY)).add(lastYrTillDateCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY));
                lyRebate = lastYrTillDateCollDivisionMap.get(name).get(LY_REBATE) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_REBATE);
                BigDecimal bigDecimal = lyAdvance = lastYrTillDateCollDivisionMap.get(name).get(LY_ADVANCE) == null ? BigDecimal.ZERO : lastYrTillDateCollDivisionMap.get(name).get(LY_ADVANCE);
            }
            if (!lastFinYrCollDivisionMap.isEmpty() && lastFinYrCollDivisionMap.get(name) != null) {
                lyTotalArrearColl = (lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_AMOUNT)).add(lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_CESS) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ARREAR_CESS));
                lyTotalCurrentColl = (lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_AMOUNT)).add(lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_CESS) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_CURRENT_CESS));
                lyTotalPenaltyColl = (lastFinYrCollDivisionMap.get(name).get(LY_PENALTY) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_PENALTY)).add(lastFinYrCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_LATE_PAYMENT_PENALTY));
                lyTotalRebate = lastFinYrCollDivisionMap.get(name).get(LY_REBATE) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_REBATE);
                BigDecimal bigDecimal = lyTotalAdvance = lastFinYrCollDivisionMap.get(name).get(LY_ADVANCE) == null ? BigDecimal.ZERO : lastFinYrCollDivisionMap.get(name).get(LY_ADVANCE);
            }
            if (!demandDivisionMap.isEmpty() && demandDivisionMap.get(name) != null) {
                arrearDemand = demandDivisionMap.get(name).get(ARREAR_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(ARREAR_DMD);
                currentDemand = demandDivisionMap.get(name).get(CURRENT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(CURRENT_DMD);
                arrearInterestDemand = demandDivisionMap.get(name).get(ARREAR_INT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(ARREAR_INT_DMD);
                currentInterestDemand = demandDivisionMap.get(name).get(CURRENT_INT_DMD) == null ? BigDecimal.ZERO : demandDivisionMap.get(name).get(CURRENT_INT_DMD);
            }
            BigDecimal cytdColl = cytdCollMap.get(name) == null ? BigDecimal.valueOf(0L) : cytdCollMap.get(name);
            this.setBoundaryDateForTable(collectionDetailsRequest, name, collIndData, aggregationField, wardWiseBillCollectors);
            this.setCollAmountsForTableData(collIndData, todayCollMap.get(name) == null ? BigDecimal.ZERO : todayCollMap.get(name), lyTodayCollMap.get(name) == null ? BigDecimal.ZERO : lyTodayCollMap.get(name), cytdColl, lytdCollMap.get(name) == null ? BigDecimal.ZERO : lytdCollMap.get(name), lastFinYrCollMap.get(name) == null ? BigDecimal.ZERO : lastFinYrCollMap.get(name));
            this.setCurrYearTillDateCollBreakUpForTableData(collIndData, cyArrearColl, cyCurrentColl, cyPenaltyColl, cyRebate, cyAdvance);
            this.setLastYearTillDateCollBreakUpForTableData(collIndData, lyArrearColl, lyCurrentColl, lyPenaltyColl, lyRebate, lyAdvance);
            this.setLastFinYearCollBreakUpForTableData(collIndData, lyTotalArrearColl, lyTotalCurrentColl, lyTotalPenaltyColl, lyTotalRebate, lyTotalAdvance);
            this.setDemandBreakUpForTableData(collIndData, arrearDemand, currentDemand, arrearInterestDemand, currentInterestDemand, noOfMonths);
            this.setDemandAmountsForTableData(name, collIndData, totalAssessments, entry.getValue(), noOfMonths, totalDemandMap);
            tableDataMap.put(name, collIndData);
        }
    }

    private void setDemandAmountsForTableData(String name, CollTableData collIndData, BigDecimal totalAssessments, BigDecimal currentYearTotalDemand, int noOfMonths, Map<String, BigDecimal> totalDemandMap) {
        BigDecimal cytdDmd = currentYearTotalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        collIndData.setCytdDmd(cytdDmd);
        if (cytdDmd != BigDecimal.valueOf(0L)) {
            BigDecimal balance = cytdDmd.subtract(collIndData.getCytdColl());
            BigDecimal performance = collIndData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
            collIndData.setPerformance(performance);
            collIndData.setCytdBalDmd(balance);
        }
        collIndData.setTotalDmd(totalDemandMap.get(name) == null ? BigDecimal.ZERO : totalDemandMap.get(name));
        collIndData.setDayTargetDemand(collIndData.getTotalDmd().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : collIndData.getTotalDmd().divide(new BigDecimal("365"), 0, 4));
        collIndData.setTotalAssessments(totalAssessments);
        BigDecimal variance = collIndData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collIndData.getCytdColl().subtract(collIndData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collIndData.getLytdColl(), 1, 4);
        collIndData.setLyVar(variance);
    }

    private void setDemandBreakUpForTableData(CollTableData collIndData, BigDecimal arrearDemand, BigDecimal currentDemand, BigDecimal arrearInterestDemand, BigDecimal currentInterestDemand, int noOfMonths) {
        collIndData.setArrearDemand(arrearDemand);
        collIndData.setCurrentDemand(currentDemand);
        collIndData.setArrearInterestDemand(arrearInterestDemand);
        collIndData.setCurrentInterestDemand(currentInterestDemand);
        BigDecimal proportionalArrearDmd = collIndData.getArrearDemand().divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        BigDecimal proportionalCurrDmd = collIndData.getCurrentDemand().divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        collIndData.setProportionalArrearDemand(proportionalArrearDmd);
        collIndData.setProportionalCurrentDemand(proportionalCurrDmd);
    }

    private void setCurrYearTillDateCollBreakUpForTableData(CollTableData collIndData, BigDecimal arrearColl, BigDecimal currentColl, BigDecimal penaltyColl, BigDecimal rebate, BigDecimal advanceColl) {
        collIndData.setCyArrearColl(arrearColl);
        collIndData.setCyCurrentColl(currentColl);
        collIndData.setCyPenaltyColl(penaltyColl);
        collIndData.setCyRebate(rebate.abs());
        collIndData.setCyAdvanceColl(advanceColl);
    }

    private void setLastYearTillDateCollBreakUpForTableData(CollTableData collIndData, BigDecimal arrearColl, BigDecimal currentColl, BigDecimal penaltyColl, BigDecimal rebate, BigDecimal advanceColl) {
        collIndData.setLyArrearColl(arrearColl);
        collIndData.setLyCurrentColl(currentColl);
        collIndData.setLyPenaltyColl(penaltyColl);
        collIndData.setLyRebate(rebate.abs());
        collIndData.setLyAdvanceColl(advanceColl);
    }

    private void setLastFinYearCollBreakUpForTableData(CollTableData collIndData, BigDecimal lyTotalArrearColl, BigDecimal lyTotalCurrentColl, BigDecimal lyTotalPenaltyColl, BigDecimal lyTotalRebate, BigDecimal lyTotalAdvanceColl) {
        collIndData.setLyTotalArrearsColl(lyTotalArrearColl);
        collIndData.setLyTotalCurrentColl(lyTotalCurrentColl);
        collIndData.setLyTotalPenaltyColl(lyTotalPenaltyColl);
        collIndData.setLyTotalRebate(lyTotalRebate.abs());
        collIndData.setLyTotalAdvanceColl(lyTotalAdvanceColl);
    }

    private void setCollAmountsForTableData(CollTableData collIndData, BigDecimal todayColl, BigDecimal lyTodayColl, BigDecimal cytdColl, BigDecimal lytdColl, BigDecimal lyTotalColl) {
        collIndData.setTodayColl(todayColl);
        collIndData.setLyTodayColl(lyTodayColl);
        collIndData.setCytdColl(cytdColl);
        collIndData.setLytdColl(lytdColl);
        collIndData.setLyTotalColl(lyTotalColl);
    }

    private void setBoundaryDateForTable(CollectionDetailsRequest collectionDetailsRequest, String name, CollTableData collIndData, String aggregationField, Map<String, BillCollectorIndex> wardWiseBillCollectors) {
        if (REGION_NAME.equals(aggregationField)) {
            collIndData.setRegionName(name);
        } else if (DISTRICT_NAME.equals(aggregationField)) {
            collIndData.setRegionName(collectionDetailsRequest.getRegionName());
            collIndData.setDistrictName(name);
        } else if (CITY_NAME.equals(aggregationField)) {
            collIndData.setUlbName(name);
            collIndData.setDistrictName(collectionDetailsRequest.getDistrictName());
            collIndData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
        } else if (CITY_GRADE.equals(aggregationField)) {
            collIndData.setUlbGrade(name);
        } else if (REVENUE_WARD.equals(aggregationField)) {
            collIndData.setWardName(name);
            if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType()) && !wardWiseBillCollectors.isEmpty()) {
                collIndData.setBillCollector(wardWiseBillCollectors.get(name) == null ? "" : wardWiseBillCollectors.get(name).getBillCollector());
                collIndData.setMobileNumber(wardWiseBillCollectors.get(name) == null ? "" : wardWiseBillCollectors.get(name).getMobileNumber());
            }
        }
        collIndData.setBoundaryName(name);
    }

    public String getAggregrationField(CollectionDetailsRequest collectionDetailsRequest) {
        String aggregationField = REGION_NAME;
        if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
            aggregationField = REGION_NAME;
        } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
            aggregationField = DISTRICT_NAME;
        } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
            aggregationField = CITY_NAME;
        } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
            aggregationField = CITY_GRADE;
        } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward") || collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
            aggregationField = REVENUE_WARD;
        }
        return aggregationField;
    }

    public void prepareIndividualDemandsMap(StringTerms individualDmdDetails, Map<String, Map<String, BigDecimal>> demandDivisionMap) {
        if (individualDmdDetails != null) {
            for (Terms.Bucket entry : individualDmdDetails.getBuckets()) {
                HashMap<String, BigDecimal> individualDmdMap = new HashMap<String, BigDecimal>();
                Sum arrearDmd = (Sum)entry.getAggregations().get("arrear_dmd");
                Sum currentDmd = (Sum)entry.getAggregations().get("curr_dmd");
                Sum arrearInterestDmd = (Sum)entry.getAggregations().get("arrear_interest_dmd");
                Sum currentInterestDmd = (Sum)entry.getAggregations().get("curr_interest_dmd");
                individualDmdMap.put(ARREAR_DMD, BigDecimal.valueOf(arrearDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_DMD, BigDecimal.valueOf(currentDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(ARREAR_INT_DMD, BigDecimal.valueOf(arrearInterestDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_INT_DMD, BigDecimal.valueOf(currentInterestDmd.getValue()).setScale(0, 4));
                demandDivisionMap.put(String.valueOf(entry.getKey()), individualDmdMap);
            }
        }
    }

    public void prepareIndividualCollMap(StringTerms collBreakup, Map<String, Map<String, BigDecimal>> collectionDivisionMap, boolean isForCurrYear) {
        if (collBreakup != null) {
            this.prepareCollBreakupMap(collBreakup, collectionDivisionMap, isForCurrYear);
        }
    }

    private void prepareCollBreakupMap(StringTerms collBreakup, Map<String, Map<String, BigDecimal>> collectionDivisionMap, boolean isForCurrYear) {
        String advanceAmtKey;
        String rebateAmtKey;
        String latePaymentPenaltyAmtKey;
        String penaltyAmtKey;
        String currentCessKey;
        String arrearCessKey;
        String currentAmtKey;
        String arrearAmtKey;
        if (isForCurrYear) {
            arrearAmtKey = CY_ARREAR_AMOUNT;
            currentAmtKey = CY_CURRENT_AMOUNT;
            arrearCessKey = CY_ARREAR_CESS;
            currentCessKey = CY_CURRENT_CESS;
            penaltyAmtKey = CY_PENALTY;
            latePaymentPenaltyAmtKey = CY_LATE_PAYMENT_PENALTY;
            rebateAmtKey = CY_REBATE;
            advanceAmtKey = CY_ADVANCE;
        } else {
            arrearAmtKey = LY_ARREAR_AMOUNT;
            currentAmtKey = LY_CURRENT_AMOUNT;
            arrearCessKey = LY_ARREAR_CESS;
            currentCessKey = LY_CURRENT_CESS;
            penaltyAmtKey = LY_PENALTY;
            latePaymentPenaltyAmtKey = LY_LATE_PAYMENT_PENALTY;
            rebateAmtKey = LY_REBATE;
            advanceAmtKey = LY_ADVANCE;
        }
        for (Terms.Bucket entry : collBreakup.getBuckets()) {
            HashMap<String, BigDecimal> individualCollMap = new HashMap<String, BigDecimal>();
            Sum arrearAmt = (Sum)entry.getAggregations().get(ARREAR_AMOUNT_CONST);
            Sum currentAmt = (Sum)entry.getAggregations().get(CURR_AMOUNT);
            Sum arrearCess = (Sum)entry.getAggregations().get(ARREAR_CESS_CONST);
            Sum currentCess = (Sum)entry.getAggregations().get(CURR_CESS);
            Sum penaltyAmt = (Sum)entry.getAggregations().get("penalty");
            Sum latePaymentPenaltyAmt = (Sum)entry.getAggregations().get("latePaymentPenalty");
            Sum rebate = (Sum)entry.getAggregations().get("rebate");
            Sum advance = (Sum)entry.getAggregations().get("advance");
            individualCollMap.put(arrearAmtKey, BigDecimal.valueOf(arrearAmt.getValue()).setScale(0, 4));
            individualCollMap.put(currentAmtKey, BigDecimal.valueOf(currentAmt.getValue()).setScale(0, 4));
            individualCollMap.put(arrearCessKey, BigDecimal.valueOf(arrearCess.getValue()).setScale(0, 4));
            individualCollMap.put(currentCessKey, BigDecimal.valueOf(currentCess.getValue()).setScale(0, 4));
            individualCollMap.put(penaltyAmtKey, BigDecimal.valueOf(penaltyAmt.getValue()).setScale(0, 4));
            individualCollMap.put(latePaymentPenaltyAmtKey, BigDecimal.valueOf(latePaymentPenaltyAmt.getValue()).setScale(0, 4));
            individualCollMap.put(rebateAmtKey, BigDecimal.valueOf(rebate.getValue()).setScale(0, 4));
            individualCollMap.put(advanceAmtKey, BigDecimal.valueOf(advance.getValue()).setScale(0, 4));
            collectionDivisionMap.put(String.valueOf(entry.getKey()), individualCollMap);
        }
    }

    public Map<String, BigDecimal> getCollectionAndDemandValues(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        boolQuery = indexName.equals("receipts") ? boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED)) : boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            Sum aggr = (Sum)entry.getAggregations().get("total");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public StringTerms getIndividualCollections(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        boolQuery = indexName.equals("receipts") ? boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED)) : boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        AggregationBuilder aggregation = ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_AMOUNT_CONST).field(ARREAR_AMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CURR_AMOUNT).field(CURRENT_AMOUNT))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_CESS_CONST).field(ARREAR_CESS))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CURR_CESS).field(CURRENT_CESS))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"penalty").field("penaltyAmount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"latePaymentPenalty").field(LATE_PAYMENT_CHARGES))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"rebate").field("reductionAmount"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"advance").field("advanceAmount"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        return (StringTerms)collAggr.get(BY_CITY);
    }

    public StringTerms getIndividualDemands(CollectionDetailsRequest collectionDetailsRequest, String indexName, String aggregationField, boolean isForMis) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        AggregationBuilder aggregation = isForMis ? ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_dmd").field("arrearDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_dmd").field("annualDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_interest_dmd").field("arrearInterestDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_interest_dmd").field("currentInterestDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total_dmd").field(TOTAL_DEMAND))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"adjustment").field("adjustment"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_coll").field("arrearCollection"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_coll").field("annualCollection"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_interest_coll").field("arrearInterestCollection"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_interest_coll").field("currentInterestCollection"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"advance").field("advance"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"rebate").field("rebate"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total_coll").field("totalCollection")) : ((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_dmd").field("arrearDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_dmd").field("annualDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"arrear_interest_dmd").field("arrearInterestDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"curr_interest_dmd").field("currentInterestDemand"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        return (StringTerms)collAggr.get(BY_CITY);
    }

    public List<CollectionTrend> getMonthwiseCollectionDetails(CollectionDetailsRequest collectionDetailsRequest) {
        CFinancialYear financialYear;
        Date toDate;
        Date fromDate;
        ArrayList<CollectionTrend> collTrendsList = new ArrayList<CollectionTrend>();
        String aggregationField = "";
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList<Map<String, BigDecimal>> yearwiseMonthlyCollList = new ArrayList<Map<String, BigDecimal>>();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            aggregationField = this.getAggregrationField(collectionDetailsRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
            financialYear = this.cFinancialYearService.getFinancialYearByDate(fromDate);
        } else {
            financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate, false, null, aggregationField);
            Histogram dateaggs = (Histogram)collAggr.get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            yearwiseMonthlyCollList.add(monthwiseColl);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = DateUtils.addYears((Date)DateUtils.addDays((Date)finYearEndDate, (int)1), (int)-1);
            }
            finYearStartDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getMonthwiseCollectionsForConsecutiveYears() for 3 consecutive years is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        this.populateCollTrends(collectionDetailsRequest, collTrendsList, yearwiseMonthlyCollList);
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken setting values in getMonthwiseCollectionDetails() is : " + timeTaken + MILLISECS);
        return collTrendsList;
    }

    private void populateCollTrends(CollectionDetailsRequest collectionDetailsRequest, List<CollectionTrend> collTrendsList, List<Map<String, BigDecimal>> yearwiseMonthlyCollList) {
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                CollectionTrend collTrend = new CollectionTrend();
                this.setCollTrends(collTrend, (String)entry.getValue(), yearwiseMonthlyCollList.get(0).get(entry.getValue()) == null ? BigDecimal.ZERO : yearwiseMonthlyCollList.get(0).get(entry.getValue()), yearwiseMonthlyCollList.get(1).get(entry.getValue()) == null ? BigDecimal.ZERO : yearwiseMonthlyCollList.get(1).get(entry.getValue()), yearwiseMonthlyCollList.get(2).get(entry.getValue()) == null ? BigDecimal.ZERO : yearwiseMonthlyCollList.get(2).get(entry.getValue()));
                collTrendsList.add(collTrend);
            }
        } else {
            for (Map.Entry<String, BigDecimal> entry : yearwiseMonthlyCollList.get(0).entrySet()) {
                CollectionTrend collTrend = new CollectionTrend();
                this.setCollTrends(collTrend, entry.getKey(), entry.getValue(), yearwiseMonthlyCollList.get(1).get(entry.getKey()) == null ? BigDecimal.ZERO : yearwiseMonthlyCollList.get(1).get(entry.getKey()), yearwiseMonthlyCollList.get(2).get(entry.getKey()) == null ? BigDecimal.ZERO : yearwiseMonthlyCollList.get(2).get(entry.getKey()));
                collTrendsList.add(collTrend);
            }
        }
    }

    private void setCollTrends(CollectionTrend collTrend, String month, BigDecimal cyColl, BigDecimal lyColl, BigDecimal pyColl) {
        collTrend.setMonth(month);
        collTrend.setCyColl(cyColl);
        collTrend.setLyColl(lyColl);
        collTrend.setPyColl(pyColl);
    }

    private Aggregations getMonthwiseCollectionsForConsecutiveYears(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, boolean isForMISReports, String intervalType, String aggregationField) {
        AggregationBuilder aggregationBuilder;
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (isForMISReports) {
            DateHistogramInterval interval = null;
            if (StringUtils.isNotBlank((CharSequence)intervalType)) {
                if ("month".equalsIgnoreCase(intervalType)) {
                    interval = DateHistogramInterval.MONTH;
                } else if ("week".equalsIgnoreCase(intervalType)) {
                    interval = DateHistogramInterval.WEEK;
                } else if ("day".equalsIgnoreCase(intervalType)) {
                    interval = DateHistogramInterval.DAY;
                }
            }
            aggregationBuilder = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGG).field(RECEIPT_DATE)).interval(interval).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field(TOTAL_AMOUNT)));
        } else {
            aggregationBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGG).field(RECEIPT_DATE)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field(TOTAL_AMOUNT));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    public void getTotalReceiptsCount(CollectionDetailsRequest collectionDetailsRequest, CollReceiptDetails receiptDetails) {
        Date toDate;
        Date fromDate;
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Long receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setTodayRcptsCount(receiptsCount);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setCytdRcptsCount(receiptsCount);
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1));
        receiptDetails.setLytdRcptsCount(receiptsCount);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getTotalReceiptCountsForDates() for all dates is : " + timeTaken + MILLISECS);
    }

    private Long getTotalReceiptCountsForDates(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT).field(CONSUMER_CODE)).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        ValueCount aggr = (ValueCount)collCountAggr.get(RECEIPT_COUNT);
        return aggr.getValue();
    }

    public List<ReceiptsTrend> getMonthwiseReceiptsTrend(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<ReceiptsTrend> rcptTrendsList = new ArrayList<ReceiptsTrend>();
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCountList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, Long> monthwiseCount = new LinkedHashMap<String, Long>();
            Aggregations collAggregation = this.getReceiptsCountForConsecutiveYears(collectionDetailsRequest, fromDate, toDate);
            Histogram dateaggs = (Histogram)collAggregation.get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Long rcptCount = entry.getDocCount();
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || rcptCount <= 0L) continue;
                monthwiseCount.put(monthName, rcptCount);
            }
            yearwiseMonthlyCountList.add(monthwiseCount);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getReceiptsCountForConsecutiveYears() for 3 consecutive years is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                ReceiptsTrend rcptsTrend = new ReceiptsTrend();
                rcptsTrend.setMonth((String)entry.getValue());
                rcptsTrend.setCyRcptsCount(((Map)yearwiseMonthlyCountList.get(0)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(0)).get(rcptsTrend.getMonth()));
                rcptsTrend.setLyRcptsCount(((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()));
                rcptsTrend.setPyRcptsCount(((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCountList.get(0)).entrySet()) {
                ReceiptsTrend rcptsTrend = new ReceiptsTrend();
                rcptsTrend.setMonth((String)entry.getKey());
                rcptsTrend.setCyRcptsCount((Long)entry.getValue());
                rcptsTrend.setLyRcptsCount(((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()));
                rcptsTrend.setPyRcptsCount(((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken foro setting values in getMonthwiseReceiptsTrend() is : " + timeTaken + MILLISECS);
        return rcptTrendsList;
    }

    private Aggregations getReceiptsCountForConsecutiveYears(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGG).field(RECEIPT_DATE)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT).field("receiptNumber"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false))).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        return collCountAggr;
    }

    public List<ReceiptTableData> getReceiptTableData(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<ReceiptTableData> receiptDataList = new ArrayList<ReceiptTableData>();
        BigDecimal variance = BigDecimal.ZERO;
        String aggregationField = REGION_NAME;
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = REGION_NAME;
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = DISTRICT_NAME;
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = CITY_NAME;
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = CITY_GRADE;
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = REVENUE_WARD;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> currDayCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", CONSUMER_CODE, aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", CONSUMER_CODE, aggregationField);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", CONSUMER_CODE, aggregationField);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionAndDemandCountResults() is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            ReceiptTableData receiptData = new ReceiptTableData();
            String name = entry.getKey();
            if (aggregationField.equals(REGION_NAME)) {
                receiptData.setRegionName(name);
            } else if (aggregationField.equals(DISTRICT_NAME)) {
                receiptData.setRegionName(collectionDetailsRequest.getRegionName());
                receiptData.setDistrictName(name);
            } else if (aggregationField.equals(CITY_NAME)) {
                receiptData.setUlbName(name);
                receiptData.setDistrictName(collectionDetailsRequest.getDistrictName());
                receiptData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            } else if (aggregationField.equals(CITY_GRADE)) {
                receiptData.setUlbGrade(name);
            } else if (aggregationField.equals(REVENUE_WARD)) {
                receiptData.setWardName(name);
            }
            receiptData.setCytdColl(entry.getValue());
            receiptData.setCurrDayColl(currDayCollMap.get(name) == null ? BigDecimal.valueOf(0L) : currDayCollMap.get(name));
            receiptData.setLytdColl(lytdCollMap.get(name) == null ? BigDecimal.valueOf(0L) : lytdCollMap.get(name));
            variance = receiptData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : receiptData.getCytdColl().subtract(receiptData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(receiptData.getLytdColl(), 1, 4);
            receiptData.setLyVar(variance);
            receiptDataList.add(receiptData);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getReceiptTableData() is : " + timeTaken + MILLISECS);
        return receiptDataList;
    }

    public Map<String, BigDecimal> getCollectionAndDemandCountResults(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        } else if (indexName.equals("propertytax")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        }
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"total_count").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            ValueCount aggr = (ValueCount)entry.getAggregations().get("total_count");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public List<CollTableData> getResponseTableDataForBillCollector(CollectionDetailsRequest collectionDetailsRequest) {
        HashMap<String, CollTableData> wardReceiptDetails = new HashMap<String, CollTableData>();
        LinkedHashMap billCollectorWiseMap = new LinkedHashMap();
        ArrayList collDetails = new ArrayList();
        ArrayList<CollTableData> billCollectorWiseTableData = new ArrayList<CollTableData>();
        List<CollTableData> wardWiseData = this.getResponseTableData(collectionDetailsRequest, false);
        for (CollTableData tableData : wardWiseData) {
            wardReceiptDetails.put(tableData.getWardName(), tableData);
        }
        List<BillCollectorIndex> billCollectorsList = this.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollectorIndex : billCollectorsList) {
            if (wardReceiptDetails.get(billCollectorIndex.getRevenueWard()) == null || !StringUtils.isNotBlank((CharSequence)billCollectorIndex.getRevenueWard())) continue;
            String billCollectorNameNumber = billCollectorIndex.getBillCollector().concat("~").concat(StringUtils.isBlank((CharSequence)billCollectorIndex.getMobileNumber()) ? "" : billCollectorIndex.getMobileNumber());
            if (billCollectorWiseMap.isEmpty()) {
                collDetails.add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, collDetails);
                continue;
            }
            if (!billCollectorWiseMap.containsKey(billCollectorNameNumber)) {
                collDetails = new ArrayList();
                collDetails.add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, collDetails);
                continue;
            }
            ((List)billCollectorWiseMap.get(billCollectorNameNumber)).add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
        }
        for (Map.Entry entry : billCollectorWiseMap.entrySet()) {
            CollTableData collTableData = new CollTableData();
            this.setTableValuesForBillCollector(collTableData, entry);
            billCollectorWiseTableData.add(collTableData);
        }
        return billCollectorWiseTableData;
    }

    private void setTableValuesForBillCollector(CollTableData collTableData, Map.Entry<String, List<CollTableData>> entry) {
        BigDecimal currDayColl = BigDecimal.ZERO;
        BigDecimal cytdColl = BigDecimal.ZERO;
        BigDecimal lytdColl = BigDecimal.ZERO;
        BigDecimal cytdDmd = BigDecimal.ZERO;
        BigDecimal totalDmd = BigDecimal.ZERO;
        BigDecimal cyArrearColl = BigDecimal.ZERO;
        BigDecimal cyCurrentColl = BigDecimal.ZERO;
        BigDecimal cyPenaltyColl = BigDecimal.ZERO;
        BigDecimal cyRebate = BigDecimal.ZERO;
        BigDecimal cyAdvance = BigDecimal.ZERO;
        BigDecimal lyArrearColl = BigDecimal.ZERO;
        BigDecimal lyCurrentColl = BigDecimal.ZERO;
        BigDecimal lyPenaltyColl = BigDecimal.ZERO;
        BigDecimal lyRebate = BigDecimal.ZERO;
        BigDecimal lyAdvance = BigDecimal.ZERO;
        BigDecimal arrearDmd = BigDecimal.ZERO;
        BigDecimal currentDmd = BigDecimal.ZERO;
        BigDecimal proportionalArrearDmd = BigDecimal.ZERO;
        BigDecimal proportionalCurrentDmd = BigDecimal.ZERO;
        BigDecimal dayTargetDmd = BigDecimal.ZERO;
        BigDecimal lyTodayColl = BigDecimal.ZERO;
        BigDecimal totalAssessments = BigDecimal.ZERO;
        BigDecimal arrearInterestDemand = BigDecimal.ZERO;
        BigDecimal currentInterestDemand = BigDecimal.ZERO;
        BigDecimal lyTotalArrearColl = BigDecimal.ZERO;
        BigDecimal lyTotalCurrentColl = BigDecimal.ZERO;
        BigDecimal lyTotalPenaltyColl = BigDecimal.ZERO;
        BigDecimal lyTotalRebate = BigDecimal.ZERO;
        BigDecimal lyTotalAdvance = BigDecimal.ZERO;
        BigDecimal lyTotalColl = BigDecimal.ZERO;
        String[] billCollectorNameNumberArr = entry.getKey().split("~");
        for (CollTableData tableData : entry.getValue()) {
            currDayColl = currDayColl.add(tableData.getTodayColl() == null ? BigDecimal.ZERO : tableData.getTodayColl());
            cytdColl = cytdColl.add(tableData.getCytdColl() == null ? BigDecimal.ZERO : tableData.getCytdColl());
            cytdDmd = cytdDmd.add(tableData.getCytdDmd() == null ? BigDecimal.ZERO : tableData.getCytdDmd());
            totalDmd = totalDmd.add(tableData.getTotalDmd() == null ? BigDecimal.ZERO : tableData.getTotalDmd());
            lytdColl = lytdColl.add(tableData.getLytdColl() == null ? BigDecimal.ZERO : tableData.getLytdColl());
            lyTotalColl = lyTotalColl.add(tableData.getLyTotalColl() == null ? BigDecimal.ZERO : tableData.getLyTotalColl());
            cyArrearColl = cyArrearColl.add(tableData.getCyArrearColl() == null ? BigDecimal.ZERO : tableData.getCyArrearColl());
            cyCurrentColl = cyCurrentColl.add(tableData.getCyCurrentColl() == null ? BigDecimal.ZERO : tableData.getCyCurrentColl());
            cyPenaltyColl = cyPenaltyColl.add(tableData.getCyPenaltyColl() == null ? BigDecimal.ZERO : tableData.getCyPenaltyColl());
            cyRebate = cyRebate.add(tableData.getCyRebate() == null ? BigDecimal.ZERO : tableData.getCyRebate());
            cyAdvance = cyAdvance.add(tableData.getCyAdvanceColl() == null ? BigDecimal.ZERO : tableData.getCyAdvanceColl());
            lyArrearColl = lyArrearColl.add(tableData.getLyArrearColl() == null ? BigDecimal.ZERO : tableData.getLyArrearColl());
            lyCurrentColl = lyCurrentColl.add(tableData.getLyCurrentColl() == null ? BigDecimal.ZERO : tableData.getLyCurrentColl());
            lyPenaltyColl = lyPenaltyColl.add(tableData.getLyPenaltyColl() == null ? BigDecimal.ZERO : tableData.getLyPenaltyColl());
            lyRebate = lyRebate.add(tableData.getLyRebate() == null ? BigDecimal.ZERO : tableData.getLyRebate());
            lyAdvance = lyAdvance.add(tableData.getLyAdvanceColl() == null ? BigDecimal.ZERO : tableData.getLyAdvanceColl());
            lyTotalArrearColl = lyTotalArrearColl.add(tableData.getLyTotalArrearsColl() == null ? BigDecimal.ZERO : tableData.getLyTotalArrearsColl());
            lyTotalCurrentColl = lyTotalCurrentColl.add(tableData.getLyTotalCurrentColl() == null ? BigDecimal.ZERO : tableData.getLyTotalCurrentColl());
            lyTotalPenaltyColl = lyTotalPenaltyColl.add(tableData.getLyTotalPenaltyColl() == null ? BigDecimal.ZERO : tableData.getLyTotalPenaltyColl());
            lyTotalRebate = lyTotalRebate.add(tableData.getLyTotalRebate() == null ? BigDecimal.ZERO : tableData.getLyTotalRebate());
            lyTotalAdvance = lyTotalAdvance.add(tableData.getLyTotalAdvanceColl() == null ? BigDecimal.ZERO : tableData.getLyTotalAdvanceColl());
            arrearDmd = arrearDmd.add(tableData.getArrearDemand() == null ? BigDecimal.ZERO : tableData.getArrearDemand());
            currentDmd = currentDmd.add(tableData.getCurrentDemand() == null ? BigDecimal.ZERO : tableData.getCurrentDemand());
            proportionalArrearDmd = proportionalArrearDmd.add(tableData.getProportionalArrearDemand() == null ? BigDecimal.ZERO : tableData.getProportionalArrearDemand());
            proportionalCurrentDmd = proportionalCurrentDmd.add(tableData.getProportionalCurrentDemand() == null ? BigDecimal.ZERO : tableData.getProportionalCurrentDemand());
            dayTargetDmd = dayTargetDmd.add(tableData.getDayTargetDemand() == null ? BigDecimal.ZERO : tableData.getDayTargetDemand());
            lyTodayColl = lyTodayColl.add(tableData.getLyTodayColl() == null ? BigDecimal.ZERO : tableData.getLyTodayColl());
            totalAssessments = totalAssessments.add(tableData.getTotalAssessments());
            arrearInterestDemand = arrearInterestDemand.add(tableData.getArrearInterestDemand() == null ? BigDecimal.ZERO : tableData.getArrearInterestDemand());
            currentInterestDemand = currentInterestDemand.add(tableData.getCurrentInterestDemand() == null ? BigDecimal.ZERO : tableData.getCurrentInterestDemand());
        }
        collTableData.setBillCollector(billCollectorNameNumberArr[0]);
        collTableData.setMobileNumber(billCollectorNameNumberArr.length > 1 ? billCollectorNameNumberArr[1] : "");
        collTableData.setTodayColl(currDayColl);
        collTableData.setCytdColl(cytdColl);
        collTableData.setCytdDmd(cytdDmd);
        collTableData.setCytdBalDmd(cytdDmd.subtract(cytdColl));
        collTableData.setTotalDmd(totalDmd);
        collTableData.setLytdColl(lytdColl);
        this.setCurrYearTillDateCollBreakUpForTableData(collTableData, cyArrearColl, cyCurrentColl, cyPenaltyColl, cyRebate, cyAdvance);
        this.setLastYearTillDateCollBreakUpForTableData(collTableData, lyArrearColl, lyCurrentColl, lyPenaltyColl, lyRebate, lyAdvance);
        this.setLastFinYearCollBreakUpForTableData(collTableData, lyTotalArrearColl, lyTotalCurrentColl, lyTotalPenaltyColl, lyTotalRebate, lyTotalAdvance);
        collTableData.setArrearDemand(arrearDmd);
        collTableData.setCurrentDemand(currentDmd);
        collTableData.setProportionalArrearDemand(proportionalArrearDmd);
        collTableData.setProportionalCurrentDemand(proportionalCurrentDmd);
        collTableData.setDayTargetDemand(dayTargetDmd);
        collTableData.setLyTodayColl(lyTodayColl);
        collTableData.setArrearInterestDemand(arrearInterestDemand);
        collTableData.setCurrentInterestDemand(currentInterestDemand);
        collTableData.setTotalAssessments(totalAssessments);
        if (cytdDmd != BigDecimal.valueOf(0L)) {
            BigDecimal performance = collTableData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
            collTableData.setPerformance(performance);
        }
        BigDecimal variance = collTableData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collTableData.getCytdColl().subtract(collTableData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collTableData.getLytdColl(), 1, 4);
        collTableData.setLyVar(variance);
    }

    public List<BillCollectorIndex> getBillCollectorDetails(CollectionDetailsRequest collectionDetailsRequest) {
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"billcollector"}).withFields(new String[]{"billCollector", "mobileNumber", REVENUE_WARD}).withQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)collectionDetailsRequest.getUlbCode()))).withSort((SortBuilder)new FieldSortBuilder("billCollector").order(SortOrder.ASC)).withPageable((Pageable)new PageRequest(0, 250)).build();
        List billCollectorsList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQueryColl, BillCollectorIndex.class);
        return billCollectorsList;
    }

    public Map<String, BillCollectorIndex> getWardWiseBillCollectors(CollectionDetailsRequest collectionDetailsRequest) {
        HashMap<String, BillCollectorIndex> wardWiseBillCollectors = new HashMap<String, BillCollectorIndex>();
        List<BillCollectorIndex> billCollectors = this.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollector : billCollectors) {
            wardWiseBillCollectors.put(billCollector.getRevenueWard(), billCollector);
        }
        return wardWiseBillCollectors;
    }

    public Long getTotalAssessmentsCount(CollectionDetailsRequest collectionDetailsRequest, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "propertytax").filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"assessment_count").field(CONSUMER_CODE)).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        ValueCount aggr = (ValueCount)collCountAggr.get("assessment_count");
        return aggr.getValue();
    }

    public CollectionAnalysis getCollectionsForInterval(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        Date fromDate = null;
        Date toDate = null;
        String aggregationField = "";
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            aggregationField = this.getAggregrationField(collectionDetailsRequest);
        }
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        HashMap<String, Map<String, BigDecimal>> intervalwiseCollMap = new HashMap<String, Map<String, BigDecimal>>();
        CollectionAnalysis collectionAnalysis = new CollectionAnalysis();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        }
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(fromDate);
        Long startTime = System.currentTimeMillis();
        Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate, true, intervalType, aggregationField);
        StringTerms cityaggr = (StringTerms)collAggr.get(BY_CITY);
        if ("month".equalsIgnoreCase(intervalType)) {
            this.prepareMonthlyCollMap(financialYear.getStartingDate(), financialYear.getEndingDate(), monthValuesMap, intervalwiseCollMap, cityaggr);
            this.setCollectionsForMonths(intervalwiseCollMap, collectionAnalysis);
        } else if ("week".equalsIgnoreCase(intervalType)) {
            this.prepareWeeklyCollMap(intervalwiseCollMap, cityaggr);
            this.setCollectionsForWeeks(intervalwiseCollMap, collectionAnalysis);
        } else if ("day".equalsIgnoreCase(intervalType)) {
            this.prepareDailyCollMap(intervalwiseCollMap, cityaggr, fromDate);
            this.setCollectionsForDays(intervalwiseCollMap, collectionAnalysis);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken setting values in getCollectionsForInterval() is : " + timeTaken + MILLISECS);
        }
        return collectionAnalysis;
    }

    private void prepareMonthlyCollMap(Date finYearStartDate, Date finYearEndDate, Map<Integer, String> monthValuesMap, Map<String, Map<String, BigDecimal>> yearwiseMonthlyCollMap, StringTerms cityaggr) {
        for (Terms.Bucket cityDetailsentry : cityaggr.getBuckets()) {
            String ulbName = cityDetailsentry.getKeyAsString();
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Histogram dateaggs = (Histogram)cityDetailsentry.getAggregations().get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = monthValuesMap.get(month);
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            yearwiseMonthlyCollMap.put(ulbName, monthwiseColl);
        }
    }

    private void prepareWeeklyCollMap(Map<String, Map<String, BigDecimal>> intervalwiseCollMap, StringTerms cityaggr) {
        for (Terms.Bucket cityDetailsentry : cityaggr.getBuckets()) {
            LinkedHashMap<String, BigDecimal> weekwiseColl = new LinkedHashMap<String, BigDecimal>();
            String ulbName = cityDetailsentry.getKeyAsString();
            int noOfWeeks = 0;
            Histogram dateaggs = (Histogram)cityDetailsentry.getAggregations().get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                if (noOfWeeks == 0) {
                    noOfWeeks = 1;
                }
                String weekName = "Week " + noOfWeeks;
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) > 0) {
                    weekwiseColl.put(weekName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
                }
                ++noOfWeeks;
            }
            intervalwiseCollMap.put(ulbName, weekwiseColl);
        }
    }

    private void prepareDailyCollMap(Map<String, Map<String, BigDecimal>> intervalwiseCollMap, StringTerms cityaggr, Date fromDate) {
        ArrayList<String> daysInWeek = new ArrayList<String>();
        Date weekStartDate = fromDate;
        for (int count = 0; count < 7; ++count) {
            daysInWeek.add(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(weekStartDate));
            weekStartDate = DateUtils.addDays((Date)weekStartDate, (int)1);
        }
        for (Terms.Bucket cityDetailsentry : cityaggr.getBuckets()) {
            LinkedHashMap<String, BigDecimal> dayWiseCollFromResult = new LinkedHashMap<String, BigDecimal>();
            LinkedHashMap<String, BigDecimal> finalDayWiseColl = new LinkedHashMap<String, BigDecimal>();
            String ulbName = cityDetailsentry.getKeyAsString();
            int noOfDays = 0;
            Histogram dateaggs = (Histogram)cityDetailsentry.getAggregations().get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String resultDateStr = entry.getKeyAsString().split("T")[0];
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                dayWiseCollFromResult.put(resultDateStr, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            for (String dates : daysInWeek) {
                if (noOfDays == 0) {
                    noOfDays = 1;
                }
                String day = "Day " + noOfDays;
                if (dayWiseCollFromResult.get(dates) == null) {
                    finalDayWiseColl.put(day, BigDecimal.ZERO);
                } else {
                    finalDayWiseColl.put(day, (BigDecimal)dayWiseCollFromResult.get(dates));
                }
                ++noOfDays;
            }
            intervalwiseCollMap.put(ulbName, finalDayWiseColl);
        }
    }

    public List<WeeklyDCB> getWeekwiseDCBDetailsAcrossCities(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        ArrayList<WeeklyDCB> ulbWiseDetails = new ArrayList<WeeklyDCB>();
        Date fromDate = null;
        Date toDate = null;
        String aggregationField = "";
        LinkedHashMap<String, Map<String, Object[]>> weeklyCollMap = new LinkedHashMap<String, Map<String, Object[]>>();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            aggregationField = this.getAggregrationField(collectionDetailsRequest);
        }
        Map<String, BigDecimal> totalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", TOTAL_DEMAND, aggregationField);
        Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate, true, intervalType, aggregationField);
        StringTerms cityaggr = (StringTerms)collAggr.get(BY_CITY);
        for (Terms.Bucket cityDetailsentry : cityaggr.getBuckets()) {
            LinkedHashMap<String, Object[]> weekwiseColl = new LinkedHashMap<String, Object[]>();
            String ulbName = cityDetailsentry.getKeyAsString();
            int noOfWeeks = 0;
            BigDecimal totalDemand = totalDemandMap.get(ulbName) == null ? BigDecimal.ZERO : totalDemandMap.get(ulbName);
            Histogram dateaggs = (Histogram)cityDetailsentry.getAggregations().get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                if (noOfWeeks == 0) {
                    noOfWeeks = 1;
                }
                Object[] demandCollValues = new Object[53];
                BigDecimal weeklyDemand = totalDemand.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalDemand.divide(BigDecimal.valueOf(52L), 4).multiply(BigDecimal.valueOf(noOfWeeks));
                String weekName = "Week " + noOfWeeks;
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) > 0) {
                    demandCollValues[0] = BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4);
                    demandCollValues[1] = weeklyDemand;
                    weekwiseColl.put(weekName, demandCollValues);
                }
                ++noOfWeeks;
            }
            weeklyCollMap.put(ulbName, weekwiseColl);
        }
        this.setWeeklyDCBValues(ulbWiseDetails, weeklyCollMap);
        return ulbWiseDetails;
    }

    private void setWeeklyDCBValues(List<WeeklyDCB> ulbWiseDetails, Map<String, Map<String, Object[]>> weeklyCollMap) {
        for (Map.Entry<String, Map<String, Object[]>> entry : weeklyCollMap.entrySet()) {
            WeeklyDCB weeklyDCB = new WeeklyDCB();
            int count = 1;
            weeklyDCB.setBoundaryName(entry.getKey());
            for (Map.Entry<String, Object[]> weeklyMap : entry.getValue().entrySet()) {
                DemandCollectionMIS demandCollectionMIS = new DemandCollectionMIS();
                demandCollectionMIS.setCollection(new BigDecimal(weeklyMap.getValue()[0].toString()));
                demandCollectionMIS.setDemand(new BigDecimal(weeklyMap.getValue()[1].toString()));
                if (demandCollectionMIS.getDemand().compareTo(BigDecimal.ZERO) > 0) {
                    demandCollectionMIS.setPercent(demandCollectionMIS.getCollection().divide(demandCollectionMIS.getDemand(), 2, RoundingMode.CEILING).multiply(PropertyTaxConstants.BIGDECIMAL_100));
                }
                if (count == 1) {
                    weeklyDCB.setWeek1DCB(demandCollectionMIS);
                } else if (count == 2) {
                    weeklyDCB.setWeek2DCB(demandCollectionMIS);
                } else if (count == 3) {
                    weeklyDCB.setWeek3DCB(demandCollectionMIS);
                } else if (count == 4) {
                    weeklyDCB.setWeek4DCB(demandCollectionMIS);
                } else if (count == 5) {
                    weeklyDCB.setWeek5DCB(demandCollectionMIS);
                }
                ++count;
            }
            ulbWiseDetails.add(weeklyDCB);
        }
    }

    public List<MonthlyDCB> getMonthwiseDCBDetailsAcrossCities(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        ArrayList<MonthlyDCB> ulbWiseDetails = new ArrayList<MonthlyDCB>();
        Date fromDate = null;
        Date toDate = null;
        String aggregationField = "";
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            aggregationField = this.getAggregrationField(collectionDetailsRequest);
        }
        HashMap<String, Map<String, Object[]>> ulbwiseMonthlyCollMap = new HashMap<String, Map<String, Object[]>>();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        }
        Map<String, BigDecimal> totalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", TOTAL_DEMAND, aggregationField);
        Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate, true, intervalType, aggregationField);
        StringTerms cityaggr = (StringTerms)collAggr.get(BY_CITY);
        for (Terms.Bucket cityDetailsentry : cityaggr.getBuckets()) {
            LinkedHashMap<String, Object[]> monthwiseColl = new LinkedHashMap<String, Object[]>();
            String ulbName = cityDetailsentry.getKeyAsString();
            int noOfMonths = 0;
            BigDecimal totalDemand = totalDemandMap.get(ulbName);
            if (totalDemand == null) {
                totalDemand = BigDecimal.ZERO;
            }
            Histogram dateaggs = (Histogram)cityDetailsentry.getAggregations().get(DATE_AGG);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                if (noOfMonths == 0) {
                    noOfMonths = 1;
                }
                Object[] demandCollValues = new Object[12];
                String[] dateArr = entry.getKeyAsString().split("T");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                BigDecimal monthlyDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) > 0) {
                    demandCollValues[0] = BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4);
                    demandCollValues[1] = monthlyDemand;
                    monthwiseColl.put(monthName, demandCollValues);
                }
                ++noOfMonths;
            }
            ulbwiseMonthlyCollMap.put(ulbName, monthwiseColl);
        }
        this.setMonthlyDCBValues(ulbWiseDetails, ulbwiseMonthlyCollMap);
        return ulbWiseDetails;
    }

    private void setMonthlyDCBValues(List<MonthlyDCB> ulbWiseDetails, Map<String, Map<String, Object[]>> yearwiseMonthlyCollMap) {
        for (Map.Entry<String, Map<String, Object[]>> entry : yearwiseMonthlyCollMap.entrySet()) {
            MonthlyDCB monthlyDCB = new MonthlyDCB();
            monthlyDCB.setBoundaryName(entry.getKey());
            for (Map.Entry<String, Object[]> monthMap : entry.getValue().entrySet()) {
                DemandCollectionMIS demandCollectionMIS = new DemandCollectionMIS();
                String month = monthMap.getKey();
                demandCollectionMIS.setCollection(new BigDecimal(monthMap.getValue()[0].toString()));
                demandCollectionMIS.setDemand(new BigDecimal(monthMap.getValue()[1].toString()));
                if (demandCollectionMIS.getDemand().compareTo(BigDecimal.ZERO) > 0) {
                    demandCollectionMIS.setPercent(demandCollectionMIS.getCollection().divide(demandCollectionMIS.getDemand(), 2, RoundingMode.CEILING).multiply(PropertyTaxConstants.BIGDECIMAL_100));
                }
                this.setDCBForMonth(monthlyDCB, demandCollectionMIS, month);
            }
            ulbWiseDetails.add(monthlyDCB);
        }
    }

    private void setCollectionsForMonths(Map<String, Map<String, BigDecimal>> collectionMap, CollectionAnalysis collectionAnalysis) {
        ArrayList<MonthlyDCB> monthlyCollDetails = new ArrayList<MonthlyDCB>();
        for (Map.Entry<String, Map<String, BigDecimal>> entry : collectionMap.entrySet()) {
            MonthlyDCB monthlyDCB = new MonthlyDCB();
            monthlyDCB.setBoundaryName(entry.getKey());
            for (Map.Entry<String, BigDecimal> monthMap : entry.getValue().entrySet()) {
                DemandCollectionMIS demandCollectionMIS = new DemandCollectionMIS();
                String month = monthMap.getKey();
                demandCollectionMIS.setCollection(monthMap.getValue());
                this.setDCBForMonth(monthlyDCB, demandCollectionMIS, month);
            }
            monthlyCollDetails.add(monthlyDCB);
        }
        collectionAnalysis.setMonthlyDCBDetails(monthlyCollDetails);
    }

    private void setCollectionsForWeeks(Map<String, Map<String, BigDecimal>> collectionMap, CollectionAnalysis collectionAnalysis) {
        ArrayList<WeeklyDCB> weeklyCollDetails = new ArrayList<WeeklyDCB>();
        for (Map.Entry<String, Map<String, BigDecimal>> citywise : collectionMap.entrySet()) {
            WeeklyDCB weeklyDCB = new WeeklyDCB();
            int intervalCount = 1;
            weeklyDCB.setBoundaryName(citywise.getKey());
            for (Map.Entry<String, BigDecimal> weeklyMap : citywise.getValue().entrySet()) {
                DemandCollectionMIS demandCollectionMIS = new DemandCollectionMIS();
                demandCollectionMIS.setCollection(weeklyMap.getValue());
                demandCollectionMIS.setIntervalCount(intervalCount);
                if (intervalCount == 1) {
                    weeklyDCB.setWeek1DCB(demandCollectionMIS);
                } else if (intervalCount == 2) {
                    weeklyDCB.setWeek2DCB(demandCollectionMIS);
                } else if (intervalCount == 3) {
                    weeklyDCB.setWeek3DCB(demandCollectionMIS);
                } else if (intervalCount == 4) {
                    weeklyDCB.setWeek4DCB(demandCollectionMIS);
                } else if (intervalCount == 5) {
                    weeklyDCB.setWeek5DCB(demandCollectionMIS);
                }
                ++intervalCount;
            }
            weeklyCollDetails.add(weeklyDCB);
        }
        collectionAnalysis.setWeeklyDCBDetails(weeklyCollDetails);
    }

    private void setCollectionsForDays(Map<String, Map<String, BigDecimal>> collectionMap, CollectionAnalysis collectionAnalysis) {
        ArrayList<DayWiseCollection> dailyCollDetails = new ArrayList<DayWiseCollection>();
        for (Map.Entry<String, Map<String, BigDecimal>> citywise : collectionMap.entrySet()) {
            DayWiseCollection dayWiseCollection = new DayWiseCollection();
            int intervalCount = 1;
            dayWiseCollection.setBoundaryName(citywise.getKey());
            for (Map.Entry<String, BigDecimal> weeklyMap : citywise.getValue().entrySet()) {
                DemandCollectionMIS demandCollectionMIS = new DemandCollectionMIS();
                demandCollectionMIS.setCollection(weeklyMap.getValue());
                demandCollectionMIS.setIntervalCount(intervalCount);
                if (intervalCount == 1) {
                    dayWiseCollection.setDay1DCB(demandCollectionMIS);
                } else if (intervalCount == 2) {
                    dayWiseCollection.setDay2DCB(demandCollectionMIS);
                } else if (intervalCount == 3) {
                    dayWiseCollection.setDay3DCB(demandCollectionMIS);
                } else if (intervalCount == 4) {
                    dayWiseCollection.setDay4DCB(demandCollectionMIS);
                } else if (intervalCount == 5) {
                    dayWiseCollection.setDay5DCB(demandCollectionMIS);
                } else if (intervalCount == 6) {
                    dayWiseCollection.setDay6DCB(demandCollectionMIS);
                } else if (intervalCount == 7) {
                    dayWiseCollection.setDay7DCB(demandCollectionMIS);
                }
                ++intervalCount;
            }
            dailyCollDetails.add(dayWiseCollection);
        }
        collectionAnalysis.setDailyCollDetails(dailyCollDetails);
    }

    private void setDCBForMonth(MonthlyDCB monthlyDCB, DemandCollectionMIS demandCollectionMIS, String month) {
        switch (month) {
            case "April": {
                monthlyDCB.setAprilDCB(demandCollectionMIS);
                break;
            }
            case "May": {
                monthlyDCB.setMayDCB(demandCollectionMIS);
                break;
            }
            case "June": {
                monthlyDCB.setJuneDCB(demandCollectionMIS);
                break;
            }
            case "July": {
                monthlyDCB.setJulyDCB(demandCollectionMIS);
                break;
            }
            case "August": {
                monthlyDCB.setAugustDCB(demandCollectionMIS);
                break;
            }
            case "September": {
                monthlyDCB.setSeptemberDCB(demandCollectionMIS);
                break;
            }
            case "October": {
                monthlyDCB.setOctoberDCB(demandCollectionMIS);
                break;
            }
            case "November": {
                monthlyDCB.setNovemberDCB(demandCollectionMIS);
                break;
            }
            case "December": {
                monthlyDCB.setDecemberDCB(demandCollectionMIS);
                break;
            }
            case "January": {
                monthlyDCB.setJanuaryDCB(demandCollectionMIS);
                break;
            }
            case "Feburary": {
                monthlyDCB.setFebruaryDCB(demandCollectionMIS);
                break;
            }
            case "March": {
                monthlyDCB.setMarchDCB(demandCollectionMIS);
                break;
            }
        }
    }

    public List<CollTableData> getWardWiseTableDataAcrossCities(CollectionDetailsRequest collectionDetailsRequest, Iterable<CityIndex> cities) {
        ArrayList<CollTableData> citywiseTableData = new ArrayList<CollTableData>();
        for (CityIndex city : cities) {
            String cityName = city.getName();
            collectionDetailsRequest.setUlbCode(city.getCitycode());
            collectionDetailsRequest.setType("ward");
            List<CollTableData> wardWiseData = this.getResponseTableData(collectionDetailsRequest, false);
            for (CollTableData wardData : wardWiseData) {
                wardData.setUlbName(cityName);
            }
            citywiseTableData.addAll(wardWiseData);
        }
        return citywiseTableData;
    }

    public List<String> getCityDetails(CollectionDetailsRequest collectionDetailsRequest, String aggregationField) {
        ArrayList<String> nameList = new ArrayList<String>();
        String fieldName = "";
        int size = 0;
        if (REGION_NAME.equalsIgnoreCase(aggregationField)) {
            fieldName = "regionname";
            size = 4;
        } else if (DISTRICT_NAME.equalsIgnoreCase(aggregationField)) {
            fieldName = "districtname";
            size = 13;
        } else if (CITY_NAME.equalsIgnoreCase(aggregationField)) {
            fieldName = "name";
            size = 112;
        } else if (CITY_GRADE.equalsIgnoreCase(aggregationField)) {
            fieldName = "citygrade";
            size = 7;
        }
        if (!REVENUE_WARD.equalsIgnoreCase(aggregationField)) {
            BoolQueryBuilder boolQuery = this.prepareQueryForAgg(collectionDetailsRequest);
            TermsBuilder agg = ((TermsBuilder)AggregationBuilders.terms((String)"uniqueAggr").field(fieldName)).size(size);
            SearchResponse cityResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"city"}).setQuery((QueryBuilder)boolQuery).setSize(size).addAggregation((AbstractAggregationBuilder)agg).execute().actionGet();
            Terms aggTerms = (Terms)cityResponse.getAggregations().get("uniqueAggr");
            for (Terms.Bucket bucket : aggTerms.getBuckets()) {
                nameList.add(bucket.getKeyAsString());
            }
        } else {
            List<BillCollectorIndex> billCollectors = this.getBillCollectorDetails(collectionDetailsRequest);
            for (BillCollectorIndex billCollector : billCollectors) {
                nameList.add(billCollector.getRevenueWard());
            }
        }
        return nameList;
    }

    private BoolQueryBuilder prepareQueryForAgg(CollectionDetailsRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = new BoolQueryBuilder();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtname", (Object)collectionDetailsRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionname", (Object)collectionDetailsRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"citygrade", (Object)collectionDetailsRequest.getUlbGrade()));
        }
        return boolQuery;
    }
}

