/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.repository.master.structureclassification.StructureClassificationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StructureClassificationService {
    private final StructureClassificationRepository structureClassificationRepository;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;

    @Autowired
    public StructureClassificationService(StructureClassificationRepository structureClassificationRepository) {
        this.structureClassificationRepository = structureClassificationRepository;
    }

    @Transactional
    public StructureClassification create(StructureClassification structureClassification) {
        this.structureClassificationRepository.save((Object)structureClassification);
        return structureClassification;
    }

    public Installment getInstallment() {
        Module module = this.moduleService.getModuleByName("Property Tax");
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        return installment;
    }

    public List<StructureClassification> getAllActiveStructureTypes() {
        return this.structureClassificationRepository.findByIsActiveTrueOrderByTypeName();
    }
}

