/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.repository.master.rooftype.RoofTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RoofTypeService {
    private final RoofTypeRepository roofTypeRepository;
    @Autowired
    private UserService userService;

    @Autowired
    public RoofTypeService(RoofTypeRepository roofTypeRepository) {
        this.roofTypeRepository = roofTypeRepository;
    }

    @Transactional
    public void createRoof(RoofType rooftype) {
        this.roofTypeRepository.save((Object)rooftype);
    }

    public RoofType getRoofTypeByName(String name) {
        return this.roofTypeRepository.findByName(name);
    }

    public RoofType getRoofTypeById(Long id) {
        return (RoofType)((Object)this.roofTypeRepository.findOne(id));
    }

    public List<RoofType> getAllRoofTypes() {
        return this.roofTypeRepository.findAll();
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }
}

