/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.report;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.repository.BoundaryRepository;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.DemandRegisterInfo;
import org.egov.ptis.domain.repository.report.AssessmentTransactionsRepository;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DemandRegisterService {
    @Autowired
    private AssessmentTransactionsRepository transactionsRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ReportService reportService;
    @Autowired
    private PropertyTaxCommonUtils ptCommonUtils;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private BoundaryRepository boundaryRepository;

    public ReportOutput generateDemandRegisterReport(String reportType, Long wardId, CFinancialYear finYear, String mode) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("selectedYear", finYear.getFinYearRange());
        ReportRequest reportInput = this.generateADRReport(reportParams, wardId, finYear.getStartingDate(), mode);
        reportInput.setPrintDialogOnOpenReport(true);
        reportInput.setReportFormat(ReportFormat.PDF);
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return reportOutput;
    }

    private ReportRequest generateADRReport(Map<String, Object> reportParams, Long wardId, java.util.Date finYearStartDate, String mode) {
        ArrayList<DemandRegisterInfo> demandRegisterInfoList = new ArrayList<DemandRegisterInfo>();
        List<String> assessmentList = this.transactionsRepository.getPriorAssessmentsByWard(wardId, new Date(finYearStartDate.getTime()), this.getPropertyType(mode));
        if (!assessmentList.isEmpty()) {
            List<CFinancialYear> finYearList = this.ptCommonUtils.getAllFinancialYearsBetweenDates(this.getFromDateforFinYearList(assessmentList), finYearStartDate);
            for (CFinancialYear cFinancialYear : finYearList) {
                demandRegisterInfoList.addAll(this.getDemandRegisterInfo(cFinancialYear.getFinYearRange(), wardId, mode));
            }
        }
        reportParams.put("demandRegisterInfoList", demandRegisterInfoList);
        StringBuilder queryString = new StringBuilder();
        queryString.append("from City");
        Query query = this.entityManager.createQuery(queryString.toString());
        City city = (City)query.getSingleResult();
        reportParams.put("cityName", city.getName());
        reportParams.put("districtName", city.getDistrictName());
        reportParams.put("ward", ((Boundary)this.boundaryRepository.getOne((Serializable)wardId)).getName());
        reportParams.put("propertyType", mode);
        reportParams.put("cityGrade", city.getGrade());
        ReportRequest reportInput = new ReportRequest("arreardemand-register", reportParams, reportParams);
        return reportInput;
    }

    @ReadOnly
    public java.util.Date getMinTransactionDate(List<String> assessmentList) {
        return this.transactionsRepository.getMinTransactionDateForAssessmentList(assessmentList);
    }

    @ReadOnly
    public java.util.Date getFromDateforFinYearList(List<String> assessmentList) {
        java.util.Date leastInstallmentDate;
        java.util.Date mintransactionDate = this.getMinTransactionDate(assessmentList);
        if (mintransactionDate.before(leastInstallmentDate = DateUtils.getDate((String)"1960-04-01", (String)"yyyy-MM-dd"))) {
            mintransactionDate = leastInstallmentDate;
        }
        return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Property Tax"), mintransactionDate).getFromDate();
    }

    @ReadOnly
    public List<DemandRegisterInfo> getDemandRegisterInfo(String finYear, Long ward, String mode) {
        String propertyType = this.getPropertyType(mode);
        StringBuilder query = new StringBuilder("select bp.propertyid \"assessmentNo\", at.ownersname \"ownerName\", at.doorno \"houseNo\", instm.financial_year \"financialYear\", cast(idi.demand as numeric) \"demand\", coalesce(cast(ici.collectiondate as character varying), '-') \"collectionDate\",cast(coalesce(ici.amount, 0) as numeric) \"collectedAmount\", coalesce(ici.collectionmode, '-') \"collectionMode\", cast(idi.totalcollection as numeric) \"totalCollection\", cast(idi.writeoff as numeric) \"writeOff\", cast(idi.advance as numeric) \"advanceAmount\"  from egpt_assessment_transactions at, egpt_basic_property bp, egpt_installment_demand_info idi left join egpt_installment_collection_info ici on idi.id=ici.installment_demand_info, eg_installment_master instm, egpt_property_type_master ptm where idi.assessment_transactions=at.id and at.basicproperty=bp.id and idi.installment=instm.id and instm.financial_year=:finYear and at.ward =:ward and at.propertytype=ptm.id and ptm.code =:propertyType order by bp.propertyid, at.transaction_date");
        SQLQuery sqlQuery = this.ptCommonUtils.getSession().createSQLQuery(query.toString());
        sqlQuery.setParameter("finYear", (Object)finYear);
        sqlQuery.setParameter("ward", (Object)ward);
        sqlQuery.setParameter("propertyType", (Object)propertyType);
        sqlQuery.setResultTransformer(Transformers.aliasToBean(DemandRegisterInfo.class));
        return this.filterDemandRegisterInfo(sqlQuery.list());
    }

    public List<DemandRegisterInfo> filterDemandRegisterInfo(List<DemandRegisterInfo> demandRegisterInfoList) {
        ArrayList<DemandRegisterInfo> list = new ArrayList<DemandRegisterInfo>();
        DemandRegisterInfo demandRegisterInfo = null;
        for (DemandRegisterInfo registerInfo : demandRegisterInfoList) {
            if (demandRegisterInfo != null && !demandRegisterInfo.getAssessmentNo().equals(registerInfo.getAssessmentNo())) {
                list.add(demandRegisterInfo);
            }
            demandRegisterInfo = registerInfo;
        }
        if (demandRegisterInfo != null) {
            list.add(demandRegisterInfo);
        }
        return list;
    }

    public String getPropertyType(String mode) {
        return mode.equals("VLT") ? "VAC_LAND" : "PRIVATE";
    }
}

