/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.utils.EGovConfig;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.domain.entity.property.PropertySource;
import org.egov.ptis.exceptions.PropertyNotFoundException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.springframework.stereotype.Repository;

@Repository(value="propertyDAO")
public class PropertyHibernateDAO
implements PropertyDAO {
    private static final Logger LOGGER = Logger.getLogger(PropertyHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public Property getPropertyByID(String propID) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.id =:ID ");
        qry.setString("ID", propID);
        return (Property)qry.uniqueResult();
    }

    @Override
    public Property getPropertyByBasicPropertyID(BasicProperty basicProperty) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty");
        qry.setEntity("basicProperty", (Object)basicProperty);
        qry.setMaxResults(1);
        return (Property)qry.uniqueResult();
    }

    @Override
    public List getOnlineDateByWardID(Integer wardId) {
        Query qry = this.getCurrentSession().createQuery("from OnlineWards P where P.wardId =:wardId ");
        qry.setInteger("wardId", wardId.intValue());
        return qry.list();
    }

    @Override
    public List getAllNonDefaultProperties(BasicProperty basicProperty) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty and P.isDefaultProperty='N' and P.status='N' ");
        qry.setEntity("basicProperty", (Object)basicProperty);
        return qry.list();
    }

    @Override
    public List getAllProperties(BasicProperty basicProperty) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty  and P.status='N' ");
        qry.setEntity("basicProperty", (Object)basicProperty);
        return qry.list();
    }

    @Override
    public Property getPropertyForInstallment(BasicProperty basicProperty, Installment insatllment, PropertySource src) {
        try {
            Property prop = null;
            Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where  P.basicProperty =:basicProperty  and P.status='N' and P.installment=:insatllment and P.propertySource =:src ");
            qry.setEntity("insatllment", (Object)insatllment);
            qry.setEntity("basicProperty", (Object)basicProperty);
            qry.setEntity("src", (Object)src);
            if (qry.uniqueResult() != null) {
                prop = (Property)qry.uniqueResult();
                LOGGER.debug((Object)("getPropertyForInstallment : prop : " + prop));
            }
            return prop;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getPropertyForInstalment in DAO : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyForInstalment" + e);
        }
    }

    @Override
    public List getAllHistories(BasicProperty bp, PropertySource src) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty and P.status='Y' and P.propertySource =:src ");
        qry.setEntity("basicProperty", (Object)bp);
        qry.setEntity("src", (Object)src);
        return qry.list();
    }

    @Override
    public List getWardWiseProperties() {
        StringBuffer selectProperties = new StringBuffer(1500);
        selectProperties.append("select count(propusage.idUsage),propusage.usageName,BndryImpl.id,BndryImpl.boundaryNum ");
        selectProperties.append("from BasicPropertyImpl BP left join BP.property prop ");
        selectProperties.append("inner join prop.propertyDetail propdetail ");
        selectProperties.append("inner join propdetail.PropertyUsage propusage ");
        selectProperties.append("left join BP.propertyID propid ");
        selectProperties.append("left join propid.wardId BndryImpl ");
        selectProperties.append("group by (propusage.usageName,BndryImpl.id,BndryImpl.boundaryNum) ");
        selectProperties.append("order by BndryImpl.boundaryNum");
        Query qry = this.getCurrentSession().createQuery(selectProperties.toString());
        return qry.list();
    }

    @Override
    public Property getPropertyBySource(String src) {
        Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.propertySource.name like :src ");
        qry.setString("src", src);
        return (Property)qry.uniqueResult();
    }

    @Override
    public List getAllPropertiesForGivenBndryListAndSrc(List bndryList, String src) {
        List propList = new ArrayList();
        if (src != null && !src.isEmpty() && bndryList != null && !bndryList.isEmpty()) {
            LOGGER.debug((Object)("getAllPropertiesForGivenBndryListAndSrc : bndryList : " + bndryList + " : src : " + src));
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select prop from BasicPropertyImpl BP left join BP.property prop ");
            if (src != null && !src.equals("")) {
                strBuffer.append(" left join prop.propertySource propsrc ");
                strBuffer.append(" where propsrc.name like :src and ");
            } else {
                strBuffer.append(" where ");
            }
            strBuffer.append(" BP.boundary.id in (:bndryList)");
            Query qry = this.getCurrentSession().createQuery(strBuffer.toString());
            qry.setString("src", src);
            qry.setParameterList("bndryList", (Collection)bndryList);
            propList = qry.list();
        }
        LOGGER.debug((Object)("getAllPropertiesForGivenBndryListAndSrc : propList.size() : " + propList.size()));
        return propList;
    }

    @Override
    public List getAllPropertiesForGivenBndryListSrcAndInst(List bndryList, String src, Installment inst) {
        List propList = new ArrayList(0);
        if (bndryList != null && !bndryList.isEmpty() && src != null && !src.isEmpty() && inst != null) {
            LOGGER.debug((Object)("getAllPropertiesForGivenBndryListSrcAndInst : bndryList : " + bndryList + " : src : " + src + " : inst : " + inst));
            Query qry = this.getCurrentSession().createQuery("select prop from BasicPropertyImpl BP, PropertyImpl prop left join prop.propertySource propsrc where prop.basicProperty.id = BP.id and propsrc.name like :src and prop.propertyDetail.installment=:inst and BP.boundary.id in (:bndryList)");
            qry.setString("src", src);
            qry.setEntity("inst", (Object)inst);
            qry.setParameterList("bndryList", (Collection)bndryList);
            propList = qry.list();
        }
        LOGGER.debug((Object)("getAllPropertiesForGivenBndryListSrcAndInst propList() : " + propList.size()));
        return propList;
    }

    @Override
    public List getAllNonHistoryPropertiesForSrc(BasicProperty basicProperty, PropertySource src) {
        List propList = new ArrayList(0);
        if (basicProperty != null && src != null) {
            Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty and P.status='N' and P.propertySource =:src");
            qry.setEntity("basicProperty", (Object)basicProperty);
            qry.setEntity("src", (Object)src);
            propList = qry.list();
        }
        LOGGER.debug((Object)("getAllNonHistoryPropertiesForSrc propList() : " + propList.size()));
        return propList;
    }

    @Override
    public Property getPropertyBySrcAndBp(BasicProperty basicProperty, PropertySource src) throws ApplicationRuntimeException {
        Property prop = null;
        try {
            if (basicProperty != null && src != null) {
                LOGGER.debug((Object)("getPropertyBySrcAndBp basicProperty : " + basicProperty));
                Query qry = this.getCurrentSession().createQuery("from PropertyImpl P where P.basicProperty =:basicProperty and  P.status='N' and P.propertySource =:src");
                qry.setEntity("basicProperty", (Object)basicProperty);
                qry.setEntity("src", (Object)src);
                prop = (Property)qry.uniqueResult();
            }
            return prop;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getPropertyBySrcAndBp : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyBySrcAndBp", (Throwable)e);
        }
    }

    @Override
    public boolean checkIfPropCountExceeds500(List bndryList) throws ApplicationRuntimeException {
        boolean chkCntExcds500 = false;
        int count = 0;
        try {
            if (bndryList != null && !bndryList.isEmpty()) {
                String qryStr = "select count(*) from BasicPropertyImpl BP where BP.boundary.id in (:bndryList) ";
                Query qry = this.getCurrentSession().createQuery("select count(*) from BasicPropertyImpl BP where BP.boundary.id in (:bndryList) ");
                qry.setParameterList("bndryList", (Collection)bndryList);
                Integer cnt = (Integer)qry.uniqueResult();
                count = cnt;
                if (count > 500) {
                    chkCntExcds500 = true;
                }
                LOGGER.debug((Object)("checkIfPropCountExceeds500 chkCntExcds500 : " + chkCntExcds500));
            }
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Error occured in PropertyHibernateDao.checkIfPropCountExceeds500" + e.getMessage()));
            throw new ApplicationRuntimeException("Hibernate Exception in checkIfPropCountExceeds500: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Error occured in PropertyHibernateDao.checkIfPropCountExceeds500" + e1.getMessage()));
            throw new ApplicationRuntimeException("Exception in checkIfPropCountExceeds500 : " + e1.getMessage(), (Throwable)e1);
        }
        return chkCntExcds500;
    }

    @Override
    public List getBasicPropertyListByDcNo(String dcNo) throws ApplicationRuntimeException {
        List bpList = null;
        try {
            if (dcNo != null) {
                Query qry = this.getCurrentSession().createQuery("from BasicPropertyImpl BP where BP.dcRegister.id=:dcNo and BP.active='Y'");
                qry.setString("dcNo", dcNo);
                bpList = qry.list();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occured in PropertyHibernateDao.getBasicPropertyListByDcNo" + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in checkIfPropCountExceeds500 : " + e);
        }
        return bpList;
    }

    @Override
    public List getPtDemandArvProposedList(Property property) {
        Query qry = this.getCurrentSession().createQuery("from PtDemandARV arv where arv.property =:property  and arv.isHistory='N' and arv.type='Proposed' ");
        qry.setEntity("property", (Object)property);
        return qry.list();
    }

    @Override
    public Citizen getOwnerByOwnerId(Long citizenId) {
        Citizen owner = null;
        Query qry = this.getCurrentSession().createQuery(" FROM Citizen citizen where citizen.id =:id ");
        qry.setLong("id", citizenId.longValue());
        owner = (Citizen)qry.uniqueResult();
        return owner;
    }

    @Override
    public List getPropertyDemand(String propertyId) {
        String rebate = EGovConfig.getProperty((String)"ptis_egov_config.xml", (String)"ACCOUNT_HEAD_REBATE", (String)"", (String)"PT");
        Query qry = this.getCurrentSession().createQuery(" select sum(dd.amount) from PropertyTaxDemand pt left join pt.demandDetails dd where pt.history = 'N' and dd.accountHead.accountHeadName !=:accHead and pt.property.basicProperty.upicNo =:PID ");
        qry.setString("accHead", rebate);
        qry.setString("PID", propertyId);
        return qry.list();
    }

    @Override
    public List getPropertyRebate(String propertyId) {
        String rebate = EGovConfig.getProperty((String)"ptis_egov_config.xml", (String)"ACCOUNT_HEAD_REBATE", (String)"", (String)"PT");
        Query qry = this.getCurrentSession().createQuery(" select sum(dd.amount) from PropertyTaxDemand pt left join pt.demandDetails dd where pt.history = 'N' and dd.isApproved = '1' and dd.accountHead.accountHeadName =:accHead and pt.property.basicProperty.upicNo =:PID ");
        qry.setString("accHead", rebate);
        qry.setString("PID", propertyId);
        return qry.list();
    }

    @Override
    public List getPropertyCollection(String propertyId) {
        Query qry = this.getCurrentSession().createQuery(" select sum(TD.inFlowAmount) from PropertyTaxTxAgent pta left join  pta.myTransactions TI left join TI.transactionDetails TD where TI.isCancelled = '0' and pta.basicProperty.upicNo =:PID ");
        qry.setString("PID", propertyId);
        return qry.list();
    }

    @Override
    public List getPTDemandArvByNoticeNumber(String noticeNo) {
        Query qry = this.getCurrentSession().createQuery(" FROM PtDemandARV ar where ar.section72No =:id and ar.isHistory='N' and ar.type ='Proposed' ");
        qry.setString("id", noticeNo);
        return qry.list();
    }

    @Override
    public List getPropsMrkdForDeactByWard(Boundary boundary) throws PropertyNotFoundException {
        List propertyList = new ArrayList();
        try {
            if (boundary != null) {
                Query qry = this.getCurrentSession().createQuery(" select distinct bp from PropertyImpl pi  left join pi.basicProperty bp  left join bp.propertyStatusValuesSet psv  left join psv.propertyStatus ps  where bp.boundary = :boundary and pi.status='N' and bp.active='Y'  and ps.statusCode='MARK_DEACTIVE' and psv.isActive='Y' ");
                qry.setEntity("boundary", (Object)boundary);
                propertyList = qry.list();
            }
            LOGGER.info((Object)("List of properties By Query" + propertyList.size()));
            return propertyList;
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("Error occured in PropertyHibernateDao.getPropsMrkdForDeactByWard" + e.getMessage()));
            PropertyNotFoundException er = new PropertyNotFoundException("Hibernate Exception In getAllPropertiesMarkedForDeactivationByWard: " + (Object)((Object)e));
            er.initCause(e);
            throw er;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occured in PropertyHibernateDao.getPropsMrkdForDeactByWard" + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getAllPropertiesMarkedForDeactivationByWard" + e);
        }
    }

    @Override
    public List getPropMaterlizeViewList(Projection projection, Criterion criterion, Order order) {
        Criteria criteria = this.getCurrentSession().createCriteria(PropertyMaterlizeView.class);
        if (projection != null) {
            criteria.setProjection(projection);
        }
        if (criterion != null) {
            criteria.add(criterion);
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    @Override
    public List getResultsList(Class classObj, Projection projection, Criterion criterion, Order order) {
        Criteria criteria = this.getCurrentSession().createCriteria(classObj);
        if (projection != null) {
            criteria.setProjection(projection);
        }
        if (criterion != null) {
            criteria.add(criterion);
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    @Override
    public List getResultsList(DetachedCriteria detachedCriteria) {
        Criteria criteria = null;
        if (detachedCriteria != null) {
            criteria = detachedCriteria.getExecutableCriteria(this.getCurrentSession());
        }
        return criteria.list();
    }

    @Override
    public List getDmdCollAmtInstWise(EgDemand egDemand) {
        new ArrayList();
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append(" select dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master and dmdresmas.code not in ('ADVANCE','PENALTY','PENALTY_FINES') group by dmdRes.id_installment, inst.start_date order by inst.start_date ");
        Query qry = this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue());
        return qry.list();
    }

    @Override
    public List getPenaltyDmdCollAmtInstWise(EgDemand egDemand) {
        new ArrayList();
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append(" select dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master and dmdresmas.code = :dmdRsnCode group by dmdRes.id_installment, inst.start_date order by inst.start_date ");
        Query qry = this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue()).setString("dmdRsnCode", "PENALTY_FINES");
        return qry.list();
    }

    @Override
    public List getDmdDetIdFromInstallandEgDemand(Installment installment, EgDemand egDemand) {
        List dmdIdList = new ArrayList();
        if (egDemand != null && installment != null) {
            StringBuffer strBuf = new StringBuffer(2000);
            strBuf.append(" select dmdet.id from eg_demand_details dmdet, eg_demand_reason res where dmdet.id_demand_reason= res.id and dmdet.id_demand =:dmdId and res.id_installment =:instlId ");
            SQLQuery qry = this.getCurrentSession().createSQLQuery(strBuf.toString());
            qry.setLong("dmdId", egDemand.getId().longValue());
            qry.setInteger("instlId", installment.getId().intValue());
            dmdIdList = qry.list();
        }
        return dmdIdList;
    }

    @Override
    public BigDecimal getEgptPropertyFromBillId(Long billId) {
        BigDecimal propertyId = null;
        if (billId != null) {
            StringBuffer strBuf = new StringBuffer(2000);
            strBuf.append(" select ptdem.id_property from ").append("egpt_ptdemand ptdem, eg_demand dmd, eg_bill bill ").append("where bill.id_demand = dmd.id and dmd.id = ptdem.id_demand ").append("and dmd.is_history = 'N' and bill.id = :billId ");
            SQLQuery qry = this.getCurrentSession().createSQLQuery(strBuf.toString());
            qry.setLong("billId", billId.longValue()).setMaxResults(1);
            propertyId = (BigDecimal)qry.uniqueResult();
        }
        return propertyId;
    }

    @Override
    public List getAllDemands(BasicProperty basicProperty) {
        List demandIds = null;
        if (basicProperty != null) {
            demandIds = new ArrayList();
            String qryStr = "SELECT ptdem.id_demand FROM egpt_basic_property bas,   egpt_property prop,   egpt_ptdemand ptdem WHERE bas.ID = prop.ID_BASIC_PROPERTY AND prop.id = ptdem.ID_PROPERTY AND bas.propertyid = :PropId ";
            SQLQuery qry = this.getCurrentSession().createSQLQuery("SELECT ptdem.id_demand FROM egpt_basic_property bas,   egpt_property prop,   egpt_ptdemand ptdem WHERE bas.ID = prop.ID_BASIC_PROPERTY AND prop.id = ptdem.ID_PROPERTY AND bas.propertyid = :PropId ");
            qry.setString("PropId", basicProperty.getUpicNo());
            demandIds = qry.list();
        }
        return demandIds;
    }

    @Override
    public List getDmdDetIdFromInstallandEgDemand(Installment installment, EgDemand egDemand, String demandReasonMasterCode) {
        List dmdIdList = new ArrayList();
        if (egDemand != null && installment != null) {
            StringBuffer strBuf = new StringBuffer(2000);
            strBuf.append(" SELECT dmdet.id FROM eg_demand_details dmdet, eg_demand_reason res , eg_demand_reason_master mast ");
            strBuf.append(" WHERE dmdet.id_demand_reason= res.id AND dmdet.id_demand =:dmdId AND res.id_installment =:instlId ");
            strBuf.append(" AND mast.id = res.id_demand_reason_master AND mast.code =:masterCode ");
            SQLQuery qry = this.getCurrentSession().createSQLQuery(strBuf.toString());
            qry.setLong("dmdId", egDemand.getId().longValue());
            qry.setInteger("instlId", installment.getId().intValue());
            qry.setString("masterCode", demandReasonMasterCode);
            dmdIdList = qry.list();
        }
        return dmdIdList;
    }

    @Override
    public List getDmdCollForAllDmdReasons(EgDemand egDemand) {
        new ArrayList();
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append(" select dmdRes.ID_INSTALLMENT, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as rebate, inst.start_date, dmdresmas.code as reason from eg_demand_details dmdDet ,eg_demand_reason dmdRes, eg_installment_master inst, eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id_installment, inst.start_date, dmdresmas.code order by inst.start_date ");
        Query qry = this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue());
        return qry.list();
    }

    @Override
    public List getTotalDemandDetailsIncludingPenalty(EgDemand egDemand) {
        new ArrayList();
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append(" select dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id_installment, dmdresmas.code, dmdDet.amount,dmdDet.amt_collected, inst.start_date order by inst.start_date ");
        Query qry = this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue());
        return qry.list();
    }

    @Override
    public List<?> getInstallmentAndReasonWiseDemandDetails(EgDemand egDemand) {
        StringBuilder strBul = new StringBuilder(2000);
        strBul.append(" select dmdRes.id_installment,  dmdresmas.code, dmdDet.amount , dmdDet.amt_collected, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id_installment,dmdresmas.code, dmdDet.amount , dmdDet.amt_collected, inst.start_date order by inst.start_date ");
        Query qry = this.getCurrentSession().createSQLQuery(strBul.toString()).setLong("dmdId", egDemand.getId().longValue());
        return qry.list();
    }

    @Override
    public Property findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<Property> findAll() {
        return null;
    }

    @Override
    public Property create(Property property) {
        return null;
    }

    @Override
    public void delete(Property property) {
    }

    @Override
    public Property update(Property property) {
        return null;
    }
}

