/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.egov.ptis.scheduler.BulkBillGenerationJob;
import org.egov.ptis.scheduler.DemandActivationJob;
import org.egov.ptis.scheduler.RecoveryNoticesJob;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class PtisSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean ptisScheduler(DataSource dataSource) {
        SchedulerFactoryBean ptisScheduler = this.createScheduler(dataSource);
        ptisScheduler.setSchedulerName("ptis-scheduler");
        ptisScheduler.setAutoStartup(true);
        ptisScheduler.setOverwriteExistingJobs(true);
        ptisScheduler.setTriggers(new Trigger[]{this.ptisBulkBillGenerationCronTrigger0().getObject(), this.ptisBulkBillGenerationCronTrigger1().getObject(), this.ptisBulkBillGenerationCronTrigger2().getObject(), this.ptisBulkBillGenerationCronTrigger3().getObject(), this.ptisBulkBillGenerationCronTrigger4().getObject(), this.demandActivationCronTrigger().getObject()});
        return ptisScheduler;
    }

    @Bean(name={"recoveryNoticeScheduler"}, destroyMethod="destroy")
    public SchedulerFactoryBean recoveryNoticeScheduler(DataSource dataSource) {
        SchedulerFactoryBean recoveryNoticeScheduler = this.createScheduler(dataSource);
        recoveryNoticeScheduler.setSchedulerName("recovery-notice-scheduler");
        recoveryNoticeScheduler.setAutoStartup(true);
        recoveryNoticeScheduler.setOverwriteExistingJobs(true);
        recoveryNoticeScheduler.setStartupDelay(1500);
        return recoveryNoticeScheduler;
    }

    @Bean(name={"recoveryNoticeJobDetail"})
    @Scope(value="prototype")
    public JobDetailFactoryBean recoveryNoticeJobDetail() {
        JobDetailFactoryBean recoveryNoticeJobDetail = new JobDetailFactoryBean();
        recoveryNoticeJobDetail.setGroup("PTIS_RECOVERY_NOTICE_JOB_GROUP");
        recoveryNoticeJobDetail.setName("PTIS_RECOVERY_NOTICE_JOB");
        recoveryNoticeJobDetail.setDurability(true);
        recoveryNoticeJobDetail.setJobClass(RecoveryNoticesJob.class);
        recoveryNoticeJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "recoveryNoticesJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "ptis");
        recoveryNoticeJobDetail.setJobDataAsMap(jobDetailMap);
        return recoveryNoticeJobDetail;
    }

    @Bean(value={"demandActivationJob"})
    public DemandActivationJob demandActivationJob() {
        return new DemandActivationJob();
    }

    @Bean
    public JobDetailFactoryBean demandActivationJobDetail() {
        JobDetailFactoryBean demandActivationJobDetail = new JobDetailFactoryBean();
        demandActivationJobDetail.setGroup("PTIS_JOB_GROUP");
        demandActivationJobDetail.setName("PTIS_DEMAND_ACTIVATION_JOB");
        demandActivationJobDetail.setDurability(true);
        demandActivationJobDetail.setJobClass(DemandActivationJob.class);
        demandActivationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "demandActivationJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "ptis");
        demandActivationJobDetail.setJobDataAsMap(jobDetailMap);
        return demandActivationJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean demandActivationCronTrigger() {
        CronTriggerFactoryBean demandActivationCron = new CronTriggerFactoryBean();
        demandActivationCron.setJobDetail(this.demandActivationJobDetail().getObject());
        demandActivationCron.setGroup("PTIS_TRIGGER_GROUP");
        demandActivationCron.setName("PTIS_DEMAND_ACTIVATION_TRIGGER");
        demandActivationCron.setCronExpression("0 15 0 * * ?");
        demandActivationCron.setMisfireInstruction(2);
        return demandActivationCron;
    }

    @Bean(value={"bulkBillGenerationJob0"})
    public BulkBillGenerationJob bulkBillGenerationJob0() {
        BulkBillGenerationJob bulkBillGenerationJob = new BulkBillGenerationJob();
        bulkBillGenerationJob.setModulo(0);
        bulkBillGenerationJob.setBillsCount(50);
        return bulkBillGenerationJob;
    }

    @Bean(value={"bulkBillGenerationJob1"})
    public BulkBillGenerationJob bulkBillGenerationJob1() {
        BulkBillGenerationJob bulkBillGenerationJob = new BulkBillGenerationJob();
        bulkBillGenerationJob.setModulo(1);
        bulkBillGenerationJob.setBillsCount(50);
        return bulkBillGenerationJob;
    }

    @Bean(value={"bulkBillGenerationJob2"})
    public BulkBillGenerationJob bulkBillGenerationJob2() {
        BulkBillGenerationJob bulkBillGenerationJob = new BulkBillGenerationJob();
        bulkBillGenerationJob.setModulo(2);
        bulkBillGenerationJob.setBillsCount(50);
        return bulkBillGenerationJob;
    }

    @Bean(value={"bulkBillGenerationJob3"})
    public BulkBillGenerationJob bulkBillGenerationJob3() {
        BulkBillGenerationJob bulkBillGenerationJob = new BulkBillGenerationJob();
        bulkBillGenerationJob.setModulo(3);
        bulkBillGenerationJob.setBillsCount(50);
        return bulkBillGenerationJob;
    }

    @Bean(value={"bulkBillGenerationJob4"})
    public BulkBillGenerationJob bulkBillGenerationJob4() {
        BulkBillGenerationJob bulkBillGenerationJob = new BulkBillGenerationJob();
        bulkBillGenerationJob.setModulo(4);
        bulkBillGenerationJob.setBillsCount(50);
        return bulkBillGenerationJob;
    }

    @Bean
    public JobDetailFactoryBean ptisBulkBillGenerationJobDetail0() {
        return this.createJobDetailFactory(0);
    }

    @Bean
    public JobDetailFactoryBean ptisBulkBillGenerationJobDetail1() {
        return this.createJobDetailFactory(1);
    }

    @Bean
    public JobDetailFactoryBean ptisBulkBillGenerationJobDetail2() {
        return this.createJobDetailFactory(2);
    }

    @Bean
    public JobDetailFactoryBean ptisBulkBillGenerationJobDetail3() {
        return this.createJobDetailFactory(3);
    }

    @Bean
    public JobDetailFactoryBean ptisBulkBillGenerationJobDetail4() {
        return this.createJobDetailFactory(4);
    }

    @Bean
    public CronTriggerFactoryBean ptisBulkBillGenerationCronTrigger0() {
        return this.createCronTrigger(this.ptisBulkBillGenerationJobDetail0(), 0);
    }

    @Bean
    public CronTriggerFactoryBean ptisBulkBillGenerationCronTrigger1() {
        return this.createCronTrigger(this.ptisBulkBillGenerationJobDetail1(), 1);
    }

    @Bean
    public CronTriggerFactoryBean ptisBulkBillGenerationCronTrigger2() {
        return this.createCronTrigger(this.ptisBulkBillGenerationJobDetail2(), 2);
    }

    @Bean
    public CronTriggerFactoryBean ptisBulkBillGenerationCronTrigger3() {
        return this.createCronTrigger(this.ptisBulkBillGenerationJobDetail3(), 3);
    }

    @Bean
    public CronTriggerFactoryBean ptisBulkBillGenerationCronTrigger4() {
        return this.createCronTrigger(this.ptisBulkBillGenerationJobDetail4(), 4);
    }

    private JobDetailFactoryBean createJobDetailFactory(int modulo) {
        JobDetailFactoryBean ptisBulkBillGenerationJobDetail = new JobDetailFactoryBean();
        ptisBulkBillGenerationJobDetail.setGroup("PTIS_JOB_GROUP");
        ptisBulkBillGenerationJobDetail.setName("PTIS_BULK_BILL_GEN_" + modulo + "_JOB");
        ptisBulkBillGenerationJobDetail.setDurability(true);
        ptisBulkBillGenerationJobDetail.setJobClass(BulkBillGenerationJob.class);
        ptisBulkBillGenerationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "bulkBillGenerationJob" + modulo);
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "ptis");
        ptisBulkBillGenerationJobDetail.setJobDataAsMap(jobDetailMap);
        return ptisBulkBillGenerationJobDetail;
    }

    private CronTriggerFactoryBean createCronTrigger(JobDetailFactoryBean jobDetail, int modulo) {
        CronTriggerFactoryBean bulkBillGenerationCron = new CronTriggerFactoryBean();
        bulkBillGenerationCron.setJobDetail(jobDetail.getObject());
        bulkBillGenerationCron.setGroup("PTIS_TRIGGER_GROUP");
        bulkBillGenerationCron.setName("PTIS_BULK_BILL_GEN_" + modulo + "_TRIGGER");
        bulkBillGenerationCron.setCronExpression("0 */5 * * * ?");
        bulkBillGenerationCron.setMisfireInstruction(2);
        return bulkBillGenerationCron;
    }
}

