/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.client.bill.BillDetailBean;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.util.FinancialUtil;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PTBillServiceImpl
extends BillServiceInterface {
    private static final Logger LOGGER = Logger.getLogger(PTBillServiceImpl.class);
    @Autowired
    PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private FinancialUtil financialUtil;

    public String getBillXML(Billable billObj) {
        if (billObj == null) {
            throw new ApplicationRuntimeException("Exception in getBillXML....Billable is null");
        }
        return super.getBillXML(billObj);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        LOGGER.debug((Object)("Entered method getBilldetails : " + billObj));
        PropertyTaxBillable billable = (PropertyTaxBillable)billObj;
        if (billable.isMutationFeePayment()) {
            Installment currInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
            EgBillDetails billdetail = new EgBillDetails();
            billdetail.setOrderNo(Integer.valueOf(1));
            billdetail.setCreateDate(new Date());
            billdetail.setModifiedDate(new Date());
            billdetail.setCrAmount(billable.getMutationFee());
            billdetail.setDrAmount(BigDecimal.ZERO);
            billdetail.setGlcode("4311002");
            billdetail.setDescription("MUTATION FEE");
            billdetail.setAdditionalFlag(Integer.valueOf(0));
            billdetail.setEgInstallmentMaster(currInstallment);
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
            billdetail.setFunctionCode(this.financialUtil.getFunctionCode());
            billDetails.add(billdetail);
            return billDetails;
        }
        BigDecimal earlyPayRebate = BigDecimal.ZERO;
        BasicProperty basicProperty = billable.getBasicProperty();
        Property activeProperty = basicProperty.getProperty();
        TreeMap installmentPenaltyAndRebate = (TreeMap)billable.getCalculatedPenalty();
        Map<String, Installment> currInstallments = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Date advanceStartDate = DateUtils.addYears((Date)currInstallments.get("Current 1st Half").getFromDate(), (int)1);
        List<Installment> advanceInstallments = this.propertyTaxCommonUtils.getAdvanceInstallmentsList(advanceStartDate);
        billable.setInstTaxBean(installmentPenaltyAndRebate);
        if (installmentPenaltyAndRebate.get(currInstallments.get("Current 1st Half")) != null) {
            earlyPayRebate = ((PenaltyAndRebate)installmentPenaltyAndRebate.get(currInstallments.get("Current 1st Half"))).getRebate();
        }
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(activeProperty);
        HashMap<String, Integer> orderMap = this.propertyTaxUtil.generateOrderForDemandDetails(ptDemand.getEgDemandDetails(), billable, advanceInstallments);
        for (EgDemandDetails demandDetail : ptDemand.getEgDemandDetails()) {
            BigDecimal balance = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = reason.getEgInstallmentMaster();
            String reasonMasterCode = reason.getEgDemandReasonMaster().getCode();
            if (balance.compareTo(BigDecimal.ZERO) != 1) continue;
            DateTime installmentDate = new DateTime(installment.getInstallmentYear().getTime());
            if (!this.isNotPenalty(reasonMasterCode)) continue;
            String key = installmentDate.getMonthOfYear() + "/" + installmentDate.getYear() + "-" + reasonMasterCode;
            BillDetailBean billDetailBean = new BillDetailBean(installment, orderMap.get(key), key, demandDetail.getAmount().subtract(demandDetail.getAmtCollected()), demandDetail.getEgDemandReason().getGlcodeId().getGlcode(), reason.getEgDemandReasonMaster().getReasonMaster(), 1, this.definePurpose(demandDetail));
            billDetails.add(this.createBillDet(billDetailBean));
        }
        this.addBillDetailsForRebate(billDetails, earlyPayRebate, currInstallments, orderMap);
        this.getPenaltyAndRebateDmd(billDetails, billable, installmentPenaltyAndRebate, ptDemand, orderMap);
        BigDecimal currentInstDemand = BigDecimal.ZERO;
        for (EgDemandDetails dmdDet : ptDemand.getEgDemandDetails()) {
            if (!this.isDmdForCurrYrSecHalf(currInstallments, dmdDet)) continue;
            currentInstDemand = currentInstDemand.add(dmdDet.getAmount());
        }
        if (this.isCurrTaxGrtZero(currentInstDemand)) {
            this.createAdvanceBillDetails(billDetails, currentInstDemand, orderMap, ptDemand, billable, advanceInstallments, currInstallments.get("Current 2nd Half"));
        }
        LOGGER.debug((Object)("Exiting method getBilldetails : " + billDetails));
        return billDetails;
    }

    private void getPenaltyAndRebateDmd(List<EgBillDetails> billDetails, PropertyTaxBillable billable, TreeMap<Installment, PenaltyAndRebate> installmentPenaltyAndRebate, Ptdemand ptDemand, HashMap<String, Integer> orderMap) {
        for (Map.Entry<Installment, PenaltyAndRebate> penaltyAndRebate : installmentPenaltyAndRebate.entrySet()) {
            EgDemandDetails penaltyDemandDetail = this.insertPenaltyAndBillDetails(billDetails, billable, orderMap, penaltyAndRebate.getValue().getPenalty(), penaltyAndRebate.getKey());
            if (penaltyDemandDetail == null) continue;
            ptDemand.getEgDemandDetails().add(penaltyDemandDetail);
        }
    }

    private void addBillDetailsForRebate(List<EgBillDetails> billDetails, BigDecimal earlyPayRebate, Map<String, Installment> currInstallments, HashMap<String, Integer> orderMap) {
        if (this.isCurrTaxGrtZero(earlyPayRebate)) {
            DateTime installmentDate = new DateTime(currInstallments.get("Current 1st Half").getInstallmentYear().getTime());
            String key = installmentDate.getMonthOfYear() + "/" + installmentDate.getYear() + "-" + "REBATE";
            BillDetailBean billDetailBean = new BillDetailBean(currInstallments.get("Current 1st Half"), orderMap.get(key), key, earlyPayRebate, "1109004", "REBATE", 1, BillAccountDetails.PURPOSE.REBATE.toString());
            billDetails.add(this.createBillDet(billDetailBean));
        }
    }

    private boolean isDmdForCurrYrSecHalf(Map<String, Installment> currInstallments, EgDemandDetails dmdDet) {
        return dmdDet.getInstallmentStartDate().equals(currInstallments.get("Current 2nd Half").getFromDate());
    }

    private boolean isCurrTaxGrtZero(BigDecimal currentInstDemand) {
        return currentInstDemand.compareTo(BigDecimal.ZERO) > 0;
    }

    private boolean isNotPenalty(String reasonMasterCode) {
        return !reasonMasterCode.equalsIgnoreCase("PENALTY_FINES");
    }

    private void createAdvanceBillDetails(List<EgBillDetails> billDetails, BigDecimal currentInstallmentDemand, HashMap<String, Integer> orderMap, Ptdemand ptDemand, PropertyTaxBillable billable, List<Installment> advanceInstallments, Installment dmdDetInstallment) {
        BillDetailBean billDetailBean = null;
        BigDecimal advanceCollection = this.demandGenericDAO.getBalanceByDmdMasterCodeInst((EgDemand)ptDemand, "ADVANCE", this.getModule(), dmdDetInstallment);
        if (advanceCollection.compareTo(BigDecimal.ZERO) < 0) {
            advanceCollection = advanceCollection.abs();
        }
        BigDecimal partiallyCollectedAmount = advanceCollection.remainder(currentInstallmentDemand);
        Integer noOfAdvancesPaid = advanceCollection.subtract(partiallyCollectedAmount).divide(currentInstallmentDemand).intValue();
        LOGGER.debug((Object)("getBilldetails - advanceCollection = " + advanceCollection + ", noOfAdvancesPaid=" + noOfAdvancesPaid));
        String key = null;
        DateTime installmentDate = null;
        Installment installment = null;
        if (noOfAdvancesPaid < PropertyTaxConstants.MAX_ADVANCES_ALLOWED) {
            for (int i = noOfAdvancesPaid.intValue(); i < advanceInstallments.size(); ++i) {
                installment = advanceInstallments.get(i);
                installmentDate = new DateTime(installment.getInstallmentYear().getTime());
                key = installmentDate.getMonthOfYear() + "/" + installmentDate.getYear() + "-" + "ADVANCE";
                billDetailBean = new BillDetailBean(installment, orderMap.get(key), key, i == noOfAdvancesPaid ? currentInstallmentDemand.subtract(partiallyCollectedAmount) : currentInstallmentDemand, "3504101", "Advance", 0, BillAccountDetails.PURPOSE.ADVANCE_AMOUNT.toString());
                billDetails.add(this.createBillDet(billDetailBean));
            }
        } else {
            LOGGER.debug((Object)"getBillDetails - All advances are paid...");
        }
    }

    private EgDemandDetails insertPenaltyAndBillDetails(List<EgBillDetails> billDetails, PropertyTaxBillable billable, HashMap<String, Integer> orderMap, BigDecimal penalty, Installment installment) {
        LOGGER.info((Object)"Entered into prepareDmdAndBillDetails");
        LOGGER.info((Object)("preapreDmdAndBillDetails- Installment : " + installment + ", Penalty Amount: " + penalty));
        String key = null;
        EgDemandDetails penDmdDtls = this.getPenaltyDmdDtls(billable, installment);
        EgDemandDetails insertPenDmdDetail = null;
        boolean thereIsPenalty = penalty != null && !penalty.equals(BigDecimal.ZERO) && !penalty.equals(BigDecimal.valueOf(0.0));
        DateTime installmentDate = new DateTime(installment.getInstallmentYear().getTime());
        if (billable.getLevyPenalty().booleanValue()) {
            if (penDmdDtls == null && thereIsPenalty) {
                insertPenDmdDetail = this.insertPenaltyDmdDetail(installment, penalty);
            } else if (penDmdDtls != null) {
                penalty = penDmdDtls.getAmount().subtract(penDmdDtls.getAmtCollected());
            }
            if (thereIsPenalty) {
                key = installmentDate.getMonthOfYear() + "/" + installmentDate.getYear() + "-" + "PENALTY_FINES";
                BillDetailBean billDetailBean = new BillDetailBean(installment, orderMap.get(key), key, penalty, "1402010", "Penalty Fines", 1, this.definePurpose(penDmdDtls));
                billDetails.add(this.createBillDet(billDetailBean));
            }
        }
        return insertPenDmdDetail;
    }

    private EgDemandDetails insertPenaltyDmdDetail(Installment inst, BigDecimal lpAmt) {
        return this.insertDemandDetails("PENALTY_FINES", lpAmt, inst);
    }

    private EgDemandDetails getPenaltyDmdDtls(Billable billObj, Installment inst) {
        return this.getDemandDetail(billObj.getCurrentDemand(), inst, "PENALTY_FINES");
    }

    public EgDemandDetails getDemandDetail(EgDemand egDemand, Installment instl, String code) {
        EgDemandDetails dmdDet = null;
        List dmdDetList = this.demandGenericDAO.getDmdDetailList(egDemand, instl, this.module(), this.getDemandReasonMaster(code));
        if (!dmdDetList.isEmpty()) {
            dmdDet = (EgDemandDetails)dmdDetList.get(0);
        }
        return dmdDet;
    }

    protected EgDemandReasonMaster getDemandReasonMaster(String code) {
        return this.demandGenericDAO.getDemandReasonMasterByCode(code, this.module());
    }

    protected Module module() {
        return this.moduleDao.getModuleByName("Property Tax");
    }

    public EgDemandDetails insertDemandDetails(String demandReason, BigDecimal amount, Installment inst) {
        EgDemandDetails demandDetail = null;
        Module ptModule = null;
        if (amount != null && this.isCurrTaxGrtZero(amount)) {
            ptModule = this.module();
            EgDemandReasonMaster egDemandReasonMaster = this.demandGenericDAO.getDemandReasonMasterByCode(demandReason, ptModule);
            if (egDemandReasonMaster == null) {
                throw new ApplicationRuntimeException(demandReason + " Demand reason Master is null in method  insertDemandDetails");
            }
            EgDemandReason egDemandReason = this.demandGenericDAO.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, inst, ptModule);
            if (egDemandReason == null) {
                throw new ApplicationRuntimeException(demandReason + " Demand reason is null in method  insertDemandDetails ");
            }
            demandDetail = "ADVANCE".equals(egDemandReason.getEgDemandReasonMaster().getCode()) ? this.createDemandDetails(egDemandReason, amount, BigDecimal.ZERO) : this.createDemandDetails(egDemandReason, BigDecimal.ZERO, amount);
        }
        return demandDetail;
    }

    public EgDemandDetails createDemandDetails(EgDemandReason egDemandReason, BigDecimal amtCollected, BigDecimal dmdAmount) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount, (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    EgBillDetails createBillDet(BillDetailBean billDetailBean) {
        LOGGER.debug((Object)("Entered into createBillDet, billDetailBean=" + billDetailBean));
        if (billDetailBean.invalidData()) {
            throw new ApplicationRuntimeException("Invalid bill details...");
        }
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setOrderNo(billDetailBean.getOrderNo());
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        if (billDetailBean.isRebate()) {
            billdetail.setDrAmount(billDetailBean.getAmount());
            billdetail.setCrAmount(BigDecimal.ZERO);
        } else {
            billdetail.setCrAmount(billDetailBean.getAmount());
            billdetail.setDrAmount(BigDecimal.ZERO);
        }
        billdetail.setGlcode(billDetailBean.getGlCode());
        billdetail.setDescription(billDetailBean.getDescription());
        billdetail.setAdditionalFlag(billDetailBean.getIsActualDemand());
        billdetail.setEgInstallmentMaster(billDetailBean.getInstallment());
        billdetail.setFunctionCode(this.financialUtil.getFunctionCode());
        billdetail.setPurpose(billDetailBean.getPurpose());
        LOGGER.debug((Object)"Exiting from createBillDet");
        return billdetail;
    }

    public EgBill updateBillWithLatest(Long billId) {
        LOGGER.debug((Object)("updateBillWithLatest billId " + billId));
        EgBill bill = this.egBillDAO.findById(billId, false);
        LOGGER.debug((Object)("updateBillWithLatest old bill " + bill));
        if (bill == null) {
            throw new ApplicationRuntimeException("No bill found with bill reference no :" + billId);
        }
        bill.getEgBillDetails().clear();
        PropertyTaxBillable propertyTaxBillable = (PropertyTaxBillable)((Object)this.context.getBean("propertyTaxBillable"));
        propertyTaxBillable.setReceiptDate(bill.getCreateDate());
        propertyTaxBillable.setLevyPenalty(true);
        propertyTaxBillable.setBasicProperty(this.basicPropertyDAO.getBasicPropertyByPropertyID(bill.getConsumerId().trim()));
        List<EgBillDetails> egBillDetails = this.getBilldetails(propertyTaxBillable);
        for (EgBillDetails billDetail : egBillDetails) {
            bill.addEgBillDetails(billDetail);
            billDetail.setEgBill(bill);
        }
        this.egBillDAO.update(bill);
        LOGGER.debug((Object)("Bill update with bill details for property tax " + bill.getConsumerId() + " as billdetails " + egBillDetails));
        return bill;
    }

    public void cancelBill() {
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Property Tax");
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public String definePurpose(EgDemandDetails demandDetail) {
        String purpose = BillAccountDetails.PURPOSE.OTHERS.toString();
        if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("CHQ_BUNC_PENALTY")) {
            return BillAccountDetails.PURPOSE.CHEQUE_BOUNCE_PENALTY.toString();
        }
        Map<String, Installment> currInstallments = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Date instStartDate = demandDetail.getInstallmentStartDate();
        if (instStartDate.equals(currInstallments.get("Current 1st Half").getFromDate()) || instStartDate.equals(currInstallments.get("Current 2nd Half").getFromDate())) {
            if (demandDetail.getReasonCategory().equalsIgnoreCase("TAX")) {
                return BillAccountDetails.PURPOSE.CURRENT_AMOUNT.toString();
            }
            if (demandDetail.getReasonCategory().equalsIgnoreCase("FINES")) {
                return BillAccountDetails.PURPOSE.CURRENT_LATEPAYMENT_CHARGES.toString();
            }
            return purpose;
        }
        if (demandDetail.getReasonCategory().equalsIgnoreCase("TAX")) {
            return BillAccountDetails.PURPOSE.ARREAR_AMOUNT.toString();
        }
        if (demandDetail.getReasonCategory().equalsIgnoreCase("FINES")) {
            return BillAccountDetails.PURPOSE.ARREAR_LATEPAYMENT_CHARGES.toString();
        }
        return purpose;
    }
}

