/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.scheduler;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.scheduler.DemandActivationJob;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandActivationSchedulerService {
    private static final Logger LOGGER = Logger.getLogger(DemandActivationJob.class);
    private static final String STR_REMARKS_DEMAND_ACTIVATION_CORP = "Demand activated by system on 15th day after notice generation";
    private static final String STR_REMARKS_DEMAND_ACTIVATION_MNCP_AND_NP = "Demand activated by system on 30th day after notice generation";
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public void demandActivation() {
        Long currentTimeMillis = System.currentTimeMillis();
        String assessmentNo = null;
        List<Ptdemand> properties = this.getInactiveDemandNotObjectedProperties();
        for (Ptdemand demand : properties) {
            try {
                BasicProperty basicProperty = demand.getEgptProperty().getBasicProperty();
                assessmentNo = basicProperty != null ? basicProperty.getUpicNo() : null;
                this.activateDemand(basicProperty);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while activating the demand for " + assessmentNo), (Throwable)e);
            }
        }
        LOGGER.info((Object)("Demand activation for " + properties.size() + " properties is completed in " + (System.currentTimeMillis() - currentTimeMillis) / 1000L + " sec(s)"));
    }

    private void activateDemand(BasicProperty basicProperty) {
        LOGGER.debug((Object)"Entered into activateDemand");
        PropertyImpl inactiveProperty = basicProperty.getInactiveProperty();
        inactiveProperty.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
        inactiveProperty.setRemarks(this.getRemarksByCityGrade(inactiveProperty));
        inactiveProperty.setLastModifiedDate(new Date());
        this.basicPropertyService.merge(basicProperty);
        LOGGER.debug((Object)"Exiting from activateDemand");
    }

    public List<Ptdemand> getInactiveDemandNotObjectedProperties() {
        LOGGER.debug((Object)"Entered into getQueryString");
        Date dateEffectiveDaysPast = this.propertyTaxCommonUtils.isCorporation() != false ? DateUtils.add((Date)new Date(), (int)5, (int)-15) : DateUtils.add((Date)new Date(), (int)5, (int)-30);
        String stringQuery = "SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ";
        LOGGER.debug((Object)"getQueryString, query=SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ");
        List properties = this.basicPropertyService.getSession().createQuery("SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ").setString("bpStatus", "OBJECTED").setParameter("pastDate", (Object)dateEffectiveDaysPast).setString("noticeType", "Special Notice").setEntity("currInstallment", (Object)this.propertyTaxCommonUtils.getCurrentInstallment()).list();
        LOGGER.debug((Object)"Exting from getQueryString");
        return properties;
    }

    private EgDemandDetails getAdvanceDemandDetail(Ptdemand ptDemand) {
        EgDemandDetails advanceDemandDetail = null;
        for (EgDemandDetails demandDetail : ptDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ADVANCE")) continue;
            advanceDemandDetail = demandDetail;
            break;
        }
        return advanceDemandDetail;
    }

    private String getRemarksByCityGrade(PropertyImpl inactiveProperty) {
        String remarks = this.propertyTaxCommonUtils.isCorporation() != false ? STR_REMARKS_DEMAND_ACTIVATION_CORP : STR_REMARKS_DEMAND_ACTIVATION_MNCP_AND_NP;
        return inactiveProperty.getRemarks() == null ? remarks : inactiveProperty.getRemarks().concat(", ").concat(remarks);
    }
}

