/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.dashboard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.admin.master.service.es.CityIndexService;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollTableData;
import org.egov.ptis.bean.dashboard.CollectionAnalysis;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.CollectionStats;
import org.egov.ptis.bean.dashboard.CollectionTrend;
import org.egov.ptis.bean.dashboard.DCBDetails;
import org.egov.ptis.bean.dashboard.DemandVariance;
import org.egov.ptis.bean.dashboard.MonthlyDCB;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.ReceiptTableData;
import org.egov.ptis.bean.dashboard.ReceiptsTrend;
import org.egov.ptis.bean.dashboard.StateCityInfo;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.bean.dashboard.TotalCollectionStats;
import org.egov.ptis.bean.dashboard.WeeklyDCB;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.service.es.CollectionIndexElasticSearchService;
import org.egov.ptis.service.es.PropertyTaxElasticSearchIndexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropTaxDashboardService {
    private static final String MILLISECS = " (millisecs) ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropTaxDashboardService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private CollectionIndexElasticSearchService collectionIndexElasticSearchService;
    @Autowired
    private PropertyTaxElasticSearchIndexService propertyTaxElasticSearchIndexService;
    @Autowired
    private SimpleRestClient simpleRestClient;
    @Autowired
    private CityIndexService cityIndexService;

    public List<StateCityInfo> getStateCityDetails() {
        ArrayList<StateCityInfo> stateCityDetails = new ArrayList<StateCityInfo>();
        Iterable cities = this.cityIndexService.findAll();
        for (CityIndex city : cities) {
            StateCityInfo cityInfo = new StateCityInfo();
            cityInfo.setRegion(city.getRegionname());
            cityInfo.setDistrict(city.getDistrictname());
            cityInfo.setCity(city.getName());
            cityInfo.setGrade(city.getCitygrade());
            cityInfo.setUlbCode(city.getCitycode());
            stateCityDetails.add(cityInfo);
        }
        return stateCityDetails;
    }

    public TotalCollectionStats getTotalCollectionStats(HttpServletRequest request) {
        TotalCollectionStats consolidatedCollectionDetails = new TotalCollectionStats();
        Long startTime = System.currentTimeMillis();
        CollectionStats consolidatedData = new CollectionStats();
        Map<String, BigDecimal> consolidatedColl = this.collectionIndexElasticSearchService.getFinYearsCollByService("Property Tax");
        Long timeTaken = System.currentTimeMillis() - startTime;
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getFinYearsCollByService() for Property Tax is : " + timeTaken + MILLISECS);
        }
        if (!consolidatedColl.isEmpty()) {
            consolidatedData.setCytdColl(consolidatedColl.get("cytdColln"));
            consolidatedData.setLytdColl(consolidatedColl.get("lytdColln"));
        }
        startTime = System.currentTimeMillis();
        BigDecimal totalDmd = this.propertyTaxElasticSearchIndexService.getTotalDemand();
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by Property Tax getTotalDemand() is : " + timeTaken + MILLISECS);
        }
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)DateUtils.startOfDay((Date)currFinYear.getStartingDate()), (Date)new Date()) + 1;
        consolidatedData.setTotalDmd(totalDmd.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths)));
        consolidatedData.setPerformance(consolidatedData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getTotalDmd(), 1, 4));
        consolidatedData.setLyVar(consolidatedData.getCytdColl().subtract(consolidatedData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getLytdColl(), 1, 4));
        consolidatedCollectionDetails.setPropertyTax(consolidatedData);
        consolidatedData = new CollectionStats();
        startTime = System.currentTimeMillis();
        consolidatedColl = this.collectionIndexElasticSearchService.getFinYearsCollByService("Water Charges");
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getFinYearsCollByService() for Water Tax is : " + timeTaken + MILLISECS);
        }
        if (!consolidatedColl.isEmpty()) {
            consolidatedData.setCytdColl(consolidatedColl.get("cytdColln"));
            consolidatedData.setLytdColl(consolidatedColl.get("lytdColln"));
        }
        startTime = System.currentTimeMillis();
        BigDecimal totalDemandValue = this.getWaterChargeTotalDemand(request);
        int numberOfMonths = DateUtils.noOfMonthsBetween((Date)DateUtils.startOfDay((Date)currFinYear.getStartingDate()), (Date)new Date()) + 1;
        consolidatedData.setTotalDmd(totalDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(numberOfMonths)));
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by Water Tax getTotalDemand() is : " + timeTaken + MILLISECS);
        }
        consolidatedData.setPerformance(consolidatedData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getTotalDmd(), 1, 4));
        consolidatedData.setLyVar(consolidatedData.getCytdColl().subtract(consolidatedData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(consolidatedData.getLytdColl(), 1, 4));
        consolidatedCollectionDetails.setWaterTax(consolidatedData);
        consolidatedData = new CollectionStats();
        consolidatedData.setCytdColl(BigDecimal.ZERO);
        consolidatedData.setTotalDmd(BigDecimal.ZERO);
        consolidatedData.setLytdColl(BigDecimal.ZERO);
        consolidatedData.setPerformance(BigDecimal.ZERO);
        consolidatedData.setLyVar(BigDecimal.ZERO);
        consolidatedCollectionDetails.setOthers(consolidatedData);
        return consolidatedCollectionDetails;
    }

    public BigDecimal getWaterChargeTotalDemand(HttpServletRequest request) {
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/totaldemandamount/", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        return waterTaxInfo.get("currentDemand") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("currentDemand"));
    }

    public CollectionDetails getCollectionIndexDetails(CollectionDetailsRequest collectionDetailsRequest, boolean isForMISReports) {
        List<CollTableData> collIndexData;
        CollectionDetails collectionIndexDetails = new CollectionDetails();
        if (!"allwards".equalsIgnoreCase(collectionDetailsRequest.getType())) {
            this.collectionIndexElasticSearchService.getCompleteCollectionIndexDetails(collectionDetailsRequest, collectionIndexDetails);
            this.propertyTaxElasticSearchIndexService.getConsolidatedDemandInfo(collectionDetailsRequest, collectionIndexDetails);
            List<CollectionTrend> collectionTrends = this.collectionIndexElasticSearchService.getMonthwiseCollectionDetails(collectionDetailsRequest);
            collectionIndexDetails.setCollTrends(collectionTrends);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
            collIndexData = this.collectionIndexElasticSearchService.getResponseTableDataForBillCollector(collectionDetailsRequest);
        } else if ("allwards".equalsIgnoreCase(collectionDetailsRequest.getType())) {
            Iterable cities = this.cityIndexService.findAll();
            collIndexData = this.collectionIndexElasticSearchService.getWardWiseTableDataAcrossCities(collectionDetailsRequest, cities);
        } else {
            collIndexData = this.collectionIndexElasticSearchService.getResponseTableData(collectionDetailsRequest, isForMISReports);
        }
        collectionIndexDetails.setResponseDetails(collIndexData);
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        collectionIndexDetails.setErrorDetails(errorDetails);
        return collectionIndexDetails;
    }

    public CollReceiptDetails getReceiptDetails(CollectionDetailsRequest collectionDetailsRequest) {
        CollReceiptDetails receiptDetails = new CollReceiptDetails();
        this.collectionIndexElasticSearchService.getTotalReceiptsCount(collectionDetailsRequest, receiptDetails);
        List<ReceiptsTrend> receiptTrends = this.collectionIndexElasticSearchService.getMonthwiseReceiptsTrend(collectionDetailsRequest);
        List<ReceiptTableData> receiptTableData = this.collectionIndexElasticSearchService.getReceiptTableData(collectionDetailsRequest);
        receiptDetails.setReceiptDetails(receiptTableData);
        receiptDetails.setReceiptsTrends(receiptTrends);
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        receiptDetails.setErrorDetails(errorDetails);
        return receiptDetails;
    }

    public TaxPayerResponseDetails getTopTenTaxProducers(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.getTopTenTaxPerformers(collectionDetailsRequest);
    }

    public TaxPayerResponseDetails getBottomTenTaxProducers(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.getBottomTenTaxPerformers(collectionDetailsRequest);
    }

    public List<TaxDefaulters> getTaxDefaulters(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        return this.propertyTaxElasticSearchIndexService.getTopDefaulters(propertyTaxDefaultersRequest);
    }

    public List<DCBDetails> getDCBDetails(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.getDCBDetails(collectionDetailsRequest);
    }

    public CollectionAnalysis getCollectionAnalysisData(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        return this.collectionIndexElasticSearchService.getCollectionsForInterval(collectionDetailsRequest, intervalType);
    }

    public List<WeeklyDCB> getWeekwiseDCBDetails(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        return this.collectionIndexElasticSearchService.getWeekwiseDCBDetailsAcrossCities(collectionDetailsRequest, intervalType);
    }

    public List<MonthlyDCB> getMonthwiseDCBDetails(CollectionDetailsRequest collectionDetailsRequest, String intervalType) {
        return this.collectionIndexElasticSearchService.getMonthwiseDCBDetailsAcrossCities(collectionDetailsRequest, intervalType);
    }

    public CollectionDetails getDailyTarget(CollectionDetailsRequest collectionDetailsRequest) {
        CollectionDetails collectionIndexDetails = new CollectionDetails();
        collectionIndexDetails.setResponseDetails(this.collectionIndexElasticSearchService.getResponseTableData(collectionDetailsRequest, true));
        return collectionIndexDetails;
    }

    public List<DemandVariance> getDemandVariationDetails(CollectionDetailsRequest collectionDetailsRequest) {
        return this.propertyTaxElasticSearchIndexService.prepareDemandVariationDetails(collectionDetailsRequest);
    }
}

