/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.collection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class MutationFeeCollection
extends TaxCollection {
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTransferService propertyTransferService;
    @Autowired
    private PersistenceService<PropertyMutation, Long> propertyMutationService;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyMutation> transferWorkflowService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    private static final Logger LOGGER = Logger.getLogger(MutationFeeCollection.class);

    @Transactional
    public void updateDemandDetails(BillReceiptInfo bri) {
        PropertyMutation propertyMutation = this.propertyTransferService.getPropertyMutationByApplicationNo(this.getEgBill(bri.getBillReferenceNum()).getConsumerId());
        if (bri.getEvent().equals("RECEIPT_CREATED")) {
            if (propertyMutation != null && propertyMutation.getReceiptDate() == null && propertyMutation.getReceiptNum() == null) {
                propertyMutation.setReceiptDate(bri.getReceiptDate());
                propertyMutation.setReceiptNum(bri.getReceiptNum());
            } else if (propertyMutation != null && propertyMutation.getReceiptDate() != null && !propertyMutation.getReceiptNum().isEmpty() && this.propertyTaxCommonUtils.isReceiptCanceled(propertyMutation.getReceiptNum())) {
                propertyMutation.setReceiptDate(bri.getReceiptDate());
                propertyMutation.setReceiptNum(bri.getReceiptNum());
            } else {
                LOGGER.error((Object)("Mutation fee is already paid with  receipt : " + propertyMutation.getReceiptNum() + " for assessment : " + propertyMutation.getBasicProperty().getUpicNo()));
                throw new ValidationException(new ValidationError[0]);
            }
        }
        if ("Closed".equalsIgnoreCase(propertyMutation.getCurrentState().getValue())) {
            LOGGER.error((Object)("Mutation workflow is already closed for the receipt : " + propertyMutation.getReceiptNum() + " payed for assessment : " + propertyMutation.getBasicProperty().getUpicNo()));
            throw new ValidationException(new ValidationError[0]);
        }
        this.updateTransitionForFullTransfer(bri, propertyMutation);
        this.propertyMutationService.persist((Object)propertyMutation);
        this.propertyMutationService.getSession().flush();
    }

    private void updateTransitionForFullTransfer(BillReceiptInfo bri, PropertyMutation propertyMutation) {
        if (bri.getEvent().equals("RECEIPT_CREATED") && propertyMutation.getType().equalsIgnoreCase("FULL TRANSFER") && !"Transfer Fee Collected".equalsIgnoreCase(propertyMutation.getCurrentState().getValue())) {
            WorkFlowMatrix wFMatrix = this.transferWorkflowService.getWfMatrix(propertyMutation.getStateType(), null, null, propertyMutation.getType(), propertyMutation.getCurrentState().getValue(), null);
            propertyMutation.transition().progressWithStateCopy().withSenderName(propertyMutation.getState().getSenderName()).withDateInfo(new Date()).withOwner(propertyMutation.getState().getOwnerPosition()).withStateValue("Transfer Fee Collected").withNextAction(wFMatrix.getNextAction());
        }
    }

    protected Module module() {
        return this.moduleDao.getModuleByName("Property Tax");
    }

    private EgBill getEgBill(String billRefNo) {
        return this.egBillDAO.findById(Long.valueOf(billRefNo), false);
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return null;
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        return new ReceiptAmountInfo();
    }
}

