/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.demand.model.EgDemandReasonDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.repository.AppConfigValueRepository;
import org.egov.infra.admin.master.repository.ModuleRepository;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.repository.master.taxrates.TaxRatesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TaxRatesService {
    private final TaxRatesRepository taxRatesRepository;
    @Autowired
    public AppConfigValueRepository appConfigValueRepository;
    @Autowired
    public ModuleRepository moduleRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="egDemandReasonDetailsService")
    private PersistenceService<EgDemandReasonDetails, Long> egDemandReasonDetailsService;
    protected static final Map<String, String> TAX_RATES_MAP = ImmutableMap.of((Object)"VAC_LAND_TAX", (Object)"Vacant Land Tax", (Object)"TOT_RESD_TAX", (Object)"Total Residential Tax", (Object)"LIB_CESS", (Object)"Library Cess", (Object)"TOT_NR_RESD_TAX", (Object)"Total Non Residential Tax", (Object)"EDU_CESS", (Object)"Education Cess");

    @Autowired
    public TaxRatesService(TaxRatesRepository taxRatesRepository) {
        this.taxRatesRepository = taxRatesRepository;
    }

    public List<AppConfigValues> getAllTaxRates() {
        return this.taxRatesRepository.findAll();
    }

    public Map<String, Double> getTaxDetails() {
        List<AppConfigValues> taxRates = this.getAllTaxRates();
        HashMap<String, Double> taxRatesMap = new HashMap<String, Double>();
        for (AppConfigValues appConfig : taxRates) {
            String[] rows;
            for (String row : rows = appConfig.getValue().split("\n")) {
                String[] value = row.split("=");
                if (PropertyTaxConstants.TAX_RATES_TEMP.contains(value[0])) continue;
                taxRatesMap.put(PropertyTaxConstants.TAX_RATES.get(value[0]), Double.parseDouble(value[1]));
            }
        }
        LinkedHashMap<String, Double> taxRatesDisplayMap = new LinkedHashMap<String, Double>();
        taxRatesDisplayMap.put("General Tax Residential", (Double)taxRatesMap.get("General Tax Residential"));
        taxRatesDisplayMap.put("General Tax Non Residential", (Double)taxRatesMap.get("General Tax Non Residential"));
        taxRatesDisplayMap.put("Education Cess", (Double)taxRatesMap.get("Education Cess"));
        taxRatesDisplayMap.put("Vacant Land Tax", (Double)taxRatesMap.get("Vacant Land Tax"));
        taxRatesDisplayMap.put("Library Cess", (Double)taxRatesMap.get("Library Cess"));
        return taxRatesDisplayMap;
    }

    @Transactional
    public void updateTaxRateAppconfig(AppConfigValues appConfigValue) {
        this.appConfigValueRepository.save((Object)appConfigValue);
    }

    public List<EgDemandReasonDetails> getTaxRates() {
        Query query = this.entityManager.createNamedQuery("DEMANDREASONDETAILS_BY_MOUDULEID");
        query.setParameter(1, (Object)this.moduleRepository.findByName("Property Tax"));
        return query.getResultList();
    }

    public List<EgDemandReasonDetails> excludeOldTaxHeads(List<EgDemandReasonDetails> demandReasonDetailsList) {
        Iterator<EgDemandReasonDetails> excludedList = demandReasonDetailsList.iterator();
        while (excludedList.hasNext()) {
            EgDemandReasonDetails egDemandReasonDetails = excludedList.next();
            if (!TAX_RATES_MAP.containsValue(egDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster())) continue;
            excludedList.remove();
        }
        return demandReasonDetailsList;
    }

    @Transactional
    public void updateTaxRates(EgDemandReasonDetails egDemandReasonDetails) {
        this.egDemandReasonDetailsService.persist((Object)egDemandReasonDetails);
    }

    public EgDemandReasonDetails getDemandReasonDetailsById(Long id) {
        Query qry = this.entityManager.createNamedQuery("DEMANDREASONDETAILS_BY_ID");
        qry.setParameter(1, (Object)id);
        return (EgDemandReasonDetails)qry.getSingleResult();
    }
}

