/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.repository.master.structureclassification.StructureClassificationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StructureClassificationService {
    private final StructureClassificationRepository structureClassificationRepository;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;

    @Autowired
    public StructureClassificationService(StructureClassificationRepository structureClassificationRepository) {
        this.structureClassificationRepository = structureClassificationRepository;
    }

    @Transactional
    public StructureClassification create(StructureClassification structureClassification) {
        this.structureClassificationRepository.save((Object)structureClassification);
        return structureClassification;
    }

    public Installment getInstallment() {
        Module module = this.moduleService.getModuleByName("Property Tax");
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        return installment;
    }

    public List<StructureClassification> getAllActiveStructureTypes() {
        return this.structureClassificationRepository.findByIsActiveTrueOrderByTypeName();
    }

    public StructureClassification findOne(Long id) {
        return (StructureClassification)((Object)this.structureClassificationRepository.findOne(id));
    }

    @Transactional
    public void update(StructureClassification structureClassification) {
        this.structureClassificationRepository.save((Object)structureClassification);
    }

    public List<String> validateUpdateClassification(StructureClassification structureClassification) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.structureClassificationRepository.findByCodeAndNotInId(structureClassification.getConstrTypeCode(), structureClassification.getId()).isEmpty()) {
            errors.add("error.duplicate.struc.code");
        } else if (!this.structureClassificationRepository.findByNameAndNotInId(structureClassification.getTypeName(), structureClassification.getId()).isEmpty()) {
            errors.add("error.duplicate.structure");
        } else if (!this.structureClassificationRepository.findByUsageUnitRateActive(structureClassification.getId()).isEmpty() && !structureClassification.getIsActive().booleanValue()) {
            errors.add("error.active.unitrates.exist.forstructure");
        }
        return errors;
    }

    public List<StructureClassification> getAllStructureTypes() {
        return this.structureClassificationRepository.findAll();
    }

    public Boolean isActiveClassification(String code) {
        return this.structureClassificationRepository.findIsActiveByCode(code);
    }

    public StructureClassification getClassificationByCode(String code) {
        return this.structureClassificationRepository.findClassificationByCode(code);
    }
}

