/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.event;

import java.math.BigInteger;
import java.util.Random;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.event.model.MutationEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class MutationEventPublisher {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public void publishEvent(PropertyMutation propertyMutation) {
        MutationEvent event = new MutationEvent(this, propertyMutation);
        BasicProperty basicProperty = propertyMutation.getBasicProperty();
        event.setCityCode(ApplicationThreadLocals.getCityCode());
        event.setPropertyType(basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster().getCode());
        event.setOwnerName(basicProperty.getFullOwnerName());
        event.setAadharNumber(basicProperty.getAadharNumber());
        event.setMobileNumber(basicProperty.getMobileNumber());
        event.setSurveyNumber(basicProperty.getActiveProperty().getPropertyDetail().getSurveyNumber());
        event.setDistrictCode("510");
        event.setCityCode("251744");
        event.setWard(String.valueOf(basicProperty.getPropertyID().getWard().getBoundaryNum()));
        event.setBlock(String.valueOf(basicProperty.getPropertyID().getArea().getBoundaryNum()));
        event.setDoorNumber(basicProperty.getAddress().getHouseNoBldgApt());
        event.setLayoutNumber(basicProperty.getActiveProperty().getPropertyDetail().getLayoutPermitNo());
        event.setRandom(new BigInteger(32, new Random()));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
    }
}

