/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.revisionPetition;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.bean.PropertyNoticeInfo;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class RevisionPetitionService
extends PersistenceService<RevisionPetition, Long> {
    private static final String REVISION_PETITION_CREATED = "CREATED";
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    @Autowired
    DesignationService designationService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    private static final String CURRENT = "current";
    private static final String HISTORY = "history";
    @Autowired
    private NotificationService notificationService;
    private SMSEmailService sMSEmailService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private UserService userService;
    @Autowired
    private CityService cityService;

    public RevisionPetitionService() {
        super(RevisionPetition.class);
    }

    public RevisionPetitionService(Class<RevisionPetition> type) {
        super(type);
    }

    @Transactional
    public RevisionPetition createRevisionPetition(RevisionPetition objection) {
        this.propertyService.processAndStoreDocument(objection.getDocuments());
        RevisionPetition revisionPetition = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.merge((Object)objection));
        return revisionPetition;
    }

    @Transactional
    public RevisionPetition createRevisionPetitionForRest(RevisionPetition objection) {
        Position position = null;
        WorkFlowMatrix wfmatrix = null;
        User user = null;
        if (objection.getId() == null) {
            if (objection.getObjectionNumber() == null) {
                objection.setObjectionNumber(this.applicationNumberGenerator.generate());
            }
            objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("OBJECTED"));
            objection.getBasicProperty().setUnderWorkflow(Boolean.TRUE);
            if (objection.getState() == null) {
                wfmatrix = this.revisionPetitionWorkFlowService.getWfMatrix(objection.getStateType(), null, null, null, "Revision Petition:CREATED", null);
                Designation desig = this.designationService.getDesignationByName("Revenue Clerk");
                List assignment = this.assignmentService.findByDesignationAndBoundary(desig.getId(), objection.getBasicProperty().getPropertyID().getZone().getId());
                if (!assignment.isEmpty()) {
                    position = ((Assignment)assignment.get(0)).getPosition();
                } else {
                    assignment = this.assignmentService.findPrimaryAssignmentForDesignationName("Revenue Clerk");
                    if (!assignment.isEmpty()) {
                        position = ((Assignment)assignment.get(0)).getPosition();
                    }
                }
                this.updateRevisionPetitionStatus(wfmatrix, objection, null);
                if (position != null) {
                    user = this.eisCommonService.getUserForPosition(position.getId(), new Date());
                }
                objection.transition().start().withNextAction(wfmatrix.getPendingActions()).withStateValue(wfmatrix.getCurrentState()).withOwner((OwnerGroup)position).withSenderName(user != null && user.getName() != null ? user.getName() : "").withOwner(user).withComments("");
            }
            this.applyAuditing((AbstractAuditable)objection.getState());
            objection = (RevisionPetition)((Object)this.persist((Object)objection));
            this.updateIndex(objection);
            this.sendEmailandSms(objection, REVISION_PETITION_CREATED);
        } else {
            objection = (RevisionPetition)((Object)this.merge((Object)objection));
        }
        return objection;
    }

    private void updateIndex(RevisionPetition objection) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(objection.getObjectionNumber());
        User user = this.securityUtils.getCurrentUser();
        if (null == applicationIndex) {
            applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(objection.getObjectionNumber()).withApplicationDate(objection.getCreatedDate() != null ? objection.getCreatedDate() : new Date()).withApplicationType("Revision_Petition").withApplicantName(objection.getBasicProperty().getFullOwnerName()).withStatus(objection.getState().getValue()).withUrl(String.format("/ptis/view/viewProperty-viewForm.action?applicationNo=%s&applicationType=%s", objection.getObjectionNumber(), "")).withApplicantAddress(objection.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(Source.SYSTEM.toString()).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
        } else {
            applicationIndex.setStatus(objection.getState().getValue());
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
        }
    }

    private void updateRevisionPetitionStatus(WorkFlowMatrix wfmatrix, RevisionPetition objection, String status) {
        EgwStatus egwStatus = null;
        if (StringUtils.isNotBlank((CharSequence)status)) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", status);
        } else if (wfmatrix != null && wfmatrix.getNextStatus() != null && objection != null) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", wfmatrix.getNextStatus());
        }
        if (egwStatus != null) {
            objection.setEgwStatus(egwStatus);
        }
    }

    @Transactional
    public RevisionPetition updateRevisionPetition(RevisionPetition objection) {
        RevisionPetition revisionPetition = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.update((Object)objection));
        return revisionPetition;
    }

    public RevisionPetition getRevisionPetitionByApplicationNumber(String applicationNumber) {
        Criteria appCriteria = this.getSession().createCriteria(RevisionPetition.class, "revPetiton");
        appCriteria.add((Criterion)Restrictions.eq((String)"revPetiton.objectionNumber", (Object)applicationNumber));
        RevisionPetition revPetitionObject = (RevisionPetition)((Object)appCriteria.uniqueResult());
        return revPetitionObject;
    }

    public void sendEmailandSms(RevisionPetition objection, String applicationType) {
        if (objection != null) {
            for (PropertyOwnerInfo ownerInfo : objection.getBasicProperty().getPropertyOwnerInfo()) {
                this.sendEmailAndSms(objection, ownerInfo.getOwner(), applicationType);
            }
        }
    }

    private void sendEmailAndSms(RevisionPetition objection, User user, String applicationType) {
        String mobileNumber = user.getMobileNumber();
        String emailid = user.getEmailId();
        String applicantName = user.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(applicantName);
        String smsMsg = "";
        String emailSubject = "";
        String emailBody = "";
        if (applicationType != null && applicationType.equalsIgnoreCase(REVISION_PETITION_CREATED)) {
            args.add(objection.getObjectionNumber());
            if (mobileNumber != null) {
                smsMsg = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
            }
            if (emailid != null) {
                emailSubject = "Revision petition created.";
                emailBody = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber) && StringUtils.isNotBlank((CharSequence)smsMsg)) {
            this.notificationService.sendSMS(mobileNumber, smsMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)emailid) && StringUtils.isNotBlank((CharSequence)emailBody)) {
            this.notificationService.sendEmail(emailid, emailSubject, emailBody);
        }
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }

    public RevisionPetition createRevisionPetition(RevisionPetition objection, HashMap<String, String> meesevaParams) {
        this.createRevisionPetition(objection);
        return objection;
    }

    public Assignment getWorkflowInitiator(RevisionPetition objection) {
        Assignment wfInitiator = this.propertyService.isEmployee(objection.getCreatedBy()).booleanValue() && !"Anonymous".equalsIgnoreCase(objection.getCreatedBy().getName()) && !this.propertyService.isCitizenPortalUser(objection.getCreatedBy()).booleanValue() ? (objection.getState() != null && objection.getState().getInitiatorPosition() != null ? this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(objection.getCreatedBy(), (Position)objection.getState().getInitiatorPosition()) : (Assignment)this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(objection.getCreatedBy().getId()).get(0)) : (!objection.getStateHistory().isEmpty() ? (objection.getState().getInitiatorPosition() == null ? (Assignment)this.assignmentService.getAssignmentsForPosition(((Position)((StateHistory)objection.getStateHistory().get(0)).getOwnerPosition()).getId(), new Date()).get(0) : (Assignment)this.assignmentService.getAssignmentsForPosition(((Position)objection.getState().getInitiatorPosition()).getId(), new Date()).get(0)) : (Assignment)this.assignmentService.getAssignmentsForPosition(((Position)objection.getState().getOwnerPosition()).getId(), new Date()).get(0));
        return wfInitiator;
    }

    public RevisionPetition getExistingObjections(BasicProperty basicProperty) {
        return (RevisionPetition)((Object)this.find("from RevisionPetition rp where rp.basicProperty = ?", new Object[]{basicProperty}));
    }

    public RevisionPetition getExistingGRP(BasicProperty basicProperty) {
        return (RevisionPetition)((Object)this.find("from RevisionPetition rp where rp.basicProperty = ? and rp.type = ?", new Object[]{basicProperty, "GRP"}));
    }

    public ReportOutput createHearingNoticeReport(ReportOutput reportOutput, RevisionPetition objection, String noticeNo) {
        reportOutput.setReportFormat(ReportFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (objection != null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = StringUtils.isNotBlank(cityGrade) && cityGrade.equalsIgnoreCase("Corp");
            String natureOfWork = "RP".equalsIgnoreCase(objection.getType()) ? "Revision Petition" : "General Revision Petition";
            reportParams.put("isCorporation", isCorporation);
            reportParams.put("cityName", cityName);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            reportParams.put("natureOfWork", natureOfWork);
            if (objection.getHearings() != null && !objection.getHearings().isEmpty() && objection.getHearings().get(objection.getHearings().size() - 1).getPlannedHearingDt() != null) {
                reportParams.put("hearingNoticeDate", DateUtils.toDefaultDateFormat((Date)objection.getHearings().get(objection.getHearings().size() - 1).getPlannedHearingDt()));
            } else {
                reportParams.put("hearingNoticeDate", "");
            }
            reportParams.put("currentDate", DateUtils.toDefaultDateFormat((Date)new Date()));
            reportParams.put("recievedOn", DateUtils.toDefaultDateFormat((Date)objection.getRecievedOn()));
            reportParams.put("docNumberObjection", noticeNo);
            reportParams.put("houseNo", objection.getBasicProperty().getAddress().getHouseNoBldgApt());
            reportParams.put("locality", objection.getBasicProperty().getPropertyID().getLocality().getName());
            reportParams.put("assessmentNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("hearingTime", objection.getHearings().get(objection.getHearings().size() - 1).getHearingTime());
            reportParams.put("hearingVenue", objection.getHearings().get(objection.getHearings().size() - 1).getHearingVenue());
            ReportRequest reportRequest = new ReportRequest("mainHearingNotice", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }

    public ReportOutput createEndoresement(ReportOutput reportOutput, RevisionPetition objection) {
        reportOutput.setReportFormat(ReportFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (objection != null) {
            Map<String, BigDecimal> currentDemand = this.ptDemandDAO.getDemandCollMap(objection.getProperty());
            Map<String, BigDecimal> earlierDemand = this.ptDemandDAO.getDemandCollMap(this.propertyService.getLatestHistoryProperty(objection.getBasicProperty().getUpicNo()));
            String natureOfWork = "RP".equalsIgnoreCase(objection.getType()) ? "Revision Petition" : "General Revision Petition";
            reportParams.put("logoPath", this.cityService.getCityLogoURL());
            reportParams.put("cityName", this.cityService.getMunicipalityName());
            reportParams.put("natureOfWork", natureOfWork);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            reportParams.put("docNumberObjection", objection.getObjectionNumber());
            reportParams.put("currentDate", DateUtils.toDefaultDateFormat((Date)new Date()));
            reportParams.put("receivedOn", DateUtils.toDefaultDateFormat((Date)objection.getRecievedOn()));
            reportParams.put("HouseNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("wardNumber", objection.getBasicProperty().getBoundary() != null ? objection.getBasicProperty().getBoundary().getName() : "");
            reportParams.put("HalfYearPropertyTaxTo", currentDemand.get("CURR_SECONDHALF_DMD").divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("HalfYearPropertyTaxFrom", earlierDemand.get("CURR_SECONDHALF_DMD").divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("AnnualPropertyTaxTo", currentDemand.get("CURR_SECONDHALF_DMD").setScale(2).toString());
            reportParams.put("AnnualPropertyTaxFrom", earlierDemand.get("CURR_SECONDHALF_DMD").setScale(2).toString());
            ReportRequest reportRequest = new ReportRequest("revPetitionEndorsement", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }

    public void setNoticeInfo(PropertyImpl property, PropertyNoticeInfo propertyNotice, BasicPropertyImpl basicProperty, RevisionPetition objection) {
        PropertyAckNoticeInfo infoBean = new PropertyAckNoticeInfo();
        PropertyAddress ownerAddress = basicProperty.getAddress();
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal propertyTax = BigDecimal.ZERO;
        if (basicProperty.getPropertyOwnerInfo().size() > 1) {
            infoBean.setOwnerName(basicProperty.getFullOwnerName().concat(" and others"));
        } else {
            infoBean.setOwnerName(basicProperty.getFullOwnerName());
        }
        infoBean.setOwnerAddress(basicProperty.getAddress().toString());
        infoBean.setApplicationNo(property.getApplicationNo());
        infoBean.setDoorNo(ownerAddress.getHouseNoBldgApt());
        if (StringUtils.isNotBlank((CharSequence)ownerAddress.getLandmark())) {
            infoBean.setStreetName(ownerAddress.getLandmark());
        } else {
            infoBean.setStreetName("N/A");
        }
        SimpleDateFormat formatNowYear = new SimpleDateFormat("yyyy");
        String occupancyYear = formatNowYear.format(basicProperty.getPropOccupationDate());
        infoBean.setInstallmentYear(occupancyYear);
        infoBean.setAssessmentNo(basicProperty.getUpicNo());
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
        infoBean.setAssessmentDate(dateformat.format(basicProperty.getAssessmentdate()));
        Ptdemand currDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        this.prepareTaxInfoForProperty(infoBean, totalTax, propertyTax, currDemand, CURRENT);
        if (currDemand.getDmdCalculations() != null && currDemand.getDmdCalculations().getAlv() != null) {
            infoBean.setNew_rev_ARV(currDemand.getDmdCalculations().getAlv());
        }
        PropertyImpl historyProperty = this.propertyService.getLatestHistoryProperty(basicProperty.getUpicNo());
        Ptdemand historyDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(historyProperty);
        if (historyProperty != null && historyDemand != null) {
            totalTax = BigDecimal.ZERO;
            propertyTax = BigDecimal.ZERO;
            this.prepareTaxInfoForProperty(infoBean, totalTax, propertyTax, historyDemand, HISTORY);
            if (historyDemand.getDmdCalculations() != null && historyDemand.getDmdCalculations().getAlv() != null) {
                infoBean.setExistingARV(historyDemand.getDmdCalculations().getAlv());
            }
        }
        PropertyID boundaryDetails = basicProperty.getPropertyID();
        infoBean.setZoneName(boundaryDetails.getZone().getName());
        infoBean.setWardName(boundaryDetails.getWard().getName());
        infoBean.setAreaName(boundaryDetails.getArea().getName());
        infoBean.setLocalityName(boundaryDetails.getLocality().getName());
        infoBean.setNoticeDate(new Date());
        infoBean.setApplicationDate(DateUtils.getFormattedDate((Date)objection.getCreatedDate(), (String)"dd/MM/yyyy"));
        infoBean.setHearingDate(DateUtils.getFormattedDate((Date)objection.getHearings().get(0).getPlannedHearingDt(), (String)"dd/MM/yyyy"));
        infoBean.setActualHearingDate(DateUtils.getFormattedDate((Date)objection.getHearings().get(0).getActualHearingDt(), (String)"dd/MM/yyyy"));
        User approver = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        infoBean.setApproverName(approver.getName());
        BigDecimal revTax = currDemand.getBaseDemand();
        infoBean.setNewTotalTax(revTax);
        if (property.getSource().equals("MEESEVA")) {
            infoBean.setMeesevaNo(property.getApplicationNo());
        }
        propertyNotice.setOwnerInfo(infoBean);
    }

    private void prepareTaxInfoForProperty(PropertyAckNoticeInfo infoBean, BigDecimal totalTax, BigDecimal propertyTax, Ptdemand currDemand, String propertyType) {
        for (EgDemandDetails demandDetail : currDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentPeriodInstallment())) continue;
            totalTax = totalTax.add(demandDetail.getAmount());
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("EDU_CESS")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            this.setLibraryCess(infoBean, propertyType, demandDetail);
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("GEN_TAX") || demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("VAC_LAND_TAX")) {
                propertyTax = propertyTax.add(demandDetail.getAmount());
            }
            this.setUCPenalty(infoBean, propertyType, demandDetail);
        }
        this.setTotalTax(infoBean, totalTax, propertyTax, propertyType);
    }

    private void setTotalTax(PropertyAckNoticeInfo infoBean, BigDecimal totalTax, BigDecimal propertyTax, String propertyType) {
        if (propertyType.equalsIgnoreCase(CURRENT)) {
            infoBean.setRevTotalTax(totalTax);
            infoBean.setRevPropertyTax(propertyTax);
        }
        if (propertyType.equalsIgnoreCase(HISTORY)) {
            infoBean.setExistingTotalTax(totalTax);
            infoBean.setExistingPropertyTax(propertyTax);
        }
    }

    private void setLibraryCess(PropertyAckNoticeInfo infoBean, String propertyType, EgDemandDetails demandDetail) {
        if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("LIB_CESS")) {
            if (propertyType.equalsIgnoreCase(CURRENT)) {
                infoBean.setRevLibraryCess(demandDetail.getAmount());
            }
            if (propertyType.equalsIgnoreCase(HISTORY)) {
                infoBean.setExistingLibraryCess(demandDetail.getAmount());
            }
        }
    }

    private void setUCPenalty(PropertyAckNoticeInfo infoBean, String propertyType, EgDemandDetails demandDetail) {
        if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("UNAUTH_PENALTY")) {
            if (propertyType.equalsIgnoreCase(CURRENT)) {
                infoBean.setRevUCPenalty(demandDetail.getAmount());
            }
            if (propertyType.equalsIgnoreCase(HISTORY)) {
                infoBean.setExistingUCPenalty(demandDetail.getAmount());
            }
        }
    }
}

