/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.ServiceTypeReportResponse;
import org.egov.ptis.domain.entity.property.WardWiseServiceReponse;
import org.egov.ptis.domain.entity.property.WardWiseServiceTypeRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;

@Service
public class ServiceTypeReportService {
    private static final String TAX_BEFORE_AFFECTED = "taxBeforeAffctd";
    private static final String TAX_AFTER_AFFECTED = "taxAfterAffctd";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String APPLICATION_DATE = "applicationDate";
    private static final String REVENUE_WARD = "ward";
    private static final String WARDGROUPING = "wardgrouping";
    private static final String STATUSGROUPING = "statusgrouping";
    private static final String PROPERTYTYPE = "propertyType";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public ServiceTypeReportResponse getDetails(WardWiseServiceTypeRequest serviceRequest) {
        ServiceTypeReportResponse wardResponse = new ServiceTypeReportResponse();
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotBlank((String)serviceRequest.getFromDate()) && StringUtils.isNotBlank((String)serviceRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)serviceRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.getDate((String)serviceRequest.getToDate(), (String)"yyyy-MM-dd");
        }
        Map<String, Map<String, List<Long>>> map = this.getDocMap(fromDate, toDate, serviceRequest);
        Set<String> wardNames = map.keySet();
        ArrayList<WardWiseServiceReponse> responseList = new ArrayList<WardWiseServiceReponse>();
        wardNames.stream().forEach(ward -> {
            WardWiseServiceReponse serviceWiseResponse = new WardWiseServiceReponse();
            Map statusMap = (Map)map.get(ward);
            if (statusMap != null) {
                serviceWiseResponse.setCountFieldValues(statusMap);
            }
            serviceWiseResponse.setRevenueWard((String)ward);
            responseList.add(serviceWiseResponse);
        });
        wardResponse.setServiceWiseResponse(responseList);
        return wardResponse;
    }

    private BoolQueryBuilder getBoolQuery(Date fromDate, Date toDate, WardWiseServiceTypeRequest serviceRequest) {
        String serviceType;
        BoolQueryBuilder boolQuery = this.getSearchFilterQuery(serviceRequest, fromDate, toDate);
        String propertyType = serviceRequest.getPropertyType();
        if (StringUtils.isNotBlank((String)propertyType)) {
            boolQuery = this.getQueryForProperties(propertyType, boolQuery);
        }
        if (StringUtils.isNotBlank((String)(serviceType = serviceRequest.getServiceType()))) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_TYPE, (Object)serviceType));
        }
        return boolQuery;
    }

    private Map<String, Map<String, List<Long>>> getDocMap(Date fromDate, Date toDate, WardWiseServiceTypeRequest serviceRequest) {
        AggregationBuilder aggregationBuilder = ((TermsBuilder)AggregationBuilders.terms((String)WARDGROUPING).field(REVENUE_WARD)).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)STATUSGROUPING).field("appStatus")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TAX_BEFORE_AFFECTED).field(TAX_BEFORE_AFFECTED))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TAX_AFTER_AFFECTED).field(TAX_AFTER_AFFECTED)));
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"ptservicetype"}).setQuery((QueryBuilder)this.getBoolQuery(fromDate, toDate, serviceRequest)).addAggregation((AbstractAggregationBuilder)aggregationBuilder).execute().actionGet();
        Terms aggTerms = (Terms)response.getAggregations().get(WARDGROUPING);
        HashMap<String, Map<String, List<Long>>> statusMap = new HashMap<String, Map<String, List<Long>>>();
        aggTerms.getBuckets().forEach(bucket -> {
            HashMap statusMap1 = new HashMap();
            Terms aggregations = (Terms)bucket.getAggregations().get(STATUSGROUPING);
            aggregations.getBuckets().forEach(bucket1 -> {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(bucket1.getDocCount());
                Sum agg1 = (Sum)bucket1.getAggregations().get(TAX_BEFORE_AFFECTED);
                long value = (long)agg1.getValue();
                list.add(value);
                Sum agg2 = (Sum)bucket1.getAggregations().get(TAX_AFTER_AFFECTED);
                long value1 = (long)agg2.getValue();
                list.add(value1);
                statusMap1.put(bucket1.getKeyAsString(), list);
            });
            statusMap.put(bucket.getKeyAsString(), statusMap1);
        });
        return statusMap;
    }

    public BoolQueryBuilder getSearchFilterQuery(WardWiseServiceTypeRequest wardWiseRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)ApplicationThreadLocals.getCityCode())).filter((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)));
        if (StringUtils.isNotBlank((String)wardWiseRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REVENUE_WARD, (Object)wardWiseRequest.getRevenueWard()));
        }
        return boolQuery;
    }

    public BoolQueryBuilder getQueryForProperties(String propertyType, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder propertyTypeQuery = boolQuery;
        if ("VLT".equalsIgnoreCase(propertyType)) {
            propertyTypeQuery = propertyTypeQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)PROPERTYTYPE, (Object)1));
        }
        if ("PT".equalsIgnoreCase(propertyType)) {
            propertyTypeQuery = propertyTypeQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)PROPERTYTYPE, (Object)1));
        }
        return propertyTypeQuery;
    }
}

