/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.reassign;

import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.bean.ReassignInfo;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReassignService {
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<StateAware> propertyWorkflowService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private VacancyRemissionService vacancyRemissionService;
    @Autowired
    private PersistenceService<StateAware, Long> persistenceService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    private PropertyService propertyService;

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public Boolean getStateObject(ReassignInfo reassignInfo, Position position) {
        VacancyRemission stateAware;
        Long stateAwareId = reassignInfo.getStateAwareId();
        String transactionType = reassignInfo.getTransactionType();
        if ("Vacancy_Remission".equalsIgnoreCase(transactionType)) {
            stateAware = this.vacancyRemissionService.getVacancyRemissionById(stateAwareId);
        } else if ("Transfer_of_Ownership".equalsIgnoreCase(transactionType)) {
            stateAware = (StateAware)this.persistenceService.find("From PropertyMutation where id = ? ", new Object[]{stateAwareId});
        } else if ("GENERAL REVISION PETITION".equalsIgnoreCase(transactionType) || "REVISION PETITION".equalsIgnoreCase(transactionType)) {
            stateAware = (StateAware)this.revisionPetitionService.findById(stateAwareId, false);
            transactionType = transactionType.equalsIgnoreCase("REVISION PETITION") ? "Revision_Petition" : "General_Revision_Petition";
        } else {
            stateAware = (StateAware)this.persistenceService.findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{(long)stateAwareId});
        }
        stateAware.transition().progressWithStateCopy().withOwner((OwnerGroup)position).withInitiator((OwnerGroup)position);
        this.propertyService.updateIndexes(stateAware, transactionType);
        this.persistenceService.persist((Object)stateAware);
        return true;
    }

    public boolean isReassignEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PTIS_REASSIGN_REQUIRED");
        return !appConfigValues.isEmpty() && "Y".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }
}

