/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;
import org.egov.ptis.domain.repository.vacancyremission.VacancyRemissionApprovalRepository;
import org.egov.ptis.domain.repository.vacancyremission.VacancyRemissionRepository;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
@Transactional(readOnly=true)
public class VacancyRemissionService {
    public static final String REJECTION_ACK_TEMPLATE = "vacancyRemission_rejectionAck";
    private static final Logger LOG = LoggerFactory.getLogger(VacancyRemissionService.class);
    @Autowired
    private VacancyRemissionRepository vacancyRemissionRepository;
    @Autowired
    private VacancyRemissionApprovalRepository vacancyRemissionApprovalRepository;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<VacancyRemission> vacancyRemissionWorkflowService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource ptisMessageSource;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private ReportService reportService;
    @Autowired
    private UserService userService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;

    public VacancyRemission getApprovedVacancyRemissionForProperty(String upicNo) {
        return this.vacancyRemissionRepository.findByUpicNo(upicNo);
    }

    public VacancyRemission getLatestRejectAckGeneratedVacancyRemissionForProperty(String upicNo) {
        VacancyRemission vacancyRemission = null;
        List<VacancyRemission> rejectedRemissionList = this.vacancyRemissionRepository.findAllRejectionAckGeneratedForUpicNo(upicNo);
        if (!rejectedRemissionList.isEmpty()) {
            vacancyRemission = rejectedRemissionList.get(0);
        }
        return vacancyRemission;
    }

    public VacancyRemission getLatestSpecialNoticeGeneratedVacancyRemissionForProperty(String upicNo) {
        VacancyRemission vacancyRemission = null;
        List<VacancyRemission> approvedRemissionList = this.vacancyRemissionRepository.findAllSpecialNoticesGeneratedForUpicNo(upicNo);
        if (!approvedRemissionList.isEmpty()) {
            vacancyRemission = approvedRemissionList.get(0);
        }
        return vacancyRemission;
    }

    public VacancyRemission getVacancyRemissionById(Long id) {
        return (VacancyRemission)((Object)this.vacancyRemissionRepository.findOne(id));
    }

    public List<VacancyRemission> getAllVacancyRemissionByUpicNo(String upicNo) {
        return this.vacancyRemissionRepository.getAllVacancyRemissionByUpicNo(upicNo);
    }

    public VacancyRemission getRejectedVacancyRemissionForProperty(String upicNo) {
        return this.vacancyRemissionRepository.findRejectedByUpicNo(upicNo);
    }

    @Transactional
    public VacancyRemission saveVacancyRemission(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee) {
        String currentState;
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String approverDesignation = "";
        String nextAction = null;
        String loggedInUserDesignation = this.getLoggedInUserDesignation(vacancyRemission, user);
        String loggedInUserDesig = "";
        if (vacancyRemission.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(((Position)vacancyRemission.getCurrentState().getOwnerPosition()).getId(), user.getId(), new Date());
            String string = loggedInUserDesig = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : "";
        }
        if ("ONLINE".equalsIgnoreCase(vacancyRemission.getSource()) && ApplicationThreadLocals.getUserId() == null) {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
        }
        if (this.propertyService.isCitizenPortalUser(user).booleanValue() || !propertyByEmployee.booleanValue() || "Anonymous".equalsIgnoreCase(user.getName())) {
            Assignment assignment;
            currentState = "Created";
            wfInitiator = this.propertyService.isCscOperator(user) != false ? (assignment = this.propertyService.getMappedAssignmentForCscOperator(vacancyRemission.getBasicProperty())) : (assignment = this.propertyService.getUserPositionByZone(vacancyRemission.getBasicProperty(), false));
            if (null != assignment) {
                approvalPosition = assignment.getPosition().getId();
            }
        } else {
            currentState = null;
            if (null != approvalPosition && approvalPosition != 0L) {
                Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date()).get(0);
                assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                approverDesignation = assignment.getDesignation().getName();
            }
        }
        if ("Forward".equalsIgnoreCase(workFlowAction) && (vacancyRemission.getId() == null || PropertyTaxConstants.ASSISTANT_DESIGNATIONS.contains(loggedInUserDesig)) && PropertyTaxConstants.COMMISSIONER_DESIGNATIONS.contains(approverDesignation)) {
            String designation = approverDesignation.split(" ")[0];
            nextAction = this.getWorkflowNextAction(designation);
        }
        if (vacancyRemission.getId() != null && (workFlowAction.equalsIgnoreCase("Reject") || workFlowAction.equalsIgnoreCase("Generate Notice"))) {
            wfInitiator = this.getWorkflowInitiator(vacancyRemission);
        } else if (wfInitiator == null) {
            wfInitiator = this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        }
        if (StringUtils.isBlank((CharSequence)vacancyRemission.getApplicationNumber())) {
            vacancyRemission.setApplicationNumber(this.applicationNumberGenerator.generate());
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice")) {
            if (wfInitiator.getPosition().equals((Object)vacancyRemission.getState().getOwnerPosition())) {
                vacancyRemission.setStatus("Rejection Acknowledgement Generated");
                vacancyRemission.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNextAction(null).withOwner((OwnerGroup)((Position)null));
                vacancyRemission.getBasicProperty().setUnderWorkflow(false);
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            String stateValue = "Rejected";
            vacancyRemission.setStatus("REJECTED");
            vacancyRemission.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator.getPosition()).withNextAction("Application Rejected");
            this.buildSMS(vacancyRemission, workFlowAction);
        } else {
            WorkFlowMatrix wfmatrix;
            if (workFlowAction.equalsIgnoreCase("Forward")) {
                vacancyRemission.setStatus("IN_WORKFLOW");
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                vacancyRemission.setStatus("APPROVED");
            }
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == vacancyRemission.getState()) {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemission.getStateType(), null, null, additionalRule, currentState, null);
                if (this.propertyService.isCitizenPortalUser(this.securityUtils.getCurrentUser()).booleanValue() || !propertyByEmployee.booleanValue() || "Anonymous".equalsIgnoreCase(user.getName())) {
                    nextAction = "Assistant Forward Pending";
                }
                vacancyRemission.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(nextAction).withNatureOfTask("Vacany Remission").withInitiator((OwnerGroup)(wfInitiator != null ? wfInitiator.getPosition() : null));
                vacancyRemission.getBasicProperty().setUnderWorkflow(true);
            } else {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemission.getStateType(), null, null, additionalRule, vacancyRemission.getCurrentState().getValue(), vacancyRemission.getCurrentState().getNextAction(), null, loggedInUserDesignation);
                if (wfmatrix != null) {
                    if ("END".equalsIgnoreCase(wfmatrix.getNextAction())) {
                        vacancyRemission.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withNextAction("Monthly Update Pending");
                    } else {
                        vacancyRemission.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(nextAction == null ? wfmatrix.getNextAction() : nextAction);
                    }
                }
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    this.buildSMS(vacancyRemission, workFlowAction);
                }
            }
        }
        this.propertyService.updateIndexes(vacancyRemission, "Vacancy_Remission");
        if (Source.CITIZENPORTAL.toString().equalsIgnoreCase(vacancyRemission.getSource()) && this.propertyService.getPortalInbox(vacancyRemission.getApplicationNumber()) != null) {
            this.propertyService.updatePortal(vacancyRemission, "Vacancy_Remission");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
        return (VacancyRemission)((Object)this.vacancyRemissionRepository.save((Object)vacancyRemission));
    }

    private void updateDemandDetailsWithRebate(VacancyRemission vacancyRemission, Installment demandInstallment, Installment effectiveInstallment) {
        Set<Ptdemand> activePropPtDemandSet = vacancyRemission.getBasicProperty().getActiveProperty().getPtDemandSet();
        BigDecimal excess = BigDecimal.ZERO;
        LinkedHashSet<String> demandReasons = new LinkedHashSet<String>(Arrays.asList("GEN_TAX", "VAC_LAND_TAX", "EDU_CESS", "LIB_CESS", "UNAUTH_PENALTY"));
        Ptdemand currPtDemand = this.getCurrentPTDemand(demandInstallment, activePropPtDemandSet);
        if (currPtDemand != null) {
            Set<EgDemandDetails> effectiveInstDemandDetails = this.propertyService.getEgDemandDetailsSetByInstallment(currPtDemand.getEgDemandDetails()).get(effectiveInstallment);
            for (String demandReason : demandReasons) {
                EgDemandDetails dmdDet = this.propertyService.getEgDemandDetailsForReason(effectiveInstDemandDetails, demandReason);
                if (dmdDet == null) continue;
                dmdDet.setAmount(dmdDet.getAmount().divide(new BigDecimal("2")).setScale(0, 4));
                excess = this.adjustCollection(excess, dmdDet);
            }
            EgDemandDetails advanceDemandDetails = this.propertyService.getEgDemandDetailsForReason(effectiveInstDemandDetails, "ADVANCE");
            this.updateAdvance(currPtDemand, excess, advanceDemandDetails);
            this.ptDemandDAO.update(currPtDemand);
        }
    }

    private BigDecimal adjustCollection(BigDecimal excess, EgDemandDetails dmdDet) {
        if (dmdDet.getAmtCollected().compareTo(dmdDet.getAmount()) > 0) {
            excess = excess.add(dmdDet.getAmtCollected().subtract(dmdDet.getAmount()));
            dmdDet.setAmtCollected(dmdDet.getAmount());
        } else if (excess.compareTo(BigDecimal.ZERO) > 0) {
            excess = this.adjustExcessToCollection(excess, dmdDet);
        }
        return excess;
    }

    private BigDecimal adjustExcessToCollection(BigDecimal excess, EgDemandDetails dmdDet) {
        if (excess.compareTo(dmdDet.getAmount().subtract(dmdDet.getAmtCollected())) > 0) {
            excess = excess.subtract(dmdDet.getAmount().subtract(dmdDet.getAmtCollected()));
            dmdDet.setAmtCollected(dmdDet.getAmount());
        } else {
            dmdDet.setAmtCollected(dmdDet.getAmtCollected().add(excess));
            excess = BigDecimal.ZERO;
        }
        return excess;
    }

    private Ptdemand getCurrentPTDemand(Installment demandInstallment, Set<Ptdemand> activePropPtDemandSet) {
        Ptdemand currPtDemand = null;
        for (Ptdemand ptDemand : activePropPtDemandSet) {
            if (!ptDemand.getIsHistory().equalsIgnoreCase("N") || !ptDemand.getEgInstallmentMaster().equals((Object)demandInstallment)) continue;
            currPtDemand = ptDemand;
            break;
        }
        return currPtDemand;
    }

    private void updateAdvance(Ptdemand currPtDemand, BigDecimal excess, EgDemandDetails advanceDemandDetails) {
        if (excess.compareTo(BigDecimal.ZERO) > 0) {
            Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
            Installment installment = yearwiseInstMap.get("Current 2nd Half");
            if (advanceDemandDetails != null) {
                advanceDemandDetails.setAmtCollected(advanceDemandDetails.getAmtCollected().add(excess));
            } else {
                EgDemandDetails newDtls = this.ptBillServiceImpl.insertDemandDetails("ADVANCE", excess, installment);
                currPtDemand.addEgDemandDetails(newDtls);
            }
        }
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        PropertyImpl property = basicProperty.getActiveProperty();
        model.addAttribute("property", (Object)property);
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        if (!basicProperty.getActiveProperty().getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propertyService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("propertyTax", (Object)currentTaxDetails.get("General Tax"));
                model.addAttribute("eduCess", (Object)(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess")));
                model.addAttribute("libraryCess", (Object)(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")));
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_BAL"));
                model.addAttribute("totalTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_BAL"));
            }
            catch (Exception e) {
                LOG.error("Exception in addModelAttributes : ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
            model.addAttribute("propertyByEmployee", (Object)this.checkIfEmployee(this.getLoggedInUser()));
        }
    }

    public Boolean checkIfEmployee(User user) {
        return this.propertyService.isCitizenPortalUser(user) == false && this.propertyService.isEmployee(user) != false && !"Anonymous".equalsIgnoreCase(user.getName());
    }

    public String getInitiatorName(VacancyRemission vacancyRemission) {
        Assignment assignment = this.checkIfEmployee(vacancyRemission.getCreatedBy()) != false ? this.assignmentService.getPrimaryAssignmentForUser(vacancyRemission.getCreatedBy().getId()) : (vacancyRemission.getState().getInitiatorPosition() == null ? this.assignmentService.getPrimaryAssignmentForPositon(((Position)((StateHistory)vacancyRemission.getStateHistory().get(0)).getOwnerPosition()).getId()) : this.assignmentService.getPrimaryAssignmentForPositon(((Position)vacancyRemission.getState().getInitiatorPosition()).getId()));
        String initiatorName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
        return initiatorName;
    }

    public Assignment getWorkflowInitiator(VacancyRemission vacancyRemission) {
        Assignment wfInitiator = this.checkIfEmployee(vacancyRemission.getCreatedBy()).booleanValue() ? (vacancyRemission.getState() != null && vacancyRemission.getState().getInitiatorPosition() != null ? this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(vacancyRemission.getCreatedBy(), (Position)vacancyRemission.getState().getInitiatorPosition()) : this.assignmentService.getPrimaryAssignmentForUser(vacancyRemission.getCreatedBy().getId())) : (!vacancyRemission.getStateHistory().isEmpty() ? (vacancyRemission.getState().getInitiatorPosition() == null ? this.assignmentService.getPrimaryAssignmentForPositon(((Position)((StateHistory)vacancyRemission.getStateHistory().get(0)).getOwnerPosition()).getId()) : this.assignmentService.getPrimaryAssignmentForPositon(((Position)vacancyRemission.getState().getInitiatorPosition()).getId())) : this.assignmentService.getPrimaryAssignmentForPositon(((Position)vacancyRemission.getState().getOwnerPosition()).getId()));
        return wfInitiator;
    }

    @Transactional
    public void saveRemissionDetails(VacancyRemission vacancyRemission) {
        this.vacancyRemissionRepository.save((Object)vacancyRemission);
    }

    @Transactional
    public void rejectVacancyRemission(VacancyRemission vacancyRemission, String commnets, HttpServletRequest request) {
        User user = this.securityUtils.getCurrentUser();
        if (vacancyRemission != null) {
            Position wfInitiator = (Position)vacancyRemission.getState().getInitiatorPosition();
            vacancyRemission.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(commnets).withStateValue("VacancyRemission:Rejected").withDateInfo(new Date()).withOwner((OwnerGroup)wfInitiator).withNextAction("Generate Notice");
            vacancyRemission.setStatus("REJECTED");
            this.buildSMS(vacancyRemission, "Reject");
        }
        this.vacancyRemissionRepository.save((Object)vacancyRemission);
    }

    public List<VacancyRemissionDetails> getMonthlyDetailsHistory(VacancyRemission vacancyRemission) {
        List<VacancyRemissionDetails> historyList = new ArrayList<VacancyRemissionDetails>();
        if (!vacancyRemission.getVacancyRemissionDetails().isEmpty()) {
            historyList = vacancyRemission.getVacancyRemissionDetails();
            Collections.reverse(historyList);
        }
        return historyList;
    }

    public VacancyRemissionApproval getVacancyRemissionApprovalById(Long id) {
        return (VacancyRemissionApproval)((Object)this.vacancyRemissionApprovalRepository.findOne(id));
    }

    @Transactional
    public void saveVacancyRemissionApproval(VacancyRemissionApproval vacancyRemissionApproval, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        String approverDesignation = "";
        String nextAction = "";
        String loggedInUserDesignation = "";
        Assignment wfInitiator = this.getInitiatorOnWFAction(vacancyRemissionApproval, workFlowAction);
        if (wfInitiator == null) {
            wfInitiator = this.getWorkflowInitiatorAssignment(user.getId(), Arrays.asList("UD Revenue Inspector"));
        }
        if (null != approvalPosition && approvalPosition != 0L) {
            Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date()).get(0);
            approverDesignation = assignment.getDesignation().getName();
        }
        if (vacancyRemissionApproval.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(((Position)vacancyRemissionApproval.getCurrentState().getOwnerPosition()).getId(), user.getId(), new Date());
            String string = loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        if ("Forward".equalsIgnoreCase(workFlowAction) && (approverDesignation.equalsIgnoreCase("Assistant Commissioner") || approverDesignation.equalsIgnoreCase("Deputy Commissioner") || approverDesignation.equalsIgnoreCase("Additional Commissioner") || approverDesignation.equalsIgnoreCase("Zonal Commissioner") || approverDesignation.equalsIgnoreCase("Commissioner"))) {
            if (vacancyRemissionApproval.getStatus().equals("APPROVED")) {
                nextAction = "Digital Signature Pending";
            } else {
                String designation = approverDesignation.split(" ")[0];
                nextAction = this.getApprovalAsNextAction(designation);
            }
        }
        if (workFlowAction.equalsIgnoreCase("Generate Notice")) {
            if ("APPROVED".equalsIgnoreCase(vacancyRemissionApproval.getStatus())) {
                vacancyRemissionApproval.setStatus("Specialnotice Generated");
                vacancyRemissionApproval.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNextAction(null);
            } else {
                vacancyRemissionApproval.setStatus("Rejection Acknowledgement Generated");
                vacancyRemissionApproval.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNextAction(null);
            }
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            if (wfInitiator != null) {
                if (wfInitiator.getPosition().equals((Object)vacancyRemissionApproval.getCurrentState().getOwnerPosition())) {
                    vacancyRemissionApproval.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNextAction(null);
                    vacancyRemissionApproval.setStatus("REJECTED");
                    vacancyRemissionApproval.getVacancyRemission().getBasicProperty().setUnderWorkflow(Boolean.FALSE);
                } else {
                    vacancyRemissionApproval.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)wfInitiator.getPosition()).withNextAction("UD Revenue Inspector Approval Pending").withNatureOfTask("Vacancy Remission Approval");
                    vacancyRemissionApproval.setStatus("REJECTED");
                }
            }
        } else {
            WorkFlowMatrix wfmatrix;
            if (workFlowAction.equalsIgnoreCase("Forward") && vacancyRemissionApproval.getStatus() == null) {
                vacancyRemissionApproval.setStatus("IN_WORKFLOW");
            } else if (workFlowAction.equalsIgnoreCase("Approve")) {
                vacancyRemissionApproval.setStatus("APPROVED");
                vacancyRemissionApproval.setIsApproved(true);
                vacancyRemissionApproval.setApprovalDate(new Date());
            }
            if ("Approve".equalsIgnoreCase(workFlowAction)) {
                pos = (Position)vacancyRemissionApproval.getCurrentState().getOwnerPosition();
            } else if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            if (null == vacancyRemissionApproval.getState()) {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemissionApproval.getStateType(), null, null, additionalRule, null, null);
                vacancyRemissionApproval.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Vacancy Remission Approval").withInitiator((OwnerGroup)(wfInitiator != null ? wfInitiator.getPosition() : null));
            } else if ("END".equalsIgnoreCase(vacancyRemissionApproval.getCurrentState().getNextAction())) {
                vacancyRemissionApproval.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNextAction(null);
            } else {
                wfmatrix = this.vacancyRemissionWorkflowService.getWfMatrix(vacancyRemissionApproval.getStateType(), null, null, additionalRule, vacancyRemissionApproval.getCurrentState().getValue(), vacancyRemissionApproval.getCurrentState().getNextAction(), null, loggedInUserDesignation);
                vacancyRemissionApproval.transition().progress().withSenderName(user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(StringUtils.isNotBlank((CharSequence)nextAction) ? nextAction : wfmatrix.getNextAction()).withNatureOfTask("Vacancy Remission Approval");
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    this.wFApprove(vacancyRemissionApproval);
                }
            }
        }
        this.propertyService.updateIndexes(vacancyRemissionApproval, "Vacancy_Remission_Approval");
        if (Source.CITIZENPORTAL.toString().equalsIgnoreCase(vacancyRemissionApproval.getVacancyRemission().getSource()) && this.propertyService.getPortalInbox(vacancyRemissionApproval.getVacancyRemission().getApplicationNumber()) != null) {
            this.propertyService.updatePortal(vacancyRemissionApproval.getVacancyRemission(), "Vacancy_Remission");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
        this.vacancyRemissionApprovalRepository.save((Object)vacancyRemissionApproval);
    }

    private void wFApprove(VacancyRemissionApproval vacancyRemissionApproval) {
        Map<String, Installment> installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = installmentMap.get("Current 1st Half");
        Installment installmentSecondHalf = installmentMap.get("Current 2nd Half");
        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
            this.updateDemandDetailsWithRebate(vacancyRemissionApproval.getVacancyRemission(), installmentFirstHalf, installmentSecondHalf);
        }
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public VacancyRemission saveVacancyRemission(VacancyRemission vacancyRemission, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, Boolean propertyByEmployee, HashMap<String, String> meesevaParams) {
        return this.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, additionalRule, workFlowAction, propertyByEmployee);
    }

    public void buildSMS(VacancyRemission vacancyRemission, String workFlowAction) {
        for (PropertyOwnerInfo ownerInfo : vacancyRemission.getBasicProperty().getPropertyOwnerInfo()) {
            if (!StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getMobileNumber())) continue;
            this.buildSms(vacancyRemission, ownerInfo.getOwner(), workFlowAction);
        }
    }

    private void buildSms(VacancyRemission vacancyRemission, User user, String workFlowAction) {
        String assessmentNo = vacancyRemission.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.ptisMessageSource.getMessage("vacancyremission.rejection.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                smsMsg = this.ptisMessageSource.getMessage("vacancyremission.approval.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.notificationService.sendSMS(mobileNumber, smsMsg);
        }
    }

    public List<DocumentType> getDocuments(TransactionType transactionType) {
        return this.propertyService.getDocumentTypesForTransactionType(transactionType);
    }

    public DocumentType getDocType(String docname) {
        return this.vacancyRemissionRepository.findDocumentTypeByNameAndTransactionType(docname, TransactionType.VACANCYREMISSION);
    }

    public ReportOutput generateReport(VacancyRemission vacancyRemission, HttpServletRequest request, String approvedUser, String noticeNo) {
        ReportOutput reportOutput = null;
        if (vacancyRemission != null) {
            reportOutput = this.reportService.createReport(this.generateVRReportRequest(vacancyRemission, noticeNo, request, approvedUser));
        }
        return reportOutput;
    }

    public ReportRequest generateVRReportRequest(VacancyRemission vacancyRemission, String noticeNo, HttpServletRequest request, String approvedUser) {
        ReportRequest reportInput = null;
        if (vacancyRemission != null) {
            BasicPropertyImpl basicProperty = vacancyRemission.getBasicProperty();
            HashMap<String, Object> reportParams = new HashMap<String, Object>();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cityGrade}) && "Corp".equalsIgnoreCase(cityGrade) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            PropertyAddress ownerAddress = basicProperty.getAddress();
            PropertyID propertyId = basicProperty.getPropertyID();
            reportParams.put("isCorporation", isCorporation);
            reportParams.put("cityName", cityName);
            reportParams.put("userSignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : "");
            reportParams.put("loggedInUsername", approvedUser);
            reportParams.put("approvedDate", formatter.format(vacancyRemission.getState().getCreatedDate()));
            reportParams.put("approverName", this.userService.getUserById(ApplicationThreadLocals.getUserId()).getName());
            reportParams.put("applicationDate", formatter.format(vacancyRemission.getCreatedDate()));
            reportParams.put("currentDate", formatter.format(new Date()));
            reportParams.put("noticeNo", noticeNo);
            reportParams.put("ownerName", basicProperty.getFullOwnerName());
            reportParams.put("houseNo", ownerAddress.getHouseNoBldgApt());
            reportParams.put("assessmentNo", basicProperty.getUpicNo());
            reportParams.put("locality", propertyId.getLocality().getName());
            reportParams.put("vrFromDate", formatter.format(vacancyRemission.getVacancyFromDate()));
            reportParams.put("vrToDate", formatter.format(vacancyRemission.getVacancyToDate()));
            int noOfMonths = DateUtils.noOfMonthsBetween((Date)vacancyRemission.getVacancyFromDate(), (Date)new DateTime((Object)vacancyRemission.getVacancyToDate()).plusDays(1).toDate());
            reportParams.put("totalMonths", noOfMonths);
            Map<String, BigDecimal> currentDemand = this.ptDemandDAO.getDemandCollMap(vacancyRemission.getBasicProperty().getProperty());
            BigDecimal halfYearTax = currentDemand.get("CURR_SECONDHALF_DMD");
            BigDecimal newTax = BigDecimal.ZERO;
            CFinancialYear financialYear = this.propertyTaxUtil.getFinancialYearforDate(new Date());
            Map<String, Installment> installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(vacancyRemission.getVacancyRemissionApproval().get(0).getApprovalDate());
            Installment installmentFirstHalf = installmentMap.get("Current 1st Half");
            Installment installmentSecondHalf = installmentMap.get("Current 2nd Half");
            Ptdemand currPtDemand = this.getCurrentPTDemand(installmentFirstHalf, vacancyRemission.getBasicProperty().getActiveProperty().getPtDemandSet());
            if (this.isApprovedInFirstHalf(vacancyRemission, installmentFirstHalf)) {
                halfYearTax = currentDemand.get("CURR_FIRSTHALF_DMD");
                newTax = this.getNewTax(currPtDemand, newTax, installmentFirstHalf);
            } else {
                newTax = this.getNewTax(currPtDemand, newTax, installmentSecondHalf);
            }
            reportParams.put("financialYear", financialYear.getFinYearRange());
            reportParams.put("halfYearTax", halfYearTax.toString());
            reportParams.put("newTax", newTax.toString());
            reportInput = new ReportRequest("mainVRProceedings", (Object)vacancyRemission, reportParams);
        }
        if (reportInput != null) {
            reportInput.setPrintDialogOnOpenReport(true);
            reportInput.setReportFormat(ReportFormat.PDF);
        }
        return reportInput;
    }

    private BigDecimal getNewTax(Ptdemand currPtDemand, BigDecimal newTax, Installment installmentHalf) {
        if (currPtDemand != null) {
            for (EgDemandDetails dmdDet : currPtDemand.getEgDemandDetails()) {
                if (!dmdDet.getInstallmentStartDate().equals(installmentHalf.getFromDate()) || "PENALTY_FINES".equals(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                newTax = newTax.add(dmdDet.getAmount().divide(new BigDecimal("2")).setScale(0, 4));
            }
        }
        return newTax;
    }

    private boolean isApprovedInFirstHalf(VacancyRemission vacancyRemission, Installment installmentFirstHalf) {
        return DateUtils.between((Date)vacancyRemission.getVacancyRemissionApproval().get(0).getApprovalDate(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate());
    }

    public String getLoggedInUserDesignation(Long posId, User user) {
        List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(posId, user.getId(), new Date());
        return !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
    }

    public Assignment getWorkflowInitiatorAssignment(Long userId, List<String> designations) {
        Assignment wfInitiatorAssignment = null;
        if (userId != null) {
            List assignments = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(userId);
            for (Assignment assignment : assignments) {
                if (!designations.contains(assignment.getDesignation().getName()) || !assignment.getEmployee().isActive()) continue;
                wfInitiatorAssignment = assignment;
                break;
            }
        }
        return wfInitiatorAssignment;
    }

    public Assignment getWorkflowInitiator(StateAware<Position> property) {
        Assignment wfInitiator;
        if (this.isEmployee(property.getCreatedBy()).booleanValue()) {
            wfInitiator = this.isStateNotNull(property) ? this.getWfInitiatorIfStateNotNull(property) : this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId());
        } else if (property.getState().getInitiatorPosition() != null) {
            List assignment = this.assignmentService.getAssignmentsForPosition(((Position)property.getState().getInitiatorPosition()).getId(), new Date());
            wfInitiator = this.getActiveAssignment(assignment);
            if (wfInitiator == null && !property.getStateHistory().isEmpty()) {
                wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((Position)((StateHistory)property.getStateHistory().get(0)).getOwnerPosition()).getId());
            }
        } else {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((Position)property.getState().getOwnerPosition()).getId());
        }
        return wfInitiator;
    }

    private Assignment getWfInitiatorIfStateNotNull(StateAware<Position> property) {
        Assignment wfInitiator = null;
        Assignment assgmnt = this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(property.getCreatedBy(), (Position)property.getState().getInitiatorPosition());
        if (assgmnt != null && assgmnt.getEmployee().isActive()) {
            wfInitiator = assgmnt;
        }
        if (wfInitiator == null) {
            List assignment = this.assignmentService.getAssignmentsForPosition(((Position)property.getState().getInitiatorPosition()).getId(), new Date());
            wfInitiator = this.getActiveAssignment(assignment);
        }
        return wfInitiator;
    }

    private boolean isStateNotNull(StateAware property) {
        return property.getState() != null && property.getState().getInitiatorPosition() != null;
    }

    private Assignment getActiveAssignment(List<Assignment> assignment) {
        Assignment wfInitiator = null;
        for (Assignment assign : assignment) {
            if (!assign.getEmployee().isActive()) continue;
            wfInitiator = assign;
            break;
        }
        return wfInitiator;
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PROPERTYTAXROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    @Transactional
    public void closeVacancyRemission(VacancyRemission vacancyRemission) {
        User user = this.securityUtils.getCurrentUser();
        vacancyRemission.transition().end().withSenderName(user.getName()).withDateInfo(new Date()).withNextAction(null);
        if (!"APPROVED".equals(vacancyRemission.getStatus())) {
            vacancyRemission.setStatus("Rejection Acknowledgement Generated");
            vacancyRemission.getBasicProperty().setUnderWorkflow(false);
        }
        if (Source.CITIZENPORTAL.toString().equalsIgnoreCase(vacancyRemission.getSource()) && this.propertyService.getPortalInbox(vacancyRemission.getApplicationNumber()) != null) {
            this.propertyService.updatePortal(vacancyRemission, "Vacancy_Remission");
        }
    }

    private String getLoggedInUserDesignation(VacancyRemission vacancyRemission, User user) {
        String loggedInUserDesignation = "";
        if (vacancyRemission.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(((Position)vacancyRemission.getCurrentState().getOwnerPosition()).getId(), user.getId(), new Date());
            String string = loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : "";
        }
        if ("Junior Assistant".equals(loggedInUserDesignation) || "Senior Assistant".equals(loggedInUserDesignation)) {
            loggedInUserDesignation = "";
        }
        return loggedInUserDesignation;
    }

    private String getWorkflowNextAction(String designation) {
        String nextAction = "Commissioner".equalsIgnoreCase(designation) ? "Commissioner Forward Pending" : designation + " " + "Commissioner Forward Pending";
        return nextAction;
    }

    private String getApprovalAsNextAction(String designation) {
        String nextAction = designation.equalsIgnoreCase("Commissioner") ? "Commissioner Approval Pending" : designation + " " + "Commissioner Approval Pending";
        return nextAction;
    }

    private Assignment getInitiatorOnWFAction(VacancyRemissionApproval vacancyRemissionApproval, String wfAction) {
        Assignment wfInitiator = null;
        if (vacancyRemissionApproval.getId() != null && "Reject".equalsIgnoreCase(wfAction)) {
            wfInitiator = this.getWorkflowInitiatorAssignment(vacancyRemissionApproval.getState().getCreatedBy().getId(), Arrays.asList("UD Revenue Inspector"));
        }
        if (vacancyRemissionApproval.getId() != null && "Generate Notice".equalsIgnoreCase(wfAction)) {
            wfInitiator = (Assignment)this.assignmentService.getAssignmentsForPosition(((Position)vacancyRemissionApproval.getVacancyRemission().getState().getInitiatorPosition()).getId(), new Date()).get(0);
        }
        return wfInitiator;
    }

    public BigDecimal getWaterTaxDues(String assessmentNo, HttpServletRequest request) {
        return this.propertyService.getWaterTaxDues(assessmentNo, request).get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)this.propertyService.getWaterTaxDues(assessmentNo, request).get("totalTaxDue"));
    }

    public Boolean isUnderWtmsWF(String assessmentNo, HttpServletRequest request) {
        return this.propertyService.getWaterTaxDues(assessmentNo, request).get("isInWorkFlow") == null ? Boolean.FALSE : Boolean.valueOf((Boolean)this.propertyService.getWaterTaxDues(assessmentNo, request).get("isInWorkFlow"));
    }
}

