/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.RebatePeriod;
import org.egov.ptis.domain.service.property.RebatePeriodService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RebateService {
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private RebatePeriodService rebatePeriodService;

    public BigDecimal calculateEarlyPayRebate(BigDecimal tax, Date date) {
        if (this.isEarlyPayRebateActive(date)) {
            return tax.multiply(PropertyTaxConstants.ADVANCE_REBATE_PERCENTAGE).divide(PropertyTaxConstants.BIGDECIMAL_100).setScale(0, 4);
        }
        return BigDecimal.ZERO;
    }

    public boolean isEarlyPayRebateActive(Date date) {
        boolean isActive = false;
        Date today = date != null ? date : new Date();
        RebatePeriod rebatePeriod = this.rebatePeriodService.getRebateForCurrInstallment(this.propertyTaxCommonUtils.getCurrentInstallment().getId());
        if (rebatePeriod != null && today.before(rebatePeriod.getRebateDate())) {
            isActive = true;
        }
        return isActive;
    }
}

