/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.notice.PtNotice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PropertyThirdPartyService {
    private static final Logger LOGGER = Logger.getLogger(PropertyThirdPartyService.class);
    public PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private PropertyTransferService transferOwnerService;

    public byte[] getSpecialNotice(String assessmentNo, String applicationNo, String applicationType) throws IOException {
        PtNotice ptNotice = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into getSpecialNotice application type:" + applicationType + ",application no:" + applicationNo));
        }
        if (applicationType.equals("New_Assessment") || applicationType.equals("Alter_Assessment") || applicationType.equals("Bifuracate_Assessment") || applicationType.equals("Demolition") || applicationType.equals("Amalgamation")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                ptNotice = (PtNotice)this.persistenceService.find("from PtNotice where applicationNumber = ? and noticeType = ?", new Object[]{applicationNo, "Special Notice"});
            } else if (StringUtils.isNotBlank((CharSequence)assessmentNo)) {
                ptNotice = (PtNotice)this.persistenceService.find("from PtNotice where basicProperty.upicNo = ?", new Object[]{assessmentNo});
            }
        } else if (applicationType.equals("Transfer_of_Ownership")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                ptNotice = (PtNotice)this.persistenceService.find("from PtNotice where applicationNumber = ? and noticeType = ?", new Object[]{applicationNo, "Mutation Certificate"});
            }
        } else if (applicationType.equals("Tax_Exemption") && StringUtils.isNotBlank((CharSequence)applicationNo)) {
            ptNotice = (PtNotice)this.persistenceService.find("from PtNotice where applicationNumber = ? and noticeType = ?", new Object[]{applicationNo, "exemption"});
        }
        if (ptNotice != null && ptNotice.getFileStore() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Property notice : " + ptNotice.getNoticeNo()));
            }
            FileStoreMapper fsm = ptNotice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            return FileUtils.readFileToByteArray((File)file);
        }
        return null;
    }

    public Map<String, String> validatePropertyStatus(String applicationNo, String applicationType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into validatePropertyStatus method,applicationType:" + applicationType + ",application no:" + applicationNo));
        }
        PropertyImpl property = null;
        PropertyMutation mutation = null;
        VacancyRemission vacancyRemission = null;
        RevisionPetition revisionPetition = null;
        StateHistory stateHistory = null;
        HashMap<String, String> statusCommentsMap = new HashMap<String, String>();
        if (applicationType.equals("New_Assessment") || applicationType.equals("Alter_Assessment") || applicationType.equals("Bifuracate_Assessment") || applicationType.equals("Tax_Exemption") || applicationType.equals("Demolition") || applicationType.equals("Amalgamation")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                property = (PropertyImpl)this.persistenceService.find("From PropertyImpl where applicationNo = ? ", new Object[]{applicationNo});
            }
            if (null != property) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Inside applicationType:" + applicationType + "for property" + property));
                }
                if (!property.getState().getHistory().isEmpty()) {
                    int size = property.getState().getHistory().size();
                    stateHistory = (StateHistory)property.getStateHistory().get(size - 1);
                }
                if (property.getState().getValue().equals("Closed") && (stateHistory.getValue().endsWith("Digitally Signed") || stateHistory.getValue().endsWith("Commissioner Approved"))) {
                    statusCommentsMap.put("status", "Approved");
                    statusCommentsMap.put("comments", stateHistory.getComments());
                    statusCommentsMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                } else if (property.getState().getValue().equals("Closed") && stateHistory.getValue().endsWith("Rejected")) {
                    statusCommentsMap.put("status", "Rejected");
                    statusCommentsMap.put("comments", property.getState().getComments());
                    statusCommentsMap.put("updatedBy", property.getState().getLastModifiedBy().getName());
                } else {
                    statusCommentsMap.put("status", "Open");
                    statusCommentsMap.put("comments", property.getState().getComments());
                    statusCommentsMap.put("updatedBy", property.getState().getLastModifiedBy().getName());
                }
            }
        } else if (applicationType.equals("Transfer_of_Ownership")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                mutation = this.transferOwnerService.getPropertyMutationByApplicationNo(applicationNo);
            }
            if (null != mutation) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Inside applicationType:" + applicationType + "for property mutation" + (Object)((Object)mutation)));
                }
                if (!mutation.getState().getHistory().isEmpty()) {
                    int size = mutation.getState().getHistory().size();
                    stateHistory = (StateHistory)mutation.getStateHistory().get(size - 1);
                }
                if (mutation.getState().getValue().equals("Closed") && (stateHistory.getValue().equals("Digitally Signed") || stateHistory.getValue().equals("Commissioner Approved"))) {
                    statusCommentsMap.put("status", "Approved");
                    statusCommentsMap.put("comments", stateHistory.getComments());
                    statusCommentsMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                } else if (mutation.getState().getValue().equals("Closed") && stateHistory.getValue().equals("Rejected")) {
                    statusCommentsMap.put("status", "Rejected");
                    statusCommentsMap.put("comments", mutation.getState().getComments());
                    statusCommentsMap.put("updatedBy", mutation.getState().getLastModifiedBy().getName());
                } else {
                    statusCommentsMap.put("status", "Open");
                    statusCommentsMap.put("comments", mutation.getState().getComments());
                    statusCommentsMap.put("updatedBy", mutation.getState().getLastModifiedBy().getName());
                }
            }
        } else if (applicationType.equals("Vacancy_Remission")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                vacancyRemission = (VacancyRemission)((Object)this.persistenceService.find("From VacancyRemission where applicationNumber = ? ", new Object[]{applicationNo}));
            }
            if (null != vacancyRemission) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Inside applicationType:" + applicationType + "for property vacancy remission" + (Object)((Object)vacancyRemission)));
                }
                if (!vacancyRemission.getState().getHistory().isEmpty()) {
                    int size = vacancyRemission.getState().getHistory().size();
                    stateHistory = (StateHistory)vacancyRemission.getStateHistory().get(size - 1);
                }
                if (vacancyRemission.getState().getValue().equals("Closed") && stateHistory.getValue().endsWith("Bill Collector Approved")) {
                    statusCommentsMap.put("status", "Approved");
                    statusCommentsMap.put("comments", vacancyRemission.getState().getComments());
                    statusCommentsMap.put("updatedBy", vacancyRemission.getState().getLastModifiedBy().getName());
                } else if (vacancyRemission.getState().getValue().equals("Closed") && stateHistory.getValue().endsWith("Rejected")) {
                    statusCommentsMap.put("status", "Rejected");
                    statusCommentsMap.put("comments", stateHistory.getComments());
                    statusCommentsMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                } else {
                    statusCommentsMap.put("status", "Open");
                    statusCommentsMap.put("comments", vacancyRemission.getState().getComments());
                    statusCommentsMap.put("updatedBy", vacancyRemission.getState().getLastModifiedBy().getName());
                }
            }
        } else if (applicationType.equals("Revision_Petition")) {
            if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
                revisionPetition = (RevisionPetition)((Object)this.persistenceService.find("From RevisionPetition where objectionNumber = ? ", new Object[]{applicationNo}));
            }
            if (null != revisionPetition) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Inside applicationType:" + applicationType + "for property revision petition" + (Object)((Object)revisionPetition)));
                }
                if (!revisionPetition.getState().getHistory().isEmpty()) {
                    int size = revisionPetition.getState().getHistory().size();
                    stateHistory = (StateHistory)revisionPetition.getStateHistory().get(size - 1);
                }
                if (revisionPetition.getState().getValue().equals("END") && (stateHistory.getValue().endsWith("Digitally Signed") || stateHistory.getValue().endsWith("Commissioner Approved"))) {
                    statusCommentsMap.put("status", "Approved");
                    statusCommentsMap.put("comments", stateHistory.getComments());
                    statusCommentsMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                } else if (revisionPetition.getState().getValue().equals("END")) {
                    statusCommentsMap.put("status", "Rejected");
                    statusCommentsMap.put("comments", stateHistory.getComments());
                    statusCommentsMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                } else {
                    statusCommentsMap.put("status", "Open");
                    statusCommentsMap.put("comments", revisionPetition.getState().getComments());
                    statusCommentsMap.put("updatedBy", revisionPetition.getState().getLastModifiedBy().getName());
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validatePropertyStatus method");
        }
        return statusCommentsMap;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

