/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Area;
import org.egov.commons.Bank;
import org.egov.commons.Installment;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.Payment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.CorrespondenceAddress;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.bean.AssessmentInfo;
import org.egov.ptis.bean.FloorInfo;
import org.egov.ptis.bean.SurveyAssessmentDetails;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.integration.utils.CollectionHelper;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyMutationDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.document.DocumentTypeDetails;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyDocs;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.LocalityDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.model.OwnerDetails;
import org.egov.ptis.domain.model.OwnerInformation;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.PropertyDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.RestAssessmentDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.model.TaxCalculatorRequest;
import org.egov.ptis.domain.model.TaxCalculatorResponse;
import org.egov.ptis.domain.model.ViewPropertyDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.master.service.FloorTypeService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.master.service.RoofTypeService;
import org.egov.ptis.master.service.StructureClassificationService;
import org.egov.ptis.master.service.WallTypeService;
import org.egov.ptis.master.service.WoodTypeService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class PropertyExternalService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyExternalService.class);
    private static final String ASSESSMENT = "Assessment";
    public static final Integer FLAG_MOBILE_EMAIL = 0;
    public static final Integer FLAG_TAX_DETAILS = 1;
    public static final Integer FLAG_FULL_DETAILS = 2;
    private static final String FORWARD_SUCCESS_COMMENT = "Application has been created by GIS Survey system.";
    private static final String TAX_CALCULATIONS_EFFECTIVE_DATE = "01/10/2017";
    private static final String HALF_YEARLY_TAX = "halfYearlyTax";
    private static final String ARV = "ARV";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    @Qualifier(value="propertyTaxBillable")
    private PropertyTaxBillable propertyTaxBillable;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private CollectionIntegrationService collectionService;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private UserService userService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private PropertyMutationDAO propertyMutationDAO;
    @Autowired
    private FloorTypeService floorTypeService;
    @Autowired
    private RoofTypeService roofTypeService;
    @Autowired
    private WallTypeService wallTypeService;
    @Autowired
    private WoodTypeService woodTypeService;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private PersistenceService persistenceService;
    @Autowired
    PropertyUsageService propertyUsageService;
    @Autowired
    StructureClassificationService structureClassificationService;
    @Autowired
    PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SimpleRestClient simpleRestClient;
    private PropertyImpl propty = new PropertyImpl();
    @Autowired
    @Qualifier(value="documentTypeDetailsService")
    private PersistenceService<DocumentTypeDetails, Long> documentTypeDetailsService;

    public PropertyImpl getPropty() {
        return this.propty;
    }

    public void setPropty(PropertyImpl propty) {
        this.propty = propty;
    }

    public AssessmentDetails loadAssessmentDetails(String propertyId, Integer flag, BasicPropertyStatus status) {
        AssessmentDetails assessmentDetail = new AssessmentDetails();
        assessmentDetail.setPropertyID(propertyId);
        assessmentDetail.setFlag(flag);
        this.validate(assessmentDetail);
        BasicProperty basicProperty = this.initiateBasicProperty(status, assessmentDetail);
        if (basicProperty != null) {
            PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
            if (basicProperty.getLatitude() != null && basicProperty.getLongitude() != null) {
                assessmentDetail.setLatitude(basicProperty.getLatitude());
                assessmentDetail.setLongitude(basicProperty.getLongitude());
            }
            if (flag.equals(FLAG_MOBILE_EMAIL)) {
                this.loadPrimaryMobileAndEmail(basicProperty, assessmentDetail);
            }
            if (property != null) {
                PropertyDetails propertyDetails = new PropertyDetails();
                assessmentDetail.setPropertyDetails(propertyDetails);
                if (flag.equals(FLAG_FULL_DETAILS)) {
                    this.getAsssessmentDetails(basicProperty, assessmentDetail);
                    this.loadPropertyDues(property, assessmentDetail);
                }
                if (flag.equals(FLAG_TAX_DETAILS)) {
                    this.loadPropertyDues(property, assessmentDetail);
                }
                if (assessmentDetail.isExempted()) {
                    assessmentDetail.getPropertyDetails().setTaxDue(BigDecimal.ZERO);
                    assessmentDetail.getPropertyDetails().setCurrentTax(BigDecimal.ZERO);
                    assessmentDetail.getPropertyDetails().setArrearTax(BigDecimal.ZERO);
                }
            }
        }
        return assessmentDetail;
    }

    private void validate(AssessmentDetails assessmentDetail) {
        if (assessmentDetail.getPropertyID() == null || assessmentDetail.getPropertyID().trim().equals("")) {
            throw new ApplicationRuntimeException("PropertyID is null or empty!");
        }
        if (assessmentDetail.getFlag() == null || assessmentDetail.getFlag() > 3) {
            throw new ApplicationRuntimeException("Invalid Flag");
        }
    }

    private BasicProperty initiateBasicProperty(BasicPropertyStatus status, AssessmentDetails assessmentDetail) {
        BasicProperty basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(assessmentDetail.getPropertyID());
        ErrorDetails errorDetails = new ErrorDetails();
        if (null != basicProperty) {
            assessmentDetail.setStatus(basicProperty.isActive());
            if (status.equals((Object)BasicPropertyStatus.ACTIVE)) {
                if (basicProperty.isActive().booleanValue()) {
                    this.checkStatusValues(basicProperty, errorDetails);
                } else {
                    errorDetails.setErrorCode("PTAX103");
                    errorDetails.setErrorMessage("Active property does not exists for the given assessment number");
                    assessmentDetail.setErrorDetails(errorDetails);
                }
            } else if (status.equals((Object)BasicPropertyStatus.INACTIVE)) {
                if (!basicProperty.isActive().booleanValue()) {
                    this.checkStatusValues(basicProperty, errorDetails);
                } else {
                    errorDetails.setErrorCode("PTAX104");
                    errorDetails.setErrorMessage("Property is not active for the given assessment number");
                    assessmentDetail.setErrorDetails(errorDetails);
                }
            } else {
                this.checkStatusValues(basicProperty, errorDetails);
            }
        } else {
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Property with assessment no " + assessmentDetail.getPropertyID() + " does not exist");
        }
        assessmentDetail.setErrorDetails(errorDetails);
        return basicProperty;
    }

    private void checkStatusValues(BasicProperty basicProperty, ErrorDetails errorDetails) {
        Set<PropertyStatusValues> statusValues = basicProperty.getPropertyStatusValuesSet();
        if (null != statusValues && !statusValues.isEmpty()) {
            for (PropertyStatusValues statusValue : statusValues) {
                if (statusValue.getPropertyStatus().getStatusCode() != "MARK_DEACTIVE") continue;
                errorDetails.setErrorCode("PTAX102");
                errorDetails.setErrorMessage("Property is marked for deactivation");
            }
        }
    }

    private void loadPrimaryMobileAndEmail(BasicProperty basicProperty, AssessmentDetails assessmentDetail) {
        User primaryOwner = basicProperty.getPrimaryOwner();
        assessmentDetail.setPrimaryEmail(primaryOwner.getEmailId());
        assessmentDetail.setPrimaryMobileNo(primaryOwner.getMobileNumber());
    }

    private void loadPropertyDues(PropertyImpl property, AssessmentDetails assessmentDetail) {
        Map<String, BigDecimal> resultmap = this.ptDemandDAO.getDemandCollMap(property);
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_FIRSTHALF_DMD");
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            BigDecimal currCollection = resultmap.get("CURR_FIRSTHALF_COLL");
            BigDecimal arrColelection = resultmap.get("ARR_COLL");
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrColelection);
            assessmentDetail.getPropertyDetails().setTaxDue(taxDue);
            assessmentDetail.getPropertyDetails().setCurrentTax(currDmd);
            assessmentDetail.getPropertyDetails().setArrearTax(arrDmd);
        }
    }

    private void getAsssessmentDetails(BasicProperty basicProperty, AssessmentDetails assessmentDetail) {
        assessmentDetail.setBoundaryDetails(this.prepareBoundaryInfo(basicProperty));
        assessmentDetail.setHouseNo(basicProperty.getAddress().getHouseNoBldgApt());
        assessmentDetail.setPropertyAddress(basicProperty.getAddress().toString());
        PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
        if (null != property) {
            assessmentDetail.setOwnerNames(this.prepareOwnerInfo(property));
            assessmentDetail.setExempted(property.getIsExemptedFromTax());
            PropertyDetail propertyDetail = property.getPropertyDetail();
            if (null != propertyDetail) {
                assessmentDetail.getPropertyDetails().setPropertyType(propertyDetail.getPropertyTypeMaster().getType());
                if (propertyDetail.getPropertyUsage() != null) {
                    assessmentDetail.getPropertyDetails().setPropertyUsage(propertyDetail.getPropertyUsage().getUsageName());
                }
                if (null != propertyDetail.getNoofFloors()) {
                    assessmentDetail.getPropertyDetails().setNoOfFloors(propertyDetail.getNoofFloors());
                } else {
                    assessmentDetail.getPropertyDetails().setNoOfFloors(0);
                }
            }
        }
    }

    private BoundaryDetails prepareBoundaryInfo(BasicProperty basicProperty) {
        BoundaryDetails boundaryDetails = new BoundaryDetails();
        PropertyID propertyID = basicProperty.getPropertyID();
        if (null != propertyID) {
            if (null != propertyID.getZone()) {
                boundaryDetails.setZoneId(propertyID.getZone().getId());
                boundaryDetails.setZoneNumber(propertyID.getZone().getBoundaryNum());
                boundaryDetails.setZoneName(propertyID.getZone().getName());
                boundaryDetails.setZoneBoundaryType(propertyID.getZone().getBoundaryType().getName());
            }
            if (null != propertyID.getWard()) {
                boundaryDetails.setWardId(propertyID.getWard().getId());
                boundaryDetails.setWardNumber(propertyID.getWard().getBoundaryNum());
                boundaryDetails.setWardName(propertyID.getWard().getName());
                boundaryDetails.setWardBoundaryType(propertyID.getWard().getBoundaryType().getName());
            }
            if (null != propertyID.getElectionBoundary()) {
                boundaryDetails.setAdminWardId(propertyID.getElectionBoundary().getId());
                boundaryDetails.setAdminWardNumber(propertyID.getElectionBoundary().getBoundaryNum());
                boundaryDetails.setAdminWardName(propertyID.getElectionBoundary().getName());
                boundaryDetails.setAdminWardBoundaryType(propertyID.getElectionBoundary().getBoundaryType().getName());
            }
            if (null != propertyID.getArea()) {
                boundaryDetails.setBlockId(propertyID.getArea().getId());
                boundaryDetails.setBlockNumber(propertyID.getArea().getBoundaryNum());
                boundaryDetails.setBlockName(propertyID.getArea().getName());
            }
            if (null != propertyID.getLocality()) {
                boundaryDetails.setLocalityId(propertyID.getLocality().getId());
                boundaryDetails.setLocalityName(propertyID.getLocality().getName());
            }
            if (null != propertyID.getStreet()) {
                boundaryDetails.setStreetId(propertyID.getStreet().getId());
                boundaryDetails.setStreetName(propertyID.getStreet().getName());
            }
        }
        return boundaryDetails;
    }

    private Set<OwnerName> prepareOwnerInfo(Property property) {
        List<PropertyOwnerInfo> propertyOwners = property.getBasicProperty().getPropertyOwnerInfo();
        HashSet<OwnerName> ownerNames = new HashSet<OwnerName>(0);
        if (propertyOwners != null && !propertyOwners.isEmpty()) {
            for (PropertyOwnerInfo propertyOwner : propertyOwners) {
                OwnerName ownerName = new OwnerName();
                ownerName.setAadhaarNumber(propertyOwner.getOwner().getAadhaarNumber());
                ownerName.setOwnerName(propertyOwner.getOwner().getName());
                ownerName.setMobileNumber(propertyOwner.getOwner().getMobileNumber());
                ownerName.setEmailId(propertyOwner.getOwner().getEmailId());
                ownerNames.add(ownerName);
            }
        }
        return ownerNames;
    }

    public PropertyTaxDetails getPropertyTaxDetails(String assessmentNo, String oldAssessmentNo, String category) {
        PropertyTaxDetails propertyTaxDetails;
        BasicProperty basicProperty = null;
        List basicProperties = new ArrayList();
        ErrorDetails errorDetails = new ErrorDetails();
        if (org.egov.infra.utils.StringUtils.isNotBlank((String)assessmentNo)) {
            basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        } else if (org.egov.infra.utils.StringUtils.isNotBlank((String)oldAssessmentNo) && (basicProperties = this.basicPropertyDAO.getBasicPropertyByOldMunipalNo(oldAssessmentNo)).size() == 1) {
            basicProperty = (BasicProperty)basicProperties.get(0);
        }
        if (basicProperties.size() > 1) {
            propertyTaxDetails = new PropertyTaxDetails();
            errorDetails.setErrorCode("PTAX106");
            errorDetails.setErrorMessage("More than one assessment for the old assessment number: " + oldAssessmentNo);
            propertyTaxDetails.setErrorDetails(errorDetails);
        } else if (basicProperty != null) {
            Property property = basicProperty.getProperty();
            if (property != null && property.getIsExemptedFromTax().booleanValue()) {
                propertyTaxDetails = new PropertyTaxDetails();
                errorDetails.setErrorCode("PTAX105");
                errorDetails.setErrorMessage("Property is exempted");
                propertyTaxDetails.setErrorDetails(errorDetails);
            } else {
                propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, category);
                if (propertyTaxDetails.getErrorDetails() == null) {
                    errorDetails.setErrorCode("PTIS-REST-0");
                    errorDetails.setErrorMessage("SUCCESS");
                    propertyTaxDetails.setErrorDetails(errorDetails);
                }
            }
        } else {
            propertyTaxDetails = new PropertyTaxDetails();
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Property with assessment no " + assessmentNo + " does not exist");
            propertyTaxDetails.setErrorDetails(errorDetails);
        }
        return propertyTaxDetails;
    }

    public List<PropertyTaxDetails> getPropertyTaxDetails(String assessmentNo, String ownerName, String mobileNumber, String category, String doorNo) {
        List<BasicProperty> basicProperties = this.basicPropertyDAO.getBasicPropertiesForTaxDetails(assessmentNo, ownerName, mobileNumber, category, doorNo);
        ArrayList<PropertyTaxDetails> propTxDetailsList = new ArrayList<PropertyTaxDetails>();
        if (null != basicProperties && !basicProperties.isEmpty()) {
            for (BasicProperty basicProperty : basicProperties) {
                PropertyTaxDetails propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, category);
                propTxDetailsList.add(propertyTaxDetails);
            }
        } else {
            PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Assessment does not exist");
            propertyTaxDetails.setErrorDetails(errorDetails);
            propTxDetailsList.add(propertyTaxDetails);
        }
        return propTxDetailsList;
    }

    public List<PropertyTaxDetails> getPropertyTaxDetails(String circleName, String zoneName, String wardName, String blockName, String ownerName, String doorNo, String aadhaarNumber, String mobileNumber) {
        ArrayList<PropertyTaxDetails> propTxDetailsList = null;
        List<BasicProperty> basicPropertyList = this.basicPropertyDAO.getBasicPropertiesForTaxDetails(circleName, zoneName, wardName, blockName, ownerName, doorNo, aadhaarNumber, mobileNumber);
        if (null != basicPropertyList) {
            propTxDetailsList = new ArrayList<PropertyTaxDetails>();
            for (BasicProperty basicProperty : basicPropertyList) {
                PropertyTaxDetails propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, null);
                propTxDetailsList.add(propertyTaxDetails);
            }
        }
        return propTxDetailsList;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username.equals("mahesh") && password.equals("demo")) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }

    private PropertyTaxDetails getPropertyTaxDetails(BasicProperty basicProperty, String category) {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        ErrorDetails errorDetails = new ErrorDetails();
        if (null != basicProperty) {
            String assessmentNo = basicProperty.getUpicNo();
            if (!basicProperty.isActive().booleanValue()) {
                errorDetails.setErrorCode("PTAX101");
                errorDetails.setErrorMessage("Property is decativated");
                propertyTaxDetails.setErrorDetails(errorDetails);
            } else {
                Set<PropertyStatusValues> statusValues = basicProperty.getPropertyStatusValuesSet();
                if (null != statusValues && !statusValues.isEmpty()) {
                    for (PropertyStatusValues statusValue : statusValues) {
                        if (statusValue.getPropertyStatus().getStatusCode() != "MARK_DEACTIVE") continue;
                        errorDetails.setErrorCode("PTAX102");
                        errorDetails.setErrorMessage("Property is marked for deactivation");
                    }
                }
            }
            Property property = basicProperty.getProperty();
            this.ptDemandDAO.getDemandCollMap(property);
            if (!StringUtils.isBlank((CharSequence)category)) {
                String propType = property.getPropertyDetail().getPropertyTypeMaster().getCode();
                if ("PT".equals(category)) {
                    if (propType.equals("VAC_LAND")) {
                        errorDetails.setErrorCode("PTIS-REST-43");
                        errorDetails.setErrorMessage("There is no Property Tax record found for this assessment");
                        propertyTaxDetails.setErrorDetails(errorDetails);
                        return propertyTaxDetails;
                    }
                } else if ("VLT".equals(category)) {
                    if (!propType.equals("VAC_LAND")) {
                        errorDetails.setErrorCode("PTIS-REST-44");
                        errorDetails.setErrorMessage("There is no Vacant Land record found for this assessment");
                        propertyTaxDetails.setErrorDetails(errorDetails);
                        return propertyTaxDetails;
                    }
                } else {
                    errorDetails.setErrorCode("PTIS-REST-45");
                    errorDetails.setErrorMessage("Invalid Category");
                    propertyTaxDetails.setErrorDetails(errorDetails);
                    return propertyTaxDetails;
                }
            }
            List<PropertyOwnerInfo> propOwnerInfos = property.getBasicProperty().getPropertyOwnerInfo();
            propertyTaxDetails.setOwnerDetails(new ArrayList<OwnerDetails>(0));
            for (int i = 0; i < propOwnerInfos.size(); ++i) {
                PropertyOwnerInfo propOwnerInfo = propOwnerInfos.get(i);
                String ownerName = propOwnerInfo.getOwner().getName();
                if (null == ownerName || ownerName.trim().length() == 0) continue;
                OwnerDetails ow = new OwnerDetails();
                ow.setOwnerName(ownerName);
                ow.setMobileNo(propOwnerInfo.getOwner().getMobileNumber());
                propertyTaxDetails.getOwnerDetails().add(ow);
            }
            propertyTaxDetails.setPropertyAddress(property.getBasicProperty().getAddress().toString());
            propertyTaxDetails.setAssessmentNo(property.getBasicProperty().getUpicNo());
            propertyTaxDetails.setOldAssessmentNo(property.getBasicProperty().getOldMuncipalNum());
            propertyTaxDetails.setLocalityName(property.getBasicProperty().getPropertyID().getLocality().getName());
            this.propertyTaxBillable.setBasicProperty(basicProperty);
            this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
            Map<Installment, PenaltyAndRebate> calculatedPenalty = this.propertyTaxBillable.getCalculatedPenalty();
            List<Object> list = this.ptDemandDAO.getPropertyTaxDetails(assessmentNo);
            if (list.size() <= 0) {
                return propertyTaxDetails;
            }
            propertyTaxDetails.setTaxDetails(new ArrayList<RestPropertyTaxDetails>(0));
            String loopInstallment = "";
            RestPropertyTaxDetails arrearDetails = null;
            BigDecimal total = BigDecimal.ZERO;
            for (Object record : list) {
                Object[] data = (Object[])record;
                String taxType = (String)data[0];
                String installment = (String)data[1];
                Double dmd = (Double)data[2];
                Double col = (Double)data[3];
                BigDecimal demand = BigDecimal.valueOf(dmd);
                BigDecimal collection = BigDecimal.valueOf(col);
                if (loopInstallment.isEmpty()) {
                    loopInstallment = installment;
                    arrearDetails = new RestPropertyTaxDetails();
                    arrearDetails.setInstallment(installment);
                }
                if (loopInstallment.equals(installment)) {
                    if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                        arrearDetails.setPenalty(demand.subtract(collection));
                        continue;
                    }
                    if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                        arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                        continue;
                    }
                    total = total.add(demand.subtract(collection));
                    continue;
                }
                arrearDetails.setTaxAmount(total);
                arrearDetails.setTotalAmount(total.add(arrearDetails.getChqBouncePenalty()));
                propertyTaxDetails.getTaxDetails().add(arrearDetails);
                loopInstallment = installment;
                arrearDetails = new RestPropertyTaxDetails();
                arrearDetails.setInstallment(installment);
                total = BigDecimal.ZERO;
                if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                    arrearDetails.setPenalty(demand.subtract(collection));
                    continue;
                }
                if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                    arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                    continue;
                }
                total = total.add(demand.subtract(collection));
            }
            if (arrearDetails != null) {
                arrearDetails.setTaxAmount(total);
                arrearDetails.setTotalAmount(total.add(arrearDetails.getChqBouncePenalty()));
                propertyTaxDetails.getTaxDetails().add(arrearDetails);
            }
            Set<Installment> keySet = calculatedPenalty.keySet();
            block3: for (RestPropertyTaxDetails details : propertyTaxDetails.getTaxDetails()) {
                for (Installment inst : keySet) {
                    if (!inst.getDescription().equalsIgnoreCase(details.getInstallment())) continue;
                    details.setPenalty(calculatedPenalty.get(inst).getPenalty());
                    details.setRebate(calculatedPenalty.get(inst).getRebate());
                    details.setTotalAmount(details.getTotalAmount().add(calculatedPenalty.get(inst).getPenalty()));
                    if (details.getRebate() == null) continue block3;
                    details.setTotalAmount(details.getTotalAmount().subtract(details.getRebate()));
                    continue block3;
                }
            }
        }
        return propertyTaxDetails;
    }

    public ReceiptDetails payPropertyTax(PayPropertyTaxDetails payPropertyTaxDetails, String propertyType) {
        Payment payment;
        BillReceiptInfo billReceiptInfo;
        ReceiptDetails receiptDetails = null;
        ErrorDetails errorDetails = null;
        BigDecimal totalAmountToBePaid = BigDecimal.ZERO;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropertyTaxDetails.getAssessmentNo());
        if (propertyType.equalsIgnoreCase("VAC_LAND")) {
            this.propertyTaxBillable.setVacantLandTaxPayment(true);
        }
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateBillNumber(basicProperty.getPropertyID().getWard().getBoundaryNum().toString()));
        this.propertyTaxBillable.setBillType(this.egBillDAO.getBillTypeByCode("AUTO"));
        this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
        this.propertyTaxBillable.setTransanctionReferenceNumber(payPropertyTaxDetails.getTransactionId());
        EgBill egBill = this.ptBillServiceImpl.generateBill(this.propertyTaxBillable);
        for (EgBillDetails billDetails : egBill.getEgBillDetails()) {
            if (!billDetails.getDescription().contains("Advance") && !billDetails.getDescription().contains("REBATE") && billDetails.getCrAmount().compareTo(BigDecimal.ZERO) > 0) {
                totalAmountToBePaid = totalAmountToBePaid.add(billDetails.getCrAmount());
                continue;
            }
            if (!billDetails.getDescription().contains("REBATE")) continue;
            totalAmountToBePaid = totalAmountToBePaid.subtract(billDetails.getDrAmount());
        }
        CollectionHelper collectionHelper = new CollectionHelper(egBill);
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>();
        paymentDetailsMap.put("amount", payPropertyTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", payPropertyTaxDetails.getPaidBy());
        if ("CHEQUE".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", payPropertyTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", ChequePayment.CHEQUE_DATE_FORMAT.format(payPropertyTaxDetails.getChqddDate()));
            paymentDetailsMap.put("branchName", payPropertyTaxDetails.getBranchName());
            Long validatesBankId = this.validateBank(payPropertyTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
        }
        if (null != (billReceiptInfo = collectionHelper.executeCollection(payment = Payment.create((String)payPropertyTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap), payPropertyTaxDetails.getSource()))) {
            receiptDetails = new ReceiptDetails();
            receiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
            receiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
            receiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
            receiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
            receiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
            receiptDetails.setServiceName(billReceiptInfo.getServiceName());
            receiptDetails.setDescription(billReceiptInfo.getDescription());
            receiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
            receiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
            receiptDetails.setPaymentMode(payPropertyTaxDetails.getPaymentMode());
            receiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
            String[] paidFrom = null;
            String[] paidTo = null;
            Installment fromInstallment = null;
            Installment toInstallment = null;
            if (totalAmountToBePaid.compareTo(BigDecimal.ZERO) > 0) {
                ArrayList receiptAccountsList = new ArrayList(billReceiptInfo.getAccountDetails());
                Collections.sort(receiptAccountsList, new Comparator<ReceiptAccountInfo>(){

                    @Override
                    public int compare(ReceiptAccountInfo rcptAcctInfo1, ReceiptAccountInfo rcptAcctInfo2) {
                        if (rcptAcctInfo1.getOrderNumber() != null && rcptAcctInfo2.getOrderNumber() != null) {
                            return rcptAcctInfo1.getOrderNumber().compareTo(rcptAcctInfo2.getOrderNumber());
                        }
                        return 0;
                    }
                });
                for (ReceiptAccountInfo rcptAcctInfo : receiptAccountsList) {
                    if (rcptAcctInfo.getCrAmount().compareTo(BigDecimal.ZERO) <= 0 || rcptAcctInfo.getDescription().contains("Advance")) continue;
                    if (paidFrom == null) {
                        paidFrom = rcptAcctInfo.getDescription().split("-", 2);
                    }
                    paidTo = rcptAcctInfo.getDescription().split("-", 2);
                }
                if (paidFrom != null) {
                    fromInstallment = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Property Tax"), paidFrom[1].toString());
                }
                if (paidTo != null) {
                    toInstallment = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Property Tax"), paidTo[1].toString());
                }
            }
            if (totalAmountToBePaid.compareTo(BigDecimal.ZERO) == 0) {
                receiptDetails.setPaymentPeriod("");
                receiptDetails.setPaymentType("Advance");
            } else {
                receiptDetails.setPaymentPeriod(DateUtils.getDefaultFormattedDate((Date)fromInstallment.getFromDate()).concat(" to ").concat(DateUtils.getDefaultFormattedDate((Date)toInstallment.getToDate())));
            }
            if (payPropertyTaxDetails.getPaymentAmount().compareTo(totalAmountToBePaid) > 0) {
                receiptDetails.setPaymentType("Advance");
            } else if (totalAmountToBePaid.compareTo(payPropertyTaxDetails.getPaymentAmount()) > 0) {
                receiptDetails.setPaymentType("Partially");
            } else {
                receiptDetails.setPaymentType("Fully");
            }
            this.basicPropertyService.update(basicProperty);
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            receiptDetails.setErrorDetails(errorDetails);
        }
        return receiptDetails;
    }

    private Long validateBank(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        if (bank == null) {
            bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        }
        return (long)bank.getId();
    }

    public ErrorDetails payWaterTax(String consumerNo, String paymentMode, BigDecimal totalAmount, String paidBy) {
        ErrorDetails errorDetails = this.validatePaymentDetails(consumerNo, paymentMode, totalAmount, paidBy);
        if (null != errorDetails) {
            return errorDetails;
        }
        errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        return errorDetails;
    }

    public List<MasterCodeNamePairDetails> getPropertyTypeMasterDetails() {
        ArrayList<MasterCodeNamePairDetails> propTypeMasterDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List<PropertyTypeMaster> propertyTypeMasters = this.propertyTypeMasterDAO.findAllExcludeEWSHS();
        for (PropertyTypeMaster propertyTypeMaster : propertyTypeMasters) {
            MasterCodeNamePairDetails propTypeMasterDetails = new MasterCodeNamePairDetails();
            propTypeMasterDetails.setCode(propertyTypeMaster.getCode());
            propTypeMasterDetails.setName(propertyTypeMaster.getType());
            propTypeMasterDetailsList.add(propTypeMasterDetails);
        }
        return propTypeMasterDetailsList;
    }

    public PropertyTypeMaster getPropertyTypeMasterByCode(String propertyTypeMasterCode) {
        return this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(propertyTypeMasterCode);
    }

    public List<MasterCodeNamePairDetails> getPropertyTypeCategoryDetails(String categoryCode) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        AbstractMap codeNameMap = null;
        PropertyTypeMaster propertyTypeMasters = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(categoryCode);
        if (null != propertyTypeMasters && null != (codeNameMap = propertyTypeMasters.getCode().equalsIgnoreCase("VAC_LAND") ? PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY : PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY) && !codeNameMap.isEmpty()) {
            for (String code : codeNameMap.keySet()) {
                MasterCodeNamePairDetails mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamepairDetails.setCode(code);
                mstrCodeNamepairDetails.setName((String)codeNameMap.get(code));
                mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getPropertyTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        MasterCodeNamePairDetails mstrCodeNamepairDetails = null;
        HashMap<String, String> vacLandMap = PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY;
        TreeMap<String, String> nonVacLandMap = PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY;
        for (String key : vacLandMap.keySet()) {
            mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamepairDetails.setCode(key);
            mstrCodeNamepairDetails.setName((String)vacLandMap.get(key));
            mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
        }
        for (String code : nonVacLandMap.keySet()) {
            mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamepairDetails.setCode(code);
            mstrCodeNamepairDetails.setName((String)nonVacLandMap.get(code));
            mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getApartmentsAndComplexes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List apartmentList = this.entityManager.createQuery("from Apartment").getResultList();
        if (null != apartmentList) {
            for (Apartment apartment : apartmentList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(apartment.getCode());
                mstrCodeNamePairDetails.setName(apartment.getName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getReasonsForChangeProperty(String reason) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        Query qry = this.entityManager.createQuery("from PropertyMutationMaster pmm where pmm.type = :type");
        qry.setParameter("type", (Object)reason);
        List propMutationMasterList = qry.getResultList();
        if (null != propMutationMasterList) {
            for (PropertyMutationMaster propMutationMaster : propMutationMasterList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(propMutationMaster.getCode());
                mstrCodeNamePairDetails.setName(propMutationMaster.getMutationName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getBoundariesByBoundaryTypeAndHierarchyType(String boundaryType, String hierarchyType) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List boundaryList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryType, hierarchyType);
        if (boundaryList != null) {
            for (Boundary boundary : boundaryList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(boundary.getBoundaryNum().toString());
                mstrCodeNamePairDetails.setName(boundary.getName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public LocalityDetails getLocalityDetailsByLocalityCode(String localityCode) {
        Long boundaryNo = Long.valueOf(localityCode.substring(0, localityCode.indexOf("~")).trim());
        String name = localityCode.substring(localityCode.indexOf("~") + 1).trim();
        LocalityDetails localityDetails = null;
        Query qry = this.entityManager.createQuery("from Boundary b where b.boundaryNum = :boundaryNo and b.name = :name");
        qry.setParameter("boundaryNo", (Object)boundaryNo);
        qry.setParameter("name", (Object)name);
        List list = qry.getResultList();
        if (null != list && !list.isEmpty()) {
            localityDetails = new LocalityDetails();
            Boundary boundary = (Boundary)list.get(0);
            qry = this.entityManager.createQuery("from CrossHierarchy cr where cr.child = :child");
            qry.setParameter("child", (Object)boundary);
            list = qry.getResultList();
            if (null != list && !list.isEmpty()) {
                CrossHierarchy crossHeirarchyImpl = (CrossHierarchy)list.get(0);
                qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                qry.setParameter("id", (Object)crossHeirarchyImpl.getParent().getId());
                list = qry.getResultList();
                if (null != list && !list.isEmpty()) {
                    Boundary block = (Boundary)list.get(0);
                    localityDetails.setBlockName(block.getName());
                    qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                    qry.setParameter("id", (Object)block.getParent().getId());
                    list = qry.getResultList();
                    if (null != list && !list.isEmpty()) {
                        Boundary ward = (Boundary)list.get(0);
                        localityDetails.setWardName(ward.getName());
                        qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                        qry.setParameter("id", (Object)ward.getParent().getId());
                        list = qry.getResultList();
                        if (null != list && !list.isEmpty()) {
                            Boundary zone = (Boundary)list.get(0);
                            localityDetails.setZoneName(zone.getName());
                        }
                    }
                }
            }
        }
        return localityDetails;
    }

    public Boundary getBoundaryByNumberAndType(String boundaryNum, String boundaryTypeName, String hierarchyName) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeName, hierarchyName);
        Boundary boundary = this.boundaryService.getBoundaryByTypeAndNo(boundaryType, Long.valueOf(boundaryNum));
        return boundary;
    }

    public List<MasterCodeNamePairDetails> getEnumerationBlocks() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List enumerationBlockList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Election Ward", "ELECTION");
        for (Boundary boundary : enumerationBlockList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(boundary.getBoundaryNum().toString());
            mstrCodeNamePairDetails.setName(boundary.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getFloorTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List floorTypeList = this.entityManager.createQuery("from FloorType order by name").getResultList();
        for (FloorType floorType : floorTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(floorType.getId().toString());
            mstrCodeNamePairDetails.setName(floorType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getRoofTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List roofTypeList = this.entityManager.createQuery("from RoofType order by name").getResultList();
        for (RoofType roofType : roofTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(roofType.getId().toString());
            mstrCodeNamePairDetails.setName(roofType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getWallTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List wallTypeList = this.entityManager.createQuery("from WallType order by name").getResultList();
        for (WallType wallType : wallTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(wallType.getId().toString());
            mstrCodeNamePairDetails.setName(wallType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getWoodTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List woodTypeList = this.entityManager.createQuery("from WoodType order by name").getResultList();
        for (WoodType woodType : woodTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(woodType.getId().toString());
            mstrCodeNamePairDetails.setName(woodType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getBuildingClassifications() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List structClsfList = this.entityManager.createQuery("from StructureClassification").getResultList();
        for (StructureClassification structClsf : structClsfList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(structClsf.getConstrTypeCode());
            mstrCodeNamePairDetails.setName(structClsf.getTypeName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public StructureClassification getStructureClassificationByCode(String classificationCode) {
        Query qry = this.entityManager.createQuery("from StructureClassification sc where sc.constrTypeCode =:code");
        qry.setParameter("code", (Object)classificationCode);
        return (StructureClassification)((Object)qry.getSingleResult());
    }

    public List<MasterCodeNamePairDetails> getNatureOfUsages() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List usageList = this.entityManager.createQuery("from PropertyUsage order by usageName").getResultList();
        for (PropertyUsage propUsage : usageList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(propUsage.getUsageCode());
            mstrCodeNamePairDetails.setName(propUsage.getUsageName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public PropertyUsage getPropertyUsageByUsageCde(String usageCode) {
        Query qry = this.entityManager.createQuery("from PropertyUsage pu where pu.usageCode = :usageCode order by usageName");
        qry.setParameter("usageCode", (Object)usageCode);
        PropertyUsage propertyUsage = (PropertyUsage)((Object)qry.getSingleResult());
        return propertyUsage;
    }

    public List<MasterCodeNamePairDetails> getOccupancies() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List propOccupList = this.entityManager.createQuery("from PropertyOccupation").getResultList();
        for (PropertyOccupation propOccup : propOccupList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(propOccup.getOccupancyCode());
            mstrCodeNamePairDetails.setName(propOccup.getOccupation());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public PropertyOccupation getPropertyOccupationByOccupancyCode(String occupancyCode) {
        Query qry = this.entityManager.createQuery("from PropertyOccupation po where po.occupancyCode = :occupancyCode");
        qry.setParameter("occupancyCode", (Object)occupancyCode);
        PropertyOccupation propertyOccupation = (PropertyOccupation)((Object)qry.getSingleResult());
        return propertyOccupation;
    }

    public List<MasterCodeNamePairDetails> getExemptionCategories() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List taxExemptionReasonList = this.entityManager.createQuery("from TaxExemptionReason where isActive = true order by name").getResultList();
        for (TaxExemptionReason taxExemptionReason : taxExemptionReasonList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(taxExemptionReason.getCode());
            mstrCodeNamePairDetails.setName(taxExemptionReason.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public TaxExemptionReason getTaxExemptionReasonByCode(String exemptionReasonCode) {
        TaxExemptionReason taxExemptionReason = null;
        Query qry = this.entityManager.createQuery("from TaxExemptionReason ter where ter.code = :code");
        qry.setParameter("code", (Object)("" + exemptionReasonCode));
        List list = qry.getResultList();
        if (null != list && !list.isEmpty()) {
            taxExemptionReason = (TaxExemptionReason)((Object)qry.getSingleResult());
        }
        return taxExemptionReason;
    }

    public List<MasterCodeNamePairDetails> getApproverDepartments() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List approverDepartmentList = this.entityManager.createQuery("from Department order by name").getResultList();
        for (Department approverDepartment : approverDepartmentList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(approverDepartment.getCode());
            mstrCodeNamePairDetails.setName(approverDepartment.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public NewPropertyDetails createNewProperty(ViewPropertyDetails viewpropertyDetails) throws ParseException {
        NewPropertyDetails newPropertyDetails = null;
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        BasicProperty basicProperty = this.createBscPropty(viewpropertyDetails, propService);
        Address ownerCorrAddr = this.createCorrespondenceAddress(viewpropertyDetails, basicProperty.getAddress());
        PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
        property.setSource("SURVEY");
        property.setReferenceId(viewpropertyDetails.getReferenceId());
        ArrayList<File> fileAttachments = new ArrayList<File>(0);
        ArrayList<String> uploadContentTypes = new ArrayList<String>(0);
        ArrayList<String> uploadFileNames = new ArrayList<String>(0);
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        if (viewpropertyDetails.getTwSigned()) {
            viewpropertyDetails.setTwSigned(false);
        }
        this.processAndStoreDocumentsWithReason(basicProperty, "CREATE", fileAttachments, uploadFileNames, uploadContentTypes);
        this.basicPropertyService.createOwners(property, basicProperty, ownerCorrAddr);
        this.transitionWorkFlow(property, propService, "create");
        this.basicPropertyService.applyAuditing((AbstractAuditable)property.getState());
        basicProperty = (BasicProperty)this.basicPropertyService.persist(basicProperty);
        propService.updateIndexes(property, "New_Assessment");
        this.saveDocumentTypeDetails(basicProperty, viewpropertyDetails);
        if (null != basicProperty) {
            newPropertyDetails = new NewPropertyDetails();
            newPropertyDetails.setReferenceId(viewpropertyDetails.getReferenceId());
            newPropertyDetails.setApplicationNo(basicProperty.getProperty().getApplicationNo());
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            newPropertyDetails.setErrorDetails(errorDetails);
        }
        return newPropertyDetails;
    }

    private BasicProperty createBscPropty(ViewPropertyDetails viewPropertyDetails, PropertyService propService) throws ParseException {
        PropertyImpl property;
        BasicProperty basicProperty = this.setBasicPropertyValues(viewPropertyDetails, propService);
        PropertyTypeMaster propertyTypeMaster = this.getPropertyTypeMasterByCode(viewPropertyDetails.getPropertyTypeMaster());
        PropertyImpl propertyImpl = this.createPropertyWithBasicDetails(viewPropertyDetails.getPropertyTypeMaster());
        propertyImpl.setBasicProperty(basicProperty);
        this.setPropertyDetails(viewPropertyDetails, propertyImpl);
        if (!viewPropertyDetails.getPropertyTypeMaster().equalsIgnoreCase("VAC_LAND")) {
            FloorType floorType = null;
            RoofType roofType = null;
            WallType wallType = null;
            WoodType woodType = null;
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getFloorType())) {
                floorType = this.floorTypeService.getFloorTypeById(Long.valueOf(viewPropertyDetails.getFloorType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getRoofType())) {
                roofType = this.roofTypeService.getRoofTypeById(Long.valueOf(viewPropertyDetails.getRoofType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWallType())) {
                wallType = this.wallTypeService.getWallTypeById(Long.valueOf(viewPropertyDetails.getWallType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWoodType())) {
                woodType = this.woodTypeService.getWoodTypeById(Long.valueOf(viewPropertyDetails.getWoodType()));
            }
            this.setAmenities(viewPropertyDetails, propertyImpl);
            property = propService.createProperty(propertyImpl, viewPropertyDetails.getExtentOfSite(), viewPropertyDetails.getMutationReason(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, null, null, floorType != null ? floorType.getId() : null, roofType != null ? roofType.getId() : null, wallType != null ? wallType.getId() : null, woodType != null ? woodType.getId() : null, null, null, null, null, Boolean.FALSE);
        } else {
            this.setVacantLandDetails(viewPropertyDetails, propertyImpl);
            property = propService.createProperty(propertyImpl, viewPropertyDetails.getExtentOfSite(), viewPropertyDetails.getMutationReason(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, viewPropertyDetails.getRegdDocNo(), null, null, null, null, null, null, null, new Long(viewPropertyDetails.getVlPlotArea()), new Long(viewPropertyDetails.getLaAuthority()), Boolean.FALSE);
        }
        Date propCompletionDate = this.getCompletionDate(propService, property);
        property.setStatus(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        property.setPropertyModifyReason("CREATE");
        property.getPropertyDetail().setCategoryType(viewPropertyDetails.getCategory());
        basicProperty.addProperty(property);
        basicProperty.setPropOccupationDate(propCompletionDate);
        this.setBasicPropOwnerInfo(viewPropertyDetails, basicProperty);
        if (property != null && !property.getDocuments().isEmpty()) {
            propService.processAndStoreDocument(property.getDocuments());
        }
        try {
            propService.createDemand(propertyImpl, propCompletionDate);
        }
        catch (TaxCalculatorExeption taxCalculatorExeption) {
            // empty catch block
        }
        return basicProperty;
    }

    private BasicProperty setBasicPropertyValues(ViewPropertyDetails viewPropertyDetails, PropertyService propService) {
        BasicPropertyImpl basicProperty = new BasicPropertyImpl();
        basicProperty.setActive(Boolean.TRUE);
        basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_MOBILE);
        PropertyStatus propertyStatus = this.getPropertyStatus();
        basicProperty.setStatus(propertyStatus);
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        basicProperty.setParcelId(viewPropertyDetails.getParcelId());
        basicProperty.setLatitude(viewPropertyDetails.getLatitude());
        basicProperty.setLongitude(viewPropertyDetails.getLongitude());
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        PropertyMutationMaster propertyMutationMaster = this.getPropertyMutationMaster(viewPropertyDetails.getMutationReason());
        basicProperty.setPropertyMutationMaster(propertyMutationMaster);
        Boundary block = this.getBoundaryByNumberAndType(viewPropertyDetails.getBlockName(), "Block", "REVENUE");
        PropertyAddress propAddress = this.createPropAddress(viewPropertyDetails, block);
        basicProperty.setAddress(propAddress);
        PropertyID propertyID = this.createPropertID(basicProperty, viewPropertyDetails, block);
        basicProperty.setPropertyID(propertyID);
        if (propertyMutationMaster.getCode().equals("BIFUR")) {
            basicProperty.addPropertyStatusValues(propService.createPropStatVal(basicProperty, "CREATE", null, null, null, null, viewPropertyDetails.getParentPropertyAssessmentNo()));
        }
        return basicProperty;
    }

    private void setBasicPropOwnerInfo(ViewPropertyDetails viewPropertyDetails, BasicProperty basicProperty) {
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getDocType()) && "Un-registered Document / Notary document".equals(viewPropertyDetails.getDocType())) {
            basicProperty.setPropertyOwnerInfoProxy(this.getNotaryOwners());
        } else {
            basicProperty.setPropertyOwnerInfoProxy(this.getPropertyOwnerInfoList(viewPropertyDetails.getOwnerDetails()));
        }
    }

    private List<PropertyOwnerInfo> getNotaryOwners() {
        ArrayList<PropertyOwnerInfo> notaryOwnersList = new ArrayList<PropertyOwnerInfo>();
        PropertyOwnerInfo notaryPropOwner = new PropertyOwnerInfo();
        User notaryUser = this.userService.getUserByUsername("The Holder Of The Premises");
        notaryPropOwner.setOwner(notaryUser);
        notaryOwnersList.add(notaryPropOwner);
        return notaryOwnersList;
    }

    private void setPropertyDetails(ViewPropertyDetails viewPropertyDetails, PropertyImpl propertyImpl) throws ParseException {
        propertyImpl.getPropertyDetail().setCorrAddressDiff(viewPropertyDetails.getIsCorrAddrDiff());
        if (!viewPropertyDetails.getFloorDetailsEntered().booleanValue()) {
            propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(viewPropertyDetails.getEffectiveDate()));
        } else {
            propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(viewPropertyDetails.getFloorDetails().get(0).getOccupancyDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getApartmentCmplx())) {
            Apartment apartment = this.getApartmentByCode(viewPropertyDetails.getApartmentCmplx());
            propertyImpl.getPropertyDetail().setApartment(apartment);
        }
        propertyImpl.getPropertyDetail().setOccupancyCertificationNo(viewPropertyDetails.getOccupancyCertificationNo());
        propertyImpl.getPropertyDetail().setOccupancyCertificationDate(viewPropertyDetails.getOccupancyCertificationDate());
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getDocType()) && "Un-registered Document / Notary document".equals(viewPropertyDetails.getDocType())) {
            propertyImpl.getPropertyDetail().setStructure(true);
        }
    }

    private Date getCompletionDate(PropertyService propService, PropertyImpl propertyImpl) {
        Date propCompletionDate = !propertyImpl.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? propService.getLowestDtOfCompFloorWise(propertyImpl.getPropertyDetail().getFloorDetailsProxy()) : propertyImpl.getPropertyDetail().getDateOfCompletion();
        return propCompletionDate;
    }

    private void setVacantLandDetails(ViewPropertyDetails viewPropertyDetails, PropertyImpl propertyImpl) throws ParseException {
        propertyImpl.getPropertyDetail().setDateOfCompletion(viewPropertyDetails.getEffectiveDate() != null ? this.convertStringToDate(viewPropertyDetails.getEffectiveDate()) : null);
        propertyImpl.getPropertyDetail().setCurrentCapitalValue(viewPropertyDetails.getCurrentCapitalValue());
        propertyImpl.getPropertyDetail().setSurveyNumber(viewPropertyDetails.getSurveyNumber());
        propertyImpl.getPropertyDetail().setPattaNumber(viewPropertyDetails.getPattaNumber());
        propertyImpl.getPropertyDetail().setLayoutPermitNo(viewPropertyDetails.getLpNo() != null ? viewPropertyDetails.getLpNo() : null);
        propertyImpl.getPropertyDetail().setLayoutPermitDate(viewPropertyDetails.getLpDate() != null ? this.convertStringToDate(viewPropertyDetails.getLpDate()) : null);
        Area area = new Area();
        area.setArea(viewPropertyDetails.getVacantLandArea());
        propertyImpl.getPropertyDetail().setSitalArea(area);
        propertyImpl.getPropertyDetail().setMarketValue(viewPropertyDetails.getMarketValue());
    }

    private void setAmenities(ViewPropertyDetails viewPropertyDetails, PropertyImpl propertyImpl) throws ParseException {
        propertyImpl.getPropertyDetail().setFloorDetailsProxy(this.getFloorList(viewPropertyDetails.getFloorDetails()));
        propertyImpl.getPropertyDetail().setLift(viewPropertyDetails.getHasLift());
        propertyImpl.getPropertyDetail().setToilets(viewPropertyDetails.getHasToilet());
        propertyImpl.getPropertyDetail().setWaterTap(viewPropertyDetails.getHasWaterTap());
        propertyImpl.getPropertyDetail().setElectricity(viewPropertyDetails.getHasElectricity());
        propertyImpl.getPropertyDetail().setAttachedBathRoom(viewPropertyDetails.getHasAttachedBathroom());
        propertyImpl.getPropertyDetail().setWaterHarvesting(viewPropertyDetails.getHasWaterHarvesting());
        propertyImpl.getPropertyDetail().setCable(viewPropertyDetails.getHasCableConnection());
    }

    private PropertyAddress createPropAddress(ViewPropertyDetails viewPropertyDetails, Boundary block) {
        PropertyAddress propAddr = new PropertyAddress();
        propAddr.setHouseNoBldgApt(viewPropertyDetails.getDoorNo());
        propAddr.setAreaLocalitySector(this.getBoundaryByNumberAndType(viewPropertyDetails.getLocalityName(), "Locality", "LOCATION").getName());
        String cityName = ApplicationThreadLocals.getCityName();
        propAddr.setStreetRoadLine(block.getParent().getName());
        propAddr.setCityTownVillage(cityName);
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getPinCode())) {
            propAddr.setPinCode(viewPropertyDetails.getPinCode());
        }
        return propAddr;
    }

    private Address createCorrespondenceAddress(ViewPropertyDetails viewPropertyDetails, PropertyAddress propAddr) {
        CorrespondenceAddress ownerCorrAddr = new CorrespondenceAddress();
        if (viewPropertyDetails.getIsCorrAddrDiff().booleanValue()) {
            ownerCorrAddr.setAreaLocalitySector(viewPropertyDetails.getCorrAddr1());
            ownerCorrAddr.setStreetRoadLine(viewPropertyDetails.getCorrAddr2());
            ownerCorrAddr.setPinCode(viewPropertyDetails.getCorrPinCode());
        } else {
            ownerCorrAddr.setAreaLocalitySector(propAddr.getAreaLocalitySector());
            ownerCorrAddr.setHouseNoBldgApt(propAddr.getHouseNoBldgApt());
            ownerCorrAddr.setStreetRoadLine(propAddr.getStreetRoadLine());
            ownerCorrAddr.setPinCode(propAddr.getPinCode());
        }
        return ownerCorrAddr;
    }

    private PropertyID createPropertID(BasicProperty basicProperty, ViewPropertyDetails viewPropertyDetails, Boundary block) {
        PropertyID propertyID = new PropertyID();
        Boundary ward = this.getBoundaryByNumberAndType(viewPropertyDetails.getWardName(), "Ward", "REVENUE");
        Boundary zone = this.getBoundaryByNumberAndType(viewPropertyDetails.getZoneName(), "Zone", "REVENUE");
        Boundary locality = this.getBoundaryByNumberAndType(viewPropertyDetails.getLocalityName(), "Locality", "LOCATION");
        propertyID.setArea(block);
        propertyID.setWard(ward);
        propertyID.setZone(zone);
        propertyID.setLocality(locality);
        propertyID.setBasicProperty(basicProperty);
        Boundary electionBoundary = this.getBoundaryByNumberAndType(viewPropertyDetails.getElectionWardName(), "Ward", "ADMINISTRATION");
        if (electionBoundary != null) {
            propertyID.setElectionBoundary(electionBoundary);
            basicProperty.setBoundary(electionBoundary);
        }
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getNorthBoundary())) {
            propertyID.setNorthBoundary(viewPropertyDetails.getNorthBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getSouthBoundary())) {
            propertyID.setSouthBoundary(viewPropertyDetails.getSouthBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getEastBoundary())) {
            propertyID.setEastBoundary(viewPropertyDetails.getEastBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWestBoundary())) {
            propertyID.setWestBoundary(viewPropertyDetails.getWestBoundary());
        }
        propertyID.setBasicProperty(basicProperty);
        return propertyID;
    }

    public void saveDocumentTypeDetails(BasicProperty basicProperty, ViewPropertyDetails viewPropertyDetails) throws ParseException {
        DocumentTypeDetails documentTypeDetails = new DocumentTypeDetails();
        documentTypeDetails.setBasicPropertyId(basicProperty.getId());
        documentTypeDetails.setDocumentName(viewPropertyDetails.getDocType());
        documentTypeDetails.setDocumentNo(viewPropertyDetails.getRegdDocNo());
        documentTypeDetails.setDocumentDate(StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getRegdDocDate()) ? this.convertStringToDate(viewPropertyDetails.getRegdDocDate()) : null);
        documentTypeDetails.setCourtName(viewPropertyDetails.getCourtName());
        documentTypeDetails.setProceedingNo(viewPropertyDetails.getMroProcNo());
        documentTypeDetails.setProceedingDate(StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getMroProcDate()) ? this.convertStringToDate(viewPropertyDetails.getMroProcDate()) : null);
        documentTypeDetails.setSigned(viewPropertyDetails.getTwSigned());
        this.documentTypeDetailsService.persist((Object)documentTypeDetails);
    }

    private PropertyStatus getPropertyStatus() {
        Query qry = this.entityManager.createQuery("from PropertyStatus where statusCode = :statusCode");
        qry.setParameter("statusCode", (Object)"WORKFLOW");
        PropertyStatus propertyStatus = (PropertyStatus)qry.getSingleResult();
        return propertyStatus;
    }

    private PropertyMutationMaster getPropertyMutationMaster(String mutationReasonCode) {
        Query qry = this.entityManager.createQuery("from PropertyMutationMaster pmm where pmm.code = :mutationReasonCode");
        qry.setParameter("mutationReasonCode", (Object)mutationReasonCode);
        PropertyMutationMaster propMutationMaster = (PropertyMutationMaster)qry.getSingleResult();
        return propMutationMaster;
    }

    public ErrorDetails validatePaymentDetails(String assessmentNo, String paymentMode, BigDecimal totalAmount, String paidBy) {
        ErrorDetails errorDetails = null;
        if (assessmentNo == null || assessmentNo.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (assessmentNo.trim().length() > 0 && assessmentNo.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(assessmentNo).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (paymentMode == null || paymentMode.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(paymentMode.trim()) || "CHEQUE".equalsIgnoreCase(paymentMode.trim()) || "DD".equalsIgnoreCase(paymentMode.trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        return errorDetails;
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.format(date);
    }

    public Date convertStringToDate(String dateInString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.parse(dateInString);
    }

    private void processAndStoreDocumentsWithReason(BasicProperty basicProperty, String reason, List<File> fileAttachments, List<String> uploadFileNames, List<String> uploadContentTypes) {
        if (!fileAttachments.isEmpty()) {
            int fileCount = 0;
            for (File file : fileAttachments) {
                FileStoreMapper fileStore = this.fileStoreService.store(file, uploadFileNames.get(fileCount), uploadContentTypes.get(fileCount++), "PTIS");
                PropertyDocs propertyDoc = new PropertyDocs();
                propertyDoc.setSupportDoc(fileStore);
                propertyDoc.setBasicProperty(basicProperty);
                propertyDoc.setReason(reason);
                basicProperty.addDocs(propertyDoc);
            }
        }
    }

    private PropertyImpl createPropertyWithBasicDetails(String propertyType) {
        PropertyImpl propertyImpl = new PropertyImpl();
        if (propertyType.equalsIgnoreCase("VAC_LAND")) {
            propertyImpl.setPropertyDetail(new VacantProperty());
        } else {
            propertyImpl.setPropertyDetail(new BuiltUpProperty());
        }
        propertyImpl.setBasicProperty(new BasicPropertyImpl());
        return propertyImpl;
    }

    private List<Floor> getFloorList(List<FloorDetails> floorDetailsList) throws ParseException {
        ArrayList<Floor> floorList = new ArrayList<Floor>(0);
        for (FloorDetails floorDetails : floorDetailsList) {
            Floor floor = new Floor();
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getFloorNoCode())) {
                floor.setFloorNo(Integer.valueOf(floorDetails.getFloorNoCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getBuildClassificationCode())) {
                floor.setStructureClassification(this.getStructureClassificationByCode(floorDetails.getBuildClassificationCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getNatureOfUsageCode())) {
                floor.setPropertyUsage(this.getPropertyUsageByUsageCde(floorDetails.getNatureOfUsageCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getOccupancyCode())) {
                floor.setPropertyOccupation(this.getPropertyOccupationByOccupancyCode(floorDetails.getOccupancyCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getFirmName())) {
                floor.setFirmName(floorDetails.getFirmName());
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getOccupantName())) {
                floor.setOccupantName(floorDetails.getOccupantName());
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getConstructionDate())) {
                floor.setConstructionDate(this.convertStringToDate(floorDetails.getConstructionDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getOccupancyDate())) {
                floor.setOccupancyDate(this.convertStringToDate(floorDetails.getOccupancyDate()));
            }
            floor.setCreatedDate(new Date());
            Area builtUpArea = new Area();
            builtUpArea.setBreadth(floorDetails.getPlinthBreadth());
            builtUpArea.setLength(floorDetails.getPlinthLength());
            floor.setBuiltUpArea(builtUpArea);
            floor.setUnstructuredLand(floorDetails.getUnstructuredLand());
            if (!floor.getUnstructuredLand().booleanValue()) {
                builtUpArea.setArea(Float.valueOf((float)((double)Math.round((double)(builtUpArea.getBreadth().floatValue() * builtUpArea.getLength().floatValue()) * 100.0) / 100.0)));
            } else {
                builtUpArea.setArea(floorDetails.getPlinthArea());
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getBuildingPermissionNo())) {
                floor.setBuildingPermissionNo(floorDetails.getBuildingPermissionNo());
            }
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getBuildingPermissionDate())) {
                floor.setBuildingPermissionDate(this.convertStringToDate(floorDetails.getBuildingPermissionDate()));
            }
            Area buildingPlanPlinthArea = new Area();
            buildingPlanPlinthArea.setArea(floorDetails.getBuildingPlanPlinthArea());
            floor.setBuildingPlanPlinthArea(buildingPlanPlinthArea);
            floorList.add(floor);
        }
        return floorList;
    }

    private List<PropertyOwnerInfo> getPropertyOwnerInfoList(List<OwnerInformation> ownerInfoList) {
        ArrayList<PropertyOwnerInfo> proeprtyOwnerInfoList = new ArrayList<PropertyOwnerInfo>(0);
        for (OwnerInformation ownerInfo : ownerInfoList) {
            PropertyOwnerInfo propOwner = new PropertyOwnerInfo();
            User owner = new User();
            owner.setAadhaarNumber(StringUtils.isNotBlank((CharSequence)ownerInfo.getAadhaarNo()) ? ownerInfo.getAadhaarNo() : "");
            owner.setSalutation(StringUtils.isNotBlank((CharSequence)ownerInfo.getSalutationCode()) ? ownerInfo.getSalutationCode() : "");
            owner.setName(StringUtils.isNotBlank((CharSequence)ownerInfo.getName()) ? ownerInfo.getName() : "");
            owner.setGender(Gender.valueOf((String)ownerInfo.getGender()));
            owner.setMobileNumber(StringUtils.isNotBlank((CharSequence)ownerInfo.getMobileNumber()) ? ownerInfo.getMobileNumber() : "");
            owner.setEmailId(StringUtils.isNotBlank((CharSequence)ownerInfo.getEmailId()) ? ownerInfo.getEmailId() : "");
            owner.setGuardianRelation(StringUtils.isNotBlank((CharSequence)ownerInfo.getGuardianRelation()) ? ownerInfo.getGuardianRelation() : "");
            owner.setGuardian(StringUtils.isNotBlank((CharSequence)ownerInfo.getGuardian()) ? ownerInfo.getGuardian() : "");
            propOwner.setOwner(owner);
            proeprtyOwnerInfoList.add(propOwner);
        }
        return proeprtyOwnerInfoList;
    }

    public BillReceiptInfo validateTransanctionIdPresent(String transantion, String propertyType) {
        if (propertyType.equals("VAC_LAND")) {
            return this.collectionService.getReceiptInfo("VLT", transantion);
        }
        return this.collectionService.getReceiptInfo("PT", transantion);
    }

    private PropertyImpl transitionWorkFlow(PropertyImpl property, PropertyService propService, String mode) {
        DateTime currentDate = new DateTime();
        User user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        String approverComments = FORWARD_SUCCESS_COMMENT;
        String currentState = "";
        String additionalRule = "";
        String natureOftask = "";
        if (mode.equals("create")) {
            currentState = "Created";
            additionalRule = "NEW ASSESSMENT";
            natureOftask = "New Assessment";
        } else {
            currentState = "Created";
            additionalRule = "ALTER ASSESSMENT";
            natureOftask = "Addition/Alteration";
        }
        Assignment assignment = propService.getUserPositionByZone(property.getBasicProperty(), false);
        Position pos = assignment.getPosition();
        WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, currentState, null);
        property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(FORWARD_SUCCESS_COMMENT).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOftask).withInitiator((OwnerGroup)(assignment != null ? assignment.getPosition() : null));
        return property;
    }

    public List<MasterCodeNamePairDetails> getDocumentTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List documentTypesList = this.entityManager.createQuery("from DocumentType order by id").getResultList();
        for (DocumentType documentType : documentTypesList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(documentType.getId().toString());
            mstrCodeNamePairDetails.setName(documentType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    private Apartment getApartmentByCode(String apartmentCode) {
        Query qry = this.entityManager.createQuery("from Apartment ap where ap.code = :code");
        qry.setParameter("code", (Object)apartmentCode);
        Apartment apartment = (Apartment)((Object)qry.getSingleResult());
        return apartment;
    }

    public RestAssessmentDetails fetchAssessmentDetails(String assessmentNo) {
        PropertyMutation propertyMutation;
        RestAssessmentDetails assessmentDetails = new RestAssessmentDetails();
        BasicProperty basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(assessmentNo);
        if (basicProperty != null) {
            assessmentDetails.setAssessmentNo(basicProperty.getUpicNo());
            assessmentDetails.setPropertyAddress(basicProperty.getAddress().toString());
            PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
            assessmentDetails.setLocalityName(basicProperty.getPropertyID().getLocality().getName());
            if (property != null) {
                assessmentDetails.setOwnerDetails(this.prepareOwnerInfo(property));
                if (property.getPropertyDetail().getTotalBuiltupArea() != null && property.getPropertyDetail().getTotalBuiltupArea().getArea() != null) {
                    assessmentDetails.setPlinthArea(property.getPropertyDetail().getTotalBuiltupArea().getArea());
                }
                Ptdemand currentPtdemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
                BigDecimal totalTaxDue = BigDecimal.ZERO;
                if (currentPtdemand != null) {
                    for (EgDemandDetails demandDetails : currentPtdemand.getEgDemandDetails()) {
                        if (demandDetails.getAmount().compareTo(demandDetails.getAmtCollected()) <= 0) continue;
                        totalTaxDue = totalTaxDue.add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()));
                    }
                }
                assessmentDetails.setTotalTaxDue(totalTaxDue);
            }
        }
        if ((propertyMutation = this.getLatestPropertyMutationByAssesmentNo(assessmentNo)) != null) {
            assessmentDetails.setMutationFee(propertyMutation.getMutationFee());
            if (StringUtils.isNotBlank((CharSequence)propertyMutation.getReceiptNum())) {
                assessmentDetails.setIsMutationFeePaid("Y");
                assessmentDetails.setFeeReceipt(propertyMutation.getReceiptNum());
                Date receiptDate = null;
                Query qry = this.entityManager.createQuery("select receiptdate from ReceiptHeader where receiptnumber = :receiptNum");
                qry.setParameter("receiptNum", (Object)propertyMutation.getReceiptNum());
                receiptDate = (Date)qry.getSingleResult();
                assessmentDetails.setFeeReceiptDate(new SimpleDateFormat("dd/MM/yyyy").format(receiptDate));
            } else {
                assessmentDetails.setIsMutationFeePaid("N");
            }
            assessmentDetails.setApplicationNo(propertyMutation.getApplicationNo());
        } else {
            assessmentDetails.setIsMutationFeePaid("N");
            assessmentDetails.setFeeReceipt("");
            assessmentDetails.setFeeReceiptDate("");
            assessmentDetails.setApplicationNo("");
        }
        return assessmentDetails;
    }

    public RestAssessmentDetails loadAssessmentDetails(String applicationNo) {
        RestAssessmentDetails assessmentDetails = new RestAssessmentDetails();
        PropertyMutation propertyMutation = this.getPropertyMutationByAssesmentNoAndApplicationNo(null, applicationNo);
        if (propertyMutation != null) {
            BasicProperty basicProperty = propertyMutation.getBasicProperty();
            if (basicProperty != null) {
                assessmentDetails.setAssessmentNo(basicProperty.getUpicNo());
                assessmentDetails.setPropertyAddress(basicProperty.getAddress().toString());
                PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
                assessmentDetails.setLocalityName(basicProperty.getPropertyID().getLocality().getName());
                if (property != null) {
                    assessmentDetails.setOwnerDetails(this.prepareOwnerInfo(property));
                    if (property.getPropertyDetail().getTotalBuiltupArea() != null && property.getPropertyDetail().getTotalBuiltupArea().getArea() != null) {
                        assessmentDetails.setPlinthArea(property.getPropertyDetail().getTotalBuiltupArea().getArea());
                    }
                    Ptdemand currentPtdemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
                    BigDecimal totalTaxDue = BigDecimal.ZERO;
                    if (currentPtdemand != null) {
                        for (EgDemandDetails demandDetails : currentPtdemand.getEgDemandDetails()) {
                            if (demandDetails.getAmount().compareTo(demandDetails.getAmtCollected()) <= 0) continue;
                            totalTaxDue = totalTaxDue.add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()));
                        }
                    }
                    assessmentDetails.setTotalTaxDue(totalTaxDue);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)propertyMutation.getReceiptNum())) {
                assessmentDetails.setFeeReceipt(propertyMutation.getReceiptNum());
                assessmentDetails.setIsMutationFeePaid("Y");
                assessmentDetails.setMutationFee(BigDecimal.ZERO);
            } else {
                assessmentDetails.setIsMutationFeePaid("N");
                assessmentDetails.setMutationFee(propertyMutation.getMutationFee());
            }
            assessmentDetails.setApplicationNo(propertyMutation.getApplicationNo());
        } else {
            assessmentDetails.setIsMutationFeePaid("N");
        }
        return assessmentDetails;
    }

    public ReceiptDetails payMutationFee(PayPropertyTaxDetails payPropertyTaxDetails) {
        ReceiptDetails receiptDetails = null;
        ErrorDetails errorDetails = null;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropertyTaxDetails.getAssessmentNo());
        PropertyMutation propertyMutation = this.getLatestPropertyMutationByAssesmentNo(payPropertyTaxDetails.getAssessmentNo());
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setTransanctionReferenceNumber(payPropertyTaxDetails.getTransactionId());
        this.propertyTaxBillable.setMutationFeePayment(Boolean.TRUE);
        this.propertyTaxBillable.setMutationFee(payPropertyTaxDetails.getPaymentAmount());
        this.propertyTaxBillable.setCallbackForApportion(Boolean.FALSE);
        if (propertyMutation != null) {
            this.propertyTaxBillable.setMutationApplicationNo(propertyMutation.getApplicationNo());
        }
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateManualBillNumber(basicProperty.getPropertyID()));
        EgBill egBill = this.ptBillServiceImpl.generateBill(this.propertyTaxBillable);
        CollectionHelper collectionHelper = new CollectionHelper(egBill);
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>();
        paymentDetailsMap.put("amount", payPropertyTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", egBill.getCitizenName());
        if ("CHEQUE".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", payPropertyTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", ChequePayment.CHEQUE_DATE_FORMAT.format(payPropertyTaxDetails.getChqddDate()));
            paymentDetailsMap.put("branchName", payPropertyTaxDetails.getBranchName());
            Long validatesBankId = this.validateBank(payPropertyTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
        }
        Payment payment = Payment.create((String)payPropertyTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap);
        collectionHelper.setIsMutationFeePayment(true);
        BillReceiptInfo billReceiptInfo = collectionHelper.executeCollection(payment, payPropertyTaxDetails.getSource());
        if (null != billReceiptInfo) {
            receiptDetails = new ReceiptDetails();
            receiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
            receiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
            receiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
            receiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
            receiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
            receiptDetails.setServiceName(billReceiptInfo.getServiceName());
            receiptDetails.setDescription(billReceiptInfo.getDescription());
            receiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
            receiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
            receiptDetails.setPaymentMode(payPropertyTaxDetails.getPaymentMode());
            receiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            receiptDetails.setErrorDetails(errorDetails);
        }
        return receiptDetails;
    }

    public boolean validateMutationFee(String assessmentNo, BigDecimal paymentAmount) {
        boolean validFee = true;
        PropertyMutation propertyMutation = this.getLatestPropertyMutationByAssesmentNo(assessmentNo);
        if (propertyMutation != null) {
            if (paymentAmount.compareTo(propertyMutation.getMutationFee()) > 0) {
                validFee = false;
            }
        } else {
            validFee = false;
        }
        return validFee;
    }

    public PropertyMutation getPropertyMutationByAssesmentNoAndApplicationNo(String assessmentNo, String applicationNo) {
        PropertyMutation propertyMutation = this.propertyMutationDAO.getPropertyMutationForAssessmentNoAndApplicationNumber(assessmentNo, applicationNo);
        return propertyMutation;
    }

    public PropertyMutation getLatestPropertyMutationByAssesmentNo(String assessmentNo) {
        PropertyMutation propertyMutation = this.propertyMutationDAO.getPropertyLatestMutationForAssessmentNo(assessmentNo);
        return propertyMutation;
    }

    public List<Object[]> getWardBlockLocalityMapping() {
        StringBuilder queryString = new StringBuilder();
        queryString.append("select parent.parent.boundaryNum as wardnum, parent.parent.name as wardname, parent.boundaryNum as blocknum,");
        queryString.append(" parent.name as blockname, child.boundaryNum as localitynum, child.name as localityname");
        queryString.append(" from CrossHierarchy ch, Boundary parent, Boundary child");
        queryString.append(" where ch.parent.id = parent.id  and ch.child.id = child.id  and ch.parentType.name=:block and");
        queryString.append(" ch.childType.name=:locality and parent.parent.boundaryType.hierarchyType.name=:hierarchyType");
        List boundaryDetails = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString()).setParameter("block", (Object)"Block").setParameter("locality", (Object)"Locality").setParameter("hierarchyType", (Object)"REVENUE").list();
        return boundaryDetails;
    }

    public List<AssessmentInfo> getPropertyDetailsForWard(String ulbCode, String wardNum, String assessmentNo, String doorNo, String oldAssessmentNo) {
        Long wardId = null;
        if (StringUtils.isNotBlank((CharSequence)wardNum)) {
            Boundary ward = this.getBoundaryByNumberAndType(wardNum, "Ward", "REVENUE");
            wardId = ward.getId();
        }
        ArrayList<AssessmentInfo> propertyDetails = new ArrayList<AssessmentInfo>();
        List<BasicProperty> basicProperties = this.basicPropertyDAO.getActiveBasicPropertiesForWard(wardId, assessmentNo, doorNo, oldAssessmentNo);
        if (!basicProperties.isEmpty()) {
            for (BasicProperty basicProperty : basicProperties) {
                AssessmentInfo assessmentInfo = new AssessmentInfo();
                assessmentInfo.setUlbCode(ulbCode);
                this.prepareProperyDetailsInfo(basicProperty, assessmentInfo);
                propertyDetails.add(assessmentInfo);
            }
        }
        return propertyDetails;
    }

    private void prepareProperyDetailsInfo(BasicProperty basicProperty, AssessmentInfo assessmentInfo) {
        Property property = basicProperty.getProperty();
        assessmentInfo.setOldAssessmentNumber(basicProperty.getOldMuncipalNum());
        assessmentInfo.setAssessmentNumber(basicProperty.getUpicNo());
        assessmentInfo.setCategory(basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster().getType());
        PropertyID propertyID = basicProperty.getPropertyID();
        if (property != null) {
            PropertyDetail propertyDetail = property.getPropertyDetail();
            assessmentInfo.setExemption(property.getTaxExemptedReason() == null ? "N" : "Y");
            this.populatePropertyDetails(basicProperty, assessmentInfo, propertyID, propertyDetail);
        }
        this.populateOwnerAndAddressDetails(basicProperty, assessmentInfo, propertyID);
    }

    public void populateOwnerAndAddressDetails(BasicProperty basicProperty, AssessmentInfo assessmentInfo, PropertyID propertyID) {
        if (!basicProperty.getPropertyOwnerInfo().isEmpty()) {
            for (PropertyOwnerInfo propOwner : basicProperty.getPropertyOwnerInfo()) {
                List addrSet = propOwner.getOwner().getAddress();
                Iterator iterator = addrSet.iterator();
                if (!iterator.hasNext()) continue;
                Address address = (Address)iterator.next();
                assessmentInfo.setDoorNo(address.getHouseNoBldgApt() == null ? "N/A" : address.getHouseNoBldgApt());
            }
            assessmentInfo.setOwnerDetails(this.getOwnerDetails(basicProperty));
        }
        this.getAddressDetails(basicProperty, assessmentInfo, propertyID);
    }

    private void getAddressDetails(BasicProperty basicProperty, AssessmentInfo assessmentInfo, PropertyID propertyID) {
        if (basicProperty.getAddress() != null) {
            assessmentInfo.setPropertyAddress(basicProperty.getAddress().toString());
        }
        if (propertyID.getZone() != null && StringUtils.isNotBlank((CharSequence)propertyID.getZone().getName())) {
            assessmentInfo.setRevZone(propertyID.getZone().getName());
        }
        if (propertyID.getWard() != null && StringUtils.isNotBlank((CharSequence)propertyID.getWard().getName())) {
            assessmentInfo.setRevWard(propertyID.getWard().getName());
        }
        if (propertyID.getArea() != null && StringUtils.isNotBlank((CharSequence)propertyID.getArea().getName())) {
            assessmentInfo.setRevBlock(propertyID.getArea().getName());
        }
        if (propertyID.getLocality() != null && StringUtils.isNotBlank((CharSequence)propertyID.getLocality().getName())) {
            assessmentInfo.setLocalityName(propertyID.getLocality().getName());
        }
        if (propertyID.getElectionBoundary() != null && StringUtils.isNotBlank((CharSequence)propertyID.getElectionBoundary().getName())) {
            assessmentInfo.setElectionWardName(propertyID.getElectionBoundary().getName());
        }
    }

    public void populatePropertyDetails(BasicProperty basicProperty, AssessmentInfo assessmentInfo, PropertyID propertyID, PropertyDetail propertyDetail) {
        DocumentTypeDetails docTypeDetails;
        assessmentInfo.setEffectiveDate(DateUtils.getDefaultFormattedDate((Date)basicProperty.getPropOccupationDate()));
        assessmentInfo.setPropertyType(PropertyTaxConstants.PROPERTY_TYPE_CATEGORIES.get(propertyDetail.getCategoryType()));
        assessmentInfo.setApartmentCmplx(propertyDetail.getApartment() == null ? "N/A" : propertyDetail.getApartment().getName());
        assessmentInfo.setExtentOfSite(propertyDetail.getSitalArea() == null ? "N/A" : propertyDetail.getSitalArea().getArea().toString());
        assessmentInfo.setRegdDocNo(basicProperty.getRegdDocNo());
        if (basicProperty.getRegdDocDate() != null) {
            assessmentInfo.setRegdDocDate(DateUtils.getDefaultFormattedDate((Date)basicProperty.getRegdDocDate()));
        }
        if (!propertyDetail.getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.getAmenitiesAndConstructionTypeDetails(assessmentInfo, propertyDetail);
            assessmentInfo.setFloorInfo(this.getFloorDetails(propertyDetail));
        } else {
            this.getVacantLandDetails(assessmentInfo, propertyDetail, propertyID);
        }
        Query query = this.entityManager.createNamedQuery("DOCUMENT_TYPE_DETAILS_BY_ID");
        query.setParameter(1, (Object)propertyID.getBasicProperty().getId());
        List docTypeDetailsList = query.getResultList();
        if (!docTypeDetailsList.isEmpty() && (docTypeDetails = (DocumentTypeDetails)((Object)docTypeDetailsList.get(0))) != null) {
            assessmentInfo.setDocType(docTypeDetails.getDocumentName());
            assessmentInfo.setMroProcNo(docTypeDetails.getProceedingNo());
            if (docTypeDetails.getProceedingDate() != null) {
                assessmentInfo.setMroProcDate(DateUtils.getDefaultFormattedDate((Date)docTypeDetails.getProceedingDate()));
            }
            assessmentInfo.setCourtName(docTypeDetails.getCourtName());
            assessmentInfo.setTwSigned(docTypeDetails.isSigned());
        }
    }

    private void getAmenitiesAndConstructionTypeDetails(AssessmentInfo assessmentInfo, PropertyDetail propertyDetail) {
        assessmentInfo.setHasLift(propertyDetail.isLift());
        assessmentInfo.setHasToilet(propertyDetail.isToilets());
        assessmentInfo.setHasWaterTap(propertyDetail.isWaterTap());
        assessmentInfo.setHasElectricity(propertyDetail.isElectricity());
        assessmentInfo.setHasAttachedBathroom(propertyDetail.isAttachedBathRoom());
        assessmentInfo.setHasWaterHarvesting(propertyDetail.isWaterHarvesting());
        assessmentInfo.setHasCableConnection(propertyDetail.isCable());
        if (propertyDetail.getFloorType() != null) {
            assessmentInfo.setFloorType(propertyDetail.getFloorType().getName());
        }
        if (propertyDetail.getRoofType() != null) {
            assessmentInfo.setRoofType(propertyDetail.getRoofType().getName());
        }
        assessmentInfo.setWallType(propertyDetail.getWallType() == null ? "N/A" : propertyDetail.getWallType().getName());
        assessmentInfo.setWoodType(propertyDetail.getWoodType() == null ? "N/A" : propertyDetail.getWoodType().getName());
    }

    private List<OwnerInformation> getOwnerDetails(BasicProperty basicProperty) {
        ArrayList<OwnerInformation> ownerDetails = new ArrayList<OwnerInformation>();
        for (PropertyOwnerInfo propOwnerInfo : basicProperty.getPropertyOwnerInfo()) {
            OwnerInformation ownerInfo = new OwnerInformation();
            User owner = propOwnerInfo.getOwner();
            ownerInfo.setAadhaarNo(owner.getAadhaarNumber());
            ownerInfo.setMobileNumber(owner.getMobileNumber());
            ownerInfo.setName(owner.getName());
            ownerInfo.setGender(owner.getGender().name());
            ownerInfo.setEmailId(owner.getEmailId());
            ownerInfo.setGuardianRelation(owner.getGuardianRelation());
            ownerInfo.setGuardian(owner.getGuardian());
            ownerDetails.add(ownerInfo);
        }
        return ownerDetails;
    }

    private List<FloorInfo> getFloorDetails(PropertyDetail propertyDetail) {
        ArrayList<FloorInfo> floorDetails = new ArrayList<FloorInfo>();
        for (Floor floor : propertyDetail.getFloorDetails()) {
            FloorInfo floorInfo = new FloorInfo();
            if (floor.getFloorNo() != null) {
                floorInfo.setFloorNo(PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()));
            }
            if (floor.getStructureClassification() != null && StringUtils.isNotBlank((CharSequence)floor.getStructureClassification().getDescription())) {
                floorInfo.setBuildClassification(floor.getStructureClassification().getDescription());
            }
            if (floor.getPropertyUsage() != null && StringUtils.isNotBlank((CharSequence)floor.getPropertyUsage().getUsageName())) {
                floorInfo.setNatureOfUsage(floor.getPropertyUsage().getUsageName());
            }
            floorInfo.setFirmName(StringUtils.isBlank((CharSequence)floor.getFirmName()) ? "N/A" : floor.getFirmName());
            floorInfo.setOccupancy(floor.getPropertyOccupation().getOccupation());
            floorInfo.setOccupantName(StringUtils.isBlank((CharSequence)floor.getOccupantName()) ? "N/A" : floor.getOccupantName());
            floorInfo.setConstructionDate(floor.getConstructionDate() == null ? "N/A" : DateUtils.getDefaultFormattedDate((Date)floor.getConstructionDate()));
            if (floor.getOccupancyDate() != null) {
                floorInfo.setOccupancyDate(DateUtils.getDefaultFormattedDate((Date)floor.getOccupancyDate()));
            }
            if (floor.getBuiltUpArea() != null && floor.getBuiltUpArea().getLength() != null) {
                floorInfo.setPlinthLength(floor.getBuiltUpArea().getLength());
            }
            if (floor.getBuiltUpArea() != null && floor.getBuiltUpArea().getBreadth() != null) {
                floorInfo.setPlinthBreadth(floor.getBuiltUpArea().getBreadth());
            }
            if (floor.getBuiltUpArea() != null && floor.getBuiltUpArea().getArea() != null) {
                floorInfo.setPlinthArea(floor.getBuiltUpArea().getArea());
            }
            if (StringUtils.isNotBlank((CharSequence)floor.getBuildingPermissionNo())) {
                floorInfo.setBuildingPermissionNo(floor.getBuildingPermissionNo());
            }
            floorInfo.setBuildingPermissionDate(floor.getBuildingPermissionDate() == null ? "N/A" : DateUtils.getDefaultFormattedDate((Date)floor.getBuildingPermissionDate()));
            floorInfo.setBuildingPlanPlinthArea(Float.valueOf(floor.getBuildingPlanPlinthArea() == null ? 0.0f : floor.getBuildingPlanPlinthArea().getArea().floatValue()));
            floorDetails.add(floorInfo);
        }
        return floorDetails;
    }

    private void getVacantLandDetails(AssessmentInfo assessmentInfo, PropertyDetail propertyDetail, PropertyID propertyID) {
        if (StringUtils.isNotBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            assessmentInfo.setSurveyNumber(propertyDetail.getSurveyNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)propertyDetail.getPattaNumber())) {
            assessmentInfo.setPattaNumber(propertyDetail.getPattaNumber());
        }
        if (propertyDetail.getSitalArea() != null && propertyDetail.getSitalArea().getArea() != null) {
            assessmentInfo.setVacantLandArea(propertyDetail.getSitalArea().getArea());
        }
        if (propertyDetail.getMarketValue() != null) {
            assessmentInfo.setMarketValue(propertyDetail.getMarketValue());
        }
        if (propertyDetail.getCurrentCapitalValue() != null) {
            assessmentInfo.setCurrentCapitalValue(propertyDetail.getCurrentCapitalValue());
        }
        if (propertyDetail.getDateOfCompletion() != null) {
            assessmentInfo.setEffectiveDate(DateUtils.getDefaultFormattedDate((Date)propertyDetail.getDateOfCompletion()));
        }
        if (propertyDetail.getVacantLandPlotArea() != null && StringUtils.isNotBlank((CharSequence)propertyDetail.getVacantLandPlotArea().getName())) {
            assessmentInfo.setVlPlotArea(propertyDetail.getVacantLandPlotArea().getName());
        }
        if (propertyDetail.getLayoutApprovalAuthority() != null && StringUtils.isNotBlank((CharSequence)propertyDetail.getLayoutApprovalAuthority().getName())) {
            assessmentInfo.setLaAuthority(propertyDetail.getLayoutApprovalAuthority().getName());
        }
        assessmentInfo.setLpNo(propertyDetail.getLayoutPermitNo());
        if (propertyDetail.getLayoutPermitDate() != null) {
            assessmentInfo.setLpDate(DateUtils.getDefaultFormattedDate((Date)propertyDetail.getLayoutPermitDate()));
        }
        this.getBoundariesForVacantLand(assessmentInfo, propertyID);
    }

    private void getBoundariesForVacantLand(AssessmentInfo assessmentInfo, PropertyID propertyID) {
        if (StringUtils.isNotBlank((CharSequence)propertyID.getNorthBoundary())) {
            assessmentInfo.setNorthBoundary(propertyID.getNorthBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)propertyID.getNorthBoundary())) {
            assessmentInfo.setEastBoundary(propertyID.getEastBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)propertyID.getWestBoundary())) {
            assessmentInfo.setWestBoundary(propertyID.getWestBoundary());
        }
        if (StringUtils.isNotBlank((CharSequence)propertyID.getSouthBoundary())) {
            assessmentInfo.setSouthBoundary(propertyID.getSouthBoundary());
        }
    }

    public Long getPropertiesCount(String transactionType, String fromDate, String toDate) throws ParseException {
        StringBuilder queryString = new StringBuilder();
        queryString.append("select count(distinct prop.basicProperty.id) from PropertyImpl prop, PropertyMaterlizeView pmv ");
        queryString.append(" where prop.basicProperty.id = pmv.basicPropertyID and (cast(prop.createdDate as date)) between :fromDate and :toDate ");
        queryString.append(" and upper(prop.propertyModifyReason) like :modifyReason and prop.status in ('A','I') ");
        if (transactionType.equalsIgnoreCase("Create")) {
            queryString.append(" and prop.demolitionReason is null ");
        } else if (transactionType.equalsIgnoreCase("Demolition")) {
            queryString.append(" and prop.demolitionReason is not null ");
        }
        Query qry = this.entityManager.createQuery(queryString.toString());
        qry.setParameter("fromDate", (Object)this.convertStringToDate(fromDate));
        qry.setParameter("toDate", (Object)this.convertStringToDate(toDate));
        qry.setParameter("modifyReason", (Object)"%".concat(transactionType.toUpperCase()).concat("%"));
        return (Long)qry.getResultList().get(0);
    }

    public List<SurveyAssessmentDetails> getPropertyDetailsForSurvey(String transactionType, String fromDate, String toDate) throws ParseException {
        StringBuilder queryString = new StringBuilder();
        ArrayList<SurveyAssessmentDetails> assessmentDetailsList = new ArrayList<SurveyAssessmentDetails>();
        queryString.append("select prop, pmv.houseNo, pmv.propertyAddress, pmv.sitalArea, (coalesce(pmv.arrearDemand,0)+coalesce(pmv.aggrArrearPenaly,0)+coalesce(pmv.aggrCurrFirstHalfPenaly,0)+");
        queryString.append("coalesce(pmv.aggrCurrSecondHalfPenaly,0)+coalesce(pmv.aggrCurrFirstHalfDmd,0)+coalesce(pmv.aggrCurrSecondHalfDmd,0)) from PropertyImpl prop, PropertyMaterlizeView pmv ");
        queryString.append(" where prop.basicProperty.id = pmv.basicPropertyID and (cast(prop.createdDate as date)) between :fromDate and :toDate ");
        queryString.append(" and upper(prop.propertyModifyReason) like :modifyReason and prop.status in ('A','I') ");
        if (transactionType.equalsIgnoreCase("Create")) {
            queryString.append(" and prop.demolitionReason is null ");
        } else if (transactionType.equalsIgnoreCase("Demolition")) {
            queryString.append(" and prop.demolitionReason is not null ");
        }
        Query qry = this.entityManager.createQuery(queryString.toString());
        qry.setParameter("fromDate", (Object)this.convertStringToDate(fromDate));
        qry.setParameter("toDate", (Object)this.convertStringToDate(toDate));
        qry.setParameter("modifyReason", (Object)"%".concat(transactionType.toUpperCase()).concat("%"));
        List propertyDetails = qry.getResultList();
        if (!propertyDetails.isEmpty()) {
            for (Object[] objArr : propertyDetails) {
                SurveyAssessmentDetails assessmentDetails = new SurveyAssessmentDetails();
                this.preparePropertyDetails(objArr, assessmentDetails);
                assessmentDetailsList.add(assessmentDetails);
            }
        }
        return assessmentDetailsList;
    }

    private void preparePropertyDetails(Object[] obj, SurveyAssessmentDetails assessmentDetails) {
        Property property = (Property)obj[0];
        BasicProperty basicProperty = property.getBasicProperty();
        if (StringUtils.isNotBlank((CharSequence)basicProperty.getUpicNo())) {
            assessmentDetails.setAssessmentNo(basicProperty.getUpicNo());
        }
        assessmentDetails.setDoorNo(obj[1].toString());
        assessmentDetails.setPropertyAddress(obj[2].toString());
        if (property.getPropertyDetail().getPropertyTypeMaster() != null && StringUtils.isNotBlank((CharSequence)property.getPropertyDetail().getPropertyTypeMaster().getType())) {
            assessmentDetails.setPropertyType(property.getPropertyDetail().getPropertyTypeMaster().getType());
        }
        assessmentDetails.setPropertyCategory(PropertyTaxConstants.PROPERTY_TYPE_CATEGORIES.get(property.getPropertyDetail().getCategoryType()));
        assessmentDetails.setAssessmentYear(DateUtils.toYearFormat((Date)basicProperty.getPropOccupationDate()));
        assessmentDetails.setTotalTax(new BigDecimal(obj[4].toString()));
        assessmentDetails.setTotalSitalArea(new BigDecimal(obj[3].toString()));
        assessmentDetails.setOwnerDetails(this.getOwnerDetails(basicProperty));
    }

    public NewPropertyDetails updateProperty(ViewPropertyDetails viewPropertyDetails) throws ParseException {
        NewPropertyDetails newPropertyDetails = null;
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        BasicProperty basicProperty = this.updateBasicProperty(viewPropertyDetails, propService);
        PropertyImpl property = (PropertyImpl)basicProperty.getWFProperty();
        property.getPropertyDetail().setCategoryType(viewPropertyDetails.getCategory());
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        basicProperty.setParcelId(viewPropertyDetails.getParcelId());
        basicProperty.setLatitude(viewPropertyDetails.getLatitude());
        basicProperty.setLongitude(viewPropertyDetails.getLongitude());
        property.setReferenceId(viewPropertyDetails.getReferenceId());
        this.transitionWorkFlow(property, propService, "modify");
        this.basicPropertyService.applyAuditing((AbstractAuditable)property.getState());
        propService.updateIndexes(property, "Alter_Assessment");
        if (basicProperty.getWFProperty() != null && basicProperty.getWFProperty().getPtDemandSet() != null && !basicProperty.getWFProperty().getPtDemandSet().isEmpty()) {
            for (Ptdemand ptDemand : basicProperty.getWFProperty().getPtDemandSet()) {
                this.basicPropertyService.applyAuditing(ptDemand.getDmdCalculations());
            }
        }
        if ((basicProperty = (BasicProperty)this.basicPropertyService.update(basicProperty)) != null) {
            newPropertyDetails = new NewPropertyDetails();
            newPropertyDetails.setApplicationNo(basicProperty.getWFProperty().getApplicationNo());
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            newPropertyDetails.setErrorDetails(errorDetails);
        }
        return newPropertyDetails;
    }

    private BasicProperty updateBasicProperty(ViewPropertyDetails viewPropertyDetails, PropertyService propService) throws ParseException {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(viewPropertyDetails.getAssessmentNumber());
        PropertyImpl oldProperty = (PropertyImpl)basicProperty.getProperty();
        PropertyImpl propertyImpl = this.createPropertyWithBasicDetails(viewPropertyDetails.getPropertyTypeMaster());
        Date propCompletionDate = null;
        PropertyTypeMaster propertyTypeMaster = this.getPropertyTypeMasterByCode(viewPropertyDetails.getPropertyTypeMaster());
        propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(viewPropertyDetails.getEffectiveDate()));
        if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getApartmentCmplx())) {
            Apartment apartment = this.getApartmentByCode(viewPropertyDetails.getApartmentCmplx());
            propertyImpl.getPropertyDetail().setApartment(apartment);
        }
        propertyImpl.setSource("SURVEY");
        propertyImpl.getPropertyDetail().setOccupancyCertificationNo(viewPropertyDetails.getOccupancyCertificationNo());
        propertyImpl.getPropertyDetail().setOccupancyCertificationDate(viewPropertyDetails.getOccupancyCertificationDate());
        PropertyMutationMaster propMutMstr = this.getPropertyMutationMaster("ADD_OR_ALTER");
        basicProperty.setPropertyMutationMaster(propMutMstr);
        if (!propertyTypeMaster.getCode().equalsIgnoreCase("VAC_LAND")) {
            FloorType floorType = null;
            RoofType roofType = null;
            WallType wallType = null;
            WoodType woodType = null;
            PropertyDetail propDetail = basicProperty.getActiveProperty().getPropertyDetail();
            floorType = StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getFloorType()) ? this.floorTypeService.getFloorTypeById(Long.valueOf(viewPropertyDetails.getFloorType())) : propDetail.getFloorType();
            roofType = StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getRoofType()) ? this.roofTypeService.getRoofTypeById(Long.valueOf(viewPropertyDetails.getRoofType())) : propDetail.getRoofType();
            wallType = StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWallType()) ? this.wallTypeService.getWallTypeById(Long.valueOf(viewPropertyDetails.getWallType())) : propDetail.getWallType();
            woodType = StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWoodType()) ? this.woodTypeService.getWoodTypeById(Long.valueOf(viewPropertyDetails.getWoodType())) : propDetail.getWoodType();
            propertyImpl.getPropertyDetail().setFloorDetailsProxy(this.getFloorList(viewPropertyDetails.getFloorDetails()));
            propertyImpl.getPropertyDetail().setLift(viewPropertyDetails.getHasLift());
            propertyImpl.getPropertyDetail().setToilets(viewPropertyDetails.getHasToilet());
            propertyImpl.getPropertyDetail().setWaterTap(viewPropertyDetails.getHasWaterTap());
            propertyImpl.getPropertyDetail().setElectricity(viewPropertyDetails.getHasElectricity());
            propertyImpl.getPropertyDetail().setAttachedBathRoom(viewPropertyDetails.getHasAttachedBathroom());
            propertyImpl.getPropertyDetail().setWaterHarvesting(viewPropertyDetails.getHasWaterHarvesting());
            propertyImpl.getPropertyDetail().setCable(viewPropertyDetails.getHasCableConnection());
            String extentOfSite = null;
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getExtentOfSite())) {
                propertyImpl.getPropertyDetail().setExtentSite(Double.valueOf(viewPropertyDetails.getExtentOfSite()));
                extentOfSite = viewPropertyDetails.getExtentOfSite();
            } else if (!viewPropertyDetails.getPropertyTypeMaster().equalsIgnoreCase("VAC_LAND")) {
                extentOfSite = propDetail.getExtentSite() != null ? propDetail.getExtentSite().toString() : propDetail.getSitalArea().getArea().toString();
            }
            propertyImpl = propService.createProperty(propertyImpl, extentOfSite, propMutMstr.getCode(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_WORKFLOW, propertyImpl.getDocNumber(), null, floorType != null ? floorType.getId() : null, roofType != null ? roofType.getId() : null, wallType != null ? wallType.getId() : null, woodType != null ? woodType.getId() : null, null, null, null, null, Boolean.FALSE);
        } else {
            propertyImpl.getPropertyDetail().setDateOfCompletion(this.convertStringToDate(viewPropertyDetails.getEffectiveDate()));
            propertyImpl.getPropertyDetail().setCurrentCapitalValue(viewPropertyDetails.getCurrentCapitalValue());
            propertyImpl.getPropertyDetail().setSurveyNumber(viewPropertyDetails.getSurveyNumber());
            propertyImpl.getPropertyDetail().setPattaNumber(viewPropertyDetails.getPattaNumber());
            propertyImpl.getPropertyDetail().setLayoutPermitNo(viewPropertyDetails.getLpNo() != null ? viewPropertyDetails.getLpNo() : null);
            propertyImpl.getPropertyDetail().setLayoutPermitDate(viewPropertyDetails.getLpDate() != null ? this.convertStringToDate(viewPropertyDetails.getLpDate()) : null);
            Area area = new Area();
            if (viewPropertyDetails.getVacantLandArea() != null) {
                area.setArea(viewPropertyDetails.getVacantLandArea());
            }
            propertyImpl.getPropertyDetail().setSitalArea(area);
            if (viewPropertyDetails.getMarketValue() != null) {
                propertyImpl.getPropertyDetail().setMarketValue(viewPropertyDetails.getMarketValue());
            }
            propertyImpl = propService.createProperty(propertyImpl, String.valueOf(viewPropertyDetails.getVacantLandArea()), propMutMstr.getCode(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_WORKFLOW, propertyImpl.getDocNumber(), null, null, null, null, null, null, null, new Long(viewPropertyDetails.getVlPlotArea()), new Long(viewPropertyDetails.getLaAuthority()), Boolean.FALSE);
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getNorthBoundary())) {
                basicProperty.getPropertyID().setNorthBoundary(viewPropertyDetails.getNorthBoundary());
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getSouthBoundary())) {
                basicProperty.getPropertyID().setSouthBoundary(viewPropertyDetails.getSouthBoundary());
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getEastBoundary())) {
                basicProperty.getPropertyID().setEastBoundary(viewPropertyDetails.getEastBoundary());
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWestBoundary())) {
                basicProperty.getPropertyID().setWestBoundary(viewPropertyDetails.getWestBoundary());
            }
        }
        propCompletionDate = !propertyTypeMaster.getCode().equalsIgnoreCase("VAC_LAND") ? propService.getLowestDtOfCompFloorWise(propertyImpl.getPropertyDetail().getFloorDetailsProxy()) : propertyImpl.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(propCompletionDate);
        propertyImpl.setPropertyModifyReason("ADD_OR_ALTER");
        propertyImpl.setBasicProperty(basicProperty);
        propertyImpl.setEffectiveDate(propCompletionDate);
        Long oldPropTypeId = oldProperty.getPropertyDetail().getPropertyTypeMaster().getId();
        PropertyTypeMaster vacantPropTypeMstr = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND");
        if ((oldPropTypeId == vacantPropTypeMstr.getId() && propertyTypeMaster.getId() != vacantPropTypeMstr.getId() || oldPropTypeId != vacantPropTypeMstr.getId() && propertyTypeMaster.getId() == vacantPropTypeMstr.getId()) && !propertyImpl.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW)) {
            if (vacantPropTypeMstr != null && vacantPropTypeMstr.getId() == propertyTypeMaster.getId()) {
                this.changePropertyDetail(propertyImpl, new VacantProperty(), 0);
            } else {
                this.changePropertyDetail(propertyImpl, new BuiltUpProperty(), propertyImpl.getPropertyDetail().getNoofFloors());
            }
        }
        Property modProperty = null;
        try {
            modProperty = propService.modifyDemand(propertyImpl, oldProperty);
        }
        catch (TaxCalculatorExeption taxCalculatorExeption) {
            // empty catch block
        }
        if (modProperty != null && !modProperty.getDocuments().isEmpty()) {
            propService.processAndStoreDocument(modProperty.getDocuments());
        }
        if (modProperty == null) {
            basicProperty.addProperty(propertyImpl);
        } else {
            basicProperty.addProperty(modProperty);
        }
        return basicProperty;
    }

    private void changePropertyDetail(Property modProperty, PropertyDetail propDetail, Integer numOfFloors) {
        PropertyDetail propertyDetail = modProperty.getPropertyDetail();
        propDetail.setSitalArea(propertyDetail.getSitalArea());
        propDetail.setTotalBuiltupArea(propertyDetail.getTotalBuiltupArea());
        propDetail.setCommBuiltUpArea(propertyDetail.getCommBuiltUpArea());
        propDetail.setPlinthArea(propertyDetail.getPlinthArea());
        propDetail.setCommVacantLand(propertyDetail.getCommVacantLand());
        propDetail.setSurveyNumber(propertyDetail.getSurveyNumber());
        propDetail.setFieldVerified(propertyDetail.getFieldVerified());
        propDetail.setFieldVerificationDate(propertyDetail.getFieldVerificationDate());
        propDetail.setFloorDetails(propertyDetail.getFloorDetails());
        propDetail.setPropertyDetailsID(propertyDetail.getPropertyDetailsID());
        propDetail.setWater_Meter_Num(propertyDetail.getWater_Meter_Num());
        propDetail.setElec_Meter_Num(propertyDetail.getElec_Meter_Num());
        propDetail.setNoofFloors(numOfFloors);
        propDetail.setFieldIrregular(propertyDetail.getFieldIrregular());
        propDetail.setDateOfCompletion(propertyDetail.getDateOfCompletion());
        propDetail.setProperty(propertyDetail.getProperty());
        propDetail.setUpdatedTime(propertyDetail.getUpdatedTime());
        propDetail.setPropertyTypeMaster(propertyDetail.getPropertyTypeMaster());
        propDetail.setPropertyType(propertyDetail.getPropertyType());
        propDetail.setInstallment(propertyDetail.getInstallment());
        propDetail.setPropertyOccupation(propertyDetail.getPropertyOccupation());
        propDetail.setPropertyMutationMaster(propertyDetail.getPropertyMutationMaster());
        propDetail.setComZone(propertyDetail.getComZone());
        propDetail.setCornerPlot(propertyDetail.getCornerPlot());
        propDetail.setCable(propertyDetail.isCable());
        propDetail.setAttachedBathRoom(propertyDetail.isAttachedBathRoom());
        propDetail.setElectricity(propertyDetail.isElectricity());
        propDetail.setWaterTap(propertyDetail.isWaterTap());
        propDetail.setWaterHarvesting(propertyDetail.isWaterHarvesting());
        propDetail.setLift(propertyDetail.isLift());
        propDetail.setToilets(propertyDetail.isToilets());
        propDetail.setFloorType(propertyDetail.getFloorType());
        propDetail.setRoofType(propertyDetail.getRoofType());
        propDetail.setWallType(propertyDetail.getWallType());
        propDetail.setWoodType(propertyDetail.getWoodType());
        propDetail.setExtentSite(propertyDetail.getExtentSite());
        propDetail.setExtentAppartenauntLand(propertyDetail.getExtentAppartenauntLand());
        if (numOfFloors == 0) {
            propDetail.setPropertyUsage(propertyDetail.getPropertyUsage());
        } else {
            propDetail.setPropertyUsage(null);
        }
        propDetail.setManualAlv(propertyDetail.getManualAlv());
        propDetail.setOccupierName(propertyDetail.getOccupierName());
        modProperty.setPropertyDetail(propDetail);
    }

    private VacantProperty changePropertyDetail(PropertyImpl property) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        VacantProperty vacantProperty = new VacantProperty(propertyDetail.getSitalArea(), propertyDetail.getTotalBuiltupArea(), propertyDetail.getCommBuiltUpArea(), propertyDetail.getPlinthArea(), propertyDetail.getCommVacantLand(), propertyDetail.getNonResPlotArea(), false, propertyDetail.getSurveyNumber(), propertyDetail.getFieldVerified(), propertyDetail.getFieldVerificationDate(), propertyDetail.getFloorDetails(), propertyDetail.getPropertyDetailsID(), propertyDetail.getWater_Meter_Num(), propertyDetail.getElec_Meter_Num(), 0, propertyDetail.getFieldIrregular(), propertyDetail.getDateOfCompletion(), propertyDetail.getProperty(), propertyDetail.getUpdatedTime(), propertyDetail.getPropertyUsage(), null, propertyDetail.getPropertyTypeMaster(), propertyDetail.getPropertyType(), propertyDetail.getInstallment(), propertyDetail.getPropertyOccupation(), propertyDetail.getPropertyMutationMaster(), propertyDetail.getComZone(), propertyDetail.getCornerPlot(), propertyDetail.getExtentSite() != null ? propertyDetail.getExtentSite() : 0.0, propertyDetail.getExtentAppartenauntLand() != null ? propertyDetail.getExtentAppartenauntLand() : 0.0, propertyDetail.getFloorType(), propertyDetail.getRoofType(), propertyDetail.getWallType(), propertyDetail.getWoodType(), propertyDetail.isLift(), propertyDetail.isToilets(), propertyDetail.isWaterTap(), propertyDetail.isStructure(), propertyDetail.isElectricity(), propertyDetail.isAttachedBathRoom(), propertyDetail.isWaterHarvesting(), propertyDetail.isCable(), propertyDetail.getSiteOwner(), propertyDetail.getPattaNumber(), propertyDetail.getCurrentCapitalValue(), propertyDetail.getMarketValue(), propertyDetail.getCategoryType(), propertyDetail.getOccupancyCertificationNo(), propertyDetail.getOccupancyCertificationDate(), propertyDetail.isAppurtenantLandChecked(), propertyDetail.isCorrAddressDiff(), propertyDetail.getPropertyDepartment(), propertyDetail.getVacantLandPlotArea(), propertyDetail.getLayoutApprovalAuthority(), propertyDetail.getLayoutPermitNo(), propertyDetail.getLayoutPermitDate());
        vacantProperty.setManualAlv(propertyDetail.getManualAlv());
        vacantProperty.setOccupierName(propertyDetail.getOccupierName());
        return vacantProperty;
    }

    public String getPropertyType(String assessmentno) {
        String pType = "";
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentno);
        PropertyTypeMaster ptypeMaster = basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster();
        if (ptypeMaster != null) {
            pType = ptypeMaster.getCode();
        }
        return pType;
    }

    public NewPropertyDetails createAppurTenantProperties(ViewPropertyDetails viewPropertyDetails) throws ParseException {
        NewPropertyDetails newPropertyDetails = null;
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        BasicProperty vacantBasicProperty = new BasicPropertyImpl();
        BasicProperty nonVacantBasicProperty = this.createBasicProp(viewPropertyDetails, propService);
        this.updatePropertyStatusValuesRemarks(nonVacantBasicProperty);
        PropertyImpl nonVacantProperty = null;
        try {
            nonVacantProperty = this.createNonVacantProperty(nonVacantBasicProperty, viewPropertyDetails, propService);
            vacantBasicProperty = this.createBasicProp(viewPropertyDetails, propService);
            this.updatePropertyStatusValuesRefProperty(nonVacantBasicProperty, vacantBasicProperty);
            this.createVacantProperty(nonVacantProperty, vacantBasicProperty, viewPropertyDetails, propService);
        }
        catch (TaxCalculatorExeption taxCalculatorExeption) {
            // empty catch block
        }
        if (null != nonVacantBasicProperty) {
            String applicationNumber = nonVacantBasicProperty.getProperty().getApplicationNo().concat(", ").concat(vacantBasicProperty.getProperty().getApplicationNo());
            newPropertyDetails = new NewPropertyDetails();
            newPropertyDetails.setApplicationNo(applicationNumber);
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            newPropertyDetails.setErrorDetails(errorDetails);
        }
        return newPropertyDetails;
    }

    private PropertyImpl createNonVacantProperty(BasicProperty nonVacantBasicProperty, ViewPropertyDetails viewPropertyDetails, PropertyService propService) throws TaxCalculatorExeption, ParseException {
        PropertyImpl nonVacProp = this.createAppurTenantProperty(nonVacantBasicProperty, Boolean.TRUE, viewPropertyDetails, propService);
        this.persistAndMessage(nonVacantBasicProperty, nonVacProp, propService);
        this.saveDocumentTypeDetails(nonVacantBasicProperty, viewPropertyDetails);
        return nonVacProp;
    }

    private void createVacantProperty(PropertyImpl nonVacantProperty, BasicProperty vacantBasicProperty, ViewPropertyDetails viewPropertyDetails, PropertyService propService) throws TaxCalculatorExeption, ParseException {
        PropertyImpl vacantProperty = this.createAppurTenantProperty(vacantBasicProperty, Boolean.FALSE, viewPropertyDetails, propService);
        vacantProperty.setPropertyDetail(this.changePropertyDetail(vacantProperty));
        vacantProperty.getPropertyDetail().setCategoryType(this.getCategoryByNonVacantPropertyType(nonVacantProperty));
        vacantProperty.getPropertyDetail().setAppurtenantLandChecked(null);
        vacantBasicProperty.getAddress().setHouseNoBldgApt(null);
        vacantProperty.getPropertyDetail().getFloorDetails().clear();
        this.persistAndMessage(vacantBasicProperty, vacantProperty, propService);
        this.saveDocumentTypeDetails(vacantBasicProperty, viewPropertyDetails);
    }

    private void updatePropertyStatusValuesRefProperty(BasicProperty nonVacantBasicProperty, BasicProperty vacantBasicProperty) {
        PropertyStatusValues propStatusVal = this.updatePropertyStatusValuesRemarks(vacantBasicProperty);
        propStatusVal.setReferenceBasicProperty(nonVacantBasicProperty);
    }

    private PropertyStatusValues updatePropertyStatusValuesRemarks(BasicProperty basicProperty) {
        PropertyStatusValues propStatusVal = basicProperty.getPropertyStatusValuesSet().iterator().next();
        propStatusVal.setRemarks("AppurTenantProperty");
        return propStatusVal;
    }

    private String getCategoryByNonVacantPropertyType(PropertyImpl nonVacantProperty) {
        String propertyType = nonVacantProperty.getPropertyDetail().getPropertyTypeMaster().getCode();
        return "PRIVATE".equals(propertyType) || "VAC_LAND".equals(propertyType) ? "VACANTLAND" : ("STATE_GOVT".equals(propertyType) ? "STATE_GOVT" : "CENTRAL_GOVT");
    }

    private void persistAndMessage(BasicProperty basicProperty, PropertyImpl property, PropertyService propService) throws ParseException {
        this.basicPropertyService.persist(basicProperty);
    }

    private BasicProperty createBasicProp(ViewPropertyDetails viewPropertyDetails, PropertyService propService) {
        BasicPropertyImpl basicProperty = new BasicPropertyImpl();
        basicProperty.setActive(Boolean.TRUE);
        basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_MOBILE);
        Boundary block = this.getBoundaryByNumberAndType(viewPropertyDetails.getBlockName(), "Block", "REVENUE");
        PropertyAddress propAddress = this.createPropAddress(viewPropertyDetails, block);
        Address ownerCorrAddr = this.createCorrespondenceAddress(viewPropertyDetails, propAddress);
        basicProperty.setAddress(propAddress);
        PropertyID propertyID = this.createPropertID(basicProperty, viewPropertyDetails, block);
        basicProperty.setPropertyID(propertyID);
        PropertyStatus propertyStatus = this.getPropertyStatus();
        basicProperty.setStatus(propertyStatus);
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        basicProperty.setParcelId(viewPropertyDetails.getParcelId());
        basicProperty.setLatitude(viewPropertyDetails.getLatitude());
        basicProperty.setLongitude(viewPropertyDetails.getLongitude());
        PropertyMutationMaster propertyMutationMaster = this.getPropertyMutationMaster(viewPropertyDetails.getMutationReason());
        basicProperty.setPropertyMutationMaster(propertyMutationMaster);
        if (propertyMutationMaster.getCode().equals("BIFUR") || viewPropertyDetails.getIsExtentAppurtenantLand().booleanValue()) {
            basicProperty.addPropertyStatusValues(propService.createPropStatVal(basicProperty, "CREATE", null, null, null, null, viewPropertyDetails.getParentPropertyAssessmentNo() != null ? viewPropertyDetails.getParentPropertyAssessmentNo() : null));
        }
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        basicProperty.setBoundary(propertyID.getElectionBoundary());
        basicProperty.setPropertyOwnerInfoProxy(this.getPropertyOwnerInfoList(viewPropertyDetails.getOwnerDetails()));
        this.propty.setBasicProperty(basicProperty);
        if (!viewPropertyDetails.getIsExtentAppurtenantLand().booleanValue()) {
            this.basicPropertyService.createOwners(this.propty, basicProperty, ownerCorrAddr);
            this.propty.setBasicProperty(basicProperty);
        } else {
            this.basicPropertyService.createOwnersForAppurTenant(this.propty, basicProperty, ownerCorrAddr);
        }
        this.propty.setPropertyModifyReason("CREATE");
        return basicProperty;
    }

    private PropertyImpl createAppurTenantProperty(BasicProperty basicProperty, Boolean nonVacant, ViewPropertyDetails viewPropertyDetails, PropertyService propService) throws TaxCalculatorExeption, ParseException {
        PropertyTypeMaster propertyTypeMaster = this.getPropertyTypeMasterByCode(viewPropertyDetails.getPropertyTypeMaster());
        PropertyImpl propertyImpl = this.createPropertyWithBasicDetails(viewPropertyDetails.getPropertyTypeMaster());
        if (nonVacant.booleanValue()) {
            propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(viewPropertyDetails.getFloorDetails().get(0).getOccupancyDate()));
            FloorType floorType = null;
            RoofType roofType = null;
            WallType wallType = null;
            WoodType woodType = null;
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getFloorType())) {
                floorType = this.floorTypeService.getFloorTypeById(Long.valueOf(viewPropertyDetails.getFloorType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getRoofType())) {
                roofType = this.roofTypeService.getRoofTypeById(Long.valueOf(viewPropertyDetails.getRoofType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWallType())) {
                wallType = this.wallTypeService.getWallTypeById(Long.valueOf(viewPropertyDetails.getWallType()));
            }
            if (StringUtils.isNotBlank((CharSequence)viewPropertyDetails.getWoodType())) {
                woodType = this.woodTypeService.getWoodTypeById(Long.valueOf(viewPropertyDetails.getWoodType()));
            }
            propertyImpl.getPropertyDetail().setFloorDetailsProxy(this.getFloorList(viewPropertyDetails.getFloorDetails()));
            propertyImpl.getPropertyDetail().setLift(viewPropertyDetails.getHasLift());
            propertyImpl.getPropertyDetail().setToilets(viewPropertyDetails.getHasToilet());
            propertyImpl.getPropertyDetail().setWaterTap(viewPropertyDetails.getHasWaterTap());
            propertyImpl.getPropertyDetail().setElectricity(viewPropertyDetails.getHasElectricity());
            propertyImpl.getPropertyDetail().setAttachedBathRoom(viewPropertyDetails.getHasAttachedBathroom());
            propertyImpl.getPropertyDetail().setWaterHarvesting(viewPropertyDetails.getHasWaterHarvesting());
            propertyImpl.getPropertyDetail().setCable(viewPropertyDetails.getHasCableConnection());
            propertyImpl = propService.createProperty(propertyImpl, viewPropertyDetails.getExtentOfSite(), viewPropertyDetails.getMutationReason(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, null, null, floorType != null ? floorType.getId() : null, roofType != null ? roofType.getId() : null, wallType != null ? wallType.getId() : null, woodType != null ? woodType.getId() : null, null, null, null, null, nonVacant);
        } else {
            propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(viewPropertyDetails.getEffectiveDate()));
            propertyImpl.getPropertyDetail().setDateOfCompletion(viewPropertyDetails.getEffectiveDate() != null ? this.convertStringToDate(viewPropertyDetails.getEffectiveDate()) : null);
            propertyImpl.getPropertyDetail().setCurrentCapitalValue(viewPropertyDetails.getCurrentCapitalValue());
            propertyImpl.getPropertyDetail().setSurveyNumber(viewPropertyDetails.getSurveyNumber());
            propertyImpl.getPropertyDetail().setPattaNumber(viewPropertyDetails.getPattaNumber());
            propertyImpl.getPropertyDetail().setLayoutPermitNo(viewPropertyDetails.getLpNo());
            propertyImpl.getPropertyDetail().setLayoutPermitDate(viewPropertyDetails.getLpDate() != null ? this.convertStringToDate(viewPropertyDetails.getLpDate()) : null);
            Area area = new Area();
            area.setArea(viewPropertyDetails.getVacantLandArea());
            propertyImpl.getPropertyDetail().setSitalArea(area);
            propertyImpl.getPropertyDetail().setMarketValue(viewPropertyDetails.getMarketValue());
            propertyImpl = propService.createProperty(propertyImpl, viewPropertyDetails.getExtentOfSite(), viewPropertyDetails.getMutationReason(), propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, viewPropertyDetails.getRegdDocNo(), null, null, null, null, null, null, null, viewPropertyDetails.getVlPlotArea() != null ? Long.valueOf(viewPropertyDetails.getVlPlotArea()) : null, viewPropertyDetails.getVlPlotArea() != null ? Long.valueOf(viewPropertyDetails.getVlPlotArea()) : null, Boolean.FALSE);
        }
        propertyImpl.setBasicProperty(basicProperty);
        propertyImpl.setPropertyModifyReason("CREATE");
        propertyImpl.setReferenceId(viewPropertyDetails.getReferenceId());
        Date propCompletionDate = null;
        propCompletionDate = !propertyImpl.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? propService.getLowestDtOfCompFloorWise(propertyImpl.getPropertyDetail().getFloorDetailsProxy()) : propertyImpl.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(propCompletionDate);
        basicProperty.setPropertyOwnerInfoProxy(this.getPropertyOwnerInfoList(viewPropertyDetails.getOwnerDetails()));
        basicProperty.setPropOccupationDate(propCompletionDate);
        basicProperty.addProperty(propertyImpl);
        if (basicProperty.getSource() == PropertyTaxConstants.SOURCEOFDATA_APPLICATION) {
            if (!propertyImpl.getDocuments().isEmpty()) {
                propService.processAndStoreDocument(propertyImpl.getDocuments());
            }
            propService.createDemand(propertyImpl, propCompletionDate);
        }
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.transitionWorkFlow(propertyImpl, propService, "create");
        this.basicPropertyService.applyAuditing((AbstractAuditable)propertyImpl.getState());
        propService.updateIndexes(propertyImpl, "New_Assessment");
        propService.processAndStoreDocument(propertyImpl.getAssessmentDocuments());
        return propertyImpl;
    }

    public BasicProperty getBasicPropertyByPropertyID(String propertyId) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("from BasicPropertyImpl BP where BP.upicNo =:propertyId ");
        BasicProperty basicProperty = null;
        Query qry = this.entityManager.createQuery(queryString.toString());
        qry.setParameter("propertyId", (Object)propertyId);
        basicProperty = (BasicProperty)qry.getSingleResult();
        return basicProperty;
    }

    public Property getPropertyByBasicPropertyID(BasicProperty basicpropertyId) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("from PropertyImpl prop where prop.basicProperty =:basicpropertyId  and prop.status='A' ");
        Property property = null;
        Query qry = this.entityManager.createQuery(queryString.toString());
        qry.setParameter("basicpropertyId", (Object)basicpropertyId);
        property = (Property)qry.getSingleResult();
        return property;
    }

    public Boolean isBoundaryActive(String boundaryNum, String boundaryTypeName, String hierarchyName) {
        Boolean isActive = Boolean.FALSE;
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeName, hierarchyName);
        Boundary boundary = this.boundaryService.getBoundaryByTypeAndNo(boundaryType, Long.valueOf(boundaryNum));
        if (boundary != null && boundary.isActive()) {
            isActive = Boolean.TRUE;
        }
        return isActive;
    }

    public Boolean isActiveUnitRateExists(FloorDetails floorDetails, String zoneNumber, String usageCode, String classificationCode) throws ParseException {
        Boolean isActive = Boolean.FALSE;
        Boundary zone = this.getBoundaryByNumberAndType(zoneNumber, "Zone", "REVENUE");
        PropertyUsage usage = this.propertyUsageService.getUsageByCode(usageCode);
        StructureClassification sc = this.structureClassificationService.getClassificationByCode(classificationCode);
        List<Installment> taxInstallments = this.propertyTaxUtil.getInstallmentsListByEffectiveDate(this.convertStringToDate(floorDetails.getOccupancyDate()));
        for (Installment installment : taxInstallments) {
            List categories;
            if (!this.betweenOrBefore(this.convertStringToDate(floorDetails.getOccupancyDate()), installment.getFromDate(), installment.getToDate()).booleanValue() || !(categories = this.persistenceService.findAllByNamedQuery("BASERATE_BY_OCCUPANCY_ZONE", new Object[]{zone.getId(), usage.getId(), sc.getId(), this.convertStringToDate(floorDetails.getOccupancyDate()), installment.getToDate()})).isEmpty()) continue;
            isActive = Boolean.TRUE;
        }
        return isActive;
    }

    private Boolean between(Date date, Date fromDate, Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    private Boolean betweenOrBefore(Date date, Date fromDate, Date toDate) {
        return this.between(date, fromDate, toDate) != false || date.before(fromDate);
    }

    public Boundary getBoundarybyboundaryNumberTypeHierarchy(String boundaryNum, BoundaryType boundaryType) {
        return this.boundaryService.getBoundaryByTypeAndNo(boundaryType, Long.valueOf(boundaryNum));
    }

    public BoundaryType getBoundaryTypeByNameandHierarchy(String boundaryTypeName, String hierarchyName) {
        return this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeName, hierarchyName);
    }

    public Boolean isCrossHierarchyMappingExist(Long localityId, Long wardId, Long blockId, Long wardBoundaryTypeId) {
        Boolean isMappingExists = Boolean.FALSE;
        StringBuilder queryString = new StringBuilder();
        queryString.append("select parent.parent.boundaryNum as wardnum, parent.parent.name as wardname, parent.boundaryNum as blocknum,");
        queryString.append(" parent.name as blockname, child.boundaryNum as localitynum, child.name as localityname");
        queryString.append(" from CrossHierarchy ch, Boundary parent, Boundary child");
        queryString.append(" where ch.parent.id = :blockId  and ch.child.id = :localityId  and ch.parentType.name=:block and");
        queryString.append(" ch.childType.name=:locality and parent.parent.boundaryType.id=:wardBoundaryTypeId and parent.parent.id=:wardId");
        List boundaryDetails = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString()).setParameter("block", (Object)"Block").setParameter("locality", (Object)"Locality").setParameter("wardBoundaryTypeId", (Object)wardBoundaryTypeId).setParameter("blockId", (Object)blockId).setParameter("localityId", (Object)localityId).setParameter("wardId", (Object)wardId).list();
        if (!boundaryDetails.isEmpty()) {
            isMappingExists = Boolean.TRUE;
        }
        return isMappingExists;
    }

    public Boolean isCrossHierarchyMappingExistforLoclityandElecWrd(Long localityId, Long electionWardId) {
        Boolean isMappingExists = Boolean.FALSE;
        StringBuilder queryString = new StringBuilder();
        queryString.append(" from CrossHierarchy ch");
        queryString.append(" where ch.parent.id = :electionWardId  and ch.child.id = :localityId  ");
        List boundaryDetails = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString()).setParameter("electionWardId", (Object)electionWardId).setParameter("localityId", (Object)localityId).list();
        if (!boundaryDetails.isEmpty()) {
            isMappingExists = Boolean.TRUE;
        }
        return isMappingExists;
    }

    public AssessmentDetails getDuesForProperty(HttpServletRequest request, String assessmentNo, String oldAssessmentNo) {
        AssessmentDetails assessmentDetails = new AssessmentDetails();
        BasicProperty basicProperty = this.fetchBasicProperty(assessmentNo, oldAssessmentNo);
        if (basicProperty != null) {
            String restURL;
            HashMap taxDetails;
            assessmentDetails.setPropertyID(basicProperty.getUpicNo());
            assessmentDetails.setOldAssessmentNo(basicProperty.getOldMuncipalNum());
            assessmentDetails.setPropertyAddress(basicProperty.getAddress().toString());
            assessmentDetails.setOwners(basicProperty.getFullOwnerName());
            Map<String, BigDecimal> dmdCollMap = this.ptDemandDAO.getDemandIncludingPenaltyCollMap(basicProperty.getProperty());
            if (!dmdCollMap.isEmpty()) {
                BigDecimal totalDemand = dmdCollMap.get("ARR_DMD").add(dmdCollMap.get("CURR_FIRSTHALF_DMD")).add(dmdCollMap.get("CURR_SECONDHALF_DMD"));
                BigDecimal totalColl = dmdCollMap.get("ARR_COLL").add(dmdCollMap.get("CURR_FIRSTHALF_COLL")).add(dmdCollMap.get("CURR_SECONDHALF_COLL"));
                assessmentDetails.setPropertyDue(totalDemand.subtract(totalColl));
            }
            if (!(taxDetails = this.simpleRestClient.getRESTResponseAsMap(restURL = String.format("%s/wtms/rest/watertax/due/byptno/%s", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), basicProperty.getUpicNo()))).isEmpty()) {
                assessmentDetails.setWaterTaxDue(BigDecimal.valueOf((Double)taxDetails.get("totalTaxDue")));
                assessmentDetails.setConnectionCount(Double.valueOf(taxDetails.get("connectionCount").toString()).intValue());
            }
            if (!(taxDetails = this.simpleRestClient.getRESTResponseAsMap(restURL = String.format("%s/stms/rest/seweragetax/dues/%s", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), basicProperty.getUpicNo()))).isEmpty()) {
                assessmentDetails.setSewerageDue(BigDecimal.valueOf((Double)taxDetails.get("totalTaxDue")));
            }
        }
        return assessmentDetails;
    }

    public TaxCalculatorResponse calculateTaxes(TaxCalculatorRequest taxCalculatorRequest) throws ParseException {
        TaxCalculatorResponse taxCalculatorResponse = new TaxCalculatorResponse();
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(taxCalculatorRequest.getAssessmentNo());
        PropertyImpl propertyImpl = (PropertyImpl)basicProperty.getProperty();
        taxCalculatorResponse.setAssessmentNo(basicProperty.getUpicNo());
        taxCalculatorResponse.setZoneNo(basicProperty.getPropertyID().getZone().getBoundaryNum());
        if (StringUtils.isNotBlank((CharSequence)propertyImpl.getReferenceId())) {
            taxCalculatorResponse.setReferenceId(propertyImpl.getReferenceId());
        }
        if (propertyImpl != null) {
            Map<String, BigDecimal> calculationsMap = this.getARVAndTaxDetails(propertyImpl, currYearInstMap.get("Current 1st Half"), false);
            taxCalculatorResponse.setExistingARV(calculationsMap.get(ARV));
            taxCalculatorResponse.setExistingHalfYearlyTax(calculationsMap.get(HALF_YEARLY_TAX));
            Date effectiveDate = DateUtils.getDate((String)TAX_CALCULATIONS_EFFECTIVE_DATE, (String)"dd/MM/yyyy");
            propertyImpl.setReferenceId(taxCalculatorRequest.getReferenceId());
            this.prepareFloorDetailsForTaxCalculation(taxCalculatorRequest, propertyImpl, effectiveDate);
            Date completionDate = this.getCompletionDate(propService, propertyImpl);
            try {
                propService.createDemand(propertyImpl, completionDate);
            }
            catch (TaxCalculatorExeption e) {
                LOGGER.error("create : There are no Unit rates defined for chosen combinations", (Throwable)e);
            }
            calculationsMap = this.getARVAndTaxDetails(propertyImpl, currYearInstMap.get("Current 1st Half"), true);
            taxCalculatorResponse.setCalculatedARV(calculationsMap.get(ARV));
            taxCalculatorResponse.setNewHalfYearlyTax(calculationsMap.get(HALF_YEARLY_TAX));
            BigDecimal taxVariance = taxCalculatorResponse.getNewHalfYearlyTax().subtract(taxCalculatorResponse.getExistingHalfYearlyTax()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(taxCalculatorResponse.getExistingHalfYearlyTax());
            taxCalculatorResponse.setTaxVariance(taxVariance);
            if (taxCalculatorResponse.getExistingARV().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal arvVariance = taxCalculatorResponse.getCalculatedARV().subtract(taxCalculatorResponse.getExistingARV()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(taxCalculatorResponse.getExistingARV());
                taxCalculatorResponse.setArvVariance(arvVariance);
            }
        }
        return taxCalculatorResponse;
    }

    private Map<String, BigDecimal> getARVAndTaxDetails(PropertyImpl propertyImpl, Installment installment, boolean forNewCalculation) {
        Ptdemand ptDemand;
        HashMap<String, BigDecimal> calculationDetailsMap = new HashMap<String, BigDecimal>();
        if (!propertyImpl.getPtDemandSet().isEmpty() && (ptDemand = forNewCalculation ? propertyImpl.getPtDemandSet().iterator().next() : this.ptDemandDAO.getNonHistoryCurrDmdForProperty(propertyImpl)) != null) {
            BigDecimal halfYearlyTax = this.getTotalTaxExcludingUACPenalty(installment, ptDemand);
            calculationDetailsMap.put(HALF_YEARLY_TAX, halfYearlyTax);
            if (ptDemand.getDmdCalculations() != null) {
                calculationDetailsMap.put(ARV, ptDemand.getDmdCalculations().getAlv() == null ? BigDecimal.ZERO : ptDemand.getDmdCalculations().getAlv());
            }
        }
        return calculationDetailsMap;
    }

    private BigDecimal getTotalTaxExcludingUACPenalty(Installment installment, Ptdemand ptDemand) {
        BigDecimal halfYearlyTax = BigDecimal.ZERO;
        for (EgDemandDetails demandDetails : ptDemand.getEgDemandDetails()) {
            if (!installment.getFromDate().equals(demandDetails.getInstallmentStartDate()) || "UNAUTH_PENALTY".equalsIgnoreCase(demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
            halfYearlyTax = halfYearlyTax.add(demandDetails.getAmount());
        }
        return halfYearlyTax;
    }

    private void prepareFloorDetailsForTaxCalculation(TaxCalculatorRequest taxCalculatorRequest, PropertyImpl propertyImpl, Date effectiveDate) throws ParseException {
        if (taxCalculatorRequest.getFloorDetails() != null && !taxCalculatorRequest.getFloorDetails().isEmpty()) {
            propertyImpl.getPropertyDetail().getFloorDetails().clear();
            List<Floor> floorList = this.getFloorList(taxCalculatorRequest.getFloorDetails());
            for (Floor floor : floorList) {
                floor.setDepreciationMaster(this.propertyTaxUtil.getDepreciationByDate(floor.getConstructionDate(), effectiveDate));
            }
            propertyImpl.getPropertyDetail().setFloorDetails(floorList);
            propertyImpl.getPropertyDetail().setFloorDetailsProxy(propertyImpl.getPropertyDetail().getFloorDetails());
        }
    }

    public BasicProperty fetchBasicProperty(String assessmentNo, String oldAssessmentNo) {
        List basicProperties;
        BasicProperty basicProperty = null;
        if (StringUtils.isNotBlank((CharSequence)assessmentNo)) {
            basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        }
        if (basicProperty == null && StringUtils.isNotBlank((CharSequence)oldAssessmentNo) && !(basicProperties = this.basicPropertyDAO.getBasicPropertyByOldMunipalNo(oldAssessmentNo)).isEmpty() && basicProperties.size() == 1) {
            basicProperty = (BasicProperty)basicProperties.get(0);
        }
        return basicProperty;
    }
}

