/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.bulkboundaryupdatation;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.bean.BulkBoundaryRequest;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.view.PropertyMVInfo;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.repository.bulkboundaryupdation.BulkBoundaryUpdationRepository;
import org.egov.ptis.repository.spec.BulkBoundarySpec;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BulkBoundaryService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyService propService;
    @Autowired
    private BulkBoundaryUpdationRepository bulkBoundaryUpdationRepository;

    public BasicProperty getBasicPropertyByPropertyID(String propertyId) {
        Query qry = null;
        BasicProperty basicProperty = null;
        if (propertyId != null && !propertyId.equals("")) {
            qry = ((Session)this.entityManager.unwrap(Session.class)).createQuery("from BasicPropertyImpl BP where BP.upicNo =:propertyId and BP.active='Y' ");
            qry.setString("propertyId", propertyId);
            basicProperty = (BasicProperty)qry.uniqueResult();
        }
        return basicProperty;
    }

    @Transactional
    public boolean updateBasicPropertyByBoundary(List<BasicProperty> basicProperties) {
        boolean success = false;
        try {
            for (BasicProperty basicProperty : basicProperties) {
                basicProperty.addPropertyStatusValues(this.propService.createPropStatVal(basicProperty, "BULK BOUNDARY UPDATION", null, null, null, null, null));
                this.basicPropertyService.update(basicProperty);
                this.updatePropertyMvInfo(basicProperty);
                success = true;
            }
            if (success) {
                this.refreshViewPropertyInfo();
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occured : " + e.getMessage(), (Throwable)e);
        }
        return success;
    }

    @Transactional
    public void updatePropertyMvInfo(BasicProperty basicProperty) {
        String query = String.format("update egpt_mv_propertyinfo set localityid = :localityid,  blockid=:blockid,  wardid=:wardid,  electionwardid=:electionwardid where upicno = :assessmentno", new Object[0]);
        SQLQuery sqlQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query);
        sqlQuery.setParameter("localityid", (Object)basicProperty.getPropertyID().getLocality().getId());
        sqlQuery.setParameter("blockid", (Object)basicProperty.getPropertyID().getArea().getId());
        sqlQuery.setParameter("wardid", (Object)basicProperty.getPropertyID().getWard().getId());
        sqlQuery.setParameter("electionwardid", (Object)basicProperty.getPropertyID().getElectionBoundary().getId());
        sqlQuery.setParameter("assessmentno", (Object)basicProperty.getUpicNo());
        sqlQuery.executeUpdate();
    }

    @Transactional
    public void refreshViewPropertyInfo() {
        String sqlqry = "REFRESH MATERIALIZED VIEW CONCURRENTLY egpt_view_propertyinfo ";
        ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(sqlqry).executeUpdate();
    }

    @ReadOnly
    public Page<PropertyMVInfo> pagedBulkBoundaryRecords(BulkBoundaryRequest bulkBoundaryRequest) {
        return this.bulkBoundaryUpdationRepository.findAll(BulkBoundarySpec.bulkBoundarySpecification(bulkBoundaryRequest), (Pageable)new PageRequest(bulkBoundaryRequest.pageNumber(), bulkBoundaryRequest.pageSize(), bulkBoundaryRequest.orderDir(), new String[]{bulkBoundaryRequest.orderBy()}));
    }
}

