/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.recovery;

import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.demand.model.EgBill;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.recovery.CeaseNotice;
import org.egov.ptis.domain.entity.recovery.IntimationNotice;
import org.egov.ptis.domain.entity.recovery.Warrant;
import org.egov.ptis.domain.entity.recovery.WarrantNotice;

public class Recovery
extends StateAware<Position> {
    private static final long serialVersionUID = 1L;
    private Long id;
    private BasicProperty basicProperty;
    private EgwStatus status;
    private EgBill bill;
    @Valid
    private Warrant warrant;
    @Valid
    private IntimationNotice intimationNotice;
    @Valid
    private WarrantNotice warrantNotice;
    @Valid
    private CeaseNotice ceaseNotice;

    public String getStateDetails() {
        return this.getBasicProperty().getUpicNo();
    }

    @Required(message="recovery.basicProperty.null")
    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public Warrant getWarrant() {
        return this.warrant;
    }

    public void setWarrant(Warrant warrant) {
        this.warrant = warrant;
    }

    public IntimationNotice getIntimationNotice() {
        return this.intimationNotice;
    }

    public void setIntimationNotice(IntimationNotice intimationNotice) {
        this.intimationNotice = intimationNotice;
    }

    public WarrantNotice getWarrantNotice() {
        return this.warrantNotice;
    }

    public void setWarrantNotice(WarrantNotice warrantNotice) {
        this.warrantNotice = warrantNotice;
    }

    public CeaseNotice getCeaseNotice() {
        return this.ceaseNotice;
    }

    public void setCeaseNotice(CeaseNotice ceaseNotice) {
        this.ceaseNotice = ceaseNotice;
    }

    @Required(message="recovery.status.null")
    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    @Required(message="recovery.bill.null")
    public EgBill getBill() {
        return this.bill;
    }

    public void setBill(EgBill bill) {
        this.bill = bill;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UcipNo :").append(null != this.basicProperty ? this.basicProperty.getUpicNo() : " ");
        sb.append("BillNo :").append(null != this.bill ? this.bill.getBillNo() : " ");
        sb.append("Status :").append(null != this.status ? this.status.getDescription() : " ");
        return sb.toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

