/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.entity.property.VacancyRemission;

@Entity
@Table(name="egpt_vacancy_remission_approval")
@SequenceGenerator(name="SEQ_EGPT_VACANCY_REMISSION_APPROVAL", sequenceName="SEQ_EGPT_VACANCY_REMISSION_APPROVAL", allocationSize=1)
public class VacancyRemissionApproval
extends StateAware<Position> {
    public static final String SEQ_VACANCY_REMISSION_APPROVAL = "SEQ_EGPT_VACANCY_REMISSION_APPROVAL";
    private static final long serialVersionUID = 1821640343172434474L;
    @Id
    @GeneratedValue(generator="SEQ_EGPT_VACANCY_REMISSION_APPROVAL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vacancyremission", nullable=false)
    private VacancyRemission vacancyRemission;
    @NotNull
    private String comments;
    private Date checkinDate;
    private String status;
    private Date approvalDate;
    private boolean isApproved;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public VacancyRemission getVacancyRemission() {
        return this.vacancyRemission;
    }

    public void setVacancyRemission(VacancyRemission vacancyRemission) {
        this.vacancyRemission = vacancyRemission;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCheckinDate() {
        return this.checkinDate;
    }

    public void setCheckinDate(Date checkinDate) {
        this.checkinDate = checkinDate;
    }

    public String getStateDetails() {
        return "Vacancy Remission Approval - " + this.vacancyRemission.getBasicProperty().getUpicNo();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public boolean getIsApproved() {
        return this.isApproved;
    }

    public void setIsApproved(boolean isApproved) {
        this.isApproved = isApproved;
    }
}

