/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;

@Entity
@Table(name="egpt_vacancy_remission")
@SequenceGenerator(name="SEQ_EGPT_VACANCY_REMISSION", sequenceName="SEQ_EGPT_VACANCY_REMISSION", allocationSize=1)
public class VacancyRemission
extends StateAware<Position> {
    public static final String SEQ_VACANCYREMISSION = "SEQ_EGPT_VACANCY_REMISSION";
    private static final long serialVersionUID = 3387659460257524470L;
    @Id
    @GeneratedValue(generator="SEQ_EGPT_VACANCY_REMISSION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="basicproperty", nullable=false)
    private BasicPropertyImpl basicProperty;
    @NotNull
    @Column(name="vacancy_fromdate")
    private Date vacancyFromDate;
    @NotNull
    @Column(name="vacancy_todate")
    private Date vacancyToDate;
    @NotNull
    @Column(name="vacancy_comments")
    private String vacancyComments;
    @OrderBy(value="id")
    @OneToMany(mappedBy="vacancyRemission", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<VacancyRemissionDetails> vacancyRemissionDetails = new LinkedList<VacancyRemissionDetails>();
    @Column(name="status")
    private String status;
    @Column(name="applicationno")
    private String applicationNumber;
    @OrderBy(value="id")
    @OneToMany(mappedBy="vacancyRemission", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<VacancyRemissionApproval> vacancyRemissionApproval = new LinkedList<VacancyRemissionApproval>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="egpt_vacancy_remission_docs", joinColumns={@JoinColumn(name="vacancyremission")}, inverseJoinColumns={@JoinColumn(name="document")})
    private List<Document> documents = new ArrayList<Document>();
    @Transient
    private String meesevaApplicationNumber;
    @Column(name="source")
    private String source;

    public String getStateDetails() {
        return "Vacancy Remission - " + this.basicProperty.getUpicNo();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BasicPropertyImpl getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicPropertyImpl basicProperty) {
        this.basicProperty = basicProperty;
    }

    public Date getVacancyFromDate() {
        return this.vacancyFromDate;
    }

    public void setVacancyFromDate(Date vacancyFromDate) {
        this.vacancyFromDate = vacancyFromDate;
    }

    public Date getVacancyToDate() {
        return this.vacancyToDate;
    }

    public void setVacancyToDate(Date vacancyToDate) {
        this.vacancyToDate = vacancyToDate;
    }

    public String getVacancyComments() {
        return this.vacancyComments;
    }

    public void setVacancyComments(String vacancyComments) {
        this.vacancyComments = vacancyComments;
    }

    public List<VacancyRemissionDetails> getVacancyRemissionDetails() {
        return this.vacancyRemissionDetails;
    }

    public void setVacancyRemissionDetails(List<VacancyRemissionDetails> vacancyRemissionDetails) {
        this.vacancyRemissionDetails = vacancyRemissionDetails;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<VacancyRemissionApproval> getVacancyRemissionApproval() {
        return this.vacancyRemissionApproval;
    }

    public void setVacancyRemissionApproval(List<VacancyRemissionApproval> vacancyRemissionApproval) {
        this.vacancyRemissionApproval = vacancyRemissionApproval;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }
}

