/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.Installment;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.hibernate.envers.Audited;

@Entity
@Table(name="EGPT_STRUC_CL")
@Unique(columnName={"CODE", "CONSTR_TYPE"}, fields={"constrTypeCode", "typeName"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGPT_STRUC_CL", sequenceName="SEQ_EGPT_STRUC_CL", allocationSize=1)
public class StructureClassification
extends AbstractAuditable {
    private static final long serialVersionUID = 1L;
    public static final String SEQ_STRUCTURE_CLASSIFICATION = "SEQ_EGPT_STRUC_CL";
    @Id
    @GeneratedValue(generator="SEQ_EGPT_STRUC_CL", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Audited
    @Column(name="CONSTR_TYPE")
    private String typeName;
    @Audited
    @Column(name="CONSTR_DESCR")
    private String description;
    @Audited
    @Column(name="CODE")
    private String constrTypeCode;
    @Column(name="ORDER_ID")
    private Integer orderId;
    @Column(name="FLOOR_NUM")
    private Integer floorNum;
    @Column(name="CONSTR_NUM")
    private Integer number;
    @Column(name="CONSTR_FACTOR")
    private Float factor;
    @ManyToOne
    @JoinColumn(name="ID_INSTALLMENT")
    private Installment startInstallment;
    @Column(name="IS_HISTORY")
    private char isHistory;
    @Column(name="FROM_DATE")
    private Date fromDate;
    @Column(name="TO_DATE")
    private Date toDate;
    @Audited
    @Column(name="ISACTIVE")
    private Boolean isActive;

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        StructureClassification thatStrCls = (StructureClassification)((Object)that);
        if (this.getId() != null && thatStrCls.getId() != null) {
            return this.getId().equals(thatStrCls.getId());
        }
        if (this.getTypeName() != null && thatStrCls.getTypeName() != null) {
            return this.getTypeName().equals(thatStrCls.getTypeName());
        }
        if (this.getNumber() != null && thatStrCls.getNumber() != null) {
            return this.getNumber().equals(thatStrCls.getNumber());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        if (this.getTypeName() != null) {
            hashCode += this.getTypeName().hashCode();
        }
        if (this.getNumber() != null) {
            hashCode += this.getNumber().hashCode();
        }
        return hashCode;
    }

    public List<ValidationError> validate() {
        ValidationError ve;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.getTypeName() == null) {
            ve = new ValidationError("StrucClass.TypeName.Null", "In StructureClassification Attribute 'Type Name' is Not Set, Please Check !!");
            validationErrors.add(ve);
        }
        if (this.getNumber() == null || this.getNumber() == 0) {
            ve = new ValidationError("StrucClass.Number.Null", "In StructureClassification Attribute 'Number' is Not Set OR is Zero, Please Check !!");
            validationErrors.add(ve);
        }
        return validationErrors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("").append(this.id).append("|").append(this.constrTypeCode).append("|").append(this.factor);
        return sb.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getConstrTypeCode() {
        return this.constrTypeCode;
    }

    public void setConstrTypeCode(String constrTypeCode) {
        this.constrTypeCode = constrTypeCode.toUpperCase();
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Integer getFloorNum() {
        return this.floorNum;
    }

    public void setFloorNum(Integer floorNum) {
        this.floorNum = floorNum;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Float getFactor() {
        return this.factor;
    }

    public void setFactor(Float factor) {
        this.factor = factor;
    }

    public Installment getStartInstallment() {
        return this.startInstallment;
    }

    public void setStartInstallment(Installment startInstallment) {
        this.startInstallment = startInstallment;
    }

    public char getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(char isHistory) {
        this.isHistory = isHistory;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

