/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.persistence.entity.enums.GuardianRelation;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.MutationRegistrationDetails;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyMutationTransferee;

public class PropertyMutation
extends StateAware<Position> {
    private static final long serialVersionUID = -3387659460257524470L;
    private Long id;
    private PropertyMutationMaster mutationReason;
    private Date mutationDate;
    private BigDecimal mutationFee;
    private BigDecimal marketValue;
    private BigDecimal otherFee;
    private String receiptNum;
    private Date receiptDate;
    private String applicationNo;
    private String applicantName;
    private BasicProperty basicProperty;
    private Property property;
    private List<User> transferorInfos = new ArrayList<User>();
    private List<PropertyMutationTransferee> transfereeInfos = new ArrayList<PropertyMutationTransferee>();
    private List<PropertyMutationTransferee> transfereeInfosProxy = new ArrayList<PropertyMutationTransferee>();
    private boolean feePayable;
    private String deedNo;
    private Date deedDate;
    private String documentNumber;
    private String saleDetail;
    private List<Document> documents = new ArrayList<Document>();
    private String meesevaApplicationNumber;
    private String source;
    private BigDecimal partyValue;
    private BigDecimal departmentValue;
    private boolean partialMutation;
    private boolean registrationDone;
    private String type;
    private String decreeNumber;
    private Date decreeDate;
    private String courtName;
    private MutationRegistrationDetails mutationRegistrationDetails = new MutationRegistrationDetails();

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getStateDetails() {
        StringBuilder stateDetails = new StringBuilder();
        stateDetails.append(this.getBasicProperty().getUpicNo()).append(", ").append(this.getPrimaryTransferee().getName()).append(", ").append(PropertyTaxConstants.PROPERTY_TYPE_CATEGORIES.get(this.getBasicProperty().getProperty().getPropertyDetail().getCategoryType())).append(", ").append(this.getBasicProperty().getPropertyID().getLocality().getName());
        return stateDetails.toString();
    }

    public PropertyMutationMaster getMutationReason() {
        return this.mutationReason;
    }

    public void setMutationReason(PropertyMutationMaster mutationReason) {
        this.mutationReason = mutationReason;
    }

    public Date getMutationDate() {
        return this.mutationDate;
    }

    public void setMutationDate(Date mutationDate) {
        this.mutationDate = mutationDate;
    }

    public BigDecimal getMutationFee() {
        return this.mutationFee;
    }

    public void setMutationFee(BigDecimal mutationFee) {
        this.mutationFee = mutationFee;
    }

    public BigDecimal getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(BigDecimal marketValue) {
        this.marketValue = marketValue;
    }

    public BigDecimal getOtherFee() {
        return this.otherFee;
    }

    public void setOtherFee(BigDecimal otherFee) {
        this.otherFee = otherFee;
    }

    public String getReceiptNum() {
        return this.receiptNum;
    }

    public void setReceiptNum(String receiptNum) {
        this.receiptNum = receiptNum;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public List<User> getTransferorInfos() {
        return this.transferorInfos;
    }

    public void setTransferorInfos(List<User> transferorInfos) {
        this.transferorInfos = transferorInfos;
    }

    public boolean isFeePayable() {
        return this.feePayable;
    }

    public void setFeePayable(boolean feePayable) {
        this.feePayable = feePayable;
    }

    public String getDeedNo() {
        return this.deedNo;
    }

    public void setDeedNo(String deedNo) {
        this.deedNo = deedNo;
    }

    public Date getDeedDate() {
        return this.deedDate;
    }

    public void setDeedDate(Date deedDate) {
        this.deedDate = deedDate;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getSaleDetail() {
        return this.saleDetail;
    }

    public void setSaleDetail(String saleDetail) {
        this.saleDetail = saleDetail;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public String getFullTranfereeName() {
        return this.buildOwnerName(this.getTransfereeInfos());
    }

    public String getFullTranferorName() {
        return this.buildTransferorOwnerName(this.getTransferorInfos());
    }

    public String getTransferorGuardianRelation() {
        return this.buildOwnerGuardianRelation(this.getTransferorInfos());
    }

    public String getFullTransfereeGuardianName() {
        return this.buildGuarianName(this.getTransfereeInfos());
    }

    public String getTransfereeGuardianRelation() {
        return this.buildOwnerGuardianRelation(this.getTransferees(this.transfereeInfos));
    }

    private String buildGuarianName(List<PropertyMutationTransferee> userInfo) {
        StringBuilder guardianName = new StringBuilder();
        for (PropertyMutationTransferee owner : userInfo) {
            if (!StringUtils.isNotBlank((CharSequence)owner.getTransferee().getGuardian())) continue;
            guardianName.append(owner.getTransferee().getGuardian()).append(", ");
        }
        if (guardianName.length() > 0) {
            guardianName.deleteCharAt(guardianName.length() - 2);
        }
        return guardianName.toString();
    }

    private List<User> getTransferees(List<PropertyMutationTransferee> transfereeInfos) {
        ArrayList<User> users = new ArrayList<User>();
        for (PropertyMutationTransferee transferee : transfereeInfos) {
            users.add(transferee.getTransferee());
        }
        return users;
    }

    private String buildOwnerName(List<PropertyMutationTransferee> userInfos) {
        StringBuilder ownerName = new StringBuilder();
        for (PropertyMutationTransferee owner : userInfos) {
            ownerName.append(owner.getTransferee().getName()).append(", ");
        }
        if (ownerName.length() > 0) {
            ownerName.deleteCharAt(ownerName.length() - 2);
        }
        return ownerName.toString();
    }

    private String buildTransferorOwnerName(List<User> userInfos) {
        StringBuilder ownerName = new StringBuilder();
        for (User owner : userInfos) {
            ownerName.append(owner.getName()).append(", ");
        }
        if (ownerName.length() > 0) {
            ownerName.deleteCharAt(ownerName.length() - 2);
        }
        return ownerName.toString();
    }

    private String buildOwnerGuardianRelation(List<User> userInfo) {
        StringBuilder ownerGuardianRelation = new StringBuilder();
        String relation = "";
        for (User owner : userInfo) {
            ownerGuardianRelation.append(owner.getName());
            if (owner.getGuardianRelation().equalsIgnoreCase(GuardianRelation.Father.toString()) || owner.getGuardianRelation().equalsIgnoreCase(GuardianRelation.Mother.toString())) {
                if (owner.getGender().equals((Object)Gender.FEMALE)) {
                    relation = " D/O ";
                } else if (owner.getGender().equals((Object)Gender.MALE)) {
                    relation = " S/O ";
                }
            } else {
                relation = owner.getGuardianRelation().equalsIgnoreCase(GuardianRelation.Husband.toString()) ? " W/O " : (owner.getGuardianRelation().equalsIgnoreCase("WIFE") ? " H/O " : " C/O ");
            }
            ownerGuardianRelation.append(relation).append(StringUtils.isNotBlank((CharSequence)owner.getGuardian()) ? owner.getGuardian() : " ").append(", ");
        }
        if (ownerGuardianRelation.length() > 0) {
            ownerGuardianRelation.deleteCharAt(ownerGuardianRelation.length() - 2);
        }
        return ownerGuardianRelation.toString();
    }

    public User getPrimaryTransferee() {
        User user = new User();
        if (!this.getTransfereeInfos().isEmpty()) {
            return this.getTransferorInfos().get(0);
        }
        return user;
    }

    public User getPrimaryTransferor() {
        User user = new User();
        if (!this.getTransferorInfos().isEmpty()) {
            return this.getTransferorInfos().get(0);
        }
        return user;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<PropertyMutationTransferee> getTransfereeInfos() {
        return this.transfereeInfos;
    }

    public void setTransfereeInfos(List<PropertyMutationTransferee> transfereeInfos) {
        this.transfereeInfos = transfereeInfos;
    }

    public void addTransfereeInfos(PropertyMutationTransferee transfereeInfo) {
        this.getTransfereeInfos().add(transfereeInfo);
    }

    public void removeTransfereeInfos(PropertyMutationTransferee transfereeInfo) {
        this.getTransfereeInfos().remove((Object)transfereeInfo);
    }

    public List<PropertyMutationTransferee> getTransfereeInfosProxy() {
        return this.transfereeInfosProxy;
    }

    public void setTransfereeInfosProxy(List<PropertyMutationTransferee> transfereeInfosProxy) {
        this.transfereeInfosProxy = transfereeInfosProxy;
    }

    public BigDecimal getPartyValue() {
        return this.partyValue;
    }

    public void setPartyValue(BigDecimal partyValue) {
        this.partyValue = partyValue;
    }

    public BigDecimal getDepartmentValue() {
        return this.departmentValue;
    }

    public void setDepartmentValue(BigDecimal departmentValue) {
        this.departmentValue = departmentValue;
    }

    public boolean isPartialMutation() {
        return this.partialMutation;
    }

    public void setPartialMutation(boolean partialMutation) {
        this.partialMutation = partialMutation;
    }

    public boolean isRegistrationDone() {
        return this.registrationDone;
    }

    public void setRegistrationDone(boolean registrationDone) {
        this.registrationDone = registrationDone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MutationRegistrationDetails getMutationRegistrationDetails() {
        return this.mutationRegistrationDetails;
    }

    public void setMutationRegistrationDetails(MutationRegistrationDetails mutationRegistrationDetails) {
        this.mutationRegistrationDetails = mutationRegistrationDetails;
    }

    public String getDecreeNumber() {
        return this.decreeNumber;
    }

    public void setDecreeNumber(String decreeNumber) {
        this.decreeNumber = decreeNumber;
    }

    public Date getDecreeDate() {
        return this.decreeDate;
    }

    public void setDecreeDate(Date decreeDate) {
        this.decreeDate = decreeDate;
    }

    public String getCourtName() {
        return this.courtName;
    }

    public void setCourtName(String courtName) {
        this.courtName = courtName;
    }
}

