/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.demand;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.demand.model.DemandCalculations;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.BaseModel;
import org.egov.ptis.domain.entity.demand.FloorwiseDemandCalculations;
import org.egov.ptis.domain.entity.demand.Ptdemand;

public class PTDemandCalculations
extends BaseModel
implements DemandCalculations {
    private Ptdemand ptDemand;
    private BigDecimal propertyTax;
    private BigDecimal rateOfTax;
    private Date lastUpdatedTimeStamp;
    private Date createTimeStamp;
    private Set<FloorwiseDemandCalculations> flrwiseDmdCalculations = new HashSet<FloorwiseDemandCalculations>();
    private byte[] taxInfo;
    private BigDecimal alv;

    public DemandCalculations createDemandCalculations() {
        return null;
    }

    public PTDemandCalculations(Ptdemand ptDemand, BigDecimal propertyTax, BigDecimal rateOfTax, Date lastUpdatedTimeStamp, Date createTimeStamp, Set<FloorwiseDemandCalculations> flrwiseDmdCalculations, byte[] taxInfo, BigDecimal alv) {
        this.ptDemand = ptDemand;
        this.propertyTax = propertyTax;
        this.rateOfTax = rateOfTax;
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        this.createTimeStamp = createTimeStamp;
        this.flrwiseDmdCalculations = flrwiseDmdCalculations;
        this.taxInfo = taxInfo;
        this.alv = alv;
    }

    public PTDemandCalculations(PTDemandCalculations ptDemandCalc) {
        this.propertyTax = ptDemandCalc.propertyTax;
        this.rateOfTax = ptDemandCalc.rateOfTax;
        this.lastUpdatedTimeStamp = new Date();
        for (FloorwiseDemandCalculations floorDmdCalc : ptDemandCalc.flrwiseDmdCalculations) {
            this.addFlrwiseDmdCalculations(new FloorwiseDemandCalculations(floorDmdCalc));
        }
        this.taxInfo = ptDemandCalc.taxInfo;
    }

    public PTDemandCalculations() {
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        PTDemandCalculations thatDemand = (PTDemandCalculations)((Object)that);
        if (this.getId() != null && thatDemand.getId() != null) {
            return this.getId().equals(thatDemand.getId());
        }
        if (this.getPtDemand() != null && thatDemand.getPtDemand() != null) {
            return this.getPtDemand().equals((Object)thatDemand.getPtDemand());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        if (this.getPtDemand() != null) {
            hashCode += this.getPtDemand().hashCode();
        }
        return hashCode;
    }

    public boolean validateDmdCalc() {
        if (this.getPtDemand() == null) {
            throw new ApplicationRuntimeException("In PTDemandCalculations Validate : ptDemand is Not Set, Please Check !!");
        }
        if (this.getFlrwiseDmdCalculations() == null || this.getFlrwiseDmdCalculations().size() == 0) {
            throw new ApplicationRuntimeException("In PTDemandCalculations Validate : FloorwiseDmdCalculations is Not Set, Please Check !!");
        }
        return true;
    }

    public Ptdemand getPtDemand() {
        return this.ptDemand;
    }

    public void setPtDemand(Ptdemand ptDemand) {
        this.ptDemand = ptDemand;
    }

    public BigDecimal getPropertyTax() {
        return this.propertyTax;
    }

    public void setPropertyTax(BigDecimal propertyTax) {
        this.propertyTax = propertyTax;
    }

    public BigDecimal getRateOfTax() {
        return this.rateOfTax;
    }

    public void setRateOfTax(BigDecimal rateOfTax) {
        this.rateOfTax = rateOfTax;
    }

    public Date getLastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public void setLastUpdatedTimeStamp(Date lastUpdatedTimeStamp) {
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
    }

    public Date getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public void setCreateTimeStamp(Date createTimeStamp) {
        this.createTimeStamp = createTimeStamp;
    }

    public Set<FloorwiseDemandCalculations> getFlrwiseDmdCalculations() {
        return this.flrwiseDmdCalculations;
    }

    public void setFlrwiseDmdCalculations(Set<FloorwiseDemandCalculations> flrwiseDmdCalculations) {
        this.flrwiseDmdCalculations = flrwiseDmdCalculations;
    }

    public void addFlrwiseDmdCalculations(FloorwiseDemandCalculations flwiseDmd) {
        this.getFlrwiseDmdCalculations().add(flwiseDmd);
        flwiseDmd.setPTDemandCalculations(this);
    }

    public void removeFlrwiseDmdCalculations(FloorwiseDemandCalculations flwiseDmd) {
        this.getFlrwiseDmdCalculations().remove(flwiseDmd);
    }

    public byte[] getTaxInfo() {
        return this.taxInfo;
    }

    public void setTaxInfo(byte[] taxInfo) {
        this.taxInfo = taxInfo;
    }

    public BigDecimal getAlv() {
        return this.alv;
    }

    public void setAlv(BigDecimal alv) {
        this.alv = alv;
    }

    public String toString() {
        StringBuilder objStr = new StringBuilder();
        objStr.append("Id: ").append(this.getId()).append("|PtDemamd: ").append((Object)this.getPtDemand()).append("|PropertyTax: ").append(this.getPropertyTax()).append("|RateOfTax: ").append(this.getRateOfTax()).append("|TaxInfo: ").append(this.getTaxInfo()).append("|Alv: ").append(this.getAlv());
        return objStr.toString();
    }
}

