/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.StructureClassificationDAO;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="structureClassificationDAO")
@Transactional(readOnly=true)
public class StructureClassificationHibernateDAO
implements StructureClassificationDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List getAllStructureClassification() {
        Query qry = this.getCurrentSession().createQuery("FROM StructureClassification SC WHERE ((SC.toDate IS NULL AND SC.fromDate <= :currDate) OR (SC.fromDate <= :currDate AND SC.toDate >= :currDate))");
        qry.setDate("currDate", new Date());
        return qry.list();
    }

    @Override
    public StructureClassification getStructureClassification(String constrTypeCode, Integer floorNum) {
        Query qry = this.getCurrentSession().createQuery("FROM StructureClassification SC WHERE SC.constrTypeCode =:constrTypeCode AND SC.floorNum =:floorNum");
        qry.setString("constrTypeCode", constrTypeCode);
        qry.setInteger("floorNum", floorNum.intValue());
        return (StructureClassification)((Object)qry.uniqueResult());
    }

    @Override
    public StructureClassification getStructureClassification(String constrTypeCode, Date fromDate, Integer floorNum) {
        Query qry = this.getCurrentSession().createQuery("FROM StructureClassification SC WHERE SC.constrTypeCode =:constrTypeCode AND SC.floorNum =:floorNum AND ((SC.toDate IS NULL AND SC.fromDate <= :fromDate) OR (SC.fromDate <= :fromDate AND SC.toDate >= :fromDate))");
        qry.setString("constrTypeCode", constrTypeCode);
        qry.setInteger("floorNum", floorNum.intValue());
        qry.setDate("fromDate", fromDate);
        return (StructureClassification)((Object)qry.uniqueResult());
    }

    @Override
    public StructureClassification getStructureClassification(String constrTypeCode) {
        Query qry = this.getCurrentSession().createQuery("FROM StructureClassification SC WHERE SC.constrTypeCode =:constrTypeCode AND ((SC.toDate IS NULL AND SC.fromDate <= :currDate) OR (SC.fromDate <= :currDate AND SC.toDate >= :currDate))");
        qry.setString("constrTypeCode", constrTypeCode);
        qry.setDate("currDate", new Date());
        return (StructureClassification)((Object)qry.uniqueResult());
    }

    @Override
    public StructureClassification getStructureClassification(String constrTypeCode, Date fromDate) {
        Query qry = this.getCurrentSession().createQuery("FROM StructureClassification SC WHERE SC.constrTypeCode =:constrTypeCode AND ((SC.toDate IS NULL AND SC.fromDate <= :fromDate) OR (SC.fromDate <= :fromDate AND SC.toDate >= :fromDate))");
        qry.setString("constrTypeCode", constrTypeCode);
        qry.setDate("fromDate", fromDate);
        return (StructureClassification)((Object)qry.uniqueResult());
    }

    @Override
    public StructureClassification findById(Long id, boolean lock) {
        return null;
    }

    @Override
    public List<StructureClassification> findAll() {
        return null;
    }

    @Override
    public StructureClassification create(StructureClassification structureClassification) {
        return null;
    }

    @Override
    public void delete(StructureClassification structureClassification) {
    }

    @Override
    public StructureClassification update(StructureClassification structureClassification) {
        return null;
    }
}

