/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.demand;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="ptDemandDAO")
public class PtDemandHibernateDao
implements PtDemandDao {
    private static final String BILLID_PARAM = "billid";
    private static final String PROPERTY = "property";
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    @Qualifier(value="demandGenericDAO")
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private PropertyDAO propertyDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public BigDecimal getCurrentDemandforProperty(Property property) {
        BigDecimal currentDemand = BigDecimal.ZERO;
        Query qry = null;
        if (property != null) {
            qry = this.getCurrentSession().createQuery(" select sum(DmdDetails.amount) from  EgptPtdemand egDemand left join  egDemand.egDemandDetails DmdDetails where  egDemand.egptProperty =:property  and egDemand.isHistory='N'   ");
            qry.setEntity(PROPERTY, (Object)property);
            currentDemand = (BigDecimal)qry.uniqueResult();
        }
        return currentDemand;
    }

    @Override
    public Character whetherBillExistsForProperty(Property property, String billnum, Module module) {
        Character status = null;
        Query qry = null;
        if (property != null && billnum != null) {
            List egBillList = this.demandGenericDAO.getBillsByBillNumber(billnum, module);
            if (egBillList == null || egBillList.isEmpty()) {
                status = Character.valueOf('N');
            } else {
                EgBill egBill = (EgBill)egBillList.get(0);
                if (egBill == null) {
                    status = Character.valueOf('N');
                } else {
                    qry = this.getCurrentSession().createQuery("select egBill from  EgptPtdemand egptDem , EgBill egBill  where egptDem.egptProperty =:property and :egBill in elements(egptDem.egBills)   ");
                    qry.setEntity(PROPERTY, (Object)property);
                    qry.setEntity("egBill", (Object)egBill);
                    List list = qry.list();
                    status = list.isEmpty() ? Character.valueOf('N') : Character.valueOf('Y');
                }
            }
        }
        return status;
    }

    @Override
    public Ptdemand getNonHistoryDemandForProperty(Property property) {
        Query qry = null;
        Ptdemand egptPtdemand = null;
        if (property != null) {
            qry = this.getCurrentSession().createQuery("from  Ptdemand egptDem where egptDem.egptProperty =:property   ");
            qry.setEntity(PROPERTY, (Object)property);
            egptPtdemand = qry.list().size() == 1 ? (Ptdemand)((Object)qry.uniqueResult()) : (Ptdemand)((Object)qry.list().get(0));
        }
        return egptPtdemand;
    }

    @Override
    public List getDmdDetailsByPropertyIdBoundary(BasicProperty basicProperty, Boundary divBoundary) {
        String divStatus = "N";
        List list = new ArrayList();
        StringBuffer qry = new StringBuffer(50);
        if (basicProperty != null) {
            qry.append(" select demdet From EgptPtdemand ptdem left join ptdem.egDemandDetails demdet left join ptdem.egptProperty prop left join  prop.basicProperty bp");
            if (divBoundary != null) {
                qry.append(" left join bp.propertyID ppid  ");
                divStatus = "Y";
            }
            qry.append(" where ptdem.isHistory='N'  and prop.status='N' and  prop.isDefaultProperty='Y' and bp.active='Y' and bp =:basicProperty ");
            if ("Y".equals(divStatus)) {
                qry.append(" and ppid.wardId =:divBoundary  ");
            }
            Query query = this.getCurrentSession().createQuery(qry.toString());
            query.setEntity("basicProperty", (Object)basicProperty);
            if ("Y".equals(divStatus)) {
                query.setEntity("divBoundary", (Object)divBoundary);
            }
            list = query.list();
        }
        return list;
    }

    public List getTransactionByBasicProperty(BasicProperty basicProperty, Installment installment, String is_cancelled) {
        Query qry = null;
        List list = new ArrayList(0);
        if (basicProperty != null && installment != null && is_cancelled != null && !is_cancelled.equals("")) {
            qry = this.getCurrentSession().createQuery(" select TD from PropertyTaxTxAgent txAgent left join txAgent.myTransactions header  left join header.transactionDetails TD where  header.isCancelled =:is_cancelled and  header.installment =:installment and txAgent.basicProperty =:basicProperty  ");
            qry.setString("is_cancelled", is_cancelled);
            qry.setEntity("basicProperty", (Object)basicProperty);
            qry.setEntity("installment", (Object)installment);
            list = qry.list();
        }
        return list;
    }

    @Override
    public Map<EgDemandReason, BigDecimal> getAllDemands(BasicProperty basicProperty, Boundary divBoundary) {
        BigDecimal amount = BigDecimal.ZERO;
        List demandDetailsList = this.getDmdDetailsByPropertyIdBoundary(basicProperty, divBoundary);
        HashMap<EgDemandReason, BigDecimal> dmdMap = new HashMap<EgDemandReason, BigDecimal>();
        for (EgDemandDetails egDemandDetails : demandDetailsList) {
            if (egDemandDetails.getEgDemandReason() == null) continue;
            if (dmdMap.containsKey(egDemandDetails.getEgDemandReason())) {
                dmdMap.put(egDemandDetails.getEgDemandReason(), egDemandDetails.getAmount());
                continue;
            }
            amount = amount.add(egDemandDetails.getAmount());
            dmdMap.put(egDemandDetails.getEgDemandReason(), amount);
        }
        return dmdMap;
    }

    @Override
    public List<BigDecimal> getCurrentAmountsFromBill(Long billId) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT").append("    SUM(det.amount),").append("    SUM(det.amt_collected),").append("    SUM(det.amt_rebate)").append(" FROM ").append("    eg_bill bill,").append("    eg_demand_details det,").append("    eg_demand_reason reas,").append("    eg_demand_reason_master reasm,").append("    eg_reason_category reascat,").append("    eg_installment_master inst,").append("    eg_module module").append(" WHERE ").append("    bill.id = :").append(BILLID_PARAM).append(" AND").append("    det.id_demand = bill.id_demand AND").append("    det.id_demand_reason = reas.id AND").append("    reas.id_installment = inst.id_installment AND").append("    reas.id_demand_reason_master = reasm.id AND").append("    reasm.id_category = reascat.id_type AND").append("    reascat.code = 'TAX' AND").append("    inst.start_date <= SYSDATE AND").append("    inst.end_date   >= SYSDATE AND").append("    inst.id_module = module.id_module AND").append("    module.module_name = 'Property Tax'");
        SQLQuery query = this.getCurrentSession().createSQLQuery(sb.toString());
        query.setLong(BILLID_PARAM, billId.longValue());
        Object[] results = (Object[])query.uniqueResult();
        ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
        amounts.add((BigDecimal)results[0]);
        amounts.add((BigDecimal)results[1]);
        amounts.add((BigDecimal)results[2]);
        return amounts;
    }

    @Override
    public Map<String, BigDecimal> getDemandCollMap(Property property) {
        Ptdemand currDemand = this.getNonHistoryCurrDmdForProperty(property);
        Installment installment = null;
        List dmdCollList = new ArrayList();
        Integer instId = null;
        BigDecimal currFirstHalfDmd = BigDecimal.ZERO;
        BigDecimal currSecondHalfDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currFirstHalfCollection = BigDecimal.ZERO;
        BigDecimal currSecondHalfCollection = BigDecimal.ZERO;
        BigDecimal arrColelection = BigDecimal.ZERO;
        BigDecimal demand = BigDecimal.ZERO;
        BigDecimal collection = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.propertyDAO.getDmdCollAmtInstWise(currDemand);
        }
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[0].toString());
            demand = listObj[1] != null ? new BigDecimal((Double)listObj[1]) : BigDecimal.ZERO;
            collection = listObj[2] != null ? new BigDecimal((Double)listObj[2]) : BigDecimal.ZERO;
            installment = this.installmentDao.findById(instId.intValue(), false);
            if (currYearInstMap.get("Current 1st Half").equals((Object)installment)) {
                if (collection.compareTo(BigDecimal.ZERO) == 1) {
                    currFirstHalfCollection = currFirstHalfCollection.add(collection);
                }
                currFirstHalfDmd = currFirstHalfDmd.add(demand);
                continue;
            }
            if (currYearInstMap.get("Current 2nd Half").equals((Object)installment)) {
                if (collection.compareTo(BigDecimal.ZERO) == 1) {
                    currSecondHalfCollection = currSecondHalfCollection.add(collection);
                }
                currSecondHalfDmd = currSecondHalfDmd.add(demand);
                continue;
            }
            arrDmd = arrDmd.add(demand);
            if (collection.compareTo(BigDecimal.ZERO) != 1) continue;
            arrColelection = arrColelection.add(collection);
        }
        retMap.put("CURR_FIRSTHALF_DMD", currFirstHalfDmd);
        retMap.put("CURR_SECONDHALF_DMD", currSecondHalfDmd);
        retMap.put("ARR_DMD", arrDmd);
        retMap.put("CURR_FIRSTHALF_COLL", currFirstHalfCollection);
        retMap.put("CURR_SECONDHALF_COLL", currSecondHalfCollection);
        retMap.put("ARR_COLL", arrColelection);
        return retMap;
    }

    @Override
    public Map<String, BigDecimal> getDemandCollMapIncludingPenaltyAndAdvance(Property property) {
        Ptdemand currDemand = this.getNonHistoryCurrDmdForProperty(property);
        Installment installment = null;
        List dmdCollList = new ArrayList();
        Integer instId = null;
        String code = "";
        BigDecimal currFirstHalfDmd = BigDecimal.ZERO;
        BigDecimal currSecondHalfDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currFirstHalfCollection = BigDecimal.ZERO;
        BigDecimal currSecondHalfCollection = BigDecimal.ZERO;
        BigDecimal arrColelection = BigDecimal.ZERO;
        BigDecimal currFirstHalfPenalty = BigDecimal.ZERO;
        BigDecimal currSecondHalfPenalty = BigDecimal.ZERO;
        BigDecimal currFirstHalfPenaltyColllection = BigDecimal.ZERO;
        BigDecimal currSecondHalfPenaltyCollection = BigDecimal.ZERO;
        BigDecimal arrPenaltyCollection = BigDecimal.ZERO;
        BigDecimal arrPenalty = BigDecimal.ZERO;
        BigDecimal advance = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.propertyDAO.getInstallmentAndReasonWiseDemandDetails(currDemand);
        }
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[0].toString());
            code = listObj[1].toString();
            BigDecimal demand = listObj[2] != null ? new BigDecimal((Double)listObj[2]) : BigDecimal.ZERO;
            BigDecimal collection = listObj[3] != null ? new BigDecimal((Double)listObj[3]) : BigDecimal.ZERO;
            installment = this.installmentDao.findById(instId.intValue(), false);
            if (currYearInstMap.get("Current 1st Half").equals((Object)installment) && installment.getId().equals(instId)) {
                if (!code.equals("ADVANCE") && !code.equals("PENALTY")) {
                    currFirstHalfDmd = currFirstHalfDmd.add(demand);
                    if (collection.compareTo(BigDecimal.ZERO) > 0) {
                        currFirstHalfCollection = currFirstHalfCollection.add(collection);
                    }
                } else if (!code.equals("ADVANCE") && code.equals("PENALTY")) {
                    currFirstHalfPenalty = currFirstHalfPenalty.add(demand);
                    if (collection.compareTo(BigDecimal.ZERO) > 0) {
                        currFirstHalfCollection = currFirstHalfCollection.add(collection);
                    }
                }
            } else if (currYearInstMap.get("Current 2nd Half").equals((Object)installment) && installment.getId().equals(instId)) {
                if (!code.equals("ADVANCE") && !code.equals("PENALTY")) {
                    currSecondHalfDmd = currSecondHalfDmd.add(demand);
                    if (collection.compareTo(BigDecimal.ZERO) > 0) {
                        currSecondHalfCollection = currSecondHalfCollection.add(collection);
                    } else if (!code.equals("ADVANCE") && code.equals("PENALTY")) {
                        currSecondHalfPenalty = currSecondHalfPenalty.add(demand);
                        if (collection.compareTo(BigDecimal.ZERO) > 0) {
                            currSecondHalfCollection = currSecondHalfCollection.add(collection);
                        }
                    }
                }
            } else if (!code.equals("ADVANCE") && !code.equals("PENALTY")) {
                arrDmd = arrDmd.add(demand);
                if (collection.compareTo(BigDecimal.ZERO) > 0) {
                    arrColelection = arrColelection.add(collection);
                }
            } else if (code.equals("ADVANCE") || code.equals("PENALTY")) {
                // empty if block
            }
            if (!code.equals("ADVANCE")) continue;
            advance = advance.add(collection);
        }
        retMap.put("CURR_FIRSTHALF_DMD", currFirstHalfDmd);
        retMap.put("CURR_SECONDHALF_DMD", currSecondHalfDmd);
        retMap.put("ARR_DMD", arrDmd);
        retMap.put("CURR_FIRSTHALF_COLL", currFirstHalfCollection);
        retMap.put("CURR_SECONDHALF_COLL", currSecondHalfCollection);
        retMap.put("ARR_COLL", arrColelection);
        retMap.put("CURR_FIRSTHALF_PENALTY_DMD", currFirstHalfPenalty);
        retMap.put("CURR_SECONDHALF_PENALTY_DMD", currSecondHalfPenalty);
        retMap.put("ARR_PENALTY_DMD", arrPenalty);
        retMap.put("CURR_FIRSTHALF_PENALTY_COLL", currFirstHalfPenaltyColllection);
        retMap.put("CURR_SECONDHALF_PENALTY_COLL", currSecondHalfPenaltyCollection);
        retMap.put("ARR_PENALTY_COLL", arrPenaltyCollection);
        retMap.put("ADVANCE", advance);
        return retMap;
    }

    @Override
    public Map<String, BigDecimal> getPenaltyDemandCollMap(Property property) {
        Ptdemand currDemand = this.getNonHistoryCurrDmdForProperty(property);
        Installment installment = null;
        List penaltyDmdCollList = new ArrayList();
        Object currInst = null;
        Integer instId = null;
        BigDecimal currPenalty = BigDecimal.ZERO;
        BigDecimal arrPenalty = BigDecimal.ZERO;
        BigDecimal currPenaltyColl = BigDecimal.ZERO;
        BigDecimal arrPenaltyColl = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            penaltyDmdCollList = this.propertyDAO.getPenaltyDmdCollAmtInstWise(currDemand);
        }
        for (Object object : penaltyDmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[0].toString());
            installment = this.installmentDao.findById(instId.intValue(), false);
            if (installment.equals(currInst)) {
                if (listObj[2] != null && !new BigDecimal((Double)listObj[2]).equals(BigDecimal.ZERO)) {
                    currPenaltyColl = currPenaltyColl.add(new BigDecimal((Double)listObj[2]));
                }
                if (listObj[3] != null && !new BigDecimal((Double)listObj[3]).equals(BigDecimal.ZERO)) {
                    currPenaltyColl = currPenaltyColl.add(new BigDecimal((Double)listObj[3]));
                }
                currPenalty = currPenalty.add(new BigDecimal((Double)listObj[1]));
                continue;
            }
            arrPenalty = arrPenalty.add(new BigDecimal((Double)listObj[1]));
            if (listObj[2] != null && !new BigDecimal((Double)listObj[2]).equals(BigDecimal.ZERO)) {
                arrPenaltyColl = arrPenaltyColl.add(new BigDecimal((Double)listObj[2]));
            }
            if (listObj[3] == null || new BigDecimal((Double)listObj[3]).equals(BigDecimal.ZERO)) continue;
            arrPenaltyColl = arrPenaltyColl.add(new BigDecimal((Double)listObj[3]));
        }
        retMap.put("CURR_PEANLTY_DMD", currPenalty);
        retMap.put("ARR_PENALTY_DMD", arrPenalty);
        retMap.put("CURR_PENALTY_COLL", currPenaltyColl);
        retMap.put("ARR_PENALTY_COLL", arrPenaltyColl);
        return retMap;
    }

    @Override
    public Ptdemand getNonHistoryCurrDmdForProperty(Property property) {
        Query qry = null;
        Ptdemand egptPtdemand = null;
        if (property != null) {
            CFinancialYear currentFinancialYear = this.financialYearDAO.getFinancialYearByDate(new Date());
            qry = this.getCurrentSession().createQuery("from  Ptdemand egptDem left join fetch egptDem.egDemandDetails dd left join fetch dd.egDemandReason dr where egptDem.egptProperty =:property and (egptDem.egInstallmentMaster.fromDate <= :fromYear and egptDem.egInstallmentMaster.toDate >=:toYear) and egptDem.isHistory='N' ");
            qry.setEntity(PROPERTY, (Object)property);
            qry.setDate("fromYear", currentFinancialYear.getStartingDate());
            qry.setDate("toYear", currentFinancialYear.getStartingDate());
            List ptDemandResult = qry.list();
            if (ptDemandResult != null && ptDemandResult.size() > 0) {
                egptPtdemand = (Ptdemand)((Object)ptDemandResult.get(0));
            }
        }
        return egptPtdemand;
    }

    public List findAll() {
        return null;
    }

    @Override
    public Ptdemand findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public Ptdemand create(Ptdemand ptdemand) {
        return null;
    }

    @Override
    public void delete(Ptdemand ptdemand) {
    }

    @Override
    public Ptdemand update(Ptdemand ptdemand) {
        this.getCurrentSession().update((Object)ptdemand);
        return ptdemand;
    }

    @Override
    public List<Object> getPropertyTaxDetails(String assessmentNo) {
        ArrayList<Object> list = new ArrayList();
        CFinancialYear currentFinancialYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        String selectQuery = " select drm.code, inst.description, dd.amount, dd.amt_collected  from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand d, eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where bp.id = prop.id_basic_property and prop.status  in ('A','I')  and prop.id = ptd.id_property and ptd.id_demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and dr.id_installment = inst.id and bp.propertyid =:assessmentNo and dd.amount > dd.amt_collected   and d.id_installment =(select id from eg_installment_master  where start_date <= :fromYear and end_date >=:toYear and id_module=(select id from eg_module where name='Property Tax' ))  ";
        selectQuery = selectQuery + " order by inst.description desc ";
        Query qry = this.getCurrentSession().createSQLQuery(selectQuery).setString("assessmentNo", assessmentNo).setDate("fromYear", currentFinancialYear.getStartingDate()).setDate("toYear", currentFinancialYear.getStartingDate());
        list = qry.list();
        return list;
    }

    @Override
    public List<Object> getTaxDetailsForWaterConnection(String consumerNo, String connectionType) {
        ArrayList<Object> list = new ArrayList();
        String selectQuery = "";
        selectQuery = connectionType.equals("METERED") ? " select drm.code, inst.description, dd.amount, dd.amt_collected  from  egwtr_connection conn,egwtr_connectiondetails bp, egwtr_demand_connection demconn ,eg_demand d, eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where conn.id =bp.connection  and demconn.connectiondetails = bp.id  and demconn.demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and dr.id_installment = inst.id and conn.consumercode =:consumerNo and dd.amount > dd.amt_collected   and d.id_installment =(select id from eg_installment_master where now() between start_date and end_date and id_module=(select id from eg_module where name='Water Tax Management' ) and installment_type='Monthly' )  " : " select drm.code, inst.description, dd.amount, dd.amt_collected  from  egwtr_connection conn,egwtr_connectiondetails bp,egwtr_demand_connection demconn , eg_demand d, eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where conn.id =bp.connection  and demconn.connectiondetails = bp.id  and demconn.demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and d.is_history='N'  and dr.id_installment = inst.id and conn.consumercode =:consumerNo and dd.amount > dd.amt_collected  ";
        selectQuery = selectQuery + " order by inst.description desc ";
        Query qry = this.getCurrentSession().createSQLQuery(selectQuery).setString("consumerNo", consumerNo);
        list = qry.list();
        return list;
    }

    @Override
    @Deprecated
    public Set<String> getDemandYears(String assessmentNo) {
        LinkedHashSet<String> demandYears = new LinkedHashSet<String>();
        String selectQuery = " select inst.description  from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand d, eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where bp.id = prop.id_basic_property and prop.status = 'A'  and prop.id = ptd.id_property and ptd.id_demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and dr.id_installment = inst.id and bp.propertyid =:assessmentNo  and d.id_installment =(select id from eg_installment_master where now() between start_date and end_date and id_module=(select id from eg_module where name='Property Tax' )) order by inst.start_date ";
        Query qry = this.getCurrentSession().createSQLQuery(" select inst.description  from egpt_basic_property bp, egpt_property prop, egpt_ptdemand ptd, eg_demand d, eg_demand_details dd, eg_demand_reason dr, eg_demand_reason_master drm, eg_installment_master inst  where bp.id = prop.id_basic_property and prop.status = 'A'  and prop.id = ptd.id_property and ptd.id_demand = d.id  and d.id = dd.id_demand  and dd.id_demand_reason = dr.id and drm.id = dr.id_demand_reason_master  and dr.id_installment = inst.id and bp.propertyid =:assessmentNo  and d.id_installment =(select id from eg_installment_master where now() between start_date and end_date and id_module=(select id from eg_module where name='Property Tax' )) order by inst.start_date ").setString("assessmentNo", assessmentNo);
        for (Object record : qry.list()) {
            demandYears.add((String)record);
        }
        return demandYears;
    }

    @Override
    public Map<String, BigDecimal> getDemandIncludingPenaltyCollMap(Property property) {
        Ptdemand currDemand = this.getNonHistoryCurrDmdForProperty(property);
        Installment installment = null;
        List dmdCollList = new ArrayList();
        Integer instId = null;
        BigDecimal currFirstHalfDmd = BigDecimal.ZERO;
        BigDecimal currSecondHalfDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currFirstHalfCollection = BigDecimal.ZERO;
        BigDecimal currSecondHalfCollection = BigDecimal.ZERO;
        BigDecimal arrColelection = BigDecimal.ZERO;
        BigDecimal demand = BigDecimal.ZERO;
        BigDecimal collection = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.propertyDAO.getTotalDemandDetailsIncludingPenalty(currDemand);
        }
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[0].toString());
            demand = listObj[1] != null ? new BigDecimal((Double)listObj[1]) : BigDecimal.ZERO;
            collection = listObj[2] != null ? new BigDecimal((Double)listObj[2]) : BigDecimal.ZERO;
            installment = this.installmentDao.findById(instId.intValue(), false);
            if (currYearInstMap.get("Current 1st Half").equals((Object)installment)) {
                if (collection.compareTo(BigDecimal.ZERO) == 1) {
                    currFirstHalfCollection = currFirstHalfCollection.add(collection);
                }
                currFirstHalfDmd = currFirstHalfDmd.add(demand);
                continue;
            }
            if (currYearInstMap.get("Current 2nd Half").equals((Object)installment)) {
                if (collection.compareTo(BigDecimal.ZERO) == 1) {
                    currSecondHalfCollection = currSecondHalfCollection.add(collection);
                }
                currSecondHalfDmd = currSecondHalfDmd.add(demand);
                continue;
            }
            arrDmd = arrDmd.add(demand);
            if (collection.compareTo(BigDecimal.ZERO) != 1) continue;
            arrColelection = arrColelection.add(collection);
        }
        retMap.put("CURR_FIRSTHALF_DMD", currFirstHalfDmd);
        retMap.put("CURR_SECONDHALF_DMD", currSecondHalfDmd);
        retMap.put("ARR_DMD", arrDmd);
        retMap.put("CURR_FIRSTHALF_COLL", currFirstHalfCollection);
        retMap.put("CURR_SECONDHALF_COLL", currSecondHalfCollection);
        retMap.put("ARR_COLL", arrColelection);
        return retMap;
    }
}

