/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgDemandDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.interfaces.LatePayPenaltyCalculator;
import org.egov.demand.interfaces.RebateCalculator;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.MoneyUtils;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.service.PenaltyCalculationService;
import org.egov.ptis.client.util.FinancialUtil;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.service.property.RebateService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="propertyTaxBillable")
@Scope(value="prototype")
public class PropertyTaxBillable
extends AbstractBillable
implements Billable,
LatePayPenaltyCalculator,
RebateCalculator {
    private static final String STRING_DEPARTMENT_CODE = "REV";
    private Boolean isCallbackForApportion = Boolean.TRUE;
    private LatePayPenaltyCalculator.LPPenaltyCalcType penaltyCalcType = LatePayPenaltyCalculator.LPPenaltyCalcType.SIMPLE;
    private Boolean mutationFeePayment = Boolean.FALSE;
    private Boolean vacantLandTaxPayment = Boolean.FALSE;
    private BasicProperty basicProperty;
    private String referenceNumber;
    private EgBillType billType;
    private Boolean levyPenalty;
    private Map<Installment, PenaltyAndRebate> instTaxBean = new HashMap<Installment, PenaltyAndRebate>();
    private String collType;
    private String pgType;
    private Map<Installment, EgDemandDetails> installmentWisePenaltyDemandDetail = new TreeMap<Installment, EgDemandDetails>();
    private BigDecimal mutationFee;
    private String mutationApplicationNo;
    private String transanctionReferenceNumber;
    private Boolean isNagarPanchayat;
    private Date receiptDate;
    @Autowired
    private EgDemandDao egDemandDAO;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyDAO propertyDAO;
    @Autowired
    @Qualifier(value="ptDemandDAO")
    private PtDemandDao ptDemandDAO;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PenaltyCalculationService penaltyCalculationService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtil;
    @Autowired
    private FinancialUtil financialUtil;
    @Autowired
    private RebateService rebateService;

    public Boolean getOverrideAccountHeadsAllowed() {
        Boolean retVal = Boolean.FALSE;
        return retVal;
    }

    public Long getUserId() {
        return ApplicationThreadLocals.getUserId();
    }

    public String getConsumerType() {
        return this.getBasicProperty().getProperty().getPropertyDetail().getPropertyTypeMaster().getType();
    }

    public String getBillAddress() {
        return this.getBasicProperty().getAddress().toString();
    }

    public EgDemand getCurrentDemand() {
        BasicProperty bp = null;
        try {
            bp = this.getBasicProperty();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Property does not exist" + e);
        }
        return this.ptDemandDAO.getNonHistoryCurrDmdForProperty(bp.getProperty());
    }

    public Date getBillLastDueDate() {
        return new DateTime().plusMonths(1).toDate();
    }

    public String getBillPayee() {
        String payeeName = "";
        if (this.isMutationFeePayment()) {
            for (PropertyMutation propertyMutation : this.getBasicProperty().getPropertyMutations()) {
                if (propertyMutation.getState().getValue().equals("Closed")) continue;
                payeeName = propertyMutation.getFullTranfereeName();
            }
        } else {
            payeeName = this.getBasicProperty().getPrimaryOwner().getName();
        }
        return payeeName;
    }

    public String getBoundaryType() {
        return "Ward";
    }

    public Long getBoundaryNum() {
        return this.getBasicProperty().getBoundary().getBoundaryNum();
    }

    public Module getModule() {
        return this.moduleDao.getModuleByName("Property Tax");
    }

    public String getCollModesNotAllowed() {
        String modesNotAllowed = "";
        BigDecimal chqBouncepenalty = BigDecimal.ZERO;
        EgDemand currDemand = this.getCurrentDemand();
        if (currDemand != null && currDemand.getMinAmtPayable() != null && currDemand.getMinAmtPayable().compareTo(BigDecimal.ZERO) > 0) {
            chqBouncepenalty = this.getCurrentDemand().getMinAmtPayable();
        }
        if (this.getUserId() != null && !this.getUserId().equals("")) {
            if (SecurityUtils.userAnonymouslyAuthenticated()) {
                modesNotAllowed = "cash,cheque";
            } else if (chqBouncepenalty.compareTo(BigDecimal.ZERO) > 0) {
                modesNotAllowed = "cheque";
            }
        }
        return modesNotAllowed;
    }

    public String getDepartmentCode() {
        return STRING_DEPARTMENT_CODE;
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public String getServiceCode() {
        if (this.isMutationFeePayment()) {
            return "PTMF";
        }
        if (this.isVacantLandTaxPayment()) {
            return "VLT";
        }
        return "PT";
    }

    public BigDecimal getTotalAmount() {
        BigDecimal balance = BigDecimal.ZERO;
        if (!this.isMutationFeePayment()) {
            EgDemand currentDemand = this.getCurrentDemand();
            List instVsAmt = this.propertyDAO.getDmdCollAmtInstWise(currentDemand);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = new BigDecimal((Double)ddObject[1]);
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[2]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
                BigDecimal penaltyAmount = this.demandGenericDAO.getBalanceByDmdMasterCode(currentDemand, "PENALTY", this.getModule());
                if (penaltyAmount == null || penaltyAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                balance = balance.add(penaltyAmount);
            }
        } else {
            balance = this.getMutationFee();
        }
        return balance;
    }

    public String getDescription() {
        String description;
        if (!this.isMutationFeePayment()) {
            description = "Property Tax Assessment Number: " + this.getBasicProperty().getUpicNo();
            if (this.getBasicProperty().getProperty().getPropertyDetail().isStructure()) {
                description = "Super Structure-" + description;
            }
        } else {
            description = "Property Tax Assessment Number: " + this.getBasicProperty().getUpicNo() + " (" + this.mutationApplicationNo + ")";
        }
        return description;
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = null;
        List demandIds = this.propertyDAO.getAllDemands(this.getBasicProperty());
        if (demandIds != null && !demandIds.isEmpty()) {
            demands = new ArrayList<EgDemand>();
            Iterator iter = demandIds.iterator();
            while (iter.hasNext()) {
                demands.add(this.egDemandDAO.findById(Long.valueOf(iter.next().toString()), false));
            }
        }
        return demands;
    }

    public BigDecimal getFunctionaryCode() {
        return this.financialUtil.getFunctionaryCode();
    }

    public String getFundCode() {
        return this.financialUtil.getFundCode();
    }

    public String getFundSourceCode() {
        return this.financialUtil.getFundSourceCode();
    }

    public Boolean getPartPaymentAllowed() {
        if (this.isMutationFeePayment()) {
            return false;
        }
        return true;
    }

    public String getDisplayMessage() {
        if (this.isMutationFeePayment()) {
            return "Mutation Fee Collection";
        }
        return "Property Tax Collection";
    }

    public Boolean isCallbackForApportion() {
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public String getEmailId() {
        return this.getBasicProperty().getPrimaryOwner().getEmailId();
    }

    public BigDecimal calculatePenalty(Date latestCollReceiptDate, Date fromDate, BigDecimal amount) {
        BigDecimal penalty = BigDecimal.ZERO;
        int noOfMonths = PropertyTaxUtil.getMonthsBetweenDates(fromDate, new Date());
        penalty = amount.multiply(PropertyTaxConstants.PENALTY_PERCENTAGE.multiply(new BigDecimal(noOfMonths))).divide(PropertyTaxConstants.BIGDECIMAL_100);
        return MoneyUtils.roundOff((BigDecimal)penalty);
    }

    public BigDecimal calculateLPPenaltyForPeriod(Date fromDate, Date toDate, BigDecimal amount) {
        return null;
    }

    public LatePayPenaltyCalculator.LPPenaltyCalcType getLPPenaltyCalcType() {
        return this.penaltyCalcType;
    }

    public BigDecimal getLPPPercentage() {
        return new BigDecimal(this.propertyTaxCommonUtil.getAppConfigValue("LATE_PAYPENALTY_PERC", "Property Tax"));
    }

    public void setPenaltyCalcType(LatePayPenaltyCalculator.LPPenaltyCalcType penaltyType) {
        this.penaltyCalcType = penaltyType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public EgBillType getBillType() {
        if (this.billType == null && this.getUserId() != null && !this.getUserId().equals("")) {
            this.billType = SecurityUtils.userAnonymouslyAuthenticated() ? this.egBillDAO.getBillTypeByCode("ONLINE") : this.egBillDAO.getBillTypeByCode("AUTO");
        }
        return this.billType;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public String getConsumerId() {
        if (this.isMutationFeePayment()) {
            return this.mutationApplicationNo;
        }
        return this.getBasicProperty().getUpicNo();
    }

    public Map<Installment, PenaltyAndRebate> getCalculatedPenalty() {
        TreeMap<Installment, PenaltyAndRebate> installmentPenaltyAndRebate = new TreeMap<Installment, PenaltyAndRebate>();
        Ptdemand currentDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(this.basicProperty.getProperty());
        Map<String, Map<Installment, BigDecimal>> installmentDemandAndCollection = this.penaltyCalculationService.getInstallmentDemandAndCollection(this.getBasicProperty(), currentDemand);
        Map<Installment, BigDecimal> instWiseDmdMap = installmentDemandAndCollection.get("DEMAND");
        Map<Installment, BigDecimal> instWiseAmtCollMap = installmentDemandAndCollection.get("COLLECTION");
        boolean thereIsBalance = false;
        Installment installment = null;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal collection = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        if (this.getLevyPenalty().booleanValue()) {
            this.installmentWisePenaltyDemandDetail = this.penaltyCalculationService.getInstallmentWisePenaltyDemandDetails(this.getBasicProperty().getProperty(), currentDemand);
            PenaltyAndRebate penaltyAndRebate = null;
            EgDemandDetails existingPenaltyDemandDetail = null;
            for (Map.Entry<Installment, BigDecimal> mapEntry : instWiseDmdMap.entrySet()) {
                installment = mapEntry.getKey();
                tax = mapEntry.getValue();
                collection = instWiseAmtCollMap.get(installment);
                balance = tax.subtract(collection);
                existingPenaltyDemandDetail = this.installmentWisePenaltyDemandDetail.get(installment);
                thereIsBalance = balance.compareTo(BigDecimal.ZERO) == 1;
                if (!thereIsBalance || existingPenaltyDemandDetail == null) continue;
                penaltyAndRebate = new PenaltyAndRebate();
                penaltyAndRebate.setPenalty(existingPenaltyDemandDetail.getAmount().subtract(existingPenaltyDemandDetail.getAmtCollected()));
                installmentPenaltyAndRebate.put(installment, penaltyAndRebate);
            }
            this.calculateRebate(installmentPenaltyAndRebate, instWiseDmdMap, currentDemand, this.receiptDate);
        }
        return installmentPenaltyAndRebate;
    }

    private void calculateRebate(Map<Installment, PenaltyAndRebate> installmentPenaltyAndRebate, Map<Installment, BigDecimal> instWiseDmdMap, EgDemand currentDemand, Date receiptDate) {
        if (this.isEarlyPayRebateActive(receiptDate != null ? receiptDate : new Date())) {
            BigDecimal rebateAmount = this.propertyTaxUtil.getRebateAmount(currentDemand);
            Map<String, Installment> currInstallments = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
            BigDecimal currentannualtax = this.propertyTaxUtil.getCurrentDemandForRebateCalculation(this.basicProperty);
            if (rebateAmount.compareTo(BigDecimal.ZERO) == 0) {
                if (installmentPenaltyAndRebate.get(currInstallments.get("Current 1st Half")) != null) {
                    installmentPenaltyAndRebate.get(currInstallments.get("Current 1st Half")).setRebate(this.calculateEarlyPayRebate(currentannualtax));
                } else {
                    PenaltyAndRebate currentpenaltyAndRebate = new PenaltyAndRebate();
                    currentpenaltyAndRebate.setRebate(this.calculateEarlyPayRebate(currentannualtax));
                    installmentPenaltyAndRebate.put(currInstallments.get("Current 1st Half"), currentpenaltyAndRebate);
                }
            }
        }
    }

    public BigDecimal calculateEarlyPayRebate(BigDecimal tax) {
        return this.rebateService.calculateEarlyPayRebate(tax, this.receiptDate != null ? this.receiptDate : new Date());
    }

    public boolean isEarlyPayRebateActive(Date date) {
        return this.rebateService.isEarlyPayRebateActive(date);
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public Boolean getLevyPenalty() {
        return this.levyPenalty;
    }

    public void setLevyPenalty(Boolean levyPenalty) {
        this.levyPenalty = levyPenalty;
    }

    public Map<Installment, PenaltyAndRebate> getInstTaxBean() {
        return this.instTaxBean;
    }

    public void setInstTaxBean(Map<Installment, PenaltyAndRebate> instTaxBean) {
        this.instTaxBean = instTaxBean;
    }

    public String getCollectionType() {
        return this.collType;
    }

    public void setCollectionType(String collType) {
        this.collType = collType;
    }

    public String getPaymentGatewayType() {
        return this.pgType;
    }

    public void setPaymentGatewayType(String pgType) {
        this.pgType = pgType;
    }

    public BigDecimal getMutationFee() {
        return this.mutationFee;
    }

    public void setMutationFee(BigDecimal mutationFee) {
        this.mutationFee = mutationFee;
    }

    public boolean isMutationFeePayment() {
        return this.mutationFeePayment;
    }

    public void setMutationFeePayment(boolean mutationFeePayment) {
        this.mutationFeePayment = mutationFeePayment;
    }

    public void setMutationApplicationNo(String mutationApplicationNo) {
        this.mutationApplicationNo = mutationApplicationNo;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }

    public void setPtDemandDAO(PtDemandDao ptDemandDAO) {
        this.ptDemandDAO = ptDemandDAO;
    }

    public void setPenaltyCalculationService(PenaltyCalculationService penaltyCalculationService) {
        this.penaltyCalculationService = penaltyCalculationService;
    }

    public void setRebateService(RebateService rebateService) {
        this.rebateService = rebateService;
    }

    public void setModuleDao(ModuleService moduleDao) {
        this.moduleDao = moduleDao;
    }

    public Boolean getIsNagarPanchayat() {
        return this.isNagarPanchayat;
    }

    public void setIsNagarPanchayat(Boolean isNagarPanchayat) {
        this.isNagarPanchayat = isNagarPanchayat;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public boolean isVacantLandTaxPayment() {
        return this.vacantLandTaxPayment;
    }

    public void setVacantLandTaxPayment(boolean vacantLandTaxPayment) {
        this.vacantLandTaxPayment = vacantLandTaxPayment;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }
}

