/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.util.ArrayList;
import java.util.List;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.OwnerAudit;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.repository.OwnerAuditRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OwnerAuditService {
    @Autowired
    private OwnerAuditRepository ownerAuditRepository;

    public List<OwnerAudit> setOwnerAuditDetails(BasicProperty basicProperty) {
        ArrayList<OwnerAudit> ownerAuditList = new ArrayList<OwnerAudit>();
        for (PropertyOwnerInfo ownerInfo : basicProperty.getPropertyOwnerInfo()) {
            OwnerAudit ownerAudit = new OwnerAudit();
            ownerAudit.setBasicproperty(basicProperty.getId());
            if (ownerInfo != null) {
                ownerAudit.setDoorNo(basicProperty.getAddress().getHouseNoBldgApt());
                ownerAudit.setUserId(ownerInfo.getOwner().getId());
                ownerAudit.setAadhaarNo(ownerInfo.getOwner().getAadhaarNumber());
                ownerAudit.setMobileNo(ownerInfo.getOwner().getMobileNumber());
                ownerAudit.setOwnerName(ownerInfo.getOwner().getName());
                ownerAudit.setGender(ownerInfo.getOwner().getGender().name());
                ownerAudit.setEmailId(ownerInfo.getOwner().getEmailId());
                ownerAudit.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                ownerAudit.setGuardianName(ownerInfo.getOwner().getGuardian());
            }
            ownerAuditList.add(ownerAudit);
        }
        return ownerAuditList;
    }

    @Transactional
    public void saveOwnerDetails(List<OwnerAudit> ownerAudit) {
        for (OwnerAudit owner : ownerAudit) {
            this.ownerAuditRepository.save((Object)owner);
        }
    }
}

