/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.models.BaseModel;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.Amalgamation;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDocs;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyReference;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.recovery.Recovery;
import org.egov.ptis.notice.PtNotice;

public class BasicPropertyImpl
extends BaseModel
implements BasicProperty {
    private static final long serialVersionUID = 7842150965429140561L;
    private Boolean active;
    private String upicNo;
    private PropertyID propertyID;
    private PropertyAddress address;
    private Boundary boundary;
    private String oldMuncipalNum;
    private Set<PropertyStatusValues> propertyStatusValuesSet = new HashSet<PropertyStatusValues>();
    private Set<PropertyMutation> propertyMutations = new HashSet<PropertyMutation>();
    private PropertyMutationMaster propertyMutationMaster;
    private Date propOccupationDate;
    private Set<Property> propertySet = new HashSet<Property>();
    private PropertyStatus status;
    private String extraField1;
    private String extraField2;
    private String extraField3;
    private String gisReferenceNo;
    private String partNo;
    private Set<PtNotice> notices = new HashSet<PtNotice>();
    private Set<RevisionPetition> objections = new HashSet<RevisionPetition>();
    private Set<Recovery> recoveries = new HashSet<Recovery>();
    private Character source = Character.valueOf('A');
    private Set<PropertyDocs> propertyDocsSet = new HashSet<PropertyDocs>();
    private Boolean allChangesCompleted;
    private Character isBillCreated;
    private String billCrtError;
    private Character isTaxXMLMigrated = Character.valueOf('N');
    private boolean isDemandActive = false;
    private PropertyImpl activeProperty;
    private PropertyImpl inactiveProperty;
    private String regdDocNo;
    private Date regdDocDate;
    private String vacantLandAssmtNo;
    private List<PropertyOwnerInfo> propertyOwnerInfo = new ArrayList<PropertyOwnerInfo>();
    private List<PropertyOwnerInfo> propertyOwnerInfoProxy = new ArrayList<PropertyOwnerInfo>();
    private boolean underWorkflow;
    private Date assessmentdate;
    private List<VacancyRemission> vacancyRemissions = new ArrayList<VacancyRemission>();
    private Double longitude;
    private Double latitude;
    private boolean eligible;
    private List<Amalgamation> amalgamations = new ArrayList<Amalgamation>();
    private List<Amalgamation> amalgamationsProxy = new ArrayList<Amalgamation>();
    private Character isIntgBillCreated = Character.valueOf('N');

    @Override
    public List<PropertyOwnerInfo> getPropertyOwnerInfo() {
        return this.propertyOwnerInfo;
    }

    @Override
    public void setPropertyOwnerInfo(List<PropertyOwnerInfo> propertyOwnerSet) {
        this.propertyOwnerInfo = propertyOwnerSet;
    }

    @Override
    public Set<PropertyDocs> getPropertyDocsSet() {
        return this.propertyDocsSet;
    }

    @Override
    public void addPropertyOwners(PropertyOwnerInfo ownerInfo) {
        this.getPropertyOwnerInfo().add(ownerInfo);
    }

    @Override
    public void removePropertyOwners(PropertyOwnerInfo ownerInfo) {
        this.getPropertyOwnerInfo().remove((Object)ownerInfo);
    }

    @Override
    public void setPropertyDocsSet(Set<PropertyDocs> propertyDocsSet) {
        this.propertyDocsSet = propertyDocsSet;
    }

    @Override
    public void addDocs(PropertyDocs propertyDocs) {
        this.getPropertyDocsSet().add(propertyDocs);
    }

    @Override
    public void removeDocs(PropertyDocs propertyDocs) {
        this.getPropertyDocsSet().remove(propertyDocs);
    }

    @Override
    public PropertyID getPropertyID() {
        return this.propertyID;
    }

    @Override
    public void setPropertyID(PropertyID propertyID) {
        this.propertyID = propertyID;
    }

    @Override
    public Boolean getActive() {
        return this.active;
    }

    @Override
    public Boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Override
    public Property getProperty() {
        Property returnProperty = null;
        for (Property property : this.getPropertySet()) {
            if (!property.getIsDefaultProperty().equals(Character.valueOf('Y')) || !property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE) && !property.getStatus().equals(PropertyTaxConstants.STATUS_ISACTIVE)) continue;
            returnProperty = property;
        }
        return returnProperty;
    }

    @Override
    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public List<ValidationError> validate() {
        return new ArrayList<ValidationError>();
    }

    @Override
    public boolean validateBasicProp() {
        if (this.getAddress() == null) {
            throw new ApplicationRuntimeException("BasicProperty validation failed: Address is not set, Please Check !!");
        }
        if (this.getCreatedBy() == null) {
            throw new ApplicationRuntimeException("BasicProperty validation failed: CreatedBy is not set, Please Check !!");
        }
        if (this.getPropertyID() == null) {
            throw new ApplicationRuntimeException("BasicProperty validation failed: PropertyID is not set, Please Check !!");
        }
        return true;
    }

    @Override
    public String getUpicNo() {
        return this.upicNo;
    }

    @Override
    public void setUpicNo(String upicNo) {
        this.upicNo = upicNo;
    }

    @Override
    public String getOldMuncipalNum() {
        return this.oldMuncipalNum;
    }

    @Override
    public void setOldMuncipalNum(String oldMuncipalNum) {
        this.oldMuncipalNum = oldMuncipalNum;
    }

    @Override
    public void addPropertyStatusValues(PropertyStatusValues propertyStatusValues) {
        this.getPropertyStatusValuesSet().add(propertyStatusValues);
    }

    @Override
    public void removePropertyStatusValues(PropertyStatusValues propertyStatusValues) {
        this.getPropertyStatusValuesSet().remove((Object)propertyStatusValues);
    }

    @Override
    public String getExtraField1() {
        return this.extraField1;
    }

    @Override
    public void setExtraField1(String extraField1) {
        this.extraField1 = extraField1;
    }

    @Override
    public String getExtraField2() {
        return this.extraField2;
    }

    @Override
    public void setExtraField2(String extraField2) {
        this.extraField2 = extraField2;
    }

    @Override
    public void setPropertyReference(PropertyReference propertyReference) {
    }

    @Override
    public Set<PropertyMutation> getPropertyMutations() {
        return this.propertyMutations;
    }

    @Override
    public void setPropertyMutations(Set<PropertyMutation> propertyMutations) {
        this.propertyMutations = propertyMutations;
    }

    @Override
    public PropertyMutationMaster getPropertyMutationMaster() {
        return this.propertyMutationMaster;
    }

    @Override
    public void setPropertyMutationMaster(PropertyMutationMaster propertyMutationMaster) {
        this.propertyMutationMaster = propertyMutationMaster;
    }

    @Override
    public String getExtraField3() {
        return this.extraField3;
    }

    @Override
    public void setExtraField3(String extraField3) {
        this.extraField3 = extraField3;
    }

    @Override
    public Set<PropertyStatusValues> getPropertyStatusValuesSet() {
        return this.propertyStatusValuesSet;
    }

    @Override
    public void setPropertyStatusValuesSet(Set<PropertyStatusValues> propertyStatusValuesSet) {
        this.propertyStatusValuesSet = propertyStatusValuesSet;
    }

    @Override
    public Set<Property> getPropertySet() {
        return this.propertySet;
    }

    @Override
    public void setPropertySet(Set<Property> propertySet) {
        this.propertySet = propertySet;
    }

    @Override
    public void addProperty(Property property) {
        this.getPropertySet().add(property);
    }

    @Override
    public void removeProperty(Property property) {
        this.getPropertySet().remove(property);
    }

    @Override
    public PropertyStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(PropertyStatus status) {
        this.status = status;
    }

    @Override
    public String getGisReferenceNo() {
        return this.gisReferenceNo;
    }

    @Override
    public void setGisReferenceNo(String gisReferenceNo) {
        this.gisReferenceNo = gisReferenceNo;
    }

    @Override
    public Set<PtNotice> getNotices() {
        return this.notices;
    }

    @Override
    public void setNotices(Set<PtNotice> notices) {
        this.notices = notices;
    }

    @Override
    public void addNotice(PtNotice ptNotice) {
        this.getNotices().add(ptNotice);
    }

    @Override
    public void removeNotice(PtNotice ptNotice) {
        this.getNotices().remove(ptNotice);
    }

    @Override
    public Set<RevisionPetition> getObjections() {
        return this.objections;
    }

    @Override
    public void setObjections(Set<RevisionPetition> objections) {
        this.objections = objections;
    }

    @Override
    public void addObjection(RevisionPetition objection) {
        this.getObjections().add(objection);
    }

    @Override
    public void removeObjection(RevisionPetition objection) {
        this.getObjections().remove((Object)objection);
    }

    @Override
    public Set<Recovery> getRecoveries() {
        return this.recoveries;
    }

    @Override
    public void setRecoveries(Set<Recovery> recoveries) {
        this.recoveries = recoveries;
    }

    @Override
    public void addRecoveries(Recovery recovery) {
        this.getRecoveries().add(recovery);
    }

    @Override
    public void removeRecoveries(Recovery recovery) {
        this.getRecoveries().remove((Object)recovery);
    }

    @Override
    public Map<String, String> getPropertyWfStatus() {
        Property property;
        Map<String, String> wfMap = new HashMap<String, String>();
        Boolean isPropInWf = Boolean.FALSE;
        String wfOwner = "";
        PropertyImpl wfProperty = null;
        Iterator<Property> iterator = this.getPropertySet().iterator();
        while (!(!iterator.hasNext() || (wfProperty = (PropertyImpl)(property = iterator.next())).hasState() && wfProperty.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW))) {
            wfProperty = null;
        }
        if (wfProperty != null) {
            isPropInWf = Boolean.TRUE;
            wfOwner = wfProperty.getState() != null ? wfProperty.getState().getOwnerPosition().getName() : "";
        }
        wfMap.put("WFSTATUS", isPropInWf.toString());
        wfMap.put("WFOWNER", wfOwner);
        if (((String)wfMap.get("WFSTATUS")).equalsIgnoreCase(Boolean.FALSE.toString())) {
            wfMap = this.propertyInObjectionWf();
        }
        if (((String)wfMap.get("WFSTATUS")).equalsIgnoreCase(Boolean.FALSE.toString())) {
            wfMap = this.propertyInRecoverynWf();
        }
        return wfMap;
    }

    private Map<String, String> propertyInObjectionWf() {
        RevisionPetition objection;
        HashMap<String, String> wfMap = new HashMap<String, String>();
        RevisionPetition wfObjection = null;
        Iterator<RevisionPetition> iterator = this.getObjections().iterator();
        while (iterator.hasNext() && (!(wfObjection = (objection = iterator.next())).hasState() || wfObjection.transitionCompleted())) {
            wfObjection = null;
        }
        if (wfObjection != null) {
            wfMap.put("WFSTATUS", Boolean.TRUE.toString());
            wfMap.put("WFOWNER", wfObjection.getState().getOwnerUser().getName());
        } else {
            wfMap.put("WFSTATUS", Boolean.FALSE.toString());
            wfMap.put("WFOWNER", "");
        }
        return wfMap;
    }

    private Map<String, String> propertyInRecoverynWf() {
        Boolean isPropInWf = Boolean.FALSE;
        String wfOwner = "";
        HashMap<String, String> wfMap = new HashMap<String, String>();
        for (Recovery recovery : this.getRecoveries()) {
            if (recovery.transitionCompleted()) continue;
            isPropInWf = Boolean.TRUE;
            wfOwner = recovery.getState().getOwnerUser().getName();
            break;
        }
        wfMap.put("WFSTATUS", isPropInWf.toString());
        wfMap.put("WFOWNER", wfOwner);
        return wfMap;
    }

    @Override
    public Property getWFProperty() {
        Property returnProperty = null;
        for (Property property : this.getPropertySet()) {
            if (!property.getStatus().equals(Character.valueOf('W')) || !property.getIsDefaultProperty().equals(Character.valueOf('Y'))) continue;
            returnProperty = property;
            break;
        }
        return returnProperty;
    }

    @Override
    public String getPartNo() {
        return this.partNo;
    }

    @Override
    public void setPartNo(String partNo) {
        this.partNo = partNo;
    }

    @Override
    public Boolean getAllChangesCompleted() {
        return this.allChangesCompleted;
    }

    @Override
    public void setAllChangesCompleted(Boolean allChangesCompleted) {
        this.allChangesCompleted = allChangesCompleted;
    }

    @Override
    public Character getIsBillCreated() {
        return this.isBillCreated;
    }

    @Override
    public void setIsBillCreated(Character isBillCreated) {
        this.isBillCreated = isBillCreated;
    }

    @Override
    public String getBillCrtError() {
        return this.billCrtError;
    }

    @Override
    public void setBillCrtError(String billCrtError) {
        this.billCrtError = billCrtError;
    }

    @Override
    public Character getIsTaxXMLMigrated() {
        return this.isTaxXMLMigrated;
    }

    @Override
    public void setIsTaxXMLMigrated(Character isTaxXMLMigrated) {
        this.isTaxXMLMigrated = isTaxXMLMigrated;
    }

    @Override
    public boolean getIsDemandActive() {
        return this.isDemandActive;
    }

    @Override
    public void setIsDemandActive(boolean isDemandActive) {
        this.isDemandActive = isDemandActive;
    }

    @Override
    public PropertyImpl getActiveProperty() {
        return this.activeProperty;
    }

    @Override
    public PropertyImpl getInactiveProperty() {
        return this.inactiveProperty;
    }

    @Override
    public void setActiveProperty(PropertyImpl activeProperty) {
        this.activeProperty = activeProperty;
    }

    @Override
    public void setInactiveProperty(PropertyImpl inactiveProperty) {
        this.inactiveProperty = inactiveProperty;
    }

    @Override
    public String getVacantLandAssmtNo() {
        return this.vacantLandAssmtNo;
    }

    @Override
    public void setVacantLandAssmtNo(String vacantLandAssmtNo) {
        this.vacantLandAssmtNo = vacantLandAssmtNo;
    }

    @Override
    public String getRegdDocNo() {
        return this.regdDocNo;
    }

    @Override
    public void setRegdDocNo(String regdDocNo) {
        this.regdDocNo = regdDocNo;
    }

    @Override
    public Date getRegdDocDate() {
        return this.regdDocDate;
    }

    @Override
    public void setRegdDocDate(Date regdDocDate) {
        this.regdDocDate = regdDocDate;
    }

    @Override
    public PropertyAddress getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(PropertyAddress address) {
        this.address = address;
    }

    @Override
    public Date getPropOccupationDate() {
        return this.propOccupationDate;
    }

    @Override
    public void setPropOccupationDate(Date propOccupationDate) {
        this.propOccupationDate = propOccupationDate;
    }

    @Override
    public boolean isUnderWorkflow() {
        return this.underWorkflow;
    }

    @Override
    public void setUnderWorkflow(boolean underWorkflow) {
        this.underWorkflow = underWorkflow;
    }

    @Override
    public String getFullOwnerName() {
        StringBuilder ownerName = new StringBuilder();
        for (PropertyOwnerInfo ownerInfo : this.getPropertyOwnerInfo()) {
            ownerName.append(ownerInfo.getOwner().getName()).append(", ");
        }
        if (ownerName.length() > 2) {
            ownerName.deleteCharAt(ownerName.length() - 2);
        }
        return ownerName.toString();
    }

    @Override
    public User getPrimaryOwner() {
        User user;
        block0: {
            user = new User();
            Iterator<PropertyOwnerInfo> iterator = this.getPropertyOwnerInfo().iterator();
            if (!iterator.hasNext()) break block0;
            PropertyOwnerInfo ownerInfo = iterator.next();
            user = ownerInfo.getOwner();
        }
        return user;
    }

    @Override
    public String getMobileNumber() {
        return this.getPropertyOwnerInfo().get(0).getOwner().getMobileNumber();
    }

    @Override
    public String getAadharNumber() {
        return this.getPropertyOwnerInfo().get(0).getOwner().getAadhaarNumber();
    }

    @Override
    public Map<String, String> getOwnerMap() {
        HashMap<String, String> ownerMap = new HashMap<String, String>();
        StringBuilder ownerName = new StringBuilder();
        StringBuilder mobileNo = new StringBuilder();
        StringBuilder aadharNo = new StringBuilder();
        User owner = null;
        for (PropertyOwnerInfo ownerInfo : this.getPropertyOwnerInfo()) {
            owner = ownerInfo.getOwner();
            ownerName.append(owner.getName()).append(", ");
            if (owner.getMobileNumber() != null && owner.getMobileNumber().trim().length() > 0) {
                mobileNo.append(owner.getMobileNumber()).append(", ");
            }
            if (owner.getAadhaarNumber() == null || owner.getAadhaarNumber().trim().length() <= 0) continue;
            aadharNo.append(owner.getAadhaarNumber()).append(", ");
        }
        if (ownerName.length() > 2) {
            ownerName.deleteCharAt(ownerName.length() - 2);
        }
        if (mobileNo.length() > 2) {
            mobileNo.deleteCharAt(mobileNo.length() - 2);
        }
        if (aadharNo.length() > 2) {
            aadharNo.deleteCharAt(aadharNo.length() - 2);
        }
        ownerMap.put("OWNERNAME", ownerName.toString());
        ownerMap.put("MOBILENO", mobileNo.toString());
        ownerMap.put("AADHARNO", aadharNo.toString());
        return ownerMap;
    }

    @Override
    public List<PropertyOwnerInfo> getPropertyOwnerInfoProxy() {
        return this.propertyOwnerInfoProxy;
    }

    @Override
    public void setPropertyOwnerInfoProxy(List<PropertyOwnerInfo> propertyOwnerInfoProxy) {
        this.propertyOwnerInfoProxy = propertyOwnerInfoProxy;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.upicNo == null ? 0 : this.upicNo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicPropertyImpl other = (BasicPropertyImpl)obj;
        return !(this.upicNo == null ? other.upicNo != null : !this.upicNo.equals(other.upicNo));
    }

    @Override
    public Character getSource() {
        return this.source;
    }

    @Override
    public void setSource(Character source) {
        this.source = source;
    }

    @Override
    public Date getAssessmentdate() {
        return this.assessmentdate;
    }

    @Override
    public void setAssessmentdate(Date assessmentdate) {
        this.assessmentdate = assessmentdate;
    }

    @Override
    public List<VacancyRemission> getVacancyRemissions() {
        return this.vacancyRemissions;
    }

    @Override
    public void setVacancyRemissions(List<VacancyRemission> vacancyRemissions) {
        this.vacancyRemissions = vacancyRemissions;
    }

    @Override
    public Property getPropertyForBasicProperty() {
        if (null != this.getProperty()) {
            return this.getProperty();
        }
        return this.getActiveProperty();
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public boolean isEligible() {
        return this.eligible;
    }

    @Override
    public void setEligible(boolean eligible) {
        this.eligible = eligible;
    }

    @Override
    public List<Amalgamation> getAmalgamations() {
        return this.amalgamations;
    }

    @Override
    public void setAmalgamations(List<Amalgamation> amalgamations) {
        this.amalgamations = amalgamations;
    }

    @Override
    public List<Amalgamation> getAmalgamationsProxy() {
        return this.amalgamationsProxy;
    }

    @Override
    public void setAmalgamationsProxy(List<Amalgamation> amalgamationsProxy) {
        this.amalgamationsProxy = amalgamationsProxy;
    }

    @Override
    public void addAmalgamations(Amalgamation amalgamation) {
        this.getAmalgamations().add(amalgamation);
    }

    @Override
    public Character getIsIntgBillCreated() {
        return this.isIntgBillCreated;
    }

    @Override
    public void setIsIntgBillCreated(Character isIntgBillCreated) {
        this.isIntgBillCreated = isIntgBillCreated;
    }
}

