/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.dao.property.TaxPercentageforDatesDAO;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="taxPercentageforDatesDAO")
@Transactional(readOnly=true)
public class TaxPercentageforDatesHibernateDAO
implements TaxPercentageforDatesDAO {
    private static final Logger LOGGER = Logger.getLogger(TaxPercentageforDatesHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public List getTaxPercentageforDates(Integer type, BigDecimal amount, Date installmentStartDate, Date installmentEndDate) {
        try {
            List results = this.getCurrentSession().createSQLQuery("select * from EGPT_TAXRATES er where  er.TO_DATE BETWEEN to_date(?) and to_date(?) and er.FROM_AMOUNT<? and type = ?").setParameter(0, (Object)installmentStartDate.getTime()).setParameter(1, (Object)installmentEndDate.getTime()).setParameter(2, (Object)amount).setParameter(3, (Object)type).list();
            LOGGER.info((Object)("size of the retList array is " + results.size()));
            return results;
        }
        catch (HibernateException e) {
            LOGGER.info((Object)("Exception in  getTaxPercentageforDates--- TaxPercentageforDatesHibernateDao--" + e.getMessage()));
            throw new ApplicationRuntimeException("Hibernate Exception : " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.info((Object)("Exception in  getTaxPercentageforDates--- TaxPercentageforDatesHibernateDao--" + e1.getMessage()));
            throw new ApplicationRuntimeException("Exception : " + e1.getMessage(), (Throwable)e1);
        }
    }
}

