/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.ptis.domain.dao.property.TaxPercDAO;
import org.egov.ptis.domain.entity.property.Category;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.TaxPerc;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="taxPercDAO")
@Transactional(readOnly=true)
public class TaxPercHibernateDAO
implements TaxPercDAO {
    private static final Logger LOGGER = Logger.getLogger(TaxPercHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public TaxPerc getTaxPerc(Category category, PropertyUsage propertyUsage, BigDecimal amount, Date date) {
        LOGGER.info((Object)"getTaxPerc invoked");
        TaxPerc taxPerc = null;
        Criteria crit = this.getCurrentSession().createCriteria(TaxPerc.class);
        if (category != null) {
            crit.add((Criterion)Restrictions.eq((String)"category", (Object)((Object)category)));
        }
        if (propertyUsage != null) {
            crit.add((Criterion)Restrictions.eq((String)"propertyUsage", (Object)((Object)propertyUsage)));
        }
        if (amount != null) {
            crit.add((Criterion)Restrictions.le((String)"fromAmt", (Object)amount));
            crit.add((Criterion)Restrictions.ge((String)"toAmt", (Object)amount));
        }
        if (date != null) {
            crit.add((Criterion)Restrictions.lt((String)"fromDate", (Object)date));
            crit.add((Criterion)Restrictions.gt((String)"toDate", (Object)date));
        }
        if (crit.list().size() == 1) {
            taxPerc = (TaxPerc)crit.uniqueResult();
        }
        return taxPerc;
    }

    @Override
    public Float getTaxPerc(Integer usageId) {
        LOGGER.info((Object)"getTaxPerc for a given usageId invoked");
        Query qry = this.getCurrentSession().createQuery("select P.tax_perc from TaxPerc P where P.propertyUsage.idUsage = :usageId");
        qry.setInteger("usageId", usageId.intValue());
        return (Float)qry.uniqueResult();
    }

    @Override
    public TaxPerc findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<TaxPerc> findAll() {
        return null;
    }

    @Override
    public TaxPerc create(TaxPerc taxPerc) {
        return null;
    }

    @Override
    public void delete(TaxPerc taxPerc) {
    }

    @Override
    public TaxPerc update(TaxPerc taxPerc) {
        return null;
    }
}

