/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service.calculator;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.handler.TaxCalculationInfoXmlHandler;
import org.egov.ptis.client.model.calculator.APMiscellaneousTax;
import org.egov.ptis.client.model.calculator.APTaxCalculationInfo;
import org.egov.ptis.client.model.calculator.APUnitTaxCalculationInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BoundaryCategory;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.domain.service.calculator.PropertyTaxCalculator;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class APTaxCalculator
implements PropertyTaxCalculator {
    private static final Logger LOGGER = Logger.getLogger(APTaxCalculator.class);
    private static final BigDecimal RESD_OWNER_DEPRECIATION = new BigDecimal(40);
    private static final BigDecimal SEASHORE_ADDITIONAL_DEPRECIATION = new BigDecimal(5);
    private static final String CORP_UAC_PENALTY_CASE1_STARTDATE = "01/03/1994";
    private static final String CORP_UAC_PENALTY_CASE1_ENDDATE = "14/12/2007";
    private static final String CORP_UAC_PENALTY_CASE2_STARTDATE = "15/12/2007";
    private static final String CORP_UAC_PENALTY_CASE2_ENDDATE = "04/08/2013";
    private static final String NONCORP_UAC_PENALTY_CASE1_STARTDATE = "09/03/1999";
    private static final String NONCORP_UAC_PENALTY_CASE1_ENDDATE = "04/08/2013";
    private static final BigDecimal BUILDING_VALUE = new BigDecimal(2).divide(new BigDecimal(3), 5, 4);
    private static final BigDecimal SITE_VALUE = new BigDecimal(1).divide(new BigDecimal(3), 5, 4);
    private Boolean isCorporation = Boolean.FALSE;
    private Boolean isSeaShoreULB = Boolean.FALSE;
    private Boolean isPrimaryServiceChrApplicable = Boolean.FALSE;
    private final HashMap<Installment, TaxCalculationInfo> taxCalculationMap = new HashMap();
    private Properties taxRateProps = null;
    private String unAuthPenaltyStartDate;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private CityService cityService;

    @Override
    public HashMap<Installment, TaxCalculationInfo> calculatePropertyTax(Property property, Date occupationDate) throws TaxCalculatorExeption {
        this.taxRateProps = this.propertyTaxUtil.loadTaxRates();
        this.isCorporation = "Corp".equalsIgnoreCase(this.cityService.getCityGrade());
        this.isSeaShoreULB = this.propertyTaxUtil.isSeaShoreULB();
        if (this.isCorporation.booleanValue()) {
            this.isPrimaryServiceChrApplicable = this.propertyTaxUtil.isPrimaryServiceApplicable();
            this.unAuthPenaltyStartDate = "28/02/1994";
        } else {
            this.unAuthPenaltyStartDate = "08/03/1999";
        }
        List<String> applicableTaxes = this.prepareApplicableTaxes(property);
        List<Installment> taxInstallments = this.propertyTaxUtil.getInstallmentsListByEffectiveDate(occupationDate);
        Boundary propertyZone = property.getBasicProperty().getPropertyID().getZone();
        for (Installment installment : taxInstallments) {
            BigDecimal totalTaxPayable = BigDecimal.ZERO;
            BigDecimal totalNetArv = BigDecimal.ZERO;
            APTaxCalculationInfo taxCalculationInfo = this.addPropertyInfo(property);
            if (!this.betweenOrBefore(occupationDate, installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
            if (property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
                APUnitTaxCalculationInfo unitTaxCalculationInfo = this.calculateVacantLandTax(property, occupationDate, applicableTaxes, installment);
                totalNetArv = totalNetArv.add(unitTaxCalculationInfo.getNetARV());
                taxCalculationInfo.addUnitTaxCalculationInfo(unitTaxCalculationInfo);
                totalTaxPayable = totalTaxPayable.add(unitTaxCalculationInfo.getTotalTaxPayable());
            }
            for (Floor floorIF : property.getPropertyDetail().getFloorDetails()) {
                if (!this.betweenOrBefore(floorIF.getOccupancyDate(), installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
                BoundaryCategory boundaryCategory = this.getBoundaryCategory(propertyZone, installment, floorIF.getPropertyUsage().getId(), occupationDate, floorIF.getStructureClassification().getId());
                APUnitTaxCalculationInfo unitTaxCalculationInfo = this.calculateNonVacantTax(property, floorIF, boundaryCategory, applicableTaxes, installment);
                totalNetArv = totalNetArv.add(unitTaxCalculationInfo.getNetARV());
                totalTaxPayable = totalTaxPayable.add(unitTaxCalculationInfo.getTotalTaxPayable());
                taxCalculationInfo.addUnitTaxCalculationInfo(unitTaxCalculationInfo);
            }
            taxCalculationInfo.setTotalNetARV(totalNetArv);
            taxCalculationInfo.setTotalTaxPayable(totalTaxPayable);
            taxCalculationInfo.setTaxCalculationInfoXML(this.generateTaxCalculationXML(taxCalculationInfo));
            this.taxCalculationMap.put(installment, taxCalculationInfo);
        }
        return this.taxCalculationMap;
    }

    private APUnitTaxCalculationInfo calculateNonVacantTax(Property property, Floor floor, BoundaryCategory boundaryCategory, List<String> applicableTaxes, Installment installment) {
        APUnitTaxCalculationInfo unitTaxCalculationInfo = new APUnitTaxCalculationInfo();
        BigDecimal builtUpArea = BigDecimal.valueOf(floor.getBuiltUpArea().getArea().floatValue());
        BigDecimal floorMrv = this.calculateFloorMrv(builtUpArea, boundaryCategory);
        BigDecimal floorBuildingValue = this.calculateFloorBuildingValue(floorMrv);
        BigDecimal floorSiteValue = this.calculateFloorSiteValue(floorMrv);
        BigDecimal floorGrossArv = floorBuildingValue.multiply(new BigDecimal(12));
        BigDecimal floorDepreciation = this.calculateFloorDepreciation(floorGrossArv, floor);
        BigDecimal floorNetArv = floorSiteValue.multiply(new BigDecimal(12)).add(floorGrossArv.subtract(floorDepreciation));
        unitTaxCalculationInfo.setFloorNumber(PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()));
        unitTaxCalculationInfo.setFloorArea(builtUpArea);
        unitTaxCalculationInfo.setBaseRateEffectiveDate(boundaryCategory.getFromDate());
        unitTaxCalculationInfo.setBaseRate(BigDecimal.valueOf(boundaryCategory.getCategory().getCategoryAmount()));
        unitTaxCalculationInfo.setMrv(floorMrv);
        unitTaxCalculationInfo.setBuildingValue(floorBuildingValue);
        unitTaxCalculationInfo.setSiteValue(floorSiteValue);
        unitTaxCalculationInfo.setGrossARV(floorGrossArv);
        unitTaxCalculationInfo.setDepreciation(floorDepreciation);
        unitTaxCalculationInfo.setUnitUsage(floor.getPropertyUsage().getUsageCode());
        unitTaxCalculationInfo.setUnitOccupation(floor.getPropertyOccupation().getOccupancyCode());
        unitTaxCalculationInfo.setUnitStructure(floor.getStructureClassification().getConstrTypeCode());
        unitTaxCalculationInfo.setNetARV(floorNetArv.setScale(0, 4));
        BigDecimal unAuthDeviationPerc = this.getUnAuthDeviationPerc(floor);
        this.calculateApplicableTaxes(applicableTaxes, unitTaxCalculationInfo, installment, property.getPropertyDetail().getPropertyTypeMaster().getCode(), floor, unAuthDeviationPerc);
        return unitTaxCalculationInfo;
    }

    private APTaxCalculationInfo addPropertyInfo(Property property) {
        APTaxCalculationInfo taxCalculationInfo = new APTaxCalculationInfo();
        PropertyID propertyId = property.getBasicProperty().getPropertyID();
        taxCalculationInfo.setPropertyOwnerName(property.getBasicProperty().getFullOwnerName());
        taxCalculationInfo.setPropertyAddress(property.getBasicProperty().getAddress().toString());
        taxCalculationInfo.setHouseNumber(property.getBasicProperty().getAddress().getHouseNoBldgApt());
        taxCalculationInfo.setZone(propertyId.getZone().getName());
        taxCalculationInfo.setWard(propertyId.getWard().getName());
        taxCalculationInfo.setBlock(propertyId.getArea() != null ? propertyId.getArea().getName() : "");
        taxCalculationInfo.setLocality(property.getBasicProperty().getPropertyID().getLocality().getName());
        if (property.getPropertyDetail().getSitalArea().getArea() != null) {
            taxCalculationInfo.setPropertyArea(new BigDecimal(property.getPropertyDetail().getSitalArea().getArea().toString()));
        }
        taxCalculationInfo.setPropertyType(property.getPropertyDetail().getPropertyTypeMaster().getType());
        taxCalculationInfo.setPropertyId(property.getBasicProperty().getUpicNo());
        return taxCalculationInfo;
    }

    public APUnitTaxCalculationInfo calculateApplicableTaxes(List<String> applicableTaxes, APUnitTaxCalculationInfo unitTaxCalculationInfo, Installment installment, String propTypeCode, Floor floor, BigDecimal unAuthDeviationPerc) {
        BigDecimal halfYearHeadTax;
        BigDecimal totalHalfTaxPayable = BigDecimal.ZERO;
        BigDecimal alv = unitTaxCalculationInfo.getNetARV();
        BigDecimal generalTax = BigDecimal.ZERO;
        BigDecimal educationTax = BigDecimal.ZERO;
        LOGGER.debug((Object)("calculateApplicableTaxes - ALV: " + alv));
        LOGGER.debug((Object)("calculateApplicableTaxes - applicableTaxes: " + applicableTaxes));
        for (String applicableTax : applicableTaxes) {
            halfYearHeadTax = BigDecimal.ZERO;
            if (applicableTax.equals("GEN_TAX") || applicableTax.equals("VAC_LAND_TAX")) {
                BigDecimal taxRatePerc;
                if (applicableTax.equals("VAC_LAND_TAX")) {
                    taxRatePerc = this.getTaxRate("VAC_LAND_TAX");
                    halfYearHeadTax = this.getHalfYearTax(alv.multiply(taxRatePerc.divide(new BigDecimal("100"))).setScale(2, 4));
                } else {
                    taxRatePerc = floor != null && floor.getPropertyUsage().getIsResidential() != false ? this.getTaxRate("GEN_TAX_RESD") : this.getTaxRate("GEN_TAX_NR");
                    halfYearHeadTax = alv.multiply(taxRatePerc.divide(new BigDecimal("100"))).setScale(2, 4);
                }
                generalTax = halfYearHeadTax = this.taxIfGovtProperty(propTypeCode, halfYearHeadTax);
            }
            if (applicableTax.equals("EDU_CESS")) {
                halfYearHeadTax = educationTax = alv.multiply(this.getTaxRate("EDU_CESS").divide(new BigDecimal("100"))).setScale(2, 4);
            }
            if (applicableTax.equals("LIB_CESS")) {
                halfYearHeadTax = generalTax.add(educationTax).multiply(this.getTaxRate("LIB_CESS").divide(new BigDecimal("100"))).setScale(2, 4);
            }
            if (halfYearHeadTax.compareTo(BigDecimal.ZERO) <= 0) continue;
            totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
            this.createMiscTax(applicableTax, halfYearHeadTax, unitTaxCalculationInfo);
        }
        if (!propTypeCode.equalsIgnoreCase("VAC_LAND")) {
            try {
                if (floor != null && floor.getConstructionDate().after(new SimpleDateFormat("dd/MM/yyyy").parse(this.unAuthPenaltyStartDate)) && !this.checkUnAuthDeviationPerc(unAuthDeviationPerc).booleanValue() && (unAuthDeviationPerc == null || unAuthDeviationPerc.intValue() != 0)) {
                    halfYearHeadTax = this.calculateUnAuthPenalty(unAuthDeviationPerc, totalHalfTaxPayable, floor.getConstructionDate());
                    totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
                    this.createMiscTax("UNAUTH_PENALTY", halfYearHeadTax, unitTaxCalculationInfo);
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)e);
            }
        }
        if (this.isPrimaryServiceChrApplicable.booleanValue()) {
            halfYearHeadTax = this.roundOffToNearestEven(this.calcPublicServiceCharges(totalHalfTaxPayable));
            totalHalfTaxPayable = totalHalfTaxPayable.add(halfYearHeadTax);
            this.createMiscTax("PRIMARY_SER_CHRG", halfYearHeadTax, unitTaxCalculationInfo);
        }
        unitTaxCalculationInfo.setTotalTaxPayable(totalHalfTaxPayable);
        return unitTaxCalculationInfo;
    }

    private Boolean checkUnAuthDeviationPerc(BigDecimal unAuthDeviationPerc) {
        return unAuthDeviationPerc == null || "0".equals(unAuthDeviationPerc.toString()) || "-1".equals(unAuthDeviationPerc.toString());
    }

    private List<String> prepareApplicableTaxes(Property property) {
        LOGGER.debug((Object)"Entered into prepareApplTaxes");
        LOGGER.debug((Object)("prepareApplTaxes: property: " + property));
        ArrayList<String> applicableTaxes = new ArrayList<String>();
        if (!property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
            applicableTaxes.add("GEN_TAX");
            applicableTaxes.add("UNAUTH_PENALTY");
            applicableTaxes.add("EDU_CESS");
        } else {
            applicableTaxes.add("VAC_LAND_TAX");
        }
        applicableTaxes.add("LIB_CESS");
        if (this.isCorporation.booleanValue()) {
            applicableTaxes.add("SEW_TAX");
        }
        if (this.isPrimaryServiceChrApplicable.booleanValue()) {
            applicableTaxes.add("PRIMARY_SER_CHRG");
        }
        LOGGER.debug((Object)("prepareApplTaxes: applicableTaxes: " + applicableTaxes));
        LOGGER.debug((Object)"Exiting from prepareApplTaxes");
        return applicableTaxes;
    }

    private BoundaryCategory getBoundaryCategory(Boundary zone, Installment installment, Long usageId, Date occupancyDate, Long classification) throws TaxCalculatorExeption {
        List categories = this.persistenceService.findAllByNamedQuery("BASERATE_BY_OCCUPANCY_ZONE", new Object[]{zone.getId(), usageId, classification, occupancyDate, installment.getToDate()});
        LOGGER.debug((Object)("baseRentOfUnit - Installment : " + installment));
        if (categories.isEmpty()) {
            throw new TaxCalculatorExeption("There are no Unit rates defined for chosen combinations, zone : " + zone.getName() + " usageId : " + usageId + " classification : " + classification + " occupancyDate : " + occupancyDate);
        }
        return (BoundaryCategory)((Object)categories.get(0));
    }

    public Map<String, BigDecimal> getMiscTaxesForProp(List<UnitTaxCalculationInfo> unitTaxCalcInfos) {
        HashMap<String, BigDecimal> taxMap = new HashMap<String, BigDecimal>();
        for (UnitTaxCalculationInfo unitTaxCalculationInfo : unitTaxCalcInfos) {
            for (MiscellaneousTax miscTax : unitTaxCalculationInfo.getMiscellaneousTaxes()) {
                if (taxMap.get(miscTax.getTaxName()) == null) {
                    taxMap.put(miscTax.getTaxName(), miscTax.getTotalCalculatedTax());
                    continue;
                }
                taxMap.put(miscTax.getTaxName(), ((BigDecimal)taxMap.get(miscTax.getTaxName())).add(miscTax.getTotalCalculatedTax()));
            }
        }
        for (Map.Entry entry : taxMap.entrySet()) {
            entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
        }
        return taxMap;
    }

    private APUnitTaxCalculationInfo calculateVacantLandTax(Property property, Date occupancyDate, List<String> applicableTaxes, Installment installment) {
        APUnitTaxCalculationInfo unitTaxCalculationInfo = new APUnitTaxCalculationInfo();
        unitTaxCalculationInfo.setFloorNumber("VACANT");
        unitTaxCalculationInfo.setBaseRateEffectiveDate(occupancyDate);
        unitTaxCalculationInfo.setCapitalValue(new BigDecimal(property.getPropertyDetail().getCurrentCapitalValue()));
        unitTaxCalculationInfo.setMarketValue(property.getPropertyDetail().getMarketValue() != null ? new BigDecimal(property.getPropertyDetail().getMarketValue()) : BigDecimal.ZERO);
        unitTaxCalculationInfo.setNetARV(unitTaxCalculationInfo.getCapitalValue().compareTo(unitTaxCalculationInfo.getMarketValue()) < 0 ? unitTaxCalculationInfo.getMarketValue() : unitTaxCalculationInfo.getCapitalValue());
        this.calculateApplicableTaxes(applicableTaxes, unitTaxCalculationInfo, installment, property.getPropertyDetail().getPropertyTypeMaster().getCode(), null, null);
        return unitTaxCalculationInfo;
    }

    public String generateTaxCalculationXML(TaxCalculationInfo taxCalculationInfo) {
        TaxCalculationInfoXmlHandler handler = new TaxCalculationInfoXmlHandler();
        String taxCalculationInfoXML = "";
        if (taxCalculationInfo != null) {
            taxCalculationInfoXML = handler.toXML(taxCalculationInfo);
        }
        return taxCalculationInfoXML;
    }

    private Boolean between(Date date, Date fromDate, Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    private Boolean betweenOrBefore(Date date, Date fromDate, Date toDate) {
        return this.between(date, fromDate, toDate) != false || date.before(fromDate);
    }

    private BigDecimal calculateFloorMrv(BigDecimal builtUpArea, BoundaryCategory boundaryCategory) {
        return builtUpArea.multiply(BigDecimal.valueOf(boundaryCategory.getCategory().getCategoryAmount()));
    }

    private BigDecimal calculateFloorBuildingValue(BigDecimal floorMrv) {
        return floorMrv.multiply(BUILDING_VALUE).setScale(2, 4);
    }

    private BigDecimal calculateFloorSiteValue(BigDecimal floorMrv) {
        return floorMrv.multiply(SITE_VALUE).setScale(2, 4);
    }

    private BigDecimal calculateFloorDepreciation(BigDecimal grossArv, Floor floor) {
        BigDecimal depreciationPct = floor.getPropertyOccupation().getOccupancyCode().equals("OWNER") && floor.getPropertyUsage().getIsResidential() != false ? RESD_OWNER_DEPRECIATION : BigDecimal.valueOf(floor.getDepreciationMaster().getDepreciationPct().floatValue());
        if (this.isSeaShoreULB.booleanValue()) {
            depreciationPct = depreciationPct.add(SEASHORE_ADDITIONAL_DEPRECIATION);
        }
        return grossArv.multiply(depreciationPct).divide(BigDecimal.valueOf(100L));
    }

    public BigDecimal roundOffToNearestEven(BigDecimal amount) {
        BigDecimal remainder = amount.remainder(new BigDecimal(2));
        BigDecimal roundedAmt = remainder.compareTo(new BigDecimal("1")) == 1 ? amount.subtract(remainder).add(new BigDecimal(2)) : amount.subtract(remainder);
        return roundedAmt;
    }

    public BigDecimal convertYardToSquareMeters(Float vacantLandArea) {
        Float areaInSqMts = Float.valueOf(vacantLandArea.floatValue() * new Float(PropertyTaxConstants.SQUARE_YARD_TO_SQUARE_METER_VALUE.floatValue()).floatValue());
        return new BigDecimal(areaInSqMts.floatValue()).setScale(2, 4);
    }

    private BigDecimal taxIfGovtProperty(String propTypeCode, BigDecimal tax) {
        BigDecimal amount = BigDecimal.ZERO;
        if (propTypeCode.equals("CENTRAL_GOVT_33.5")) {
            amount = tax.multiply(BigDecimal.valueOf(0.335));
        }
        if (propTypeCode.equals("CENTRAL_GOVT_50")) {
            amount = tax.multiply(BigDecimal.valueOf(0.5));
        }
        if (propTypeCode.equals("CENTRAL_GOVT_75")) {
            amount = tax.multiply(BigDecimal.valueOf(0.75));
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            amount = tax;
        }
        return amount;
    }

    private BigDecimal getUnAuthDeviationPerc(Floor floor) {
        BigDecimal buildingPlanPlinthArea;
        BigDecimal deviationPerc = null;
        BigDecimal plinthArea = new BigDecimal(floor.getBuiltUpArea().getArea().floatValue()).setScale(2, 4);
        BigDecimal bigDecimal = buildingPlanPlinthArea = floor.getBuildingPlanPlinthArea() != null && floor.getBuildingPlanPlinthArea().getArea() != null ? new BigDecimal(floor.getBuildingPlanPlinthArea().getArea().floatValue()).setScale(2, 4) : BigDecimal.ZERO;
        if (buildingPlanPlinthArea.compareTo(BigDecimal.ZERO) == 0) {
            deviationPerc = new BigDecimal(100);
        } else if (plinthArea.compareTo(buildingPlanPlinthArea) > 0) {
            BigDecimal diffArea = plinthArea.subtract(buildingPlanPlinthArea);
            deviationPerc = diffArea.divide(buildingPlanPlinthArea, 2, 4).multiply(new BigDecimal("100"));
        }
        return deviationPerc;
    }

    private BigDecimal calculateUnAuthPenalty(BigDecimal deviationPerc, BigDecimal totalPropertyTax, Date constructionDate) {
        BigDecimal unAuthPenalty = BigDecimal.ZERO;
        if (this.isCorporation.booleanValue()) {
            if (DateUtils.between((Date)constructionDate, (Date)DateUtils.getDate((String)CORP_UAC_PENALTY_CASE1_STARTDATE, (String)"dd/MM/yyyy"), (Date)DateUtils.getDate((String)CORP_UAC_PENALTY_CASE1_ENDDATE, (String)"dd/MM/yyyy"))) {
                unAuthPenalty = totalPropertyTax.multiply(PropertyTaxConstants.DEVIATION_TAXPERC_10);
            } else if (DateUtils.between((Date)constructionDate, (Date)DateUtils.getDate((String)CORP_UAC_PENALTY_CASE2_STARTDATE, (String)"dd/MM/yyyy"), (Date)DateUtils.getDate((String)"04/08/2013", (String)"dd/MM/yyyy"))) {
                unAuthPenalty = totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_1_10);
            } else if (constructionDate.after(DateUtils.getDate((String)"04/08/2013", (String)"dd/MM/yyyy"))) {
                unAuthPenalty = this.calculateUACPenaltyForDeviationPerc(deviationPerc, totalPropertyTax);
            }
        } else if (DateUtils.between((Date)constructionDate, (Date)DateUtils.getDate((String)NONCORP_UAC_PENALTY_CASE1_STARTDATE, (String)"dd/MM/yyyy"), (Date)DateUtils.getDate((String)"04/08/2013", (String)"dd/MM/yyyy"))) {
            unAuthPenalty = totalPropertyTax.multiply(PropertyTaxConstants.DEVIATION_TAXPERC_10);
        } else if (constructionDate.after(DateUtils.getDate((String)"04/08/2013", (String)"dd/MM/yyyy"))) {
            unAuthPenalty = this.calculateUACPenaltyForDeviationPerc(deviationPerc, totalPropertyTax);
        }
        return unAuthPenalty;
    }

    private BigDecimal calculateUACPenaltyForDeviationPerc(BigDecimal deviationPerc, BigDecimal totalPropertyTax) {
        BigDecimal unAuthPenalty = BigDecimal.ZERO;
        if (deviationPerc != null && deviationPerc.compareTo(BigDecimal.ZERO) > 0) {
            unAuthPenalty = deviationPerc.compareTo(BigDecimal.ZERO) > 0 && deviationPerc.compareTo(BigDecimal.TEN) <= 0 ? totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_1_10) : (deviationPerc.compareTo(BigDecimal.TEN) > 0 && deviationPerc.compareTo(PropertyTaxConstants.BIGDECIMAL_100) != 0 ? totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_ABOVE_11) : totalPropertyTax.multiply(PropertyTaxConstants.BPA_DEVIATION_TAXPERC_NOT_DEFINED));
        }
        return unAuthPenalty;
    }

    private BigDecimal calcPublicServiceCharges(BigDecimal totalPropertyTax) {
        return BigDecimal.ZERO;
    }

    private void createMiscTax(String taxHead, BigDecimal tax, APUnitTaxCalculationInfo unitTaxCalculationInfo) {
        APMiscellaneousTax miscellaneousTax = new APMiscellaneousTax();
        miscellaneousTax.setTaxName(taxHead);
        miscellaneousTax.setTotalCalculatedTax(tax);
        unitTaxCalculationInfo.addMiscellaneousTaxes(miscellaneousTax);
    }

    private BigDecimal getTaxRate(String taxHead) {
        BigDecimal taxRate = BigDecimal.ZERO;
        if (this.taxRateProps != null) {
            taxRate = new BigDecimal(this.taxRateProps.getProperty(taxHead));
        }
        return taxRate;
    }

    private BigDecimal getHalfYearTax(BigDecimal annualTax) {
        return annualTax.divide(new BigDecimal(2)).setScale(2, 4);
    }
}

