/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.demand.model.EgBillDetails;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.constants.PropertyTaxConstants;

public class CollectionApportioner {
    private static final String REBATE_STR = "REBATE";
    public static final String STRING_FULLTAX = "FULLTAX";
    public static final String STRING_ADVANCE = "ADVANCE";
    private static final Logger LOGGER = Logger.getLogger(CollectionApportioner.class);
    private boolean isEligibleForCurrentRebate;
    private boolean isEligibleForAdvanceRebate;

    public CollectionApportioner(boolean isEligibleForCurrentRebate, boolean isEligibleForAdvanceRebate, BigDecimal rebate) {
        this.isEligibleForCurrentRebate = isEligibleForCurrentRebate;
        this.isEligibleForAdvanceRebate = isEligibleForAdvanceRebate;
    }

    public void apportion(BigDecimal amtPaid, List<ReceiptDetail> receiptDetails, Map<String, BigDecimal> instDmdMap) {
        LOGGER.info((Object)("receiptDetails before apportioning amount " + amtPaid + ": " + receiptDetails));
        Boolean isFullPayment = Boolean.FALSE;
        if (this.isEligibleForCurrentRebate) {
            BigDecimal totalCrAmountToBePaid = BigDecimal.ZERO;
            for (ReceiptDetail receiptDetail : receiptDetails) {
                if (BillAccountDetails.PURPOSE.ADVANCE_AMOUNT.toString().equals(receiptDetail.getPurpose())) continue;
                totalCrAmountToBePaid = totalCrAmountToBePaid.add(receiptDetail.getCramountToBePaid());
            }
            if (amtPaid.compareTo(totalCrAmountToBePaid) >= 0) {
                isFullPayment = Boolean.TRUE;
            }
        }
        Amount balance = new Amount(amtPaid);
        BigDecimal crAmountToBePaid = null;
        for (ReceiptDetail rd : receiptDetails) {
            if (balance.isZero()) {
                rd.zeroDrAndCrAmounts();
                continue;
            }
            crAmountToBePaid = rd.getCramountToBePaid();
            if (rd.getDescription().contains(REBATE_STR)) {
                if (isFullPayment.booleanValue()) {
                    balance = balance.minus(crAmountToBePaid);
                    continue;
                }
                rd.setDramount(BigDecimal.ZERO);
                continue;
            }
            if (balance.isLessThanOrEqualTo(crAmountToBePaid)) {
                rd.setCramount(balance.amount);
                balance = Amount.ZERO;
                continue;
            }
            rd.setCramount(crAmountToBePaid);
            balance = balance.minus(crAmountToBePaid);
        }
        if (balance.isGreaterThanZero()) {
            LOGGER.error((Object)"Apportioning failed: excess payment!");
            throw new ValidationException(Arrays.asList(new ValidationError("Paid Amount is greater than Total Amount to be paid", "Paid Amount is greater than Total Amount to be paid")));
        }
        LOGGER.info((Object)("receiptDetails after apportioning: " + receiptDetails));
    }

    public List<ReceiptDetail> reConstruct(BigDecimal amountPaid, List<EgBillDetails> billDetails, FunctionHibernateDAO functionDAO, ChartOfAccountsHibernateDAO chartOfAccountsDAO) {
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>(0);
        LOGGER.info((Object)("receiptDetails before reApportion amount " + amountPaid + ": " + receiptDetails));
        LOGGER.info((Object)("billDetails before reApportion " + billDetails));
        Amount balance = new Amount(amountPaid);
        Boolean isFullPayment = Boolean.FALSE;
        BigDecimal crAmountToBePaid = BigDecimal.ZERO;
        if (this.isEligibleForCurrentRebate) {
            BigDecimal totalCrAmountToBePaid = BigDecimal.ZERO;
            for (ReceiptDetail receiptDetail : receiptDetails) {
                totalCrAmountToBePaid = totalCrAmountToBePaid.add(receiptDetail.getCramountToBePaid());
            }
            if (amountPaid.compareTo(totalCrAmountToBePaid) >= 0) {
                isFullPayment = Boolean.TRUE;
            }
        }
        for (EgBillDetails billDetail : billDetails) {
            String glCode = billDetail.getGlcode();
            ReceiptDetail receiptDetail = new ReceiptDetail();
            receiptDetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
            receiptDetail.setOrdernumber(Long.valueOf(billDetail.getOrderNo().intValue()));
            receiptDetail.setDescription(billDetail.getDescription());
            receiptDetail.setIsActualDemand(Boolean.valueOf(true));
            if (billDetail.getFunctionCode() != null) {
                receiptDetail.setFunction(functionDAO.getFunctionByCode(billDetail.getFunctionCode()));
            }
            receiptDetail.setAccounthead(chartOfAccountsDAO.getCChartOfAccountsByGlCode(glCode));
            receiptDetail.setCramountToBePaid(balance.amount);
            if (billDetail.getDescription().contains(REBATE_STR)) {
                receiptDetail.setDramount(billDetail.getDrAmount());
            } else {
                receiptDetail.setDramount(BigDecimal.ZERO);
            }
            if (balance.isZero()) {
                receiptDetail.zeroDrAndCrAmounts();
                receiptDetails.add(receiptDetail);
                continue;
            }
            crAmountToBePaid = billDetail.getCrAmount();
            if (receiptDetail.getDescription().contains(REBATE_STR)) {
                if (isFullPayment.booleanValue()) {
                    balance = balance.minus(crAmountToBePaid);
                } else {
                    receiptDetail.setDramount(BigDecimal.ZERO);
                }
            } else if (balance.isLessThanOrEqualTo(crAmountToBePaid)) {
                receiptDetail.setCramount(balance.amount);
                receiptDetail.setCramountToBePaid(balance.amount);
                balance = Amount.ZERO;
            } else {
                receiptDetail.setCramount(crAmountToBePaid);
                receiptDetail.setCramountToBePaid(crAmountToBePaid);
                balance = balance.minus(crAmountToBePaid);
            }
            receiptDetails.add(receiptDetail);
        }
        if (balance.isGreaterThanZero()) {
            LOGGER.error((Object)"reApportion failed: excess payment!");
            throw new ValidationException(Arrays.asList(new ValidationError("Paid Amount is greater than Total Amount to be paid", "Paid Amount is greater than Total Amount to be paid")));
        }
        LOGGER.info((Object)("receiptDetails after reApportion: " + receiptDetails));
        return receiptDetails;
    }

    private boolean isArrear(String glCode) {
        return !PropertyTaxConstants.GLCODES_FOR_CURRENTTAX.contains(glCode) && !glCode.equals("1109004");
    }

    private boolean isCurrent(String glCode) {
        return PropertyTaxConstants.GLCODES_FOR_CURRENTTAX.contains(glCode);
    }

    private boolean isAdvance(String glCode) {
        return glCode.equals("3504101");
    }

    private boolean isRebate(String glCode) {
        return glCode.equals("1109004") || glCode.equalsIgnoreCase("4314209");
    }

    void setEligibleForCurrentRebate(boolean isEligibleForCurrentRebate) {
        this.isEligibleForCurrentRebate = isEligibleForCurrentRebate;
    }

    void setEligibleForAdvanceRebate(boolean isEligibleForAdvanceRebate) {
        this.isEligibleForAdvanceRebate = isEligibleForAdvanceRebate;
    }

    private static class Amount {
        private BigDecimal amount;
        private static Amount ZERO = new Amount(BigDecimal.ZERO);

        private Amount(BigDecimal amount) {
            this.amount = amount;
        }

        private boolean isZero() {
            return this.amount.compareTo(BigDecimal.ZERO) == 0;
        }

        private boolean isGreaterThan(BigDecimal bd) {
            return this.amount.compareTo(bd) > 0;
        }

        private boolean isGreaterThanZero() {
            return this.isGreaterThan(BigDecimal.ZERO);
        }

        private boolean isGreaterThanOrEqualTo(BigDecimal bd) {
            return this.amount.compareTo(bd) >= 0;
        }

        private boolean isLessThanOrEqualTo(BigDecimal bd) {
            return this.amount.compareTo(bd) <= 0;
        }

        private boolean isLessThan(BigDecimal bd) {
            return this.amount.compareTo(bd) < 0;
        }

        private boolean isGreaterThanOrEqualToZero() {
            return this.isGreaterThanOrEqualTo(BigDecimal.ZERO);
        }

        private Amount minus(BigDecimal bd) {
            return new Amount(this.amount.subtract(bd));
        }

        private Amount plus(BigDecimal bd) {
            return new Amount(this.amount.add(bd));
        }

        private Amount multiply(BigDecimal bd) {
            return new Amount(this.amount.multiply(bd));
        }

        private Amount divide(BigDecimal bd) {
            return new Amount(this.amount.divide(bd));
        }
    }
}

