/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.model.calculator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.ptis.client.model.calculator.DemandNoticeDetailsInfo;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.wtms.ConsumerConsumption;
import org.egov.ptis.wtms.PropertyWiseConsumptions;
import org.jfree.util.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DemandNoticeInfo {
    private BasicProperty basicProperty;
    private String billNo;
    private String oldAssessmentNo;
    private String noOfTap;
    private String sewarageConnectionNo;
    private String rentPaid;
    private String locality;
    private List<DemandNoticeDetailsInfo> demandNoticeDetailsInfo;
    private ReportUtil reportUtil;
    private PropertyWiseConsumptions propertyWiseConsumptions;
    private String billPeriod;
    private Boolean isVacancyRemissionDone;
    @Autowired
    @Qualifier(value="cityService")
    private CityService cityService;

    public City getcityWebsite() {
        City cw = (City)this.cityService.findAll().get(0);
        return cw;
    }

    public String getCityName() {
        City cw = this.getcityWebsite();
        if (cw != null && cw.getPreferences() != null) {
            return cw != null ? cw.getPreferences().getMunicipalityName() : null;
        }
        return null;
    }

    public String getCityLogo() {
        String path = null;
        try {
            path = ReportUtil.logoBasePath();
        }
        catch (Exception e) {
            Log.error((Object)e.getMessage());
        }
        return path;
    }

    public String getWardNo() {
        return this.getBasicProperty().getPropertyID().getWard().getBoundaryNum().toString();
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getBillDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        return dateFormat.format(new Date());
    }

    public String getName() {
        return this.basicProperty.getFullOwnerName();
    }

    public String getAssessmentNo() {
        return this.getBasicProperty().getUpicNo();
    }

    public String getOldAssessmentNo() {
        return this.oldAssessmentNo;
    }

    public void setOldAssessmentNo(String oldAssessmentNo) {
        this.oldAssessmentNo = oldAssessmentNo;
    }

    public String getWaterConnectionNo() {
        String waterConnectionNo = "";
        if (this.propertyWiseConsumptions != null && this.propertyWiseConsumptions.getConsumerConsumptions() != null && !this.propertyWiseConsumptions.getConsumerConsumptions().isEmpty()) {
            String hscno = "";
            for (ConsumerConsumption cc : this.propertyWiseConsumptions.getConsumerConsumptions()) {
                if (cc == null || hscno == null || hscno == "") continue;
                hscno = hscno + cc.getHscno() + ",";
            }
            if (hscno != "" && hscno != null) {
                waterConnectionNo = hscno.substring(0, hscno.length() - 1);
            }
        }
        return waterConnectionNo;
    }

    public String getNoOfTap() {
        if (this.propertyWiseConsumptions != null && this.propertyWiseConsumptions.getConsumerConsumptions() != null && !this.propertyWiseConsumptions.getConsumerConsumptions().isEmpty()) {
            this.noOfTap = Integer.toString(this.propertyWiseConsumptions.getConsumerConsumptions().size());
        }
        return this.noOfTap;
    }

    public String getSewarageConnectionNo() {
        return this.sewarageConnectionNo;
    }

    public void setSewarageConnectionNo(String sewarageConnectionNo) {
        this.sewarageConnectionNo = sewarageConnectionNo;
    }

    public String getRentPaid() {
        return this.rentPaid;
    }

    public void setRentPaid(String rentPaid) {
        this.rentPaid = rentPaid;
    }

    public String getStreetName() {
        return this.basicProperty.getPropertyID().getStreet() != null ? this.basicProperty.getPropertyID().getStreet().getName() : null;
    }

    public String getHouseNo() {
        return this.getBasicProperty().getAddress().getHouseNoBldgApt();
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public List<DemandNoticeDetailsInfo> getDemandNoticeDetailsInfo() {
        return this.demandNoticeDetailsInfo;
    }

    public void setDemandNoticeDetailsInfo(List<DemandNoticeDetailsInfo> demandNoticeDetailsInfo) {
        this.demandNoticeDetailsInfo = demandNoticeDetailsInfo;
    }

    public ReportUtil getReportUtil() {
        return this.reportUtil;
    }

    public void setReportUtil(ReportUtil reportUtil) {
        this.reportUtil = reportUtil;
    }

    public PropertyWiseConsumptions getPropertyWiseConsumptions() {
        return this.propertyWiseConsumptions;
    }

    public void setPropertyWiseConsumptions(PropertyWiseConsumptions propertyWiseConsumptions) {
        this.propertyWiseConsumptions = propertyWiseConsumptions;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getBillPeriod() {
        return this.billPeriod;
    }

    public void setBillPeriod(String billPeriod) {
        this.billPeriod = billPeriod;
    }

    public CityService getCityService() {
        return this.cityService;
    }

    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    public Boolean getIsVacancyRemissionDone() {
        return this.isVacancyRemissionDone;
    }

    public void setIsVacancyRemissionDone(Boolean isVacancyRemissionDone) {
        this.isVacancyRemissionDone = isVacancyRemissionDone;
    }
}

