/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.builder.entity.property;

import java.util.Date;
import org.egov.commons.Area;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyUsage;

public class FloorBuilder {
    private final Floor floor = new Floor();

    public Floor build() {
        return this.floor;
    }

    public FloorBuilder withBuiltUpArea(Float builtUpArea) {
        Area area = new Area();
        area.setArea(builtUpArea);
        this.floor.setBuiltUpArea(area);
        return this;
    }

    public FloorBuilder withUsage(PropertyUsage propertyUsage) {
        this.floor.setPropertyUsage(propertyUsage);
        return this;
    }

    public FloorBuilder withOccupancy(PropertyOccupation propertyOccupation) {
        this.floor.setPropertyOccupation(propertyOccupation);
        return this;
    }

    public FloorBuilder withOccupancyDate(Date date) {
        this.floor.setCreatedDate(date);
        return this;
    }

    public FloorBuilder withDefaults() {
        this.withOccupancyDate(new Date());
        this.withBuiltUpArea(Float.valueOf(1000.0f));
        return this;
    }
}

