/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.utils.NumberUtil;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PropertyTaxCommonUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyTaxCommonUtils.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;

    public Installment getCurrentInstallment() {
        org.hibernate.Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select installment from Installment installment,CFinancialYear finYear where installment.module.name =:moduleName  and (cast(:currDate as date)) between finYear.startingDate and finYear.endingDate  and cast(installment.fromDate as date) >= cast(finYear.startingDate as date) and cast(installment.toDate as date) <= cast(finYear.endingDate as date) order by installment.fromDate asc ");
        query.setString("moduleName", "Property Tax");
        query.setDate("currDate", new Date());
        List installments = query.list();
        return (Installment)installments.get(0);
    }

    public String getAppConfigValue(String key, String moduleName) {
        AppConfigValues appConfigValues;
        String value = "";
        if (key != null && moduleName != null && (appConfigValues = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date())) != null) {
            value = appConfigValues.getValue();
        }
        return value;
    }

    public Map<String, Object> getTaxDetailsForWorkflowProperty(BasicProperty basicProperty) {
        Map<Object, Object> demandCollMap = new TreeMap();
        HashMap<String, Object> wfPropTaxDetailsMap = new HashMap<String, Object>();
        Property property = basicProperty.getWFProperty();
        try {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.getCurrentInstallment());
            if (!demandCollMap.isEmpty()) {
                for (Map.Entry<Object, Object> entry : demandCollMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map reasonDmd = (Map)entry.getValue();
                    if (key.equals("Current 1st Half")) {
                        wfPropTaxDetailsMap.put("firstHalf", "Current 1st Half");
                        wfPropTaxDetailsMap.put("firstHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("firstHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("firstHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfTotal", reasonDmd.get("CURR_FIRSTHALF_DMD") != null ? reasonDmd.get("CURR_FIRSTHALF_DMD") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfTaxDue", (reasonDmd.get("CURR_FIRSTHALF_DMD") != null ? (BigDecimal)reasonDmd.get("CURR_FIRSTHALF_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_COLL")));
                        continue;
                    }
                    if (key.equals("Current 2nd Half")) {
                        wfPropTaxDetailsMap.put("secondHalf", "Current 2nd Half");
                        wfPropTaxDetailsMap.put("secondHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("secondHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("secondHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfTotal", reasonDmd.get("CURR_SECONDHALF_DMD") != null ? reasonDmd.get("CURR_SECONDHALF_DMD") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfTaxDue", (reasonDmd.get("CURR_SECONDHALF_DMD") != null ? (BigDecimal)reasonDmd.get("CURR_SECONDHALF_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_SECONDHALF_COLL")));
                        continue;
                    }
                    wfPropTaxDetailsMap.put("arrears", "Arrears");
                    wfPropTaxDetailsMap.put("arrearTax", reasonDmd.get("ARR_DMD") != null ? reasonDmd.get("ARR_DMD") : BigDecimal.ZERO);
                    wfPropTaxDetailsMap.put("totalArrDue", (reasonDmd.get("ARR_DMD") != null ? (BigDecimal)reasonDmd.get("ARR_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("ARR_COLL")));
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception in getTaxDetailsForWorkflowProperty: ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in getTaxDetailsForWorkflowProperty : " + e);
        }
        return wfPropTaxDetailsMap;
    }

    public boolean isDigitalSignatureEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PTIS_DIGITAL_SIGNATURE_REQUIRED");
        return !appConfigValues.isEmpty() && "Y".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }

    public List<Installment> getAdvanceInstallmentsList(Date startDate) {
        ArrayList<Installment> advanceInstallments = new ArrayList();
        String query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ";
        advanceInstallments = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ").setParameter("startdate", (Object)startDate).setMaxResults(PropertyTaxConstants.MAX_ADVANCES_ALLOWED.intValue()).list();
        return advanceInstallments;
    }

    public void makeExistingDemandBillInactive(String assessmentNo) {
        DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean("demandBillService");
        demandBillService.makeDemandBillInactive(assessmentNo);
    }

    public String getAllDesignationsForUser(Long userId) {
        List positions = null;
        ArrayList<String> designationList = new ArrayList<String>();
        StringBuilder listString = new StringBuilder();
        if (userId != null && userId.intValue() != 0 && (positions = this.positionMasterService.getPositionsForEmployee(userId)) != null) {
            for (Position position : positions) {
                designationList.add(position.getDeptDesig().getDesignation().getName());
            }
            for (String s : designationList) {
                listString.append(s + ", ");
            }
        }
        return listString.toString();
    }

    public boolean isReceiptCanceled(String receiptNumber) {
        Query qry = this.entityManager.createNamedQuery("RECEIPTS_BY_RECEIPTNUM");
        qry.setParameter(1, (Object)receiptNumber);
        ReceiptHeader receiptHeader = (ReceiptHeader)qry.getSingleResult();
        return receiptHeader.getStatus().getCode().equals("CANCELLED") ? Boolean.TRUE : Boolean.FALSE;
    }

    public Installment getCurrentPeriodInstallment() {
        Module module = this.moduleService.getModuleByName("Property Tax");
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
    }

    public Assignment getUserAssignmentByPassingPositionAndUser(User user, Position position) {
        Assignment userAssignment = null;
        if (user != null && position != null) {
            List assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                if (position.getId() != assignment.getPosition().getId() || !assignment.getEmployee().isActive()) continue;
                userAssignment = assignment;
                break;
            }
        }
        return userAssignment;
    }

    public Assignment getWorkflowInitiatorAssignment(Long userId) {
        Assignment wfInitiatorAssignment = null;
        if (userId != null) {
            List assignmentList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(userId);
            for (Assignment assignment : assignmentList) {
                if (!assignment.getDesignation().getName().equals("Junior Assistant") && !assignment.getDesignation().getName().equals("Senior Assistant") || !assignment.getEmployee().isActive()) continue;
                wfInitiatorAssignment = assignment;
                break;
            }
        }
        return wfInitiatorAssignment;
    }

    public String getCurrentHalfyearTax(HashMap<Installment, TaxCalculationInfo> instTaxMap, PropertyTypeMaster propTypeMstr) {
        Installment currentInstall = this.getCurrentPeriodInstallment();
        TaxCalculationInfo calculationInfo = instTaxMap.get(currentInstall);
        BigDecimal annualValue = calculationInfo.getTotalNetARV();
        BigDecimal totalPropertyTax = calculationInfo.getTotalTaxPayable();
        BigDecimal genTax = BigDecimal.ZERO;
        BigDecimal libCess = BigDecimal.ZERO;
        BigDecimal eduTax = BigDecimal.ZERO;
        BigDecimal unAuthPenalty = BigDecimal.ZERO;
        BigDecimal vacLandTax = BigDecimal.ZERO;
        BigDecimal sewrageTax = BigDecimal.ZERO;
        BigDecimal serviceCharges = BigDecimal.ZERO;
        for (UnitTaxCalculationInfo unitTaxCalcInfo : calculationInfo.getUnitTaxCalculationInfos()) {
            for (MiscellaneousTax miscTax : unitTaxCalcInfo.getMiscellaneousTaxes()) {
                if (miscTax.getTaxName() == "GEN_TAX") {
                    genTax = genTax.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() == "UNAUTH_PENALTY") {
                    unAuthPenalty = unAuthPenalty.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() == "EDU_CESS") {
                    eduTax = eduTax.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() == "VAC_LAND_TAX") {
                    vacLandTax = vacLandTax.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() == "LIB_CESS") {
                    libCess = libCess.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() == "SEW_TAX") {
                    sewrageTax = sewrageTax.add(miscTax.getTotalCalculatedTax());
                    continue;
                }
                if (miscTax.getTaxName() != "PRIMARY_SER_CHRG") continue;
                serviceCharges = serviceCharges.add(miscTax.getTotalCalculatedTax());
            }
        }
        String resultString = this.preparResponeString(propTypeMstr, annualValue, totalPropertyTax, vacLandTax, genTax, unAuthPenalty, eduTax, libCess, sewrageTax, serviceCharges);
        return resultString;
    }

    private String preparResponeString(PropertyTypeMaster propTypeMstr, BigDecimal annualValue, BigDecimal totalPropertyTax, BigDecimal vacLandTax, BigDecimal genTax, BigDecimal unAuthPenalty, BigDecimal eduTax, BigDecimal libCess, BigDecimal sewrageTax, BigDecimal serviceCharges) {
        StringBuilder resultString = new StringBuilder(200);
        resultString.append("Annual Rental Value=" + this.formatAmount(annualValue) + "~Total Tax=" + this.formatAmount(totalPropertyTax));
        if ("VAC_LAND".equalsIgnoreCase(propTypeMstr.getCode())) {
            resultString.append("~Vacant Land Tax=" + this.formatAmount(vacLandTax));
        } else {
            resultString.append("~Property Tax=" + this.formatAmount(genTax) + "~Education Cess=" + this.formatAmount(eduTax));
        }
        resultString.append("~Library Cess=" + this.formatAmount(libCess));
        Boolean isCorporation = this.propertyTaxUtil.isCorporation();
        if (isCorporation.booleanValue()) {
            resultString.append("~Sewrage Tax=" + this.formatAmount(sewrageTax));
        }
        if (isCorporation.booleanValue() && this.propertyTaxUtil.isPrimaryServiceApplicable().booleanValue()) {
            resultString.append("~Service Charges=" + this.formatAmount(serviceCharges));
        }
        if (!"VAC_LAND".equalsIgnoreCase(propTypeMstr.getCode())) {
            resultString.append("~Unauthorized Penalty=" + this.formatAmount(unAuthPenalty));
        }
        return resultString.toString();
    }

    public String formatAmount(BigDecimal tax) {
        tax = tax.setScale(0, RoundingMode.CEILING);
        return NumberUtil.formatNumber((BigDecimal)tax);
    }

    public String getDateWithSufix(int dayOfMonth) {
        switch (dayOfMonth < 20 ? dayOfMonth : dayOfMonth % 10) {
            case 1: {
                return dayOfMonth + "st";
            }
            case 2: {
                return dayOfMonth + "nd";
            }
            case 3: {
                return dayOfMonth + "rd";
            }
        }
        return dayOfMonth + "th";
    }

    public Boolean isCorporation() {
        City city = (City)this.entityManager.createQuery("from City").getSingleResult();
        return city.getGrade().equals("Corp");
    }

    public Boolean isEligibleInitiator(Long userId) {
        return this.getAllDesignationsForUser(userId).contains("Junior Assistant") || this.getAllDesignationsForUser(userId).contains("Senior Assistant");
    }

    public String setSourceOfProperty(User user, Boolean isOnline) {
        String source = this.checkCscUserAndType(user) != false ? "CSC" : (this.isMeesevaUser(user) != false ? "MEESEVA" : (isOnline != false ? "ONLINE" : "SYSTEM"));
        return source;
    }

    public Boolean checkCscUserAndType(User user) {
        if (user.getType() != null) {
            return this.isCscOperator(user) != false && UserType.BUSINESS.equals((Object)user.getType());
        }
        return false;
    }

    public String getPropertySource(PropertyImpl property) {
        return property.getSource() != null ? property.getSource() : null;
    }

    public String getMutationSource(PropertyMutation propertyMutation) {
        return propertyMutation.getSource() != null ? propertyMutation.getSource() : null;
    }

    public String getObjectionSource(RevisionPetition objection) {
        return objection.getSource() != null ? objection.getSource() : null;
    }

    public String getVRSource(VacancyRemission vacancyRemission) {
        return vacancyRemission.getSource() != null ? vacancyRemission.getSource() : null;
    }

    public Boolean isCscOperator(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("CSC Operator")) continue;
            return true;
        }
        return false;
    }

    public Boolean isMeesevaUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("MeeSeva Operator")) continue;
            return true;
        }
        return false;
    }

    public String getDesgnForThirdPartyFullTransferWF() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PT_DESIGNATION_FOR_THIRDPARTY_FULLTRANSFER");
        return null != appConfigValue ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDeptForThirdPartyFullTransferWF() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PT_DEPARTMENT_FOR_THIRDPARTY_FULLTRANSFER");
        return null != appConfigValue ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Assignment getCommissionerAsgnForFullTransfer() {
        String designationStr = this.getDesgnForThirdPartyFullTransferWF();
        String departmentStr = this.getDeptForThirdPartyFullTransferWF();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                Long desgId;
                Long deptId = this.departmentService.getDepartmentByName(dept).getId();
                assignment = this.assignmentService.findByDepartmentAndDesignation(deptId, desgId = this.designationService.getDesignationByName(desg).getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }
}

