/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.scheduler;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.notice.RecoveryNoticesInfo;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.egov.ptis.notice.PtNotice;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.impl.JobDetailImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.transaction.support.TransactionTemplate;

@DisallowConcurrentExecution
public class RecoveryNoticesJob
extends QuartzJobBean {
    private static final Logger LOGGER = Logger.getLogger(RecoveryNoticesJob.class);
    @Autowired
    private RecoveryNoticeService recoveryNoticesService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private SecurityUtils securityUtils;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
            JobDetailImpl jobDetail = (JobDetailImpl)context.getJobDetail();
            String assessmentNumbers = (String)jobDetail.getJobDataMap().get((Object)"assessmentNumbers");
            String noticeType = (String)jobDetail.getJobDataMap().get((Object)"noticeType");
            String tenantId = jobDetail.getName().split("_")[0];
            ApplicationThreadLocals.setTenantID((String)tenantId);
            List<String> assessments = Arrays.asList(assessmentNumbers.split(", "));
            TransactionTemplate txTemplate = new TransactionTemplate(this.transactionTemplate.getTransactionManager());
            for (String assessmentNo : assessments) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Generating " + noticeType + " for assessment : " + assessmentNo));
                }
                this.generateAssessmentNotice(noticeType, txTemplate, assessmentNo);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Unable to complete execution Scheduler ", (Throwable)ex);
            throw new JobExecutionException("Unable to execute batch job Scheduler", (Throwable)ex, false);
        }
        finally {
            ApplicationThreadLocals.clearValues();
        }
    }

    private void generateAssessmentNotice(String noticeType, TransactionTemplate txTemplate, String assessmentNo) {
        try {
            txTemplate.setPropagationBehavior(3);
            txTemplate.execute(result -> {
                List<String> errors = this.recoveryNoticesService.validateRecoveryNotices(assessmentNo, noticeType);
                RecoveryNoticesInfo noticeInfo = this.recoveryNoticesService.getRecoveryNoticeInfoByAssessmentAndNoticeType(assessmentNo, noticeType);
                if (errors.isEmpty()) {
                    return this.generateNotice(noticeType, assessmentNo, noticeInfo);
                }
                this.updateNoticeInfo(errors, noticeInfo);
                return Boolean.FALSE;
            });
        }
        catch (Exception e) {
            txTemplate.execute(result -> {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)("Exception in Generating " + noticeType + " for assessment : " + assessmentNo));
                    LOGGER.error((Object)e);
                }
                return Boolean.FALSE;
            });
        }
    }

    private void updateNoticeInfo(List<String> errors, RecoveryNoticesInfo noticeInfo) {
        noticeInfo.setError(errors.get(0));
        this.recoveryNoticesService.saveRecoveryNoticeInfo(noticeInfo);
    }

    private Boolean generateNotice(String noticeType, String assessmentNo, RecoveryNoticesInfo noticeInfo) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        PtNotice notice = this.noticeService.getNoticeByTypeUpicNoAndFinYear(noticeType, basicProperty.getUpicNo());
        if (notice == null) {
            this.recoveryNoticesService.generateNotice(noticeType, basicProperty);
            noticeInfo.setGenerated(Boolean.TRUE);
            this.recoveryNoticesService.saveRecoveryNoticeInfo(noticeInfo);
        }
        return Boolean.TRUE;
    }
}

