/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.repository.master.walltype.WallTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WallTypeService {
    private final WallTypeRepository wallTypeRepository;
    @Autowired
    private UserService userService;

    @Autowired
    public WallTypeService(WallTypeRepository wallTypeRepository) {
        this.wallTypeRepository = wallTypeRepository;
    }

    @Transactional
    public WallType create(WallType wallType) {
        this.wallTypeRepository.save((Object)wallType);
        return wallType;
    }

    public WallType getWallTypeByName(String name) {
        return this.wallTypeRepository.findByName(name);
    }

    public WallType getWallTypeById(Long id) {
        return (WallType)((Object)this.wallTypeRepository.findOne(id));
    }

    public List<WallType> getAllWalls() {
        return this.wallTypeRepository.findAll();
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }
}

